/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.msp.ExportMSPException;
import org.eclipse.epf.export.msp.ExportMSPOptions;
import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.export.msp.ExportMSPServiceException;
import org.eclipse.epf.export.msp.ExportMSPXMLOperation;
import org.eclipse.epf.export.msp.ExportOptions;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TaskDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UIHelper;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.msproject.Assignment;
import org.eclipse.epf.msproject.DocumentRoot;
import org.eclipse.epf.msproject.MsprojectFactory;
import org.eclipse.epf.msproject.PredecessorLink;
import org.eclipse.epf.msproject.Project;
import org.eclipse.epf.msproject.Resource;
import org.eclipse.epf.msproject.util.MsprojectResourceImpl;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishManager;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.wizards.PublishProgressMonitorDialog;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMSPXMLService {
    private static boolean debug = ExportMSPPlugin.getDefault().isDebugging();
    private List referencedTasks = new ArrayList();
    private HashMap rolesToUidMap = new HashMap();
    private HashMap taskUidToWbsWapperPathMap = new HashMap();
    private HashMap wbsWapperPathToLocalPredListMap = new HashMap();
    private HashMap wbsGuidToTaskUidMap = new HashMap();
    private HashMap wbsWrapperPathToPredListMap = new HashMap();
    private String contentFolderName;
    private String abTargetDir;
    protected boolean exportOnlyPlannedElements;
    private boolean publishContentSite = false;
    private int task_uid = 1;
    private int res_uid = 1;
    private int assign_uid = 1;
    protected MsprojectFactory projectFactory = MsprojectFactory.eINSTANCE;
    private Process process;
    private MethodConfiguration processConfig;
    private ConfigurableComposedAdapterFactory wbsAdapterFactory;
    private ProcessConfigurator breakdownElementFilter;
    private IStructuredContentProvider wbsContentProvider;
    private Map suppressionMap = new HashMap();
    private Suppression suppression;
    private Stack elementPaths = new Stack();
    private Object currentElement;
    private String currentElementPath;
    private PredecessorList currentPredList;
    private HashMap<org.eclipse.epf.msproject.Task, WorkBreakdownElement> taskToWbeMap;

    public boolean export(Process process, ExportMSPOptions exportOptions) throws ExportMSPServiceException {
        MsprojectResourceImpl res;
        Project project;
        block10: {
            String msprojectName = exportOptions.getMSProjectName();
            File exportDir = exportOptions.getExportDir();
            this.publishContentSite = exportOptions.getPublishWebSite();
            PublishOptions publishingOptions = exportOptions.getPublishingOptions();
            this.processConfig = exportOptions.getMethodConfiguration();
            if (debug) {
                System.out.println("$$$ exporting to Microsoft Project!");
                System.out.println("$$$ process          = " + process);
                System.out.println("$$$ configuration    = " + this.processConfig);
                System.out.println("$$$ msprojectName    = " + msprojectName);
                System.out.println("$$$ targetDir                 = " + exportDir.getAbsolutePath());
                System.out.println("$$$ exportOnlyPlannedElements = " + this.exportOnlyPlannedElements);
                System.out.println("$$$ publishConfigOptions      = " + publishingOptions);
            }
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            this.abTargetDir = exportDir.getAbsolutePath();
            Path exportPath = new Path(this.abTargetDir);
            boolean endWithXmlExt = msprojectName.toLowerCase().endsWith(".xml");
            String exportPathStr = exportPath.append(endWithXmlExt ? msprojectName : String.valueOf(msprojectName) + ".xml").toOSString();
            if (debug) {
                System.out.println("$$$ exportPathStr                 = " + exportPathStr);
            }
            String emptyTemplateFile = String.valueOf(ExportMSPPlugin.getDefault().getInstallPath()) + "template" + File.separator + "msproject_2003_template.xml";
            if (debug) {
                System.out.println("$$$ emptyTemplateFile             = " + emptyTemplateFile);
            }
            try {
                File src = new File(emptyTemplateFile);
                File dst = new File(exportPathStr);
                FileUtil.copyFile((File)src, (File)dst);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            project = null;
            URI fileURI = URI.createFileURI((String)exportPathStr);
            try {
                res = new MsprojectResourceImpl(fileURI);
                res.getDefaultSaveOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
                res.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
                res.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
                res.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                res.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
                res.load(null);
                DocumentRoot docRoot = (DocumentRoot)res.getEObject("/");
                project = docRoot.getProject();
                this.taskToWbeMap = new HashMap();
                if (this.generateMSProject(process, project, exportOptions)) break block10;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ExportMSPException(e);
            }
        }
        res.save(null);
        if (debug) {
            ExportMSPXMLService.printMSProject(project);
        }
        return true;
    }

    public boolean generateMSProject(Process process, Project project, ExportMSPOptions exportOptions) throws Exception {
        MethodConfiguration config;
        block11: {
            if (process == null || project == null) {
                throw new IllegalArgumentException();
            }
            config = exportOptions.getMethodConfiguration();
            if (config == null) {
                if (process instanceof DeliveryProcess) {
                    config = ((DeliveryProcess)process).getDefaultContext();
                } else if (process instanceof CapabilityPattern) {
                    config = ((CapabilityPattern)process).getDefaultContext();
                } else {
                    throw new IllegalArgumentException();
                }
            }
            this.contentFolderName = config.getName();
            PublishOptions publishingOptions = exportOptions.getPublishingOptions();
            if (!this.publishContentSite || publishingOptions == null) break block11;
            File contentDir = new File(exportOptions.getExportDir(), this.contentFolderName);
            if (!contentDir.exists()) {
                contentDir.mkdirs();
            }
            if (debug) {
                System.out.println("$$$ vieBuilder methodConfig = " + config);
                System.out.println("$$$ vieBuilder publishConfigOptions = " + publishingOptions);
            }
            if (this.publishConfiguration(contentDir.getAbsolutePath(), config, publishingOptions)) break block11;
            return false;
        }
        this.exportOnlyPlannedElements = exportOptions.getExportOnlyPlannedWBSElements();
        project.setName(process.getName());
        project.setStartDate((Object)new Date());
        project.setCreationDate((Object)new Date());
        project.setLastSaved((Object)new Date());
        project.setFinishDate((Object)new Date());
        this.setProjectExtendedAttributes(project);
        this.generateOperatonRun(process, project, config);
        return true;
    }

    private void generateOperatonRun(Process process, Project project, MethodConfiguration config) throws InvocationTargetException, InterruptedException {
        final Process fprocess = process;
        final Project fproject = project;
        final MethodConfiguration fconfig = config;
        org.eclipse.jface.operation.IRunnableWithProgress op = new org.eclipse.jface.operation.IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(ExportMSPResources.exportMSPWizard_title, -1);
                        ExportMSPXMLService.this.generate(fprocess, fproject, fconfig);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        pmDialog.run(true, false, op);
    }

    private void generate(Process process, Project project, MethodConfiguration config) throws Exception {
        this.generateProjectResources(process, config, project);
        this.generateProjectTasks(process, config, project);
        this.generateLinks(process, project);
        this.generateWPDs(config);
    }

    protected void setExportOptions(ExportOptions exportOptions) {
        Boolean exportOnlyPlannedElements = (Boolean)exportOptions.get("exportOnlyPlannedElements");
        this.exportOnlyPlannedElements = exportOnlyPlannedElements;
    }

    protected void generateProjectResources(Process process, MethodConfiguration config, Project project) throws Exception {
        ComposedAdapterFactory adapterFactory = null;
        try {
            try {
                adapterFactory = TngAdapterFactory.INSTANCE.createTBSComposedAdapterFactory();
                if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                    ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)new ProcessConfigurator(config));
                }
                AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
                List elements = process.getBreakdownElements();
                if (elements.size() > 0) {
                    this.generateProjectResource((IStructuredContentProvider)contentProvider, (BreakdownElement)process, project);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (adapterFactory != null) {
                adapterFactory.dispose();
            }
        }
    }

    protected void generateProjectResource(IStructuredContentProvider contentProvider, BreakdownElement breakdownElement, Project project) throws Exception {
        if (breakdownElement instanceof WorkProductDescriptor || breakdownElement.getSuppressed().booleanValue() || this.exportOnlyPlannedElements && !breakdownElement.getIsPlanned().booleanValue()) {
            return;
        }
        if (breakdownElement instanceof RoleDescriptor) {
            this.addResource(breakdownElement, project);
            return;
        }
        if (contentProvider != null) {
            Object[] elements = contentProvider.getElements((Object)breakdownElement);
            int i = 0;
            while (i < elements.length) {
                Object value;
                RoleDescriptorWrapperItemProvider provider;
                Object element = elements[i];
                if (element instanceof RoleDescriptorWrapperItemProvider) {
                    provider = (RoleDescriptorWrapperItemProvider)element;
                    value = provider.getValue();
                    if (value instanceof RoleDescriptor) {
                        this.addResource((BreakdownElement)value, project);
                    }
                } else if (element instanceof RoleDescriptor) {
                    this.addResource((BreakdownElement)element, project);
                } else if (element instanceof BreakdownElementWrapperItemProvider) {
                    provider = (BreakdownElementWrapperItemProvider)element;
                    value = provider.getValue();
                    if (value instanceof WorkBreakdownElement) {
                        this.generateProjectResource(contentProvider, (BreakdownElement)((WorkBreakdownElement)value), project);
                    }
                } else if (element instanceof WorkBreakdownElement) {
                    this.generateProjectResource(contentProvider, (BreakdownElement)((WorkBreakdownElement)element), project);
                }
                ++i;
            }
        }
    }

    protected void addResource(BreakdownElement breakdownElement, Project proj) throws Exception {
        Resource aRes;
        if (!(breakdownElement instanceof RoleDescriptor)) {
            return;
        }
        RoleDescriptor roleDescriptor = (RoleDescriptor)breakdownElement;
        if (debug) {
            System.out.println("$$$ handle RoleDescriptor = " + roleDescriptor);
        }
        Role ref_edRole = roleDescriptor.getRole();
        if (debug) {
            System.out.println("$$$ handle Ref-ed Role = " + ref_edRole);
        }
        boolean newRDResource = true;
        String rdResourceName = this.getDisplayName((MethodElement)roleDescriptor);
        if (this.rolesToUidMap.get(rdResourceName) != null) {
            newRDResource = false;
        }
        boolean newRoleReource = false;
        String roleResourceName = null;
        if (ref_edRole != null && this.rolesToUidMap.get(roleResourceName = this.getDisplayName((MethodElement)ref_edRole)) == null && !roleResourceName.equalsIgnoreCase(rdResourceName)) {
            newRoleReource = true;
        }
        if (newRDResource) {
            aRes = this.projectFactory.createResource();
            aRes.setUID(BigInteger.valueOf(this.res_uid));
            aRes.setID(BigInteger.valueOf(this.res_uid));
            aRes.setName(rdResourceName);
            proj.getResources().getResource().add((Object)aRes);
            this.rolesToUidMap.put(rdResourceName, BigInteger.valueOf(this.res_uid));
            ++this.res_uid;
        }
        if (newRoleReource) {
            aRes = this.projectFactory.createResource();
            aRes.setUID(BigInteger.valueOf(this.res_uid));
            aRes.setID(BigInteger.valueOf(this.res_uid));
            aRes.setName(roleResourceName);
            proj.getResources().getResource().add((Object)aRes);
            this.rolesToUidMap.put(roleResourceName, BigInteger.valueOf(this.res_uid));
            ++this.res_uid;
        }
    }

    protected void generateProjectTasks(Process process, MethodConfiguration config, Project project) throws Exception {
        this.process = process;
        this.wbsAdapterFactory = null;
        try {
            try {
                this.suppression = new Suppression(process);
                this.suppressionMap.put(process, this.suppression);
                this.wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
                this.breakdownElementFilter = new ProcessConfigurator(config);
                this.wbsAdapterFactory.setFilter((IFilter)this.breakdownElementFilter);
                this.wbsContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.wbsAdapterFactory);
                this.currentElement = process;
                if (process instanceof CapabilityPattern) {
                    this.generateProjectTask(this.wbsContentProvider, process, 1, project);
                } else {
                    List breakdownElements = process.getBreakdownElements();
                    if (breakdownElements.size() > 0) {
                        this.generateProjectTask(this.wbsContentProvider, process, 1, project);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (this.wbsAdapterFactory != null) {
                this.wbsAdapterFactory.dispose();
            }
            if (this.suppressionMap != null) {
                this.suppressionMap.clear();
                this.suppressionMap = null;
            }
            if (this.wbsContentProvider != null) {
                this.wbsContentProvider.dispose();
            }
        }
    }

    private void enumerateProcessPredecessorLists() {
        AdapterFactoryTreeIterator wbsTreeIterator = new AdapterFactoryTreeIterator((AdapterFactory)this.wbsAdapterFactory, (Object)this.process);
        while (wbsTreeIterator.hasNext()) {
            Object obj = wbsTreeIterator.next();
            System.out.println("treeIterator: " + obj);
            IBSItemProvider adapter = (IBSItemProvider)this.wbsAdapterFactory.adapt(obj, ITreeItemContentProvider.class);
            PredecessorList predList = adapter.getPredecessors();
            for (IBSItemProvider e : predList) {
                System.out.println("    predList: " + e);
                if (!(e instanceof ItemProviderAdapter)) continue;
                System.out.println("    unwrappedPredList: " + ((ItemProviderAdapter)e).getTarget());
            }
        }
    }

    protected void generateProjectTask(IStructuredContentProvider contentProvider, Object elementOrWrapper, int taskOLevel, Project proj) throws Exception {
        ArrayList rollupRoles;
        boolean rb;
        boolean suppressed;
        WorkBreakdownElement breakdownElement = (WorkBreakdownElement)TngUtil.unwrap((Object)elementOrWrapper);
        if (breakdownElement instanceof WorkProductDescriptor || breakdownElement instanceof RoleDescriptor || breakdownElement.getSuppressed().booleanValue() || this.exportOnlyPlannedElements && !breakdownElement.getIsPlanned().booleanValue()) {
            return;
        }
        boolean isSubTasksPlanned = false;
        if (this.exportOnlyPlannedElements && breakdownElement instanceof Activity && contentProvider != null) {
            Object[] elements = contentProvider.getElements(elementOrWrapper);
            int i = 0;
            while (i < elements.length) {
                Object wrappedElement;
                Object element = elements[i];
                if (element instanceof Activity) {
                    if (!this.exportOnlyPlannedElements || ((Activity)element).getIsPlanned().booleanValue()) {
                        isSubTasksPlanned = true;
                        break;
                    }
                } else if (element instanceof ActivityWrapperItemProvider) {
                    wrappedElement = TngUtil.unwrap((Object)element);
                    if (wrappedElement instanceof Activity && (!this.exportOnlyPlannedElements || ((Activity)wrappedElement).getIsPlanned().booleanValue())) {
                        isSubTasksPlanned = true;
                        break;
                    }
                } else if (element instanceof TaskDescriptor) {
                    TaskDescriptor descriptor = (TaskDescriptor)element;
                    if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                        isSubTasksPlanned = true;
                        break;
                    }
                } else if (element instanceof TaskDescriptorWrapperItemProvider && (wrappedElement = TngUtil.unwrap((Object)element)) instanceof TaskDescriptor) {
                    TaskDescriptor descriptor = (TaskDescriptor)wrappedElement;
                    if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                        isSubTasksPlanned = true;
                        break;
                    }
                }
                ++i;
            }
        }
        boolean isPlannedTask = breakdownElement.getIsPlanned();
        org.eclipse.epf.msproject.Task newTask = null;
        if ((!this.exportOnlyPlannedElements || this.exportOnlyPlannedElements && isPlannedTask) && !(suppressed = this.isSuppressed(breakdownElement))) {
            newTask = this.addTask(elementOrWrapper, taskOLevel, proj);
        }
        if (this.exportOnlyPlannedElements && newTask != null && breakdownElement instanceof Activity && contentProvider != null && !isSubTasksPlanned && !(rb = this.calculateRollupRoles(contentProvider, (BreakdownElement)breakdownElement, rollupRoles = new ArrayList()))) {
            HashSet rolesSet = new HashSet(rollupRoles);
            for (String roleName : rolesSet) {
                this.addAssignment(roleName, newTask.getUID().intValue(), proj);
            }
        }
        if (contentProvider != null && !(suppressed = this.isSuppressed(breakdownElement))) {
            this.elementPaths.push(breakdownElement.getGuid());
            Object[] elements = contentProvider.getElements(elementOrWrapper);
            int i = 0;
            while (i < elements.length) {
                Object element;
                this.currentElement = element = elements[i];
                String[] paths = new String[this.elementPaths.size()];
                this.elementPaths.toArray(paths);
                StringBuffer pathStr = new StringBuffer();
                int j = 0;
                while (j < paths.length) {
                    pathStr.append(String.valueOf(paths[j]) + ".");
                    ++j;
                }
                if (this.currentElement instanceof BreakdownElementWrapperItemProvider) {
                    Object wrapped = TngUtil.unwrap((Object)element);
                    pathStr.append(((BreakdownElement)wrapped).getGuid());
                } else {
                    pathStr.append(((BreakdownElement)this.currentElement).getGuid());
                }
                this.currentElementPath = pathStr.toString();
                this.generateProjectTask(contentProvider, element, taskOLevel + 1, proj);
                ++i;
            }
            this.generateLinks(this.process, proj);
            this.elementPaths.pop();
        }
    }

    protected boolean isSuppressed(Object object) {
        if (object != null) {
            Process owningProcess;
            Suppression owningProcessSuppression;
            if (object instanceof Descriptor && debug) {
                System.out.println("Descriptor = " + ((Descriptor)object).getName());
            }
            if ((owningProcessSuppression = (Suppression)this.suppressionMap.get(owningProcess = TngUtil.getOwningProcess((Object)object))) == null) {
                owningProcessSuppression = new Suppression(owningProcess);
                this.suppressionMap.put(owningProcess, owningProcessSuppression);
            }
            if (owningProcessSuppression.isSuppressed(object)) {
                return true;
            }
            if (owningProcess != this.process && object instanceof WorkBreakdownElement) {
                this.elementPaths.push(((WorkBreakdownElement)object).getGuid());
                String[] paths = new String[this.elementPaths.size()];
                this.elementPaths.toArray(paths);
                Object wrapper = this.suppression.getObjectByPath(paths, (AdapterFactory)this.wbsAdapterFactory);
                this.elementPaths.pop();
                return this.suppression.isSuppressed(wrapper);
            }
        }
        return false;
    }

    protected org.eclipse.epf.msproject.Task addTask(Object elementOrWrapper, int taskOLevel, Project project) throws Exception {
        org.eclipse.epf.msproject.Task task = this.addTask_(elementOrWrapper, taskOLevel, project);
        if (task != null) {
            WorkBreakdownElement element = (WorkBreakdownElement)TngUtil.unwrap((Object)elementOrWrapper);
            this.taskToWbeMap.put(task, element);
        }
        return task;
    }

    private org.eclipse.epf.msproject.Task addTask_(Object elementOrWrapper, int taskOLevel, Project project) throws Exception {
        if (elementOrWrapper == null) {
            return null;
        }
        WorkBreakdownElement element = (WorkBreakdownElement)TngUtil.unwrap((Object)elementOrWrapper);
        org.eclipse.epf.msproject.Task task = this.projectFactory.createTask();
        task.setName(this.getDisplayName((MethodElement)element));
        task.setOutlineLevel(BigInteger.valueOf(taskOLevel));
        task.setUID(BigInteger.valueOf(this.task_uid));
        task.setID(BigInteger.valueOf(this.task_uid));
        task.setType(BigInteger.valueOf(0L));
        GregorianCalendar gcDate = new GregorianCalendar();
        Date startDate = gcDate.getTime();
        task.setStart((Object)startDate);
        String notes = this.getBriefDescription(element);
        if (notes != null && notes.trim().length() > 0) {
            task.setNotes(notes);
        }
        if (element instanceof Milestone) {
            task.setMilestone(true);
            task.setDurationFormat(BigInteger.valueOf(7L));
            task.setDuration((Object)"PT0H0M0S");
        } else {
            task.setMilestone(false);
        }
        List rolesList = null;
        if (element instanceof TaskDescriptor) {
            rolesList = this.getRolesForTaskD((TaskDescriptor)element);
        } else if (element instanceof Task) {
            rolesList = this.getRolesForTask((Task)element);
        }
        if (rolesList != null) {
            for (String roleName : rolesList) {
                this.addAssignment(roleName, this.task_uid, project);
            }
        }
        if (this.publishContentSite) {
            String linkURL = this.getElementURL((MethodElement)element);
            if (element instanceof TaskDescriptor) {
                TaskDescriptor taskDescriptor = (TaskDescriptor)element;
                Task ref_edTask = taskDescriptor.getTask();
                this.referencedTasks.add(ref_edTask);
            }
            task.setHyperlinkAddress(linkURL);
        }
        project.getTasks().getTask().add((Object)task);
        if (debug) {
            System.out.println("$$$ theCurrent element: taskUid=" + this.task_uid + ", " + this.currentElement);
            System.out.println("                  path: " + this.currentElementPath);
        }
        this.storeTaskPredecessors(element);
        this.taskUidToWbsWapperPathMap.put(BigInteger.valueOf(this.task_uid), this.currentElementPath);
        this.wbsGuidToTaskUidMap.put(element.getGuid(), BigInteger.valueOf(this.task_uid));
        IBSItemProvider adapter = (IBSItemProvider)this.wbsAdapterFactory.adapt(elementOrWrapper, ITreeItemContentProvider.class);
        PredecessorList currentPredList = adapter.getPredecessors();
        ArrayList<Object> guidPredList = new ArrayList<Object>();
        for (Object e : currentPredList) {
            Object unwrappedE;
            if (debug) {
                System.out.println("    wrapperPredListMember: " + e);
            }
            if ((unwrappedE = TngUtil.unwrap(e)) instanceof WorkBreakdownElement) {
                guidPredList.add((WorkBreakdownElement)unwrappedE);
                if (debug) {
                    System.out.println("    unwrappedPredListMember: " + unwrappedE);
                }
            }
            if (!(e instanceof ItemProviderAdapter)) continue;
            unwrappedE = ((ItemProviderAdapter)e).getTarget();
            guidPredList.add((BreakdownElement)unwrappedE);
            if (!debug) continue;
            System.out.println("    unwrappedPredListMember: " + unwrappedE);
        }
        this.wbsWrapperPathToPredListMap.put(this.currentElementPath, guidPredList);
        if (debug) {
            System.out.println("    __wrapperPredList: " + guidPredList);
        }
        ++this.task_uid;
        return task;
    }

    private String getBriefDescription(WorkBreakdownElement element) {
        TaskDescriptor taskDescriptor;
        Task ref_edTask;
        if (element == null) {
            return null;
        }
        String briefDesc = element.getBriefDescription();
        if ((briefDesc == null || briefDesc.trim().length() <= 0) && element instanceof TaskDescriptor && (ref_edTask = (taskDescriptor = (TaskDescriptor)element).getTask()) != null) {
            MethodElement realizedElement = ConfigurationHelper.getCalculatedElement((MethodElement)ref_edTask, (MethodConfiguration)this.processConfig);
            if (debug) {
                System.out.println("$$$ realizedElement = " + realizedElement);
            }
            if (realizedElement != null) {
                EAttribute attribute = UmaPackage.eINSTANCE.getMethodElement_BriefDescription();
                Object briefDescObj = ConfigurationHelper.calcAttributeFeatureValue((MethodElement)realizedElement, (EStructuralFeature)attribute, (MethodConfiguration)this.processConfig);
                briefDesc = briefDescObj.toString();
                if (debug) {
                    System.out.println("$$$ realized brief desc = " + briefDesc);
                }
            }
        }
        return briefDesc;
    }

    private void addAssignment(String resName, int taskUid, Project proj) {
        Assignment assignment = this.projectFactory.createAssignment();
        assignment.setUID(BigInteger.valueOf(this.assign_uid));
        assignment.setTaskUID(BigInteger.valueOf(taskUid));
        BigInteger resID = (BigInteger)this.rolesToUidMap.get(resName);
        assignment.setResourceUID(resID);
        proj.getAssignments().getAssignment().add((Object)assignment);
        ++this.assign_uid;
    }

    private List getRolesForTaskD(TaskDescriptor taskDescriptor) {
        ArrayList<String> rolesList = new ArrayList<String>();
        for (RoleDescriptor rd : taskDescriptor.getPerformedPrimarilyBy()) {
            RoleDescriptor roleDescrp = (RoleDescriptor)ConfigurationHelper.getCalculatedElement((MethodElement)rd, (MethodConfiguration)this.breakdownElementFilter.getMethodConfiguration());
            if (roleDescrp == null) continue;
            rolesList.add(this.getDisplayName((MethodElement)roleDescrp));
        }
        List roleDescrpList = ConfigurationHelper.getCalculatedElements((List)taskDescriptor.getAdditionallyPerformedBy(), (MethodConfiguration)this.breakdownElementFilter.getMethodConfiguration());
        for (RoleDescriptor roleDescrp : roleDescrpList) {
            rolesList.add(this.getDisplayName((MethodElement)roleDescrp));
        }
        return rolesList;
    }

    private List getRolesForTask(Task umaTask) {
        ArrayList<String> rolesList = new ArrayList<String>();
        for (Role role : umaTask.getPerformedBy()) {
            if (role == null) continue;
            rolesList.add(this.getDisplayName((MethodElement)role));
        }
        List list = umaTask.getAdditionallyPerformedBy();
        for (Role role : list) {
            rolesList.add(this.getDisplayName((MethodElement)role));
        }
        return rolesList;
    }

    private boolean calculateRollupRoles(IStructuredContentProvider contentProvider, BreakdownElement breakdownElement, List rollupRoles) {
        boolean isAnySubTaskPlanned = false;
        Object[] elements = contentProvider.getElements((Object)breakdownElement);
        int i = 0;
        while (i < elements.length) {
            Object wrappedElement;
            Object element = elements[i];
            if (element instanceof Activity) {
                isAnySubTaskPlanned = !this.exportOnlyPlannedElements || ((Activity)element).getIsPlanned().booleanValue() ? true : this.calculateRollupRoles(contentProvider, (BreakdownElement)element, rollupRoles);
            } else if (element instanceof ActivityWrapperItemProvider) {
                wrappedElement = TngUtil.unwrap((Object)element);
                if (wrappedElement instanceof Activity) {
                    isAnySubTaskPlanned = !this.exportOnlyPlannedElements || ((Activity)wrappedElement).getIsPlanned().booleanValue() ? true : this.calculateRollupRoles(contentProvider, (BreakdownElement)wrappedElement, rollupRoles);
                }
            } else if (element instanceof TaskDescriptor) {
                TaskDescriptor descriptor = (TaskDescriptor)element;
                if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                    isAnySubTaskPlanned = true;
                } else {
                    rollupRoles.addAll(this.getRolesForTaskD((TaskDescriptor)element));
                }
            } else if (element instanceof TaskDescriptorWrapperItemProvider && (wrappedElement = TngUtil.unwrap((Object)element)) instanceof TaskDescriptor) {
                TaskDescriptor descriptor = (TaskDescriptor)wrappedElement;
                if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                    isAnySubTaskPlanned = true;
                } else {
                    rollupRoles.addAll(this.getRolesForTaskD((TaskDescriptor)wrappedElement));
                }
            }
            ++i;
        }
        return isAnySubTaskPlanned;
    }

    private void storeTaskPredecessors(WorkBreakdownElement element) {
        if (element == null) {
            return;
        }
        List predecessors = element.getLinkToPredecessor();
        ArrayList<String> predList = new ArrayList<String>();
        if (predecessors != null && predecessors.size() > 0) {
            for (WorkOrder workOrder : predecessors) {
                String predGuid;
                WorkBreakdownElement predecessor = workOrder.getPred();
                if (debug) {
                    System.out.println("    localPredListMember: " + predecessor);
                }
                if (predecessor == null || (predGuid = predecessor.getGuid()) == null) continue;
                predList.add(predGuid);
            }
        }
        if (debug) {
            System.out.println("   local predlist for " + element.getName() + " = " + ((Object)predList).toString());
        }
        this.wbsWapperPathToLocalPredListMap.put(this.currentElementPath, predList);
    }

    protected void generateLinks(Process process, Project project) throws Exception {
        EList tasks = project.getTasks().getTask();
        for (org.eclipse.epf.msproject.Task task : tasks) {
            BigInteger taskUid = task.getUID();
            if (taskUid.intValue() == 0) continue;
            String wbsPathStr = (String)this.taskUidToWbsWapperPathMap.get(taskUid);
            HashMap<String, WorkOrder> predGuidToWOMap = this.getPredGuidToWOMap(this.taskToWbeMap.get(task));
            ArrayList predList = (ArrayList)this.wbsWrapperPathToPredListMap.get(wbsPathStr);
            if (predList == null) continue;
            ArrayList<MethodElement> removeList = new ArrayList<MethodElement>();
            for (MethodElement predElem : predList) {
                String predGuid = predElem.getGuid();
                BigInteger predTaskUid = (BigInteger)this.wbsGuidToTaskUidMap.get(predGuid);
                if (predTaskUid == null || predTaskUid.intValue() == taskUid.intValue()) continue;
                if (debug) {
                    System.out.println("$$$ taskUid = " + taskUid + ", wbsPathStr = " + wbsPathStr);
                    System.out.println("    localPredList: " + predList);
                    System.out.println("    found pred guid: " + predGuid);
                }
                removeList.add(predElem);
                PredecessorLink preLink = this.projectFactory.createPredecessorLink();
                task.getPredecessorLink().add((Object)preLink);
                preLink.setPredecessorUID(predTaskUid);
                BigInteger bigInt = this.getLinkTypeInt(predGuidToWOMap.get(predGuid));
                if (bigInt != null) {
                    preLink.setType(bigInt);
                }
                preLink.setCrossProject(false);
                preLink.setLinkLag(new BigInteger("0"));
                preLink.setLagFormat(new BigInteger("7"));
            }
            predList.removeAll(removeList);
        }
    }

    private BigInteger getLinkTypeInt(WorkOrder wo) {
        if (wo == null) {
            if (debug) {
                System.out.println("Warning> getLinkTypeInt, wo == null.");
            }
            return null;
        }
        WorkOrderType woType = wo.getLinkType();
        if (woType == WorkOrderType.FINISH_TO_START) {
            return new BigInteger("1");
        }
        if (woType == WorkOrderType.START_TO_START) {
            return new BigInteger("3");
        }
        if (woType == WorkOrderType.FINISH_TO_FINISH) {
            return new BigInteger("0");
        }
        if (woType == WorkOrderType.START_TO_FINISH) {
            return new BigInteger("2");
        }
        return null;
    }

    private HashMap<String, WorkOrder> getPredGuidToWOMap(WorkBreakdownElement wbe) {
        HashMap<String, WorkOrder> predGuidToWOMap = new HashMap<String, WorkOrder>();
        if (wbe != null) {
            List woList = wbe.getLinkToPredecessor();
            int sz = woList == null ? 0 : woList.size();
            int i = 0;
            while (i < sz) {
                WorkOrder wo = (WorkOrder)woList.get(i);
                if (wo != null && wo.getPred() != null) {
                    predGuidToWOMap.put(wo.getPred().getGuid(), wo);
                }
                ++i;
            }
        }
        return predGuidToWOMap;
    }

    protected String getElementURL(MethodElement element) {
        if (element == null) {
            return null;
        }
        String elementPath = null;
        String elementFileName = null;
        try {
            elementPath = ResourceHelper.getElementPath((MethodElement)element);
            elementFileName = ResourceHelper.getFileName((MethodElement)element, (String)".html");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        if (elementPath != null && elementFileName != null) {
            elementPath = elementPath.replace('\\', '/');
            elementFileName = elementFileName.replace('\\', '/');
            String url = String.valueOf(this.contentFolderName) + "/" + elementPath + elementFileName;
            return String.valueOf(this.abTargetDir) + File.separator + url;
        }
        return "";
    }

    protected String getDisplayName(MethodElement element) {
        String name = null;
        if (element instanceof BreakdownElement) {
            name = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)element));
        } else if (element instanceof DescribableElement) {
            name = ((DescribableElement)element).getPresentationName();
        }
        if (name == null || name.length() == 0) {
            name = element.getName();
        }
        return XMLUtil.escapeAttr((String)name);
    }

    protected boolean publishConfiguration(String dir, MethodConfiguration config, PublishOptions publishConfigOptions) throws Exception {
        PublishManager publishMgr = null;
        try {
            publishMgr = new PublishManager();
            publishMgr.init(dir, config, (PublishOptions)new PublishHTMLOptions(publishConfigOptions));
            ExportMSPXMLOperation operation = new ExportMSPXMLOperation((AbstractPublishManager)publishMgr);
            PublishProgressMonitorDialog dlg = new PublishProgressMonitorDialog(Display.getCurrent().getActiveShell(), publishMgr.getViewBuilder());
            boolean success = UIHelper.runWithProgress((IRunnableWithProgress)operation, (IRunnableContext)dlg, (boolean)true, (String)ExportMSPResources.exportMSPWizard_title);
            if (operation.getException() != null) {
                throw operation.getException();
            }
            boolean bl = success && !dlg.getProgressMonitor().isCanceled();
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (publishMgr != null) {
                publishMgr.dispose();
                publishMgr = null;
            }
        }
    }

    private static void printMSProject(Project project) {
        System.out.println("\n$$$ read-in project = " + project);
        EList tasks = project.getTasks().getTask();
        for (org.eclipse.epf.msproject.Task element : tasks) {
            System.out.println("$$$ a task = " + element);
        }
        EList resources = project.getResources().getResource();
        for (Resource element : resources) {
            System.out.println("$$$ a resource = " + element);
        }
        EList assignments = project.getAssignments().getAssignment();
        for (Assignment element : assignments) {
            System.out.println("$$$ an assignment = " + element);
        }
        System.out.println("$$$===\n");
    }

    protected HashMap<org.eclipse.epf.msproject.Task, WorkBreakdownElement> getTaskToWbeMap() {
        return this.taskToWbeMap;
    }

    protected void setProjectExtendedAttributes(Project project) {
    }

    protected void generateWPDs(MethodConfiguration config) {
    }
}

