/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.IDiagramMigration;
import org.eclipse.epf.migration.diagram.DiagramMigrationPlugin;
import org.eclipse.epf.migration.diagram.ad.services.WorkflowExportService;
import org.eclipse.epf.migration.diagram.util.MigrationUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramMigration
implements IDiagramMigration {
    protected boolean debug;

    public void migrate(Collection<Process> processes) throws Exception {
        this.debug = DiagramMigrationPlugin.getDefault().isDebugging();
        WorkflowExportService service = new WorkflowExportService();
        int errorCount = 0;
        MethodLibrary lib = null;
        for (Process proc : processes) {
            String modelFilePath;
            if (lib == null) {
                lib = UmaUtil.getMethodLibrary((EObject)proc);
            }
            if (this.debug) {
                System.out.println("LD> proc: " + proc);
                System.out.println("LD>  proc.eResource(): " + proc.eResource());
                if (proc.eResource() != null) {
                    System.out.println("LD>  proc.eResource().getURI(): " + proc.eResource());
                }
            }
            String string = modelFilePath = proc.eResource() == null ? null : proc.eResource().getURI().toFileString();
            if (modelFilePath == null) continue;
            File cpFolderPath = new File(modelFilePath).getParentFile();
            String diagramFilePath = String.valueOf(cpFolderPath.getAbsolutePath()) + File.separator + "diagram.xmi";
            File diagramFile = new File(diagramFilePath);
            if (diagramFile.exists()) {
                diagramFile.delete();
                System.out.println("LD> Deleted diagramFile: " + diagramFile);
                ResourceUtil.refreshResources((MethodLibrary)lib, null);
            }
            if (this.debug) {
                System.out.println("LD> diagramFile: " + diagramFile);
            }
            try {
                service.export(proc, (Activity)proc, "diagram.xmi", cpFolderPath);
            }
            catch (Exception exception) {
                ++errorCount;
                if (!this.debug) continue;
                System.out.println("LD> failed: " + diagramFile);
            }
        }
        if (this.debug) {
            System.out.println("LD> processes.size(): " + processes.size());
            System.out.println("LD> errorCount: " + errorCount);
            System.out.println("");
        }
        this.removeOldDiagrams(processes, lib);
    }

    private void removeOldDiagrams(Collection<Process> processes, MethodLibrary lib) {
        block9: {
            if (lib == null) {
                return;
            }
            boolean needSave = false;
            if (this.debug) {
                System.out.println("LD> removeOldDiagrams ...");
            }
            for (Process proc : processes) {
                boolean dirty = false;
                try {
                    Map activities = MigrationUtil.getActivities(proc, true);
                    for (Activity act : activities.values()) {
                        ProcessPackage pkg;
                        EObject container = act.eContainer();
                        if (!(container instanceof ProcessPackage) || (pkg = (ProcessPackage)container).getDiagrams().isEmpty()) continue;
                        ArrayList removeList = new ArrayList(pkg.getDiagrams());
                        pkg.getDiagrams().removeAll(removeList);
                        dirty = true;
                        if (!this.debug) continue;
                        System.out.println("LD> proc: " + proc);
                        System.out.println("LD>  pkg: ");
                    }
                    if (!dirty) continue;
                    proc.eResource().setModified(true);
                    needSave = true;
                }
                catch (Exception e) {
                    if (!this.debug) continue;
                    e.printStackTrace();
                }
            }
            if (needSave) {
                Resource resource = lib.eResource();
                MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
                Map saveOptions = resourceSet.getDefaultSaveOptions();
                try {
                    resourceSet.save(saveOptions, true);
                }
                catch (Exception e) {
                    if (!this.debug) break block9;
                    e.printStackTrace();
                }
            }
        }
    }
}

