/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;

public class AttributeFeatureValue
extends FeatureValue {
    LinkedHashMap valueMap = new LinkedHashMap();

    public AttributeFeatureValue(MethodElement element, MethodElement ownerElement, Object feature, ElementRealizer realizer) {
        super(element, ownerElement, feature, realizer);
    }

    public void add(VariabilityElement owner, Object value) {
        if (value == null || value instanceof String && value.toString().trim().length() == 0) {
            return;
        }
        this.valueMap.put(owner, value);
    }

    public int size() {
        return this.valueMap.size();
    }

    public Object getValue() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry entry : this.valueMap.entrySet()) {
            String str;
            MethodElement e = (MethodElement)entry.getKey();
            Object v = entry.getValue();
            if (v == null || v.toString().length() == 0 || this.isExtendReplaceEnabled() && AttributeFeatureValue.isBlankIndicator(str = StrUtil.getPlainText((String)v.toString()).trim())) continue;
            if (this.feature == UmaPackage.eINSTANCE.getMethodElement_PresentationName()) {
                if (this.size() > 1 && debug) {
                    System.out.println("AttributeFeatureValue: Presentation Name get more then one entry: " + LibraryUtil.getTypeName(this.element));
                }
                return v;
            }
            if (this.feature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments() && v instanceof String) {
                List vList = TngUtil.convertGuidanceAttachmentsToList((String)((String)v));
                for (String str2 : vList) {
                    this.modifyBuffer(buffer, e, str2);
                }
                continue;
            }
            this.modifyBuffer(buffer, e, v);
        }
        return buffer.toString();
    }

    private void modifyBuffer(StringBuffer buffer, MethodElement e, Object v) {
        if (buffer.length() > 0) {
            buffer.append("<p/>");
        }
        if (e == this.element && !(e instanceof Section) || e == null) {
            buffer.append(v);
        } else {
            String contentPath = ResourceHelper.getElementPath(e instanceof ContentDescription ? (MethodElement)e.eContainer() : e);
            String backPath = ResourceHelper.getBackPath(this.element instanceof ContentDescription ? (this.ownerElement != null ? this.ownerElement : (MethodElement)this.element.eContainer()) : this.element);
            if (this.feature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments()) {
                buffer.append(ResourceHelper.resolveUrl(v.toString(), contentPath, backPath));
            } else {
                buffer.append(ResourceHelper.fixContentUrlPath(v.toString(), contentPath, backPath));
            }
        }
    }
}

