/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.Log;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;

public class ConfigurationFilter
extends AdapterImpl
implements IConfigurator {
    protected MethodConfiguration methodConfig;
    private boolean discardContributors = true;

    public ConfigurationFilter(MethodConfiguration methodConfig) {
        this.methodConfig = methodConfig;
    }

    public ConfigurationFilter(MethodConfiguration methodConfig, boolean discardContributors) {
        this(methodConfig);
        this.discardContributors = discardContributors;
    }

    public boolean accept(Object obj) {
        if (this.methodConfig == null) {
            return true;
        }
        obj = LibraryUtil.unwrap(obj);
        if ((ElementRealizer.isExtendReplaceEnabled() || obj instanceof VariabilityElement && ConfigurationHelper.isExtendReplacer((VariabilityElement)obj)) && FeatureValue.isBlankIndicator(obj)) {
            return false;
        }
        if (obj instanceof MethodPackage) {
            return this.methodConfig.getMethodPackageSelection().contains(obj);
        }
        if (obj instanceof MethodElement) {
            return ConfigurationHelper.canShow((MethodElement)obj, this.methodConfig);
        }
        if (obj instanceof ItemProviderAdapter) {
            return true;
        }
        if (Log.DEBUG) {
            System.out.println("Object filtered: " + (obj == null ? null : obj.toString()));
        }
        return false;
    }

    public Collection getChildren(Object obj, EStructuralFeature childFeature) {
        if (this.methodConfig == null) {
            return null;
        }
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.methodConfig);
        realizer.setDiscardContributor(this.discardContributors);
        if (childFeature != null && childFeature.isMany() && obj instanceof MethodElement) {
            List value = ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, childFeature, realizer);
            return value;
        }
        return null;
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.methodConfig;
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        this.methodConfig = config;
    }

    protected void resolveElementVariabilityList(VariabilityElement element, VariabilityInfo info, boolean includeBase, ElementRealizer realizer) {
        if (this.methodConfig == null) {
            return;
        }
        this.resolveElementContributors(element, info, realizer);
        if (ConfigurationHelper.isExtender(element)) {
            List values;
            VariabilityElement base = element.getVariabilityBasedOnElement();
            VariabilityElement e = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)base, realizer);
            if (includeBase && !(values = info.getInheritanceList()).contains(e)) {
                values.add(e);
            }
            this.resolveElementVariabilityList(e, info, includeBase, realizer);
        }
    }

    protected void resolveElementContributors(VariabilityElement element, VariabilityInfo info, ElementRealizer realizer) {
        List items = ConfigurationHelper.getContributors(element, this.methodConfig);
        if (items != null && items.size() > 0) {
            for (VariabilityElement e : items) {
                List values = info.getContributors();
                if (!values.contains(e)) {
                    values.add(e);
                }
                this.resolveElementVariabilityList(e, info, false, realizer);
            }
        }
    }

    public VariabilityInfo getVariabilityInfo(VariabilityElement ve) {
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.methodConfig, true, true);
        return this.getVariabilityInfo(ve, realizer);
    }

    protected VariabilityInfo getVariabilityInfo(VariabilityElement ve, ElementRealizer realizer) {
        VariabilityElement e = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)ve, realizer);
        if (e == null) {
            return null;
        }
        VariabilityInfo info = new VariabilityInfo(ve);
        info.getInheritanceList().add(e);
        this.resolveElementVariabilityList(e, info, true, realizer);
        return info;
    }

    public Object resolve(Object element) {
        if (element instanceof VariabilityElement) {
            ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(this.methodConfig, true, true);
            return ConfigurationHelper.getCalculatedElement((MethodElement)element, realizer);
        }
        return element;
    }

    public IFilter getUncategorizedTaskFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof Task && ConfigurationHelper.calc0nFeatureValue((MethodElement)((Task)obj), AssociationHelper.Task_Disciplines, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getDomainUncategorizedWorkProductFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof WorkProduct && ConfigurationHelper.calc0nFeatureValue((MethodElement)((WorkProduct)obj), AssociationHelper.WorkProduct_Domains, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getWpTypeUncategorizedWorkProductFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof WorkProduct && ConfigurationHelper.calc0nFeatureValue((MethodElement)((WorkProduct)obj), AssociationHelper.WorkProduct_WorkProductTypes, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getUncategorizedRoleFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof Role && ConfigurationHelper.calc0nFeatureValue((MethodElement)((Role)obj), AssociationHelper.Role_RoleSets, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getUncategorizedToolMentorFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                return obj instanceof ToolMentor && ConfigurationHelper.calc0nFeatureValue((MethodElement)((ToolMentor)obj), AssociationHelper.ToolMentor_Tools, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getDisciplinesFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                if (obj instanceof DisciplineGrouping) {
                    return true;
                }
                return obj instanceof Discipline && ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, AssociationHelper.Discipline_DisciplineGroupings, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getRoleSetsFilter() {
        return new IFilter(){

            public boolean accept(Object obj) {
                if (obj instanceof RoleSetGrouping) {
                    return true;
                }
                return obj instanceof RoleSet && ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, AssociationHelper.RoleSet_RoleSetGrouppings, DefaultElementRealizer.newElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }
}

