/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ConfigHelperDelegate;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.AttributeFeatureValue;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.configuration.OrderedListComparator;
import org.eclipse.epf.library.configuration.ToManyFeatureValue;
import org.eclipse.epf.library.configuration.ToManyOppositeFeatureValue;
import org.eclipse.epf.library.configuration.ToOneFeatureValue;
import org.eclipse.epf.library.configuration.ToOneOppositeFeatureValue;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.FulfillableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper {
    private static ConfigHelperDelegate delegate;
    private static boolean inheritingSlotFeatures;
    public static final String ATTRIBUTE_VALUE_SEPERATOR = "<p/>";
    private static boolean debug;

    static {
        ConfigHelperDelegate extendedDelegate = (ConfigHelperDelegate)ExtensionHelper.getExtension((String)LibraryPlugin.getDefault().getId(), (String)"configHelperDelegateExt");
        delegate = extendedDelegate == null ? new ConfigHelperDelegate() : extendedDelegate;
        inheritingSlotFeatures = false;
        debug = LibraryPlugin.getDefault().isDebugging();
    }

    public static ConfigHelperDelegate getDelegate() {
        return delegate;
    }

    public static boolean isDescriptionElement(MethodElement element) {
        if (element == null) {
            return false;
        }
        return element instanceof ContentDescription || element.eContainer() instanceof ContentDescription;
    }

    public static boolean isGlobalPackage(MethodPackage pkg) {
        if (pkg == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: method package is null");
            }
            return false;
        }
        MethodPlugin p = LibraryUtil.getMethodPlugin((EObject)pkg);
        if (p == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: Unable to find method plug-in for " + pkg.getName() + ": " + pkg.getGuid());
            }
            return false;
        }
        return ConfigurationHelper.getDelegate().isSystemPackage(p, pkg);
    }

    public static boolean inConfig(MethodElement element, MethodConfiguration config) {
        return ConfigurationHelper.inConfig(element, config, true);
    }

    public static boolean inConfig(MethodElement element, MethodConfiguration config, boolean checkSubtracted) {
        return ConfigurationHelper.inConfig(element, config, checkSubtracted, true);
    }

    public static boolean inConfig(MethodElement element, MethodConfiguration config, boolean checkSubtracted, boolean checkBase) {
        VariabilityElement ve;
        if (!ConfigurationHelper.isOwnerSelected(element, config, checkSubtracted)) {
            return false;
        }
        if (checkBase && element instanceof VariabilityElement && ConfigurationHelper.isReplacer(ve = (VariabilityElement)element)) {
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            if (ConfigurationHelper.inConfig((MethodElement)base, config)) {
                for (VariabilityElement e : AssociationHelper.getImmediateVarieties((VariabilityElement)base)) {
                    if (e == element || e.getVariabilityType() != VariabilityType.REPLACES || !ConfigurationHelper.isOwnerSelected((MethodElement)e, config, checkSubtracted)) continue;
                    if (debug) {
                        System.out.println("ConfigurationHelper.inConfig: Ignoring replacing element '" + LibraryUtil.getTypeName(element) + "' since its base element has more than one replacer in the configuration");
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean isOwnerSelected(MethodElement element, MethodConfiguration config, boolean checkSubtracted) {
        return ConfigurationHelper.getDelegate().isOwnerSelected(element, config, checkSubtracted);
    }

    public static boolean isContributor(VariabilityElement element) {
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return element.getVariabilityType() == VariabilityType.CONTRIBUTES;
    }

    public static boolean isReplacer(VariabilityElement element) {
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return element.getVariabilityType() == VariabilityType.REPLACES;
    }

    public static boolean contrubuteChain(VariabilityElement a, VariabilityElement b) {
        VariabilityElement element = a;
        while (element != null) {
            if (element.getVariabilityType() != VariabilityType.CONTRIBUTES) {
                return false;
            }
            if ((element = element.getVariabilityBasedOnElement()) == null) {
                return false;
            }
            if (element != b) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtendReplacer(VariabilityElement element) {
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return element.getVariabilityType() == VariabilityType.EXTENDS_REPLACES;
    }

    public static boolean isExtender(VariabilityElement element) {
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return element.getVariabilityType() == VariabilityType.EXTENDS;
    }

    public static VariabilityElement getReplacer(VariabilityElement element, MethodConfiguration config) {
        VariabilityElement ve = null;
        for (VariabilityElement e : AssociationHelper.getImmediateVarieties((VariabilityElement)element)) {
            VariabilityType type;
            if (e == null || !ConfigurationHelper.inConfig((MethodElement)e, config) || (type = e.getVariabilityType()) != VariabilityType.REPLACES && type != VariabilityType.EXTENDS_REPLACES) continue;
            if (ve != null) {
                if (debug) {
                    System.out.println("ConfigurationHelper.getReplacer: Replacer ignored for element '" + LibraryUtil.getTypeName((MethodElement)element) + "' since it has more than one replacerin the configuration");
                }
                return null;
            }
            ve = e;
        }
        return ve;
    }

    public static List getContributors(VariabilityElement element, MethodConfiguration config) {
        ArrayList<VariabilityElement> items = new ArrayList<VariabilityElement>();
        if (element == null) {
            return items;
        }
        for (VariabilityElement e : AssociationHelper.getImmediateVarieties((VariabilityElement)element)) {
            if (e == null || e.getVariabilityType() != VariabilityType.CONTRIBUTES || !ConfigurationHelper.inConfig((MethodElement)e, config)) continue;
            VariabilityElement replacer = ConfigurationHelper.getReplacer(e, config);
            if (replacer != null) {
                items.add(replacer);
                continue;
            }
            items.add(e);
        }
        return items;
    }

    public static List getExtenders(VariabilityElement element, MethodConfiguration config) {
        ArrayList<VariabilityElement> items = new ArrayList<VariabilityElement>();
        if (element == null) {
            return items;
        }
        for (VariabilityElement e : AssociationHelper.getImmediateVarieties((VariabilityElement)element)) {
            if (e == null || e.getVariabilityType() != VariabilityType.EXTENDS || !ConfigurationHelper.inConfig((MethodElement)e, config)) continue;
            items.add(e);
        }
        return items;
    }

    public static Set<VariabilityElement> getLocalContributersAndReplacers(VariabilityElement element, MethodConfiguration config) {
        HashSet<VariabilityElement> items = new HashSet<VariabilityElement>();
        if (element == null) {
            return items;
        }
        for (VariabilityElement e : AssociationHelper.getImmediateVarieties((VariabilityElement)element)) {
            if (e == null || !ConfigurationHelper.isLocalContributerOrReplacer(e) || !ConfigurationHelper.inConfig((MethodElement)e, config)) continue;
            items.add(e);
        }
        return items;
    }

    private static boolean isLocalContributerOrReplacer(VariabilityElement ve) {
        VariabilityType type = ve.getVariabilityType();
        return type == VariabilityType.LOCAL_CONTRIBUTION || type == VariabilityType.LOCAL_REPLACEMENT;
    }

    public static boolean canShow(MethodElement element, MethodConfiguration config) {
        return ConfigurationHelper.canShow(element, config, true);
    }

    public static boolean canShow(MethodElement element, MethodConfiguration config, boolean checkSubtracted) {
        if (element == null) {
            return false;
        }
        if (!ConfigurationHelper.inConfig(element, config, checkSubtracted)) {
            return false;
        }
        Boolean supressed = element.getSuppressed();
        if (supressed != null && supressed.booleanValue()) {
            return false;
        }
        return !(element instanceof VariabilityElement) || ConfigurationHelper.canShowByCheckingVE((VariabilityElement)element, config);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean canShowByCheckingVE(VariabilityElement e, MethodConfiguration config) {
        if (ConfigurationHelper.isExtender(e)) {
            return true;
        }
        if (ConfigurationHelper.isContributor(e) || ConfigurationHelper.getReplacer(e, config) != null) {
            return false;
        }
        if (!(e instanceof Activity) || !ConfigurationHelper.hasContributor((Activity)e)) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (!ConfigurationHelper.isContributor(e = e.getVariabilityBasedOnElement())) continue;
            return false;
lbl9:
            // 2 sources

            ** while (e != null && ConfigurationHelper.isReplacer((VariabilityElement)e))
        }
lbl10:
        // 1 sources

        return true;
    }

    public static String getName(MethodElement element, MethodConfiguration config) {
        if (element instanceof VariabilityElement) {
            VariabilityElement e = (VariabilityElement)element;
            if (ConfigurationHelper.isContributor(e)) {
                return ConfigurationHelper.getName((MethodElement)e.getVariabilityBasedOnElement(), config);
            }
            VariabilityElement rep = ConfigurationHelper.getReplacer(e, config);
            if (rep != null) {
                return ConfigurationHelper.getName((MethodElement)rep, config);
            }
        }
        return element.getName();
    }

    public static String getPresentationName(MethodElement element, MethodConfiguration config) {
        String name = null;
        name = element.getPresentationName();
        if (StrUtil.isBlank((String)name) && element instanceof VariabilityElement) {
            EReference f = UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement();
            ElementRealizer r = DefaultElementRealizer.newElementRealizer(config);
            MethodElement me = element;
            HashSet<MethodElement> seens = new HashSet<MethodElement>();
            do {
                VariabilityElement oldMe = (VariabilityElement)me;
                if ((me = (DescribableElement)ConfigurationHelper.calc01FeatureValue(me, (EStructuralFeature)f, r)) == null || oldMe == me && (me = oldMe.getVariabilityBasedOnElement()) == null) break;
                name = ((DescribableElement)me).getPresentationName();
                if (seens.contains(me)) break;
                seens.add(me);
            } while (StrUtil.isBlank((String)name));
        }
        if (StrUtil.isBlank((String)name)) {
            name = TngUtil.getPresentationName((Object)element);
        }
        return name;
    }

    public static VariabilityElement getVariableOwner(MethodElement e) {
        EObject eObj;
        if (e instanceof VariabilityElement) {
            return (VariabilityElement)e;
        }
        if (e instanceof ContentDescription && (eObj = e.eContainer()) instanceof VariabilityElement) {
            return (VariabilityElement)eObj;
        }
        return null;
    }

    public static boolean isMergableAttribute(EStructuralFeature feature) {
        if (!feature.getEType().getInstanceClassName().equals("java.lang.String")) {
            return false;
        }
        return feature != UmaPackage.eINSTANCE.getMethodElement_Guid() && feature != UmaPackage.eINSTANCE.getNamedElement_Name() && feature != UmaPackage.eINSTANCE.getContentDescription_ExternalId() && feature != UmaPackage.eINSTANCE.getMethodElement_PresentationName();
    }

    public static boolean isAttributeFeature(EStructuralFeature feature) {
        return feature.getEType() instanceof EAttribute;
    }

    public static boolean is01Feature(EStructuralFeature feature) {
        return feature.getEType() instanceof EClass && !feature.isMany();
    }

    public static boolean is0nFeature(EStructuralFeature feature) {
        return feature.getEType() instanceof EClass && feature.isMany();
    }

    private static void calculateFeature(MethodElement element, MethodElement OwnerElement, EStructuralFeature feature, MethodConfiguration config, FeatureValue values, ElementRealizer realizer) {
        List features = LibraryUtil.getStructuralFeatures(element);
        if (!features.contains(feature)) {
            return;
        }
        VariabilityElement ve = ConfigurationHelper.getVariableOwner(OwnerElement == null ? element : OwnerElement);
        Object value = element.eGet(feature);
        values.add(ve, value);
        if (config == null) {
            return;
        }
        if (ve == null) {
            return;
        }
        ConfigurationHelper.__mergeBase(element, ve, feature, config, values, realizer);
        if (element instanceof FulfillableElement) {
            if (feature != UmaPackage.eINSTANCE.getFulfillableElement_Fulfills()) {
                ConfigurationHelper.mergeSlotFeatureValues((FulfillableElement)element, feature, config, values, realizer);
            }
        } else if (OwnerElement instanceof FulfillableElement) {
            ConfigurationHelper.mergeSlotFeatureValues(element, (FulfillableElement)OwnerElement, feature, config, values, realizer);
        }
        if (realizer != null) {
            realizer.addExtraFeatureValues(element, feature, values);
        }
        if (!ConfigurationHelper.is01Feature(feature) || values.size() == 0) {
            ConfigurationHelper.__mergeContributors(element, ve, feature, config, values, realizer);
        }
    }

    public static List<FulfillableElement> calcFulfillableElement_Fulfills(FulfillableElement element, MethodConfiguration config) {
        ArrayList<FulfillableElement> resultList = new ArrayList<FulfillableElement>();
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(config);
        List fullfillsObj = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getFulfillableElement_Fulfills(), realizer);
        if (!(fullfillsObj instanceof List)) {
            return resultList;
        }
        UmaPackage.eINSTANCE.getFulfillableElement_Fulfills();
        for (FulfillableElement slot : fullfillsObj) {
            if (!ConfigurationHelper.slotMatching(slot = (FulfillableElement)ConfigurationHelper.getCalculatedElement((MethodElement)slot, config), element, realizer)) continue;
            resultList.add(slot);
        }
        if (resultList.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getPresNameComparator();
            Collections.sort(resultList, comparator);
        }
        return resultList;
    }

    private static void mergeSlotFeatureValues(FulfillableElement element, EStructuralFeature feature, MethodConfiguration config, FeatureValue values, ElementRealizer realizer) {
        if (!inheritingSlotFeatures) {
            return;
        }
        if (feature == UmaPackage.eINSTANCE.getFulfillableElement_Fulfills()) {
            return;
        }
        if (!(element instanceof WorkProduct)) {
            return;
        }
        if (values.size() > 0) {
            return;
        }
        List<FulfillableElement> slots = ConfigurationHelper.calcFulfillableElement_Fulfills(element, config);
        for (FulfillableElement slot : slots) {
            if (!(slot instanceof WorkProduct)) continue;
            slot = (FulfillableElement)ConfigurationHelper.getCalculatedElement((MethodElement)slot, config);
            ConfigurationHelper.calculateFeature((MethodElement)slot, null, feature, config, values, realizer);
        }
    }

    private static void mergeSlotFeatureValues(MethodElement element, FulfillableElement OwnerElement, EStructuralFeature feature, MethodConfiguration config, FeatureValue values, ElementRealizer realizer) {
        if (!inheritingSlotFeatures) {
            return;
        }
        if (!(element instanceof ContentDescription)) {
            return;
        }
        if (!(OwnerElement instanceof WorkProduct)) {
            return;
        }
        if (values.size() > 0) {
            return;
        }
        List<FulfillableElement> slots = ConfigurationHelper.calcFulfillableElement_Fulfills(OwnerElement, config);
        for (FulfillableElement slot : slots) {
            if (!(slot instanceof WorkProduct)) continue;
            slot = (FulfillableElement)ConfigurationHelper.getCalculatedElement((MethodElement)slot, config);
            ContentDescription slotOwnedElement = slot.getPresentation();
            ConfigurationHelper.calculateFeature((MethodElement)slotOwnedElement, (MethodElement)slot, feature, config, values, realizer);
        }
    }

    private static void mergeSlotOppositeFeatureValues(FulfillableElement element, OppositeFeature feature, MethodConfiguration config, FeatureValue values, ElementRealizer realizer) {
        if (!inheritingSlotFeatures) {
            return;
        }
        if (feature == AssociationHelper.FulFills_FullFillableElements) {
            return;
        }
        if (!(element instanceof WorkProduct)) {
            return;
        }
        if (values.size() > 0) {
            return;
        }
        List<FulfillableElement> slots = ConfigurationHelper.calcFulfillableElement_Fulfills(element, config);
        for (FulfillableElement slot : slots) {
            slot = (FulfillableElement)ConfigurationHelper.getCalculatedElement((MethodElement)slot, config);
            ConfigurationHelper.calculateOppositeFeature((MethodElement)slot, feature, realizer, values);
        }
    }

    public static List<FulfillableElement> calcFulfills_FulfillableElement(FulfillableElement slot, MethodConfiguration config) {
        ArrayList<FulfillableElement> resultList = new ArrayList<FulfillableElement>();
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(config);
        List fulfillingList = ConfigurationHelper.calc0nFeatureValue((MethodElement)slot, AssociationHelper.FulFills_FullFillableElements, realizer);
        for (FulfillableElement element : fulfillingList) {
            if (!ConfigurationHelper.slotMatching(slot, element = (FulfillableElement)ConfigurationHelper.getCalculatedElement((MethodElement)element, config), realizer)) continue;
            resultList.add(element);
        }
        if (resultList.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getPresNameComparator();
            Collections.sort(resultList, comparator);
        }
        return resultList;
    }

    private static boolean slotMatching(FulfillableElement slot, FulfillableElement element, ElementRealizer realizer) {
        if (slot == null || !slot.getIsAbstract().booleanValue()) {
            return false;
        }
        if (realizer != null) {
            return realizer.slotMatching(slot, element);
        }
        return true;
    }

    private static void __mergeBase(MethodElement element, VariabilityElement ve, EStructuralFeature feature, MethodConfiguration config, FeatureValue values, ElementRealizer realizer) {
        boolean extendReplace = ConfigurationHelper.isExtendReplacer(ve) || ElementRealizer.isExtendReplaceEnabled() && ConfigurationHelper.isReplacer(ve);
        boolean isExtender = ConfigurationHelper.isExtender(ve);
        if (isExtender || extendReplace) {
            boolean mergebase = false;
            if (ConfigurationHelper.is0nFeature(feature)) {
                mergebase = true;
                if (extendReplace || isExtender && ElementRealizer.ignoreBaseToManyAssociations()) {
                    mergebase = values.size() == 0;
                }
            } else if (ConfigurationHelper.is01Feature(feature)) {
                mergebase = values.size() == 0;
            } else {
                boolean bl = mergebase = ConfigurationHelper.isMergableAttribute(feature) && values.size() == 0;
            }
            if (mergebase) {
                List containers;
                VariabilityElement e = ve.getVariabilityBasedOnElement();
                if (!extendReplace) {
                    e = ConfigurationHelper.getCalculatedElement((MethodElement)e, config);
                }
                VariabilityElement o = e;
                if (ConfigurationHelper.isContainmentFeature(feature) && (containers = ConfigurationHelper.getContainers((MethodElement)ve, config)).contains(e)) {
                    mergebase = false;
                }
                if (mergebase && ve != e && ConfigurationHelper.inConfig((MethodElement)e, config)) {
                    if (element instanceof ContentDescription) {
                        try {
                            e = ((DescribableElement)e).getPresentation();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    ConfigurationHelper.calculateFeature((MethodElement)e, (MethodElement)o, feature, config, values, realizer);
                    if (ve instanceof ContentElement && feature == UmaPackage.eINSTANCE.getContentDescription_Sections()) {
                        ConfigurationHelper.orderSections((ContentElement)ve, (List)values.getValue());
                    }
                }
            }
        }
    }

    private static void __mergeContributors(MethodElement element, VariabilityElement ve, EStructuralFeature feature, MethodConfiguration config, FeatureValue values, ElementRealizer realizer) {
        List items;
        boolean mergeable = true;
        if (ConfigurationHelper.isAttributeFeature(feature) && !ConfigurationHelper.isMergableAttribute(feature)) {
            mergeable = false;
        }
        if (mergeable && (items = ConfigurationHelper.getContributors(ve, config)) != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e;
                MethodElement o = e = (MethodElement)it.next();
                if (element instanceof ContentDescription) {
                    e = ((DescribableElement)e).getPresentation();
                }
                ConfigurationHelper.calculateFeature(e, o, feature, config, values, realizer);
            }
        }
    }

    private static void calculateOppositeFeature(MethodElement element, OppositeFeature feature, ElementRealizer realizer, FeatureValue values) {
        ConfigurationHelper.calculateOppositeFeature(element, feature, true, false, realizer, values);
    }

    private static void calculateOppositeFeature(MethodElement element, OppositeFeature feature, boolean mergeReplacerBase, boolean mergeExtenderBase, ElementRealizer realizer, FeatureValue values) {
        if (!(element instanceof MultiResourceEObject)) {
            return;
        }
        MethodConfiguration config = realizer.getConfiguration();
        VariabilityElement ve = ConfigurationHelper.getVariableOwner(element);
        Object value = ((MultiResourceEObject)element).getOppositeFeatureValue(feature);
        values.add(ve, value);
        if (element instanceof VariabilityElement && config != null) {
            boolean isExtendReplacer;
            VariabilityElement ce = (VariabilityElement)element;
            List items = ConfigurationHelper.getContributors(ce, config);
            if (items != null && items.size() > 0) {
                for (MethodElement e : items) {
                    ConfigurationHelper.calculateOppositeFeature(e, feature, mergeReplacerBase, mergeExtenderBase, realizer, values);
                }
            }
            boolean mergebase = false;
            boolean isExtender = ConfigurationHelper.isExtender(ce);
            boolean isReplacer = ConfigurationHelper.isReplacer(ce);
            boolean bl = isExtendReplacer = ConfigurationHelper.isExtendReplacer(ce) || ElementRealizer.isExtendReplaceEnabled() && isReplacer;
            if (isExtendReplacer) {
                isReplacer = true;
            }
            if (isReplacer) {
                mergebase = mergeReplacerBase && (value instanceof List || values.size() == 0);
            } else if (isExtender) {
                mergebase = mergeExtenderBase;
            }
            if (mergebase) {
                ElementRealizer realizer2 = DefaultElementRealizer.newElementRealizer(config, !isReplacer, !isReplacer);
                MethodElement e = ConfigurationHelper.getCalculatedElement((MethodElement)ce.getVariabilityBasedOnElement(), realizer2);
                if (e == null) {
                    e = ce.getVariabilityBasedOnElement();
                }
                if (e != ce && ConfigurationHelper.inConfig(e, config)) {
                    ConfigurationHelper.calculateOppositeFeature(e, feature, mergeReplacerBase, mergeExtenderBase, realizer, values);
                }
            }
            if (element instanceof FulfillableElement) {
                ConfigurationHelper.mergeSlotOppositeFeatureValues((FulfillableElement)element, feature, config, values, realizer);
            }
        }
    }

    public static List getCalculatedElements(List elements, MethodConfiguration config) {
        return ConfigurationHelper.getCalculatedElements(elements, DefaultElementRealizer.newElementRealizer(config));
    }

    public static List getCalculatedElements(List elements, ElementRealizer realizer) {
        ArrayList<MethodElement> values = new ArrayList<MethodElement>();
        for (MethodElement e : elements) {
            if ((e = ConfigurationHelper.getCalculatedElement(e, realizer)) == null || values.contains(e)) continue;
            values.add(e);
        }
        return values;
    }

    public static MethodElement getCalculatedElement(MethodElement element, MethodConfiguration config) {
        ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(config, true, true);
        return ConfigurationHelper.getCalculatedElement(element, realizer);
    }

    public static MethodElement getCalculatedElement(MethodElement element, ElementRealizer realizer) {
        MethodElement e2;
        MethodElement e = element;
        while ((e2 = realizer.realize(e)) != e) {
            e = e2;
        }
        return e;
    }

    public static MethodElement calc01FeatureValue(MethodElement element, EStructuralFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc01FeatureValue(element, null, feature, realizer);
    }

    public static MethodElement calc01FeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        Object v = element.eGet(feature);
        if (v instanceof ContentDescription) {
            return (MethodElement)v;
        }
        ToOneFeatureValue values = new ToOneFeatureValue(element, ownerElement, feature, realizer);
        ConfigurationHelper.calculateFeature(element, ownerElement, feature, realizer.getConfiguration(), values, realizer);
        return (MethodElement)values.getValue();
    }

    public static boolean isContainmentFeature(EStructuralFeature feature) {
        return feature == UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts() || feature == UmaPackage.eINSTANCE.getPractice_SubPractices();
    }

    public static boolean isContainmentElement(Object element) {
        return element instanceof Artifact || element instanceof Practice;
    }

    private static List getContainers(MethodElement element, MethodConfiguration config) {
        ArrayList<MethodElement> items = new ArrayList<MethodElement>();
        MethodElement o = element;
        while (o != null && (o = o.eContainer()) != null && o.getClass().isInstance(element)) {
            if (o instanceof VariabilityElement) {
                o = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)o), config);
            }
            if (o == null || items.contains(o)) continue;
            items.add(o);
        }
        return items;
    }

    public static OppositeFeature get01OppositeFeature(EStructuralFeature feature) {
        return null;
    }

    public static EStructuralFeature get01Feature(OppositeFeature oFeature) {
        return null;
    }

    public static List calc0nFeatureValue(MethodElement element, EStructuralFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc0nFeatureValue(element, null, feature, realizer);
    }

    public static List calc0nFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        OppositeFeature of;
        List v = null;
        MethodConfiguration config = realizer.getConfiguration();
        if (element instanceof Role && feature == UmaPackage.eINSTANCE.getRole_Modifies()) {
            v = ConfigurationHelper.calcModifiedWorkProducts((Role)element, ownerElement, realizer);
        } else if (element instanceof RoleDescriptor && feature == UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()) {
            v = ConfigurationHelper.calcModifiedWorkProductDescriptors((RoleDescriptor)element, ownerElement, realizer);
        } else {
            ToManyFeatureValue fv = new ToManyFeatureValue(element, ownerElement, feature, realizer);
            ConfigurationHelper.calculateFeature(element, ownerElement, feature, config, fv, realizer);
            v = (List)fv.getValue();
        }
        List values = ConfigurationHelper.getCalculatedElements(v, realizer);
        if (values.contains(element)) {
            values.remove(element);
        }
        if ((of = ConfigurationHelper.get01OppositeFeature(feature)) != null) {
            int i = 0;
            while (i < values.size()) {
                MethodElement o = (MethodElement)values.get(i);
                ElementRealizer r = DefaultElementRealizer.newElementRealizer(config);
                r.setShowSubtracted(realizer.showSubtracted());
                MethodElement oo = ConfigurationHelper.calc01FeatureValue(o, of, r);
                if (oo != element) {
                    values.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (ConfigurationHelper.isContainmentFeature(feature)) {
            List containers = ConfigurationHelper.getContainers(element, config);
            int i = 0;
            while (i < values.size()) {
                Object o = values.get(i);
                if (o == element || containers.contains(o)) {
                    values.remove(i);
                    continue;
                }
                ++i;
            }
        }
        List returnList = realizer.realize(element, feature, values);
        if (CategorySortHelper.needToSort((MethodElement)element, (EStructuralFeature)feature)) {
            returnList = CategorySortHelper.sortCategoryElements((MethodElement)element, (Object[])returnList.toArray(), (boolean)true);
        }
        return returnList;
    }

    public static boolean isContainerInList(MethodElement element, List items, MethodConfiguration config) {
        MethodElement o = element;
        while (o != null && (o = o.eContainer()) != null && o.getClass().isInstance(element)) {
            if (items.contains(o)) {
                return true;
            }
            if (o instanceof VariabilityElement) {
                o = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)o), config);
            }
            if (o == null || !items.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static Object calcAttributeFeatureValue(MethodElement element, EStructuralFeature feature, MethodConfiguration config) {
        return ConfigurationHelper.calcAttributeFeatureValue(element, null, feature, config);
    }

    public static Object calcAttributeFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, MethodConfiguration config) {
        if (ConfigurationHelper.isMergableAttribute(feature)) {
            ElementRealizer realizer = DefaultElementRealizer.newElementRealizer(config);
            AttributeFeatureValue values = new AttributeFeatureValue(element, ownerElement, feature, realizer);
            ConfigurationHelper.calculateFeature(element, ownerElement, feature, config, values, realizer);
            return values.getValue();
        }
        return element.eGet(feature);
    }

    public static List calc0nFeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc0nFeatureValue(element, feature, true, false, realizer);
    }

    public static List calc0nFeatureValue(MethodElement element, OppositeFeature feature, boolean mergeReplacerBase, boolean mergeExtenderBase, ElementRealizer realizer) {
        ToManyOppositeFeatureValue values = new ToManyOppositeFeatureValue(element, feature, realizer);
        ConfigurationHelper.calculateOppositeFeature(element, feature, mergeReplacerBase, mergeExtenderBase, realizer, values);
        return (List)values.getValue();
    }

    public static MethodElement calc01FeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        ToOneOppositeFeatureValue values = new ToOneOppositeFeatureValue(element, feature, realizer);
        ConfigurationHelper.calculateOppositeFeature(element, feature, realizer, values);
        return (MethodElement)values.getValue();
    }

    public static void orderSections(ContentElement element, List values) {
        String orderingGuide = element.getOrderingGuide();
        if (orderingGuide == null || orderingGuide.trim().length() == 0) {
            return;
        }
        SectionList slist = new SectionList(element, 2);
        if (ConfigurationHelper.isSameList(values, (List)slist)) {
            values.clear();
            values.addAll(slist);
            return;
        }
        OrderedListComparator comp = new OrderedListComparator(new ArrayList(values), (List)slist);
        TreeSet s = new TreeSet(comp);
        s.addAll(values);
        values.clear();
        values.addAll(s);
    }

    private static boolean isSameList(List l1, List l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (Object o : l1) {
            if (l2.contains(o)) continue;
            return false;
        }
        return true;
    }

    private static void calculateCopyright(MethodElement element, MethodConfiguration config, List values) {
        MethodElement e;
        VariabilityElement ve;
        SupportingMaterial copyright = (SupportingMaterial)ConfigurationHelper.getCalculatedElement((MethodElement)LibraryUtil.getCopyright(element), config);
        if (copyright != null && !values.contains(copyright)) {
            values.add(copyright);
        }
        if ((ve = ConfigurationHelper.getVariableOwner(element)) == null) {
            return;
        }
        if (config == null) {
            return;
        }
        List items = ConfigurationHelper.getContributors(ve, config);
        if (items != null && items.size() > 0) {
            for (MethodElement e2 : items) {
                ConfigurationHelper.calculateCopyright(e2, config, values);
            }
        }
        if (ConfigurationHelper.isExtender(ve) && ve != (e = ConfigurationHelper.getCalculatedElement((MethodElement)ve.getVariabilityBasedOnElement(), config)) && ConfigurationHelper.inConfig(e, config)) {
            ArrayList baseItems = new ArrayList();
            ConfigurationHelper.calculateCopyright(e, config, baseItems);
            if (baseItems.size() > 0) {
                int i = 0;
                while (i < values.size()) {
                    if (baseItems.contains(values.get(i))) {
                        values.remove(i);
                        continue;
                    }
                    ++i;
                }
                values.addAll(0, baseItems);
            }
        }
    }

    public static String getCopyrightText(MethodElement element, MethodConfiguration config) {
        StringBuffer copyrights = new StringBuffer();
        ArrayList items = new ArrayList();
        ConfigurationHelper.calculateCopyright(element, config, items);
        if (items.size() > 0) {
            for (SupportingMaterial copyright : items) {
                String statement = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)copyright.getPresentation(), (MethodElement)copyright, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), config);
                if (statement == null || statement.length() <= 0) continue;
                String contentPath = ResourceHelper.getElementPath((MethodElement)copyright);
                String backPath = ResourceHelper.getBackPath(element);
                statement = ResourceHelper.fixContentUrlPath(statement, contentPath, backPath);
                if (copyrights.length() > 0) {
                    copyrights.append(ATTRIBUTE_VALUE_SEPERATOR);
                }
                copyrights.append(statement);
            }
        }
        return copyrights.toString();
    }

    public static String getActivityStringAttribute(MethodElement e, MethodElement ownerElement, EAttribute attrib, MethodConfiguration config) {
        boolean isDesc;
        VariabilityElement ve;
        if (!String.class.isAssignableFrom(attrib.getEAttributeType().getInstanceClass())) {
            throw new IllegalArgumentException("The specified attribute is not of type String: " + attrib);
        }
        Object str = null;
        if (e instanceof ContentDescription) {
            ve = (VariabilityElement)e.eContainer();
            if (ve == null) {
                ve = (VariabilityElement)ownerElement;
            }
            isDesc = true;
        } else if (e instanceof VariabilityElement) {
            ve = (VariabilityElement)e;
            isDesc = false;
        } else {
            str = e.eGet((EStructuralFeature)attrib);
            return str == null ? "" : str.toString();
        }
        if (attrib == UmaPackage.eINSTANCE.getMethodElement_Guid() || attrib == UmaPackage.eINSTANCE.getNamedElement_Name()) {
            return (String)e.eGet((EStructuralFeature)attrib);
        }
        VariabilityElement base = ve.getVariabilityBasedOnElement();
        VariabilityType variabilityType = ve.getVariabilityType();
        if (base != null && variabilityType == VariabilityType.LOCAL_CONTRIBUTION) {
            Object strBase;
            if (isDesc) {
                str = ((DescribableElement)ve).getPresentation().eGet((EStructuralFeature)attrib);
                strBase = ConfigurationHelper.calcAttributeFeatureValue((MethodElement)((DescribableElement)base).getPresentation(), (MethodElement)base, (EStructuralFeature)attrib, config);
            } else {
                str = ve.eGet((EStructuralFeature)attrib);
                strBase = ConfigurationHelper.calcAttributeFeatureValue((MethodElement)base, null, (EStructuralFeature)attrib, config);
            }
            if (strBase != null && strBase.toString().length() > 0) {
                str = str != null && str.toString().length() > 0 ? strBase + ATTRIBUTE_VALUE_SEPERATOR + str : strBase;
            }
        } else {
            str = ConfigurationHelper.calcAttributeFeatureValue(e, (MethodElement)ve, (EStructuralFeature)attrib, config);
        }
        return str == null ? "" : str.toString();
    }

    public static List getAllProcesses(MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List plugins = config.getMethodPluginSelection();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            List items = TngUtil.getAllProcesses((MethodPlugin)((MethodPlugin)it.next()));
            for (Process p : items) {
                if (!ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
                processes.add(p);
            }
        }
        return processes;
    }

    public static List getAllProcesses(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        for (Process p : items) {
            if (!ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List getAllDeliveryProcesses(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        for (Process p : items) {
            if (!(p instanceof DeliveryProcess) || !ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List getAllCapabilityPatterns(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        for (Process p : items) {
            if (!(p instanceof CapabilityPattern) || !ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List calcModifiedWorkProducts(Role element, MethodElement ownerElement, ElementRealizer realizer) {
        List v = new ArrayList();
        OppositeFeature ofeature = AssociationHelper.Role_Primary_Tasks;
        ToManyOppositeFeatureValue fv2 = new ToManyOppositeFeatureValue((MethodElement)element, ofeature, realizer);
        ConfigurationHelper.calculateOppositeFeature((MethodElement)element, ofeature, realizer, fv2);
        if (fv2.size() > 0) {
            List v2 = (List)fv2.getValue();
            EReference feature = UmaPackage.eINSTANCE.getTask_Output();
            for (MethodElement e : v2) {
                ToManyFeatureValue fv = new ToManyFeatureValue((MethodElement)element, ownerElement, feature, realizer);
                ((List)fv.getValue()).addAll(v);
                ConfigurationHelper.calculateFeature(e, ownerElement, (EStructuralFeature)feature, realizer.getConfiguration(), fv, realizer);
                v = (List)fv.getValue();
            }
        }
        return v;
    }

    public static List calcModifiedWorkProductDescriptors(RoleDescriptor element, MethodElement ownerElement, ElementRealizer realizer) {
        List v = new ArrayList();
        OppositeFeature ofeature = AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors;
        ToManyOppositeFeatureValue fv2 = new ToManyOppositeFeatureValue((MethodElement)element, ofeature, realizer);
        ConfigurationHelper.calculateOppositeFeature((MethodElement)element, ofeature, realizer, fv2);
        if (fv2.size() > 0) {
            List v2 = (List)fv2.getValue();
            EReference feature = UmaPackage.eINSTANCE.getTaskDescriptor_Output();
            for (MethodElement e : v2) {
                ToManyFeatureValue fv = new ToManyFeatureValue((MethodElement)element, ownerElement, feature, realizer);
                ((List)fv.getValue()).addAll(v);
                ConfigurationHelper.calculateFeature(e, ownerElement, (EStructuralFeature)feature, realizer.getConfiguration(), fv, realizer);
                v = (List)fv.getValue();
            }
        }
        return v;
    }

    public static List calcModifyRoles(WorkProduct element, ElementRealizer realizer) {
        List tasks = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_OutputFrom_Tasks, realizer);
        ArrayList<Role> modifyRoles = new ArrayList<Role>();
        for (Task t : tasks) {
            List rList = ConfigurationHelper.calc0nFeatureValue((MethodElement)t, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy(), realizer);
            for (Role r : rList) {
                if (r == null || modifyRoles.contains(r)) continue;
                modifyRoles.add(r);
            }
        }
        return modifyRoles;
    }

    public static List calcModifyRoleDescriptors(WorkProductDescriptor element, ElementRealizer realizer) {
        List taskDescriptors = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProductDescriptor_OutputFrom_TaskDescriptors, realizer);
        ArrayList<RoleDescriptor> modifyRoles = new ArrayList<RoleDescriptor>();
        for (TaskDescriptor t : taskDescriptors) {
            RoleDescriptor r = (RoleDescriptor)ConfigurationHelper.calc01FeatureValue((MethodElement)t, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), realizer);
            if (r == null || modifyRoles.contains(r)) continue;
            modifyRoles.add(r);
        }
        return modifyRoles;
    }

    public static boolean hasContributor(Activity element) {
        if (ConfigurationHelper.isContributor((VariabilityElement)element)) {
            return true;
        }
        for (Object o : element.getBreakdownElements()) {
            if (!(o instanceof Activity) || !ConfigurationHelper.hasContributor((Activity)o)) continue;
            return true;
        }
        return false;
    }

    public static List getBaseProcesses(Activity element, MethodConfiguration config) {
        ArrayList value = new ArrayList();
        ConfigurationHelper.getBaseProcesses(element, config, value);
        return value;
    }

    public static void getBaseProcesses(Activity element, MethodConfiguration config, List value) {
        Activity base;
        if (ConfigurationHelper.isExtender((VariabilityElement)element) && (base = (Activity)element.getVariabilityBasedOnElement()) != null && !value.contains(base) && base instanceof Process) {
            if (ConfigurationHelper.canShow((MethodElement)base, config)) {
                value.add(base);
            }
            ConfigurationHelper.getBaseProcesses(base, config, value);
        }
        for (Object o : element.getBreakdownElements()) {
            if (!(o instanceof Activity)) continue;
            ConfigurationHelper.getBaseProcesses((Activity)o, config, value);
        }
    }

    public static URI getInheritingUri(DescribableElement obj, URI uri, VariabilityElement[] uriInheritingBases, MethodConfiguration config, int uriType) {
        VariabilityElement ve = (VariabilityElement)obj;
        VariabilityElement base = ve.getVariabilityBasedOnElement();
        if (base != null && (ve.getVariabilityType() == VariabilityType.EXTENDS || ve.getVariabilityType() == VariabilityType.EXTENDS_REPLACES) && (base = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)base, config)) != null) {
            if (uriType == 0) {
                uri = ((DescribableElement)base).getNodeicon();
            } else if (uriType == 1) {
                uri = ((DescribableElement)base).getShapeicon();
            }
            if (uri != null) {
                uriInheritingBases[0] = base;
            }
        }
        return uri;
    }
}

