/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.LayoutResources;

public class BrowsingLayoutSettings {
    public static BrowsingLayoutSettings INSTANCE = new BrowsingLayoutSettings();
    private boolean showExtraInfoForDescriptors = false;
    private boolean publishUnopenActivitydd = false;
    private boolean publishADForActivityExtension = false;
    private boolean useNewExtendSemantics = false;
    private File xslPath = null;
    private File cssPath = null;
    private File scriptPath = null;
    private List updatedSites = new ArrayList();

    public void setUseNewExtendSemantics(boolean flag) {
        this.useNewExtendSemantics = flag;
    }

    public boolean isUseNewExtendSemantics() {
        return this.useNewExtendSemantics;
    }

    public void setShowExtraInfoForDescriptors(boolean flag) {
        this.showExtraInfoForDescriptors = flag;
    }

    public boolean isShowExtraInfoForDescriptors() {
        return this.showExtraInfoForDescriptors;
    }

    public void setPublishUnopenActivitydd(boolean flag) {
        this.publishUnopenActivitydd = flag;
    }

    public boolean isPublishUnopenActivitydd() {
        return this.publishUnopenActivitydd;
    }

    public void setPublishADForActivityExtension(boolean flag) {
        this.publishADForActivityExtension = flag;
    }

    public boolean isPublishADForActivityExtension() {
        return this.publishADForActivityExtension;
    }

    public void setXslPath(File path) {
        this.xslPath = path;
    }

    public void setCssPath(File path) {
        this.cssPath = path;
    }

    public void setScriptPath(File path) {
        this.scriptPath = path;
    }

    public File getXslPath() {
        return this.xslPath;
    }

    public File getCssPath() {
        return this.cssPath;
    }

    public File getScriptPath() {
        return this.scriptPath;
    }

    public void setChanged() {
        this.updatedSites.clear();
    }

    public boolean needUpdate(String pubDir) {
        if (pubDir == null) {
            return false;
        }
        return !this.updatedSites.contains(pubDir);
    }

    public void update(HtmlBuilder builder) {
        if (builder == null || !this.needUpdate(builder.getPublishDir())) {
            if (builder != null && this.xslPath != null) {
                builder.setLayoutXslRootPath(this.xslPath.getAbsolutePath());
            }
            return;
        }
        if (this.xslPath == null || this.cssPath == null || this.scriptPath == null) {
            LayoutResources.copyLayoutFiles(builder.getPublishDir());
            builder.loadDefaultLayoutXsl();
        } else {
            builder.setLayoutXslRootPath(this.xslPath.getAbsolutePath());
            String include = "*.*,**/*.*";
            String exclude = null;
            boolean override = true;
            File folder = new File(builder.getPublishDir(), "css");
            LayoutResources.copyDir(this.cssPath, folder, include, exclude, override);
            folder = new File(builder.getPublishDir(), "scripts");
            LayoutResources.copyDir(this.scriptPath, folder, include, exclude, override);
        }
        this.updatedSites.add(builder.getPublishDir());
    }
}

