/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.preferences;

import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.library.LibraryPlugin;

public class LibraryPreferences {
    public static final String SAVED_METHOD_LIRARY_URI = "savedMethodLibraryURI";
    public static final String SAVED_METHOD_LIRARY_TYPE = "savedMethodLibraryType";
    public static final String DISCARD_UNRESOLVED_REFERENCES = "discardUnresolvedReferences";
    public static final String USE_NEW_EXTENDS_SEMANTICS = "useNewExtendsSemantics";
    public static final String ROLE_DIAGRAM_HORIZONTAL_SPACING = "roleDiagramHorizontalSpacing";
    public static final String ROLE_DIAGRAM_VERTICAL_SPACING = "roleDiagramVerticalSpacing";
    public static final String ROLE_DIAGRAM_MAX_TEXT_LINES = "roleDiagramElementLabelTextLines";
    private static final boolean DEFAULT_DISCARD_UNRESOLVED_REFERENCES = false;
    private static final boolean DEFAULT_USE_NEW_EXTENDS_SEMANTICS = false;
    private static final int DEFAULT_ROLE_DIAGRAM_HORIZONTAL_SPACING = 70;
    private static final int DEFAULT_ROLE_DIAGRAM_VERTICAL_SPACING = 30;
    private static final int DEFAULT_ROLE_DIAGRAM_MAX_TEXT_LINES = 3;
    private static IPreferenceStoreWrapper prefStore = LibraryPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(DISCARD_UNRESOLVED_REFERENCES, false);
        prefStore.setDefault(USE_NEW_EXTENDS_SEMANTICS, false);
        prefStore.setDefault(ROLE_DIAGRAM_HORIZONTAL_SPACING, 70);
        prefStore.setDefault(ROLE_DIAGRAM_VERTICAL_SPACING, 30);
        prefStore.setDefault(ROLE_DIAGRAM_MAX_TEXT_LINES, 3);
    }

    public static String getSavedMethodLibraryURI() {
        return prefStore.getString(SAVED_METHOD_LIRARY_URI);
    }

    public static void setSavedMethodLibraryURI(String value) {
        prefStore.setValue(SAVED_METHOD_LIRARY_URI, value);
    }

    public static String getSavedMethodLibraryType() {
        return prefStore.getString(SAVED_METHOD_LIRARY_TYPE);
    }

    public static void setSavedMethodLibraryType(String value) {
        prefStore.setValue(SAVED_METHOD_LIRARY_TYPE, value);
    }

    public static boolean getDefaultDiscardUnresolvedReferences() {
        return false;
    }

    public static boolean getDiscardUnresolvedReferences() {
        return prefStore.getBoolean(DISCARD_UNRESOLVED_REFERENCES);
    }

    public static void setDiscardUnresolvedReferences(boolean value) {
        prefStore.setValue(DISCARD_UNRESOLVED_REFERENCES, value);
    }

    public static boolean getDefaultUseNewExtendsSemantics() {
        return false;
    }

    public static boolean getUseNewExtendsSemantics() {
        return prefStore.getBoolean(USE_NEW_EXTENDS_SEMANTICS);
    }

    public static void setUseNewExtendsSemantics(boolean value) {
        prefStore.setValue(USE_NEW_EXTENDS_SEMANTICS, value);
    }

    public static int getDefaultRoleDiagramHorizontalSpacing() {
        return 70;
    }

    public static int getRoleDiagramHorizontalSpacing() {
        int value = prefStore.getInt(ROLE_DIAGRAM_HORIZONTAL_SPACING);
        return value > 0 ? value : 70;
    }

    public static void setRoleDiagramHorizontalSpacing(int value) {
        prefStore.setValue(ROLE_DIAGRAM_HORIZONTAL_SPACING, value);
    }

    public static int getDefaultRoleDiagramVerticalSpacing() {
        return 30;
    }

    public static int getRoleDiagramVerticalSpacing() {
        int value = prefStore.getInt(ROLE_DIAGRAM_VERTICAL_SPACING);
        return value > 0 ? value : 30;
    }

    public static void setRoleDiagramVerticalSpacing(int value) {
        prefStore.setValue(ROLE_DIAGRAM_VERTICAL_SPACING, value);
    }

    public static int getDefaultRoleDiagramMaximumTextLines() {
        return 3;
    }

    public static int getRoleDiagramMaximumTextLines() {
        int value = prefStore.getInt(ROLE_DIAGRAM_MAX_TEXT_LINES);
        return value > 0 ? value : 3;
    }

    public static void setRoleDiagramMaximumTextLines(int value) {
        prefStore.setValue(ROLE_DIAGRAM_MAX_TEXT_LINES, value);
    }
}

