/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.library.util.SAXParserXMI;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.GuidanceDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class CopyAttachmentsToNewLocation
extends MethodElementAddCommand.BasicResourceManager {
    private Collection modifiedResourceSet;
    private boolean debug = LibraryPlugin.getDefault().isDebugging();
    private Map elementToOldPluginMap;
    private MethodPlugin lastOldPlugin = null;

    public Collection copyReferencedContents(Collection elements, Map elementToOldPluginMap) {
        this.lastOldPlugin = null;
        this.modifiedResourceSet = new HashSet();
        if (elementToOldPluginMap == null) {
            return this.modifiedResourceSet;
        }
        this.elementToOldPluginMap = elementToOldPluginMap;
        for (Object o : elements) {
            if (o instanceof Resource) {
                Resource r = (Resource)o;
                for (EObject e : r.getContents()) {
                    this.HandleAttachmentsPlugin(e);
                }
                continue;
            }
            if (!(o instanceof EObject)) continue;
            EObject e = (EObject)o;
            this.HandleAttachmentsPlugin(e);
        }
        return this.modifiedResourceSet;
    }

    private void HandleAttachmentsPlugin(EObject e) {
        ContentDescription elementToProcess = null;
        if (this.elementToOldPluginMap != null && (MethodPlugin)this.elementToOldPluginMap.get(e) != null) {
            this.lastOldPlugin = (MethodPlugin)this.elementToOldPluginMap.get(e);
        }
        if (this.lastOldPlugin != null) {
            if (e instanceof DescribableElement) {
                DescribableElement de = (DescribableElement)e;
                try {
                    URI newNodeIconUri;
                    URI nodeIconUri;
                    URI newShapeIconUri;
                    URI shapeIconUri = de.getShapeicon();
                    if (shapeIconUri != null && (newShapeIconUri = this.handleIconURI(de, shapeIconUri)) != null) {
                        de.setShapeicon(newShapeIconUri);
                        this.modifiedResourceSet.add(de.eResource());
                    }
                    if ((nodeIconUri = de.getNodeicon()) != null && (newNodeIconUri = this.handleIconURI(de, nodeIconUri)) != null) {
                        de.setNodeicon(newNodeIconUri);
                        this.modifiedResourceSet.add(de.eResource());
                    }
                }
                catch (Exception ex) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
                }
                this.HandleAttachmentsPlugin((EObject)de.getPresentation());
                return;
            }
            if (e instanceof ContentDescription) {
                elementToProcess = (ContentDescription)e;
            } else if (e instanceof MethodElement) {
                elementToProcess = (MethodElement)e;
            } else if (this.debug) {
                System.out.println("CopyAttachmentsToNewLocation.HandleAttachmentsPlugin: unknown type " + e);
            }
            if (elementToProcess != null && elementToProcess.eResource() != null) {
                ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr((MethodElement)elementToProcess);
                ILibraryResourceManager lastOldPluginResMgr = ResourceHelper.getResourceMgr((MethodElement)this.lastOldPlugin);
                ContentResourceScanner scanner = this.getScanner((MethodElement)elementToProcess);
                String contentPath = ResourceHelper.getElementPath((MethodElement)elementToProcess);
                if (contentPath == null || contentPath.length() == 0) {
                    LibraryPlugin.getDefault().getLogger().logWarning(NLS.bind((String)LibraryResources.CopyAttachmentsToNewLocation_log_noContentPath, (Object[])new Object[]{elementToProcess.getName()}));
                    return;
                }
                String oldContentPath = contentPath.replaceFirst(UmaUtil.getMethodPlugin((EObject)elementToProcess).getName(), this.lastOldPlugin.getName());
                for (EAttribute attrib : elementToProcess.eClass().getEAllAttributes()) {
                    String newContent;
                    String content;
                    Object o = elementToProcess.eGet((EStructuralFeature)attrib);
                    if (!(o instanceof String) || (content = (String)o).length() <= 0 || (newContent = scanner.resolveResourcesPlugin(content, contentPath, oldContentPath)) == null || newContent.trim().length() == 0 || content.equals(newContent)) continue;
                    elementToProcess.eSet((EStructuralFeature)attrib, (Object)newContent);
                    this.modifiedResourceSet.add(elementToProcess.eResource());
                }
                if (elementToProcess instanceof GuidanceDescription) {
                    String attachmentString = ((GuidanceDescription)elementToProcess).getAttachments();
                    List attachmentList = TngUtil.convertGuidanceAttachmentsToList((String)attachmentString);
                    for (String attachment : attachmentList) {
                        Matcher m;
                        if (attachment == null || attachment.trim().length() <= 0 || (m = ResourceHelper.p_template_attachment_url.matcher(attachment)).find()) continue;
                        File srcContentPath = new File(lastOldPluginResMgr.resolve((MethodElement)this.lastOldPlugin, oldContentPath));
                        File srcFile = new File(srcContentPath, attachment);
                        File tgtContentPath = new File(resMgr.getPhysicalPath((MethodElement)elementToProcess));
                        File tgtFile = new File(tgtContentPath, attachment);
                        if (tgtFile.exists()) continue;
                        FileUtil.copyFile((File)srcFile, (File)tgtFile);
                    }
                }
            }
        }
        TreeIterator iter = e.eAllContents();
        while (iter.hasNext()) {
            EObject child = (EObject)iter.next();
            this.HandleAttachmentsPlugin(child);
        }
    }

    private URI handleIconURI(DescribableElement de, URI iconUri) throws URISyntaxException {
        URI srcUri = TngUtil.getFullPathURI((EObject)de, (URI)iconUri);
        String iconPath = NetUtil.decodedFileUrl((String)iconUri.getPath());
        if (iconPath.indexOf(this.lastOldPlugin.getName()) < 0) {
            srcUri = new File(String.valueOf(ResourceHelper.getPluginPath(this.lastOldPlugin)) + File.separator + iconPath).toURI();
        }
        File srcFile = new File(srcUri);
        URI tgtUri = new File(String.valueOf(ResourceHelper.getPluginPath((MethodElement)de)) + File.separator + iconPath).toURI();
        File tgtFile = new File(tgtUri);
        if (!tgtFile.exists()) {
            FileUtil.copyFile((File)srcFile, (File)tgtFile);
        }
        URI newIconUri = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)tgtFile, (File)new File(ResourceHelper.getPluginPath((MethodElement)de)))));
        return newIconUri;
    }

    private ContentResourceScanner getScanner(MethodElement owner) {
        File src_root;
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(owner);
        if (resMgr == null) {
            return null;
        }
        String rootContentPath = resMgr.getLogicalPluginPath(owner);
        File tgt_root = src_root = new File(resMgr.getPhysicalPluginPath(owner));
        ContentResourceScanner scanner = new ContentResourceScanner(src_root, tgt_root, rootContentPath, this.getValidator());
        return scanner;
    }

    public IContentValidator getValidator() {
        return null;
    }

    public static void copyAttachmentsLibrary(String oldLibDir, String newLibDir, List xmiList, IProgressMonitor monitor) {
        if (xmiList == null) {
            xmiList = FileUtil.fileList((File)new File(newLibDir), (String)"xmi");
        }
        if (monitor != null) {
            monitor.subTask(LibraryResources.copyingAttachmentsTask_name);
        }
        Iterator iter = xmiList.iterator();
        while (iter.hasNext()) {
            File xmiFile;
            if (monitor != null) {
                monitor.worked(1);
            }
            if (!(xmiFile = (File)iter.next()).exists()) continue;
            SAXParserXMI parser = new SAXParserXMI(null);
            parser.parse(xmiFile.getAbsolutePath());
            ContentResourceScanner scanner = new ContentResourceScanner(new File(oldLibDir), new File(newLibDir), null);
            CopyAttachmentsToNewLocation.HandleAttachments(parser.xmiMap, scanner, xmiFile.getParent().substring(newLibDir.length()));
        }
    }

    private static void HandleAttachments(HashMap eMap, ContentResourceScanner scanner, String contentPath) {
        String content = SAXParserXMI.getElementContent(eMap);
        if (content != null) {
            scanner.resolveResources(content, contentPath);
        }
        for (HashMap childMap : (ArrayList)eMap.get("children")) {
            CopyAttachmentsToNewLocation.HandleAttachments(childMap, scanner, contentPath);
        }
    }
}

