/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.epf.diagram.ad.commands.SetTypeCommand;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.util.TypeConverter;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;

public class NestedCommandProvider
implements INestedCommandProvider {
    public Command createNestedCommand(Command command) {
        if (command instanceof TypeConverter.TypeConversionCommand) {
            return this.createNestedCommandForTypeConversion(command);
        }
        return null;
    }

    private Command createNestedCommandForTypeConversion(Command command) {
        Process proc;
        Collection result = command.getResult();
        org.eclipse.epf.uma.Activity activity = null;
        if (!result.isEmpty()) {
            Object e = result.iterator().next();
            if (e instanceof org.eclipse.epf.uma.Activity) {
                activity = (org.eclipse.epf.uma.Activity)e;
            } else {
                return null;
            }
        }
        if (activity != null && (proc = TngUtil.getOwningProcess(activity)) != null) {
            DiagramManager mgr = DiagramManager.getInstance((Process)proc, (Object)this);
            try {
                String newType = BridgeHelper.getType((BreakdownElement)activity);
                List diagrams = mgr.getDiagrams(activity.getSuperActivities(), 0);
                SetTypeCommand cmd = new SetTypeCommand();
                for (Diagram diagram : diagrams) {
                    Activity umlAct = (Activity)diagram.getElement();
                    for (ActivityNode node : umlAct.getNodes()) {
                        String uriStr = BridgeHelper.getEAnnotationDetail((EModelElement)node, (String)"uri");
                        if (uriStr == null) continue;
                        URI uri = URI.createURI((String)uriStr);
                        String guid = uri.fragment();
                        if (!activity.getGuid().equals(guid)) continue;
                        View view = BridgeHelper.getView((View)diagram, (Object)node);
                        cmd.prepare(view, (EModelElement)node, newType);
                    }
                }
                if (cmd.canExecute()) {
                    SetTypeCommand setTypeCommand = cmd;
                    return setTypeCommand;
                }
            }
            catch (CoreException e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            }
            finally {
                mgr.removeConsumer((Object)this);
            }
        }
        return null;
    }

    public Command createRelatedObjects(Collection createdElements, Command createCommand) {
        return null;
    }

    public Command removeRelatedObjects(Collection deletedElements, Command deleteCommand) {
        return null;
    }
}

