/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.custom.commands;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;

public class ActivityPartitionDestroyCommand
extends DestroyElementCommand {
    private EditPart host;

    public ActivityPartitionDestroyCommand(DestroyElementRequest request, EditPart host) {
        super(request);
        this.host = host;
    }

    protected EObject getElementToDestroy() {
        View view = (View)this.host.getModel();
        EAnnotation annotation = view.getEAnnotation("Shortcut");
        if (annotation != null) {
            return view;
        }
        return super.getElementToDestroy();
    }

    protected void tearDownIncomingReferences(EObject destructee) {
        int size;
        Collection inverseReferences;
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)destructee);
        if (crossReferencer != null && (inverseReferences = crossReferencer.getInverseReferences(destructee)) != null && (size = inverseReferences.size()) > 0) {
            EStructuralFeature.Setting[] settings = inverseReferences.toArray(new EStructuralFeature.Setting[size]);
            int i = 0;
            while (i < size) {
                EStructuralFeature.Setting setting = settings[i];
                EReference eRef = (EReference)setting.getEStructuralFeature();
                if (eRef.isChangeable() && !eRef.isDerived() && !eRef.isContainment() && !eRef.isContainer()) {
                    EcoreUtil.remove((EObject)setting.getEObject(), (EStructuralFeature)eRef, (Object)destructee);
                }
                ++i;
            }
        }
    }

    private void moveChildrensToParent(EObject destructee) {
        if (destructee instanceof ActivityPartition) {
            ActivityPartition partition = (ActivityPartition)destructee;
            Activity activity = partition.getInActivity();
            EList nodes = partition.getNodes();
            for (ActivityNode node : nodes) {
                activity.getNodes().add((Object)node);
                node.getInPartitions().remove((Object)partition);
            }
            for (ActivityEdge edge : partition.getEdges()) {
                activity.getEdges().add((Object)edge);
                edge.getInPartitions().remove((Object)partition);
            }
        }
    }
}

