/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.LinkedObjectImpl;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.model.util.INodeChangeListener;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImpl
extends LinkedObjectImpl
implements Node {
    protected static final Point LOCATION_EDEFAULT = null;
    protected Point location = LOCATION_EDEFAULT;
    protected static final int WIDTH_EDEFAULT = -1;
    protected int width = -1;
    protected static final int HEIGHT_EDEFAULT = -1;
    protected int height = -1;
    protected EList<Link> incomingConnections;
    protected EList<Link> outgoingConnections;
    protected static final boolean READ_ONLY_EDEFAULT = false;
    protected boolean readOnly = false;
    private Adapter nodeAdapter;
    private Collection consumers = new ArrayList();
    private GraphNode umaContainer;
    private org.eclipse.epf.uma.Diagram umaDiagram;
    private Diagram diagram;
    protected GraphNode graphNode;
    protected boolean notificationEnabled = true;
    protected INodeChangeListener methodElementAdapter;
    protected boolean visible = true;

    protected NodeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.NODE;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Point newLocation) {
        Point oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int newWidth) {
        int oldWidth = this.width;
        this.width = newWidth;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldWidth, this.width));
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int newHeight) {
        int oldHeight = this.height;
        this.height = newHeight;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldHeight, this.height));
        }
    }

    @Override
    public EList<Link> getIncomingConnections() {
        if (this.incomingConnections == null) {
            this.incomingConnections = new EObjectWithInverseResolvingEList(Link.class, (InternalEObject)this, 4, 3);
        }
        return this.incomingConnections;
    }

    @Override
    public EList<Link> getOutgoingConnections() {
        if (this.outgoingConnections == null) {
            this.outgoingConnections = new EObjectContainmentWithInverseEList(Link.class, (InternalEObject)this, 5, 2);
        }
        return this.outgoingConnections;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(", width: ");
        result.append(this.width);
        result.append(", height: ");
        result.append(this.height);
        result.append(", readOnly: ");
        result.append(this.readOnly);
        result.append(')');
        return result.toString();
    }

    protected boolean addToUMA(Link link) {
        if (link.getTarget() == null || link.getSource() == null) {
            return false;
        }
        if (this.isGraphicalDataRequired()) {
            GraphicalDataHelper.addGraphicalData(link);
        }
        return true;
    }

    protected void removeFromUMA(Link link, Node oldSource, Node oldTarget) {
        GraphicalDataHelper.removeGraphicalData(link);
    }

    protected org.eclipse.epf.uma.Diagram getUMADiagram() {
        if (this.getDiagram() == null) {
            return this.umaDiagram;
        }
        return this.getDiagram().getUMADiagram();
    }

    protected GraphNode getUMAContainer() {
        Node container = (Node)this.eContainer();
        if (container == null) {
            return this.umaContainer;
        }
        return container.getGraphNode();
    }

    @Override
    public void setUMAContainer(GraphNode umaContainer) {
        this.umaContainer = umaContainer;
    }

    @Override
    public void setUMADiagram(org.eclipse.epf.uma.Diagram umaDiagram) {
        this.umaDiagram = umaDiagram;
        this.umaContainer = umaDiagram;
    }

    protected void basicSetObject(Object newObject) {
        Object e;
        if (newObject == null) {
            return;
        }
        this.object = newObject;
        MethodElement element = (MethodElement)newObject;
        this.graphNode = this.getGraphNode(element);
        if (this.graphNode != null) {
            if (this.height == -1) {
                this.setHeight(this.graphNode.getSize().getHeight().intValue());
            } else {
                this.graphNode.getSize().setHeight(new Double(this.height));
            }
            if (this.width == -1) {
                this.setWidth(this.graphNode.getSize().getWidth().intValue());
            } else {
                this.graphNode.getSize().setWidth(new Double(this.width));
            }
            if (this.location == LOCATION_EDEFAULT) {
                this.setLocation(GraphicalDataHelper.toPoint(this.graphNode.getPosition()));
            } else {
                this.graphNode.getPosition().setX(new Double(this.location.x));
                this.graphNode.getPosition().setY(new Double(this.location.y));
            }
        }
        this.getMethodElementAdapter();
        if (this.methodElementAdapter != null && !element.eAdapters().contains((Object)this.methodElementAdapter)) {
            element.eAdapters().add((Object)this.methodElementAdapter);
        }
        if (this.nodeAdapter == null) {
            this.nodeAdapter = this.createNodeAdapter();
        }
        if (this.nodeAdapter != null && !this.eAdapters().contains((Object)this.nodeAdapter)) {
            this.eAdapters().add((Object)this.nodeAdapter);
        }
        if ((e = TngUtil.unwrap((Object)this.object)) instanceof MethodElement) {
            this.setLinkedElement((MethodElement)e);
        }
    }

    protected Object getMethodElementAdapter() {
        return this.methodElementAdapter;
    }

    public GraphNode getGraphNode(MethodElement methodElement) {
        if (this.isGraphicalDataRequired()) {
            return GraphicalDataManager.getInstance().getGraphNode(this.getUMADiagram(), methodElement);
        }
        return null;
    }

    @Override
    public void setObject(Object newObject) {
        super.setObject(newObject);
        this.basicSetObject(newObject);
    }

    protected Adapter createNodeAdapter() {
        return new NodeAdapter();
    }

    @Override
    public GraphNode getGraphNode() {
        return this.graphNode;
    }

    @Override
    public Class getMethodElementAdapterType() {
        return INodeChangeListener.class;
    }

    @Override
    public Diagram getDiagram() {
        InternalEObject parent = this.eContainer;
        while (parent != null && !(parent instanceof Diagram)) {
            parent = parent.eContainer();
        }
        if (parent instanceof Diagram) {
            return (Diagram)parent;
        }
        return this.diagram;
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public void addConsumer(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    @Override
    public void removeConsumer(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.isEmpty()) {
            this.dispose();
        }
    }

    protected void dispose() {
        EObject obj = (EObject)this.getObject();
        if (obj != null && this.methodElementAdapter != null) {
            obj.eAdapters().remove((Object)this.methodElementAdapter);
        }
        if (this.nodeAdapter != null) {
            this.eAdapters().remove((Object)this.nodeAdapter);
        }
        this.umaContainer = null;
        this.umaDiagram = null;
        this.graphNode = null;
        if (this.outgoingConnections != null) {
            for (Object link : this.outgoingConnections) {
                ((Link)link).eAdapters().clear();
            }
        }
    }

    @Override
    public void setReadOnly(boolean newReadOnly) {
        boolean oldReadOnly = this.readOnly;
        this.readOnly = newReadOnly;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldReadOnly, this.readOnly));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getIncomingConnections()).basicAdd((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getOutgoingConnections()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getIncomingConnections()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getOutgoingConnections()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getLocation();
            }
            case 2: {
                return new Integer(this.getWidth());
            }
            case 3: {
                return new Integer(this.getHeight());
            }
            case 4: {
                return this.getIncomingConnections();
            }
            case 5: {
                return this.getOutgoingConnections();
            }
            case 6: {
                return this.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setLocation((Point)newValue);
                return;
            }
            case 2: {
                this.setWidth((Integer)newValue);
                return;
            }
            case 3: {
                this.setHeight((Integer)newValue);
                return;
            }
            case 4: {
                this.getIncomingConnections().clear();
                this.getIncomingConnections().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getOutgoingConnections().clear();
                this.getOutgoingConnections().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setReadOnly((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 2: {
                this.setWidth(-1);
                return;
            }
            case 3: {
                this.setHeight(-1);
                return;
            }
            case 4: {
                this.getIncomingConnections().clear();
                return;
            }
            case 5: {
                this.getOutgoingConnections().clear();
                return;
            }
            case 6: {
                this.setReadOnly(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals((Object)this.location);
            }
            case 2: {
                return this.width != -1;
            }
            case 3: {
                return this.height != -1;
            }
            case 4: {
                return this.incomingConnections != null && !this.incomingConnections.isEmpty();
            }
            case 5: {
                return this.outgoingConnections != null && !this.outgoingConnections.isEmpty();
            }
            case 6: {
                return this.readOnly;
            }
        }
        return super.eIsSet(featureID);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkOrder addDefaultWorkOrder(NamedNodeImpl node, WorkBreakdownElement predBreakdownElement) {
        notify = node.isNotificationEnabled();
        map = new HashMap<NodeImpl, Boolean>();
        list = ((WorkBreakdownElement)node.getObject()).eAdapters();
        for (E obj : list) {
            if (!(obj instanceof NamedNodeImpl.MethodElementAdapter)) continue;
            nodeobj = (NodeImpl)((NamedNodeImpl.MethodElementAdapter)obj).getNode();
            predNotification = node.notificationEnabled;
            ((NodeImpl)((NamedNodeImpl.MethodElementAdapter)obj).getNode()).notificationEnabled = false;
            map.put(nodeobj, new Boolean(predNotification));
        }
        try {
            node.setNotificationEnabled(false);
            var7_8 = UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), (WorkBreakdownElement)predBreakdownElement);
            return var7_8;
        }
        finally {
            node.setNotificationEnabled(notify);
            set = map.keySet();
            ** for (object : set)
        }
lbl-1000:
        // 1 sources

        {
            obj = map.get(object);
            if (!(obj instanceof Boolean)) continue;
            ((NodeImpl)object).notificationEnabled = prednot = ((Boolean)obj).booleanValue();
            continue;
        }
lbl24:
        // 1 sources

        return var7_8;
    }

    protected boolean isGraphicalDataRequired() {
        DiagramImpl diagram = (DiagramImpl)this.getDiagram();
        return diagram.isGraphicalDataRequired();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public void setNotificationEnabled(boolean notificationEnabled) {
        this.notificationEnabled = notificationEnabled;
    }

    protected class NodeAdapter
    extends AdapterImpl {
        protected NodeAdapter() {
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(Node.class)) {
                case 2: {
                    NodeImpl.this.getGraphNode().getSize().setWidth(new Double(msg.getNewIntValue()));
                    return;
                }
                case 3: {
                    if (NodeImpl.this.getGraphNode() != null) {
                        NodeImpl.this.getGraphNode().getSize().setHeight(new Double(msg.getNewIntValue()));
                    }
                    return;
                }
                case 1: {
                    if (NodeImpl.this.getGraphNode() != null && msg.getNewValue() != null) {
                        Point p = (Point)msg.getNewValue();
                        NodeImpl.this.getGraphNode().getPosition().setX(new Double(p.x));
                        NodeImpl.this.getGraphNode().getPosition().setY(new Double(p.y));
                    }
                    return;
                }
                case 4: {
                    switch (msg.getEventType()) {
                        case 3: {
                            Link link = (Link)msg.getNewValue();
                            NodeImpl.this.addToUMA(link);
                            return;
                        }
                        case 5: {
                            Iterator iter = ((Collection)msg.getNewValue()).iterator();
                            while (iter.hasNext()) {
                                NodeImpl.this.addToUMA((Link)iter.next());
                            }
                            break;
                        }
                        case 4: {
                            Link link = (Link)msg.getOldValue();
                            if (link.getSource() == null) break;
                            ((NodeImpl)link.getSource()).removeFromUMA(link, link.getSource(), (Node)msg.getNotifier());
                            break;
                        }
                        case 6: {
                            for (Link link : (Collection)msg.getOldValue()) {
                                if (link.getSource() == null) continue;
                                ((NodeImpl)link.getSource()).removeFromUMA(link, link.getSource(), (Node)msg.getNotifier());
                            }
                            break;
                        }
                    }
                    return;
                }
                case 5: {
                    switch (msg.getEventType()) {
                        case 3: {
                            Link link = (Link)msg.getNewValue();
                            if (link.getTarget() == null) break;
                            ((NodeImpl)link.getTarget()).addToUMA(link);
                            break;
                        }
                        case 5: {
                            for (Link link : (Collection)msg.getNewValue()) {
                                if (link.getTarget() == null) continue;
                                ((NodeImpl)link.getTarget()).addToUMA(link);
                            }
                            break;
                        }
                        case 4: {
                            Link link = (Link)msg.getOldValue();
                            if (link.getTarget() == null) break;
                            NodeImpl.this.removeFromUMA(link, (Node)msg.getNotifier(), link.getTarget());
                            break;
                        }
                        case 6: {
                            for (Link link : (Collection)msg.getOldValue()) {
                                if (link.getTarget() == null) continue;
                                NodeImpl.this.removeFromUMA(link, (Node)msg.getNotifier(), link.getTarget());
                            }
                            break;
                        }
                    }
                    return;
                }
            }
        }
    }

    protected abstract class TransactionalNodeLink
    extends AdapterImpl
    implements INodeChangeListener {
        protected TransactionalNodeLink() {
        }

        public void notifyChanged(final Notification msg) {
            if (msg.getEventType() == 8) {
                return;
            }
            if (!NodeImpl.this.notificationEnabled) {
                return;
            }
            NodeImpl.this.notificationEnabled = false;
            try {
                try {
                    TxUtil.runInTransaction(this.getNode(), new Runnable(){

                        public void run() {
                            TransactionalNodeLink.this.handleNotification(msg);
                        }
                    });
                }
                catch (Exception e) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                    NodeImpl.this.notificationEnabled = true;
                }
            }
            finally {
                NodeImpl.this.notificationEnabled = true;
            }
        }

        protected abstract void handleNotification(Notification var1);

        public Node getNode() {
            return NodeImpl.this;
        }
    }
}

