/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavadocReader {
    private InputStream fInputStream;

    public JavadocReader(InputStream inputStream) {
        Assert.isNotNull((Object)inputStream);
        this.fInputStream = new BufferedInputStream(inputStream);
    }

    public void close() throws IOException {
        if (this.fInputStream != null) {
            this.fInputStream.close();
        }
    }

    public Element readXML() throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getMessage());
        }
        Element xmlJavadocDesc = parser.parse(new InputSource(this.fInputStream)).getDocumentElement();
        NodeList targets = xmlJavadocDesc.getChildNodes();
        int i = 0;
        while (i < targets.getLength()) {
            Node target = targets.item(i);
            if (target.getNodeName().equals("target")) {
                NodeList children = target.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    Node child = children.item(j);
                    if (child.getNodeName().equals("javadoc") && child.getNodeType() == 1) {
                        return (Element)child;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }
}

