/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;

public class MultiFileXMIHelperImpl
extends XMIHelperImpl {
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected boolean logError = true;
    protected List sameDocReferences = new UniqueEList();
    private boolean discardUnresolvedRef;
    public static boolean unmodifiedGetValue = false;

    public MultiFileXMIHelperImpl(MultiFileXMIResourceImpl xmiRes) {
        super((XMLResource)xmiRes);
        Boolean b = (Boolean)((MultiFileResourceSetImpl)xmiRes.getResourceSet()).getDefaultSaveOptions().get("DISCARD_UNRESOLVED_REFERENCES");
        this.discardUnresolvedRef = b != null ? b : false;
    }

    public void setResource(XMLResource resource) {
        super.setResource(resource);
        if (resource instanceof MultiFileXMIResourceImpl) {
            this.resourceURI = ((MultiFileXMIResourceImpl)resource).getFinalURI();
            this.deresolve = this.resourceURI != null && !this.resourceURI.isRelative() && this.resourceURI.isHierarchical();
        }
    }

    public String getHREF(EObject obj) {
        if (this.discardUnresolvedRef && obj instanceof MultiResourceEObject && !((MultiResourceEObject)obj).isValid()) {
            return null;
        }
        if (obj instanceof MultiResourceEObject) {
            InternalEObject o = (InternalEObject)obj;
            URI objectURI = o.eProxyURI();
            if (objectURI == null) {
                Resource otherResource = obj.eResource();
                if (otherResource == null) {
                    objectURI = this.handleDanglingHREF(obj);
                    if (objectURI == null) {
                        return null;
                    }
                } else {
                    if (this.resource == otherResource) {
                        return "#" + this.resource.getURIFragment(obj);
                    }
                    if (obj instanceof MethodConfiguration) {
                        EObject lib = obj.eContainer();
                        if (lib != null) {
                            otherResource = lib.eResource();
                        } else {
                            return null;
                        }
                    }
                    if (otherResource != null) {
                        ResourceSet resourceSet = otherResource.getResourceSet();
                        if (resourceSet instanceof MultiFileResourceSetImpl && ((MultiFileResourceSetImpl)resourceSet).getResourceManager() == null) {
                            objectURI = MultiFileSaveUtil.getFinalURI(otherResource).appendFragment(this.getURIFragment(otherResource, obj));
                            return this.deresolve(objectURI).toString();
                        }
                        ResourceDescriptor resDesc = MultiFileSaveUtil.getResourceDescriptor(otherResource);
                        if (resDesc != null) {
                            objectURI = MultiFileURIConverter.createURI(resDesc.getId()).appendFragment(this.getURIFragment(otherResource, obj));
                            return objectURI.toString();
                        }
                        return null;
                    }
                }
            } else {
                if (!objectURI.scheme().equals("uma")) {
                    String fragment = objectURI.fragment();
                    if (this.resource instanceof MultiFileXMIResourceImpl && ((MultiFileXMIResourceImpl)this.resource).getEObjectByID(fragment) != null) {
                        return "#" + fragment;
                    }
                    objectURI = this.deresolve(objectURI);
                }
                return objectURI.toString();
            }
        }
        return super.getHREF(obj);
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (feature.isDerived()) {
            return;
        }
        int kind = this.getFeatureKind(feature);
        try {
            List list;
            if (kind == 4) {
                list = (List)object.eGet(feature);
                if (position > -1 && list.indexOf(value) == -1) {
                    return;
                }
            }
            super.setValue(object, feature, value, position);
            switch (kind) {
                case 3: 
                case 4: {
                    EReference ref;
                    list = (InternalEList)object.eGet(feature);
                    if (feature instanceof EReference && (ref = (EReference)feature).getEOpposite() != null) {
                        InternalEObject owner = (InternalEObject)object;
                        Iterator iter = list.basicIterator();
                        while (iter.hasNext()) {
                            InternalEObject element = (InternalEObject)iter.next();
                            if (!element.eIsProxy() || !element.eProxyURI().trimFragment().equals((Object)this.resourceURI)) continue;
                            this.sameDocReferences.add(new ProxyReference(owner, ref, element));
                        }
                    }
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (this.logError) {
                if (MultiFileSaveUtil.DEBUG) {
                    e.printStackTrace();
                }
                CommonPlugin.INSTANCE.log((Object)e);
                String errMsg = new StringBuffer("MultiFileXMIHelperImpl.setValue(): ERROR").append("\n  object: ").append(object).append("\n  feature: ").append(feature).append("\n  value: ").append(value).append("\n  position: ").append(position).append("\n  kind: ").append(kind).toString();
                if (MultiFileSaveUtil.DEBUG) {
                    System.err.println(errMsg);
                }
                CommonPlugin.INSTANCE.log((Object)errMsg);
            }
            throw e;
        }
    }

    public Object getValue(EObject obj, EStructuralFeature f) {
        Object value = super.getValue(obj, f);
        if (unmodifiedGetValue) {
            return value;
        }
        if (f instanceof EReference) {
            if (f.isMany()) {
                if (f.isChangeable() && value instanceof InternalEList) {
                    InternalEList list = (InternalEList)value;
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        EObject o = (EObject)iter.next();
                        if (o.eIsProxy() || o.eResource() != null) continue;
                        iter.remove();
                    }
                }
            } else {
                EObject o = (EObject)value;
                if (!o.eIsProxy() && o.eResource() == null) {
                    value = null;
                }
            }
        }
        return value;
    }

    protected static class ProxyReference {
        private InternalEObject owner;
        private EReference reference;
        private InternalEObject proxy;

        public ProxyReference(InternalEObject owner, EReference reference, InternalEObject proxy) {
            this.owner = owner;
            this.reference = reference;
            this.proxy = proxy;
        }

        public InternalEObject getOwner() {
            return this.owner;
        }

        public InternalEObject getProxy() {
            return this.proxy;
        }

        public EReference getReference() {
            return this.reference;
        }
    }
}

