/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.internal.IFailSafeSavable;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.IFileInfo;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileXMILoadImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.DefaultValueManager;
import org.eclipse.epf.uma.ecore.util.OppositeFeatureNotification;
import org.eclipse.osgi.util.NLS;

public class MultiFileXMIResourceImpl
extends XMIResourceImpl
implements ILibraryResource,
IFailSafeSavable {
    private static String tempDir;
    private URI finalURI;
    private URI oldURI;
    private String backupFile;
    private String currentTxID;
    private long lastLoadTimeStamp;
    private ResourceDescriptor resourceDescriptor;
    private boolean isUnloading;
    private long modificationStamp;
    private IFileInfo fileInfo;
    private static boolean testResourceLoaded;
    private static final String testResourceURIStr = "file:/C:/temp/newlib/library.xmi";

    public MultiFileXMIResourceImpl(URI uri) {
        super(uri);
        this.setIntrinsicIDToEObjectMap(new HashMap());
    }

    protected XMLLoad createXMLLoad() {
        return new MultiFileXMILoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new MultiFileXMISaveImpl(this.createXMLHelper());
    }

    protected XMLHelper createXMLHelper() {
        return new MultiFileXMIHelperImpl(this);
    }

    public String getID(EObject eObject) {
        String id = MultiFileSaveUtil.getGuid(eObject);
        if (id != null) {
            return id;
        }
        return super.getID(eObject);
    }

    public void setID(EObject eObject, String id) {
        String oldID = id != null ? this.getEObjectToIDMap().put(eObject, id) : (String)this.getEObjectToIDMap().remove(eObject);
        Map<String, EObject> guidToMethodElementMap = ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap();
        if (oldID != null) {
            this.getIDToEObjectMap().remove(oldID);
            if (eObject instanceof MethodElement) {
                if (eObject.eIsProxy()) {
                    EObject obj = guidToMethodElementMap.get(id);
                    if (obj != null && obj.eIsProxy()) {
                        guidToMethodElementMap.remove(id);
                    }
                } else {
                    guidToMethodElementMap.remove(id);
                }
            }
        }
        if (id != null) {
            this.getIDToEObjectMap().put(id, eObject);
            if (eObject instanceof MethodElement) {
                guidToMethodElementMap.put(id, eObject);
                MethodElement e = (MethodElement)eObject;
                if (!e.getGuid().equals(id)) {
                    e.setGuid(id);
                }
            }
        }
    }

    protected boolean useUUIDs() {
        return true;
    }

    public String getURIFragment(EObject eObject) {
        try {
            String id = this.getID(eObject);
            if (id != null) {
                return id;
            }
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            EObject container = eObject.eContainer();
            while (container != null && container.eResource() == this) {
                uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainingFeature(), eObject));
                eObject = container;
                container = eObject.eContainer();
            }
            StringBuffer result = new StringBuffer("/");
            result.append(this.getURIFragmentRootSegment(eObject));
            ListIterator i = uriFragmentPath.listIterator(uriFragmentPath.size());
            while (i.hasPrevious()) {
                result.append('/');
                result.append((String)i.previous());
            }
            return result.toString();
        }
        catch (RuntimeException e) {
            System.err.println("Error getting URI fragment for " + eObject);
            throw e;
        }
    }

    protected void attachedHelper(EObject eObject) {
        String id;
        super.attachedHelper(eObject);
        if (this.useIDs() && (id = this.getID(eObject)) != null) {
            this.getEObjectToIDMap().put(eObject, id);
            if (eObject instanceof MethodElement) {
                ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap().put(id, eObject);
            }
        }
        if (this.isTrackingModification() && eObject.eResource() != this) {
            eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        }
    }

    private void attachedAllWithIDs(EObject eObj) {
        ContentTreeIterator allContents = new ContentTreeIterator(eObj);
        while (allContents.hasNext()) {
            this.attachedHelper((EObject)allContents.next());
        }
    }

    private void basicAttachedAll(EObject eObj) {
        eObj.eAdapters().add((Object)this.modificationTrackingAdapter);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.basicAttachedAll(o);
            }
            ++i;
        }
    }

    public void attachedAll(EObject eObj) {
        if (this.useIDs()) {
            this.attachedAllWithIDs(eObj);
        } else {
            this.basicAttachedAll(eObj);
        }
    }

    public void attached(EObject eObject) {
        this.attachedAll(eObject);
    }

    private void detachedAllWithIDs(EObject eObj) {
        ContentTreeIterator allContents = new ContentTreeIterator(eObj);
        while (allContents.hasNext()) {
            this.detachedHelper((EObject)allContents.next());
        }
    }

    private void basicDetachedAll(EObject eObj) {
        eObj.eAdapters().remove((Object)this.modificationTrackingAdapter);
        EList list = eObj.eContents();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            if (o.eResource() == this) {
                this.basicDetachedAll(o);
            }
            ++i;
        }
    }

    protected EObject getEObjectByID(String id) {
        InternalEObject eObject;
        for (EObject element : this.getContents()) {
            String guid = MultiFileSaveUtil.getGuid(element);
            if (guid == null || !guid.equals(id)) continue;
            return element;
        }
        if (this.idToEObjectMap != null && (eObject = (InternalEObject)this.idToEObjectMap.get(id)) != null && !eObject.eIsProxy()) {
            return eObject;
        }
        return null;
    }

    private IFileInfo getFileInfo() {
        if (this.fileInfo == null || !new File(this.getURI().toFileString()).equals(this.fileInfo.getFile())) {
            this.fileInfo = FileManager.getInstance().getFileInfo(this);
        }
        return this.fileInfo;
    }

    public void load(Map options) throws IOException {
        if (this.isUnloading) {
            return;
        }
        boolean old = DefaultValueManager.INSTANCE.isUseStatic();
        try {
            DefaultValueManager.INSTANCE.setUseStatic(true);
            super.load(options);
            this.updateTimeStamps();
        }
        finally {
            DefaultValueManager.INSTANCE.setUseStatic(old);
        }
        if (MultiFileSaveUtil.DEBUG && this.getURI().toString().equals(testResourceURIStr)) {
            testResourceLoaded = true;
        }
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    synchronized boolean reload(Collection proxies) throws IOException {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            this.doUnload(proxies, false);
            this.isLoaded = false;
            this.contents = null;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.load(this.getResourceSet().getLoadOptions());
            return true;
        }
        return false;
    }

    final void unloadWithoutRemove() {
        if (this.isLoaded) {
            ResourceDescriptor resDesc = MultiFileSaveUtil.getResourceDescriptor(this);
            if (resDesc != null) {
                this.setResourceDescriptor(resDesc);
            }
            Notification notification = this.setLoaded(false);
            this.doUnload(null, false);
            if (notification != null) {
                this.eNotify(notification);
            }
        }
    }

    protected void doUnload() {
        this.doUnload(null, true);
    }

    /*
     * Exception decompiling
     */
    protected void doUnload(Collection proxies, boolean remove) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void unloaded(InternalEObject internalEObject) {
        this.unloaded(internalEObject, true);
    }

    private void unloaded(InternalEObject internalEObject, boolean clear) {
        String guid = MultiFileSaveUtil.getGuid(internalEObject);
        if (guid != null) {
            URI uri = this.resourceDescriptor != null ? MultiFileURIConverter.createURI(this.resourceDescriptor.getId()) : this.getURI();
            internalEObject.eSetProxyURI(uri.appendFragment(guid));
        }
        internalEObject.eAdapters().clear();
        if (internalEObject instanceof MultiResourceEObject && clear) {
            MultiResourceEObject multiResourceEObject = (MultiResourceEObject)internalEObject;
            Map oppositeFeatureMap = multiResourceEObject.basicGetOppositeFeatureMap();
            if (oppositeFeatureMap != null) {
                oppositeFeatureMap.clear();
            }
            multiResourceEObject.removeFromAllOppositeFeatures();
        }
        if (internalEObject instanceof ContentDescription || internalEObject instanceof Section) {
            for (EAttribute attr : internalEObject.eClass().getEAllAttributes()) {
                if (attr == UmaPackage.eINSTANCE.getMethodElement_Guid() || !attr.getEAttributeType().getInstanceClass().isAssignableFrom(String.class)) continue;
                internalEObject.eSet((EStructuralFeature)attr, attr.getDefaultValue());
            }
            if (internalEObject.eDirectResource() != null && internalEObject instanceof MultiResourceEObject) {
                ((MultiResourceEObject)internalEObject).eSetResource(null);
            }
        }
    }

    public void detachedAll(EObject eObj) {
        if (this.useIDs()) {
            this.detachedAllWithIDs(eObj);
        } else {
            this.basicDetachedAll(eObj);
        }
    }

    public void detached(EObject eObject) {
        this.detachedAll(eObject);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceImpl.ModificationTrackingAdapter((ResourceImpl)this){

            public void notifyChanged(Notification notification) {
                if (notification instanceof OppositeFeatureNotification) {
                    return;
                }
                super.notifyChanged(notification);
            }
        };
    }

    public void setModified(boolean isModified) {
        super.setModified(isModified);
        if (MultiFileSaveUtil.DEBUG && testResourceLoaded && this.getURI().toString().equals(testResourceURIStr)) {
            System.out.println("isModified=" + isModified);
        }
    }

    public boolean eDeliver() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null && !resourceSet.eDeliver()) {
            return false;
        }
        return super.eDeliver();
    }

    public void save(Map options) throws IOException {
        block9: {
            boolean old = DefaultValueManager.INSTANCE.isUseStatic();
            try {
                DefaultValueManager.INSTANCE.setUseStatic(true);
                if (options == null) {
                    options = MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS;
                }
                super.save(options);
                MethodElement e = PersistenceUtil.getMethodElement(this);
                if (!(e instanceof MethodLibrary)) break block9;
                MethodLibrary lib = (MethodLibrary)e;
                ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(this);
                if (resMgr != null) {
                    for (MethodConfiguration config : lib.getPredefinedConfigurations()) {
                        ResourceDescriptor resDesc = resMgr.getResourceDescriptor(config.getGuid());
                        if (resDesc == null) continue;
                        EcoreUtil.remove((EObject)resDesc);
                    }
                }
                ArrayList configs = new ArrayList(lib.getPredefinedConfigurations());
                boolean oldDeliver = lib.eDeliver();
                try {
                    lib.eSetDeliver(false);
                    lib.getPredefinedConfigurations().clear();
                    super.save(options);
                }
                finally {
                    lib.getPredefinedConfigurations().addAll(configs);
                    lib.eSetDeliver(oldDeliver);
                }
            }
            finally {
                DefaultValueManager.INSTANCE.setUseStatic(old);
            }
        }
    }

    public URI getFinalURI() {
        if (this.finalURI != null) {
            return this.finalURI;
        }
        return this.getURI();
    }

    public void setFinalURI(URI uri) {
        this.finalURI = uri;
    }

    public void backUpURI() {
        this.oldURI = this.getURI();
    }

    public boolean hasTempURI() {
        if (this.currentTxID != null) {
            return this.createTempURI().equals((Object)this.getURI());
        }
        return false;
    }

    private URI createTempURI() {
        MethodElement e = PersistenceUtil.getMethodElement(this);
        return URI.createFileURI((String)new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("new").append(e.getGuid()).toString());
    }

    static String getTempDir() {
        if (tempDir == null) {
            tempDir = new File(FileManager.getTempDir(), "EPF").getAbsolutePath();
        }
        return tempDir;
    }

    public void setTempURI(String txID) {
        if (this.finalURI == null) {
            this.finalURI = this.oldURI = this.getURI();
            this.currentTxID = txID;
            URI tempURI = this.createTempURI();
            this.setURI(tempURI);
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)this.getResourceSet();
            resourceSet.getURIToTempURIMap().put(this.oldURI, tempURI);
        }
    }

    private void restoreURI() {
        if (this.oldURI != null) {
            this.setURI(this.oldURI);
        }
    }

    public boolean txStarted() {
        return this.moveStarted() || this.saveStarted();
    }

    protected void updateTimeStamps() {
        FileManager.getInstance().refresh(this);
        this.lastLoadTimeStamp = System.currentTimeMillis();
        IFileInfo info = this.getFileInfo();
        if (info != null) {
            this.modificationStamp = info.getModificationStamp();
        }
    }

    public int checkSynchronized() {
        return this.isSynchronized() ? 1 : 0;
    }

    public boolean isSynchronized() {
        IFileInfo fileInfo = this.getFileInfo();
        if (fileInfo != null) {
            return this.modificationStamp == fileInfo.getModificationStamp();
        }
        return true;
    }

    public void txFinished(boolean successful) {
        MultiFileResourceSetImpl resourceSet;
        boolean wasMove;
        boolean bl = wasMove = !this.oldURI.equals((Object)this.finalURI);
        if (successful) {
            this.setURI(this.finalURI);
            if (!wasMove) {
                this.setModified(false);
            }
            this.updateTimeStamps();
            if (!wasMove && (resourceSet = (MultiFileResourceSetImpl)this.getResourceSet()) != null) {
                resourceSet.getUnresolvedProxyMarkerManager().validateMarkers(this);
            }
        } else {
            this.restoreURI();
            if (wasMove) {
                this.finalURI = null;
                MultiFileSaveUtil.updateURIMappings(this, this.oldURI, null, true);
            }
        }
        if (this.oldURI != null) {
            resourceSet = (MultiFileResourceSetImpl)this.getResourceSet();
            if (resourceSet != null) {
                resourceSet.getURIToTempURIMap().remove(this.oldURI);
            }
            this.oldURI = null;
        }
        this.currentTxID = null;
        this.finalURI = null;
    }

    public void deleteBackup() {
        block3: {
            if (this.backupFile != null) {
                try {
                    new File(this.backupFile).delete();
                    this.backupFile = null;
                }
                catch (Throwable e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    if (!MultiFileSaveUtil.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean restore() {
        File src = null;
        File dest = null;
        boolean moved = false;
        if (this.backupFile != null) {
            src = new File(this.backupFile);
            dest = new File(this.getFinalURI().toFileString());
        } else {
            boolean bl = moved = this.oldURI != null && !this.oldURI.equals((Object)this.finalURI);
            if (moved) {
                File file = new File(this.getFinalURI().toFileString());
                dest = new File(this.oldURI.toFileString());
                boolean bl2 = moved = file.exists() && !dest.exists();
                if (moved) {
                    src = file;
                }
            }
        }
        if (src != null) {
            boolean success;
            if (dest.exists()) {
                FileUtil.moveFile((File)dest, (File)new File(this.getURI().toFileString()));
            }
            if (moved) {
                success = MultiFileSaveUtil.move(this, src, dest);
            } else {
                boolean bl = success = src.lastModified() == dest.lastModified() && FileUtil.getSize((File)src) == FileUtil.getSize((File)dest);
                if (!success) {
                    success = FileUtil.moveFile((File)src, (File)dest);
                }
            }
            if (!success) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.restoreResourceError_msg, (Object)FileManager.toFileString(this.getFinalURI())));
            }
            return true;
        }
        return false;
    }

    URI getOldURI() {
        return this.oldURI;
    }

    boolean moveStarted() {
        return this.oldURI != null && !this.oldURI.equals((Object)this.getFinalURI());
    }

    boolean saveStarted() {
        return this.currentTxID != null;
    }

    private void refreshURIOfChildResources() {
        ResourceDescriptor desc;
        HashMap<URI, ResourceDescriptor> oldURIToResourceDescriptorMap = null;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(this);
        if (resMgr != null) {
            oldURIToResourceDescriptorMap = new HashMap<URI, ResourceDescriptor>();
            TreeIterator iter = resMgr.eAllContents();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ResourceDescriptor)) continue;
                desc = (ResourceDescriptor)obj;
                oldURIToResourceDescriptorMap.put(desc.getResolvedURI(), desc);
                desc.clearResolvedURI();
            }
        }
        if (oldURIToResourceDescriptorMap != null) {
            for (Resource res : this.getResourceSet().getResources()) {
                desc = (ResourceDescriptor)oldURIToResourceDescriptorMap.get(res.getURI());
                if (desc == null) continue;
                res.setURI(desc.getResolvedURI());
            }
        }
    }

    public void commit() {
        if (this.finalURI != null && !this.getContents().isEmpty()) {
            boolean wasMove;
            File finalFile = new File(this.finalURI.toFileString());
            boolean bl = wasMove = !this.oldURI.equals((Object)this.finalURI);
            if (wasMove) {
                MethodElement e = PersistenceUtil.getMethodElement(this);
                if (e instanceof ContentDescription && finalFile.exists()) {
                    this.finalURI = URI.createFileURI((String)MethodLibraryPersister.getNextAvailableFileName(String.valueOf(finalFile.getParent()) + File.separator, (ContentDescription)e));
                    finalFile = new File(this.finalURI.toFileString());
                }
            } else {
                String backup = this.getBackupFilePath();
                File bakFile = new File(backup);
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                if (finalFile.exists()) {
                    if (FileUtil.moveFile((File)finalFile, (File)bakFile)) {
                        this.backupFile = backup;
                    } else {
                        String msg = NLS.bind((String)PersistenceResources.renameError_msg, (Object)finalFile, (Object)backup);
                        throw new MultiFileIOException(msg);
                    }
                }
            }
            File currentFile = new File(wasMove ? this.oldURI.toFileString() : this.getURI().toFileString());
            boolean success = false;
            Exception ex = null;
            if (wasMove) {
                success = MultiFileSaveUtil.move(this, currentFile, finalFile);
            } else {
                try {
                    FileUtil.doMoveFile((File)currentFile, (File)finalFile);
                    success = true;
                }
                catch (Exception e) {
                    ex = e;
                }
            }
            if (!success) {
                String msg = NLS.bind((String)PersistenceResources.renameError_msg, (Object)currentFile, (Object)finalFile);
                if (ex != null) {
                    msg = String.valueOf(msg) + ": " + (ex.getMessage() != null ? ex.getMessage() : ex.toString());
                }
                throw new MultiFileIOException(msg);
            }
            if (wasMove) {
                MethodElement e;
                ResourceDescriptor resDesc = MultiFileSaveUtil.getResourceDescriptor(this);
                if (resDesc != null) {
                    resDesc.clearResolvedURI();
                    resDesc.getResolvedURI();
                } else if (MultiFileSaveUtil.DEBUG && (e = PersistenceUtil.getMethodElement(this)) != null && !this.getLibraryPersister().hasOwnResourceWithoutReferrer((Object)e)) {
                    String msg = "FATAL ERROR: no ResourceDescriptor found in parent resource for " + this;
                    CommonPlugin.INSTANCE.log((Object)msg);
                    System.err.println(msg);
                }
                this.refreshURIOfChildResources();
            }
            RefreshJob.getInstance().resourceSaved(this);
        }
    }

    public String getBackupFilePath() {
        String backupFile = new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("old").append(PersistenceUtil.getMethodElement(this).getGuid()).toString();
        return backupFile;
    }

    public long getLastLoadTimeStamp() {
        return this.lastLoadTimeStamp;
    }

    static void clearDetachedEObjectToIDMap() {
        DETACHED_EOBJECT_TO_ID_MAP.clear();
    }

    void setResourceDescriptor(ResourceDescriptor resDesc) {
        this.resourceDescriptor = resDesc;
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public long getLoadStamp() {
        return this.getLastLoadTimeStamp();
    }

    public URI getProxyURI(EObject object) {
        String guid = MultiFileSaveUtil.getGuid(object);
        if (guid != null) {
            ResourceDescriptor resourceDescriptor = this.resourceDescriptor != null ? this.resourceDescriptor : MultiFileSaveUtil.getResourceDescriptor(this);
            URI uri = resourceDescriptor != null ? MultiFileURIConverter.createURI(resourceDescriptor.getId()) : this.getURI();
            return uri.appendFragment(guid);
        }
        return this.getURI().appendFragment(this.getID(object));
    }

    public void setTxID(String txID) {
        this.setTempURI(txID);
    }

    private ILibraryPersister getLibraryPersister() {
        return ((MultiFileResourceSetImpl)this.resourceSet).getPersister();
    }

    private final class ContentTreeIterator
    extends AbstractTreeIterator {
        private static final long serialVersionUID = 1L;

        private ContentTreeIterator(Object object) {
            super(object);
        }

        protected Iterator getChildren(Object object) {
            if (object instanceof EObject) {
                ArrayList<EObject> children = new ArrayList<EObject>();
                EContentsEList contents = new EContentsEList((EObject)object){

                    protected boolean resolve() {
                        return false;
                    }
                };
                Iterator iter = contents.basicIterator();
                while (iter.hasNext()) {
                    EObject o = (EObject)iter.next();
                    if (o.eResource() != MultiFileXMIResourceImpl.this && !o.eIsProxy()) continue;
                    children.add(o);
                }
                return children.iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

