/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.common.utils.IMarkerAttributeContributer;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.util.PatternConstructor;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.uma.ecore.IProxyResolutionListener;
import org.eclipse.epf.uma.ecore.ResolveException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedProxyMarkerManager
extends WorkspaceJob
implements IProxyResolutionListener {
    private static final long DELAY = 0L;
    public static final String MARKER_ID = String.valueOf(PersistencePlugin.getDefault().getId()) + ".unresolvedProxyMarker";
    public static final String PROXY_URI = "proxyURI";
    public static final String OWNER_GUID = "ownerGUID";
    private Map<URI, Set<ResolveException>> uriToExceptionsMap;
    private List<ResolveException> exceptions;
    private Map<String, ValidObject> resourceGUIDToMarkersMap;
    private Map<String, Collection<ValidObject>> elementGUIToMarkersMap;
    private ResourceSet resourceSet;
    private boolean enabled = true;
    private List<Resource> resourcesToValidateMarkers;
    private boolean autoScheduled = true;

    public UnresolvedProxyMarkerManager(ResourceSet resourceSet) {
        super(PersistenceResources.unresolvedProxyLoggerJob_name);
        this.resourceSet = resourceSet;
        this.uriToExceptionsMap = new HashMap<URI, Set<ResolveException>>();
        this.exceptions = new ArrayList<ResolveException>();
        this.resourceGUIDToMarkersMap = new HashMap<String, ValidObject>();
        this.elementGUIToMarkersMap = new HashMap<String, Collection<ValidObject>>();
        this.resourcesToValidateMarkers = new UniqueEList();
    }

    public IMarker findMarker(IFile file, String proxyURI, int start, int end) throws CoreException {
        IMarker[] markers = file.findMarkers(MARKER_ID, false, 0);
        return this.findMarker(markers, proxyURI, start, end);
    }

    private IMarker findMarker(IMarker[] markers, String proxyURI, int start, int end) throws CoreException {
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            if (proxyURI.equals(marker.getAttribute(PROXY_URI)) && marker.getAttribute("charStart", -1) == start && marker.getAttribute("charEnd", -1) == end) {
                return marker;
            }
            ++i;
        }
        return null;
    }

    private IMarker findMarker(Collection<IMarker> markers, int start, int end) throws CoreException {
        for (IMarker marker : markers) {
            if (marker.getAttribute("charStart", -1) != start || marker.getAttribute("charEnd", -1) != end) continue;
            return marker;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addException(ResolveException re) {
        List<ResolveException> list = this.exceptions;
        synchronized (list) {
            block5: {
                URI uri = ((InternalEObject)re.getProxy()).eProxyURI();
                Set<ResolveException> exceptions = this.uriToExceptionsMap.get(uri);
                if (exceptions == null) {
                    exceptions = new HashSet<ResolveException>();
                    this.uriToExceptionsMap.put(uri, exceptions);
                }
                if (!exceptions.add(re)) break block5;
                this.exceptions.add(re);
                return true;
            }
            return false;
        }
    }

    private void updateMarker(IMarker[] markers, Resource resource, IProgressMonitor monitor) {
        block20: {
            URI containerURI = resource.getURI();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(containerURI.toFileString());
            IFile file = workspace.getRoot().getFileForLocation((IPath)path);
            if (file != null) {
                try {
                    file.refreshLocal(0, null);
                    HashMap<String, Object> proxyURIToMarkersAndLocationsMap = new HashMap<String, Object>();
                    int i = 0;
                    while (i < markers.length) {
                        IMarker marker = markers[i];
                        Object proxyURI = marker.getAttribute(PROXY_URI);
                        if (proxyURI != null) {
                            String string = proxyURI.toString();
                            Object markersAndLocations = (MarkersAndLocations)proxyURIToMarkersAndLocationsMap.get(string);
                            if (markersAndLocations == null) {
                                markersAndLocations = new MarkersAndLocations();
                                ((MarkersAndLocations)markersAndLocations).markers = new HashSet<IMarker>();
                                ((MarkersAndLocations)markersAndLocations).locations = new HashSet<int[]>();
                                proxyURIToMarkersAndLocationsMap.put(string, markersAndLocations);
                            }
                            ((MarkersAndLocations)markersAndLocations).markers.add(marker);
                        }
                        ++i;
                    }
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    try {
                        manager.connect((IPath)path, LocationKind.LOCATION, monitor);
                        ITextFileBuffer fileBuffer = manager.getTextFileBuffer((IPath)path, LocationKind.LOCATION);
                        fileBuffer.requestSynchronizationContext();
                        fileBuffer.getDocument();
                        IDocument doc = fileBuffer.getDocument();
                        if (doc != null) {
                            for (Map.Entry entry : proxyURIToMarkersAndLocationsMap.entrySet()) {
                                String proxyURI = (String)entry.getKey();
                                Pattern pattern = PatternConstructor.createPattern(proxyURI, true, false);
                                Matcher matcher = pattern.matcher(new DocumentCharSequence(doc));
                                while (matcher.find()) {
                                    int end;
                                    int start = matcher.start();
                                    if (start == (end = matcher.end())) continue;
                                    ((MarkersAndLocations)entry.getValue()).locations.add(new int[]{start, end});
                                }
                            }
                        }
                        fileBuffer.releaseSynchronizationContext();
                    }
                    finally {
                        manager.disconnect((IPath)path, LocationKind.LOCATION, monitor);
                    }
                    if (resource != null && resource.getResourceSet() != null) {
                        for (MarkersAndLocations markersAndLocations : proxyURIToMarkersAndLocationsMap.values()) {
                            Iterator<int[]> iterator = markersAndLocations.locations.iterator();
                            while (iterator.hasNext()) {
                                int end;
                                if (markersAndLocations.markers.isEmpty()) break;
                                int[] loc = iterator.next();
                                int start = loc[0];
                                IMarker marker = this.findMarker(markersAndLocations.markers, start, end = loc[1]);
                                if (marker == null) {
                                    Iterator<IMarker> iter = markersAndLocations.markers.iterator();
                                    marker = iter.next();
                                    iter.remove();
                                    marker.setAttribute("charStart", start);
                                    marker.setAttribute("charEnd", end);
                                    continue;
                                }
                                markersAndLocations.markers.remove(marker);
                            }
                            if (markersAndLocations.markers.isEmpty()) continue;
                            for (IMarker iMarker : markersAndLocations.markers) {
                                if (!iMarker.exists()) continue;
                                try {
                                    iMarker.delete();
                                }
                                catch (CoreException e) {
                                    PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                                }
                            }
                        }
                    }
                }
                catch (CoreException ex) {
                    PersistencePlugin.getDefault().getLogger().logError((Throwable)ex);
                    if (!MultiFileSaveUtil.DEBUG) break block20;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void addMarker(ResolveException re, Resource resource, URI proxyURI, String errMsg, String ownerGUID, IProgressMonitor monitor) {
        block4: {
            URI containerURI = resource.getURI();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(containerURI.toFileString());
            IFile file = workspace.getRoot().getFileForLocation((IPath)path);
            if (file != null) {
                String location = containerURI != null ? containerURI.toFileString() : "";
                try {
                    file.refreshLocal(0, null);
                    IMarker marker = this.findMarker(file, proxyURI.toString(), 0, 0);
                    if (marker != null) {
                        marker.setAttribute(OWNER_GUID, (Object)ownerGUID);
                        return;
                    }
                    this.createMarker(re, proxyURI, errMsg, ownerGUID, file, location, proxyURI.toString(), 0, 0);
                }
                catch (CoreException e) {
                    int code;
                    IStatus status = e.getStatus();
                    if (status instanceof IResourceStatus && ((code = ((IResourceStatus)status).getCode()) == 376 || code == 368)) break block4;
                    PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                    if (!MultiFileSaveUtil.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private IMarker createMarker(ResolveException re, URI proxyURI, String errMsg, String ownerGUID, IFile file, String location, String proxyURIStr, int start, int end) throws CoreException {
        IMarker marker = file.createMarker(MARKER_ID);
        marker.setAttribute("severity", 2);
        marker.setAttribute("message", (Object)errMsg);
        marker.setAttribute("location", (Object)location);
        marker.setAttribute("transient", true);
        marker.setAttribute("charStart", start);
        marker.setAttribute("charEnd", end);
        marker.setAttribute(PROXY_URI, (Object)proxyURIStr);
        marker.setAttribute(OWNER_GUID, (Object)ownerGUID);
        IMarkerAttributeContributer attAdder = ExtensionHelper.getMarkerAttributeContributer();
        if (attAdder != null) {
            attAdder.addAddtionalAttributes(marker, (Object)re);
        }
        this.cacheMarker(marker, proxyURI);
        return marker;
    }

    private void addMarker(ResolveException re, IProgressMonitor monitor) {
        InternalEObject proxy = (InternalEObject)re.getProxy();
        URI containerURI = null;
        Resource resource = null;
        if (re.getResolver() != null && (resource = re.getResolver().eResource()) != null && resource.getResourceSet() != null) {
            containerURI = resource.getURI();
        }
        if (containerURI != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(containerURI.toFileString());
            IFile file = workspace.getRoot().getFileForLocation((IPath)path);
            if (file != null) {
                String errMsg = re.exception() != null && re.exception().getLocalizedMessage() != null && re.exception().getLocalizedMessage().trim().length() > 0 ? re.exception().getLocalizedMessage() : (re.getMessage() == null ? NLS.bind((String)PersistenceResources.UnresolvedProxyMarkerManager_couldNotResolveProxy, (Object)proxy.eProxyURI()) : re.getMessage());
                this.addMarker(re, resource, proxy.eProxyURI(), errMsg, MultiFileSaveUtil.getGuid(re.getResolver()), monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMarker(IMarker marker, URI uri) {
        Map<String, Collection<ValidObject>> map = this.elementGUIToMarkersMap;
        synchronized (map) {
            String elementGUID;
            HashSet<Object> markers;
            String resourceGUID = uri.authority();
            if (resourceGUID != null) {
                ValidObject vo = this.resourceGUIDToMarkersMap.get(resourceGUID);
                if (vo == null) {
                    vo = new ValidObject(new HashSet());
                    this.resourceGUIDToMarkersMap.put(resourceGUID, vo);
                }
                markers = (HashSet<Object>)vo.object;
                markers.add(marker);
            }
            if ((markers = this.elementGUIToMarkersMap.get(elementGUID = uri.fragment())) == null) {
                markers = new HashSet<Object>();
                this.elementGUIToMarkersMap.put(elementGUID, markers);
            }
            markers.add(new ValidObject(marker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        boolean oldEnabled = this.enabled;
        try {
            this.enabled = false;
            this.cancel();
            List<Resource> list = this.exceptions;
            synchronized (list) {
                this.uriToExceptionsMap.clear();
                this.exceptions.clear();
            }
            list = this.elementGUIToMarkersMap;
            synchronized (list) {
                if (!this.elementGUIToMarkersMap.isEmpty()) {
                    for (Collection<ValidObject> markers : this.elementGUIToMarkersMap.values()) {
                        for (ValidObject vo : markers) {
                            IMarker marker = (IMarker)vo.object;
                            try {
                                if (!marker.exists()) continue;
                                marker.delete();
                            }
                            catch (Exception e) {
                                CommonPlugin.INSTANCE.log((Object)e);
                            }
                        }
                        markers.clear();
                    }
                    this.elementGUIToMarkersMap.clear();
                    this.resourceGUIDToMarkersMap.clear();
                }
            }
            list = this.resourcesToValidateMarkers;
            synchronized (list) {
                this.resourcesToValidateMarkers.clear();
            }
        }
        finally {
            this.enabled = oldEnabled;
        }
    }

    public boolean hasUnresolvedProxy() {
        return !this.elementGUIToMarkersMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveException nextException() {
        List<ResolveException> list = this.exceptions;
        synchronized (list) {
            block6: {
                if (!this.exceptions.isEmpty()) break block6;
                return null;
            }
            ResolveException e = this.exceptions.remove(0);
            URI uri = ((InternalEObject)e.getProxy()).eProxyURI();
            Set<ResolveException> exceptions = this.uriToExceptionsMap.get(uri);
            if (exceptions != null) {
                exceptions.remove(e);
                if (exceptions.isEmpty()) {
                    this.uriToExceptionsMap.remove(uri);
                }
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource nextResourceToValidateMarkers() {
        List<Resource> list = this.resourcesToValidateMarkers;
        synchronized (list) {
            block4: {
                if (!this.resourcesToValidateMarkers.isEmpty()) break block4;
                return null;
            }
            return this.resourcesToValidateMarkers.remove(0);
        }
    }

    private void yield() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Exception decompiling
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean removeFromResourceGUIDToMarkersMap(String proxyURI, IMarker marker) {
        ValidObject vo;
        URI uri = URI.createURI((String)proxyURI);
        String resourceGUID = uri.authority();
        if (resourceGUID != null && (vo = this.resourceGUIDToMarkersMap.get(resourceGUID)) != null) {
            Collection markers = (Collection)vo.object;
            boolean ret = markers.remove(marker);
            if (markers.isEmpty()) {
                this.resourceGUIDToMarkersMap.remove(resourceGUID);
            }
            return ret;
        }
        return false;
    }

    private void removeFromElementGUIDToMarkersMap(String proxyURI, IMarker marker) {
        Collection<ValidObject> validObjects;
        URI uri = URI.createURI((String)proxyURI);
        String elementGUID = uri.fragment();
        if (elementGUID != null && (validObjects = this.elementGUIToMarkersMap.get(elementGUID)) != null) {
            Iterator<ValidObject> iterator1 = validObjects.iterator();
            while (iterator1.hasNext()) {
                ValidObject vo1 = iterator1.next();
                if (vo1.object != marker) continue;
                iterator1.remove();
            }
            if (validObjects.isEmpty()) {
                this.elementGUIToMarkersMap.remove(elementGUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMarkers(IProgressMonitor monitor) {
        Map<String, Collection<ValidObject>> map = this.elementGUIToMarkersMap;
        synchronized (map) {
            IMarker marker;
            for (Collection<ValidObject> markers : this.elementGUIToMarkersMap.values()) {
                Iterator<ValidObject> iterator = markers.iterator();
                while (iterator.hasNext()) {
                    ValidObject vo = iterator.next();
                    if (vo.valid) continue;
                    try {
                        marker = (IMarker)vo.object;
                        if (marker.exists()) {
                            String proxyURI = (String)marker.getAttribute(PROXY_URI);
                            marker.delete();
                            this.removeFromResourceGUIDToMarkersMap(proxyURI, marker);
                        }
                        iterator.remove();
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                    }
                }
            }
            Iterator<ValidObject> iter = this.resourceGUIDToMarkersMap.values().iterator();
            while (iter.hasNext()) {
                ValidObject vo = iter.next();
                if (vo.valid) continue;
                vo.valid = true;
                Collection markers = (Collection)vo.object;
                Iterator iterator = markers.iterator();
                while (iterator.hasNext()) {
                    try {
                        marker = (IMarker)iterator.next();
                        if (marker.exists()) {
                            String proxyURIStr = (String)marker.getAttribute(PROXY_URI);
                            URI proxyURI = URI.createURI((String)proxyURIStr);
                            String elementGUID = proxyURI.fragment();
                            EObject o = ((MultiFileResourceSetImpl)this.resourceSet).getGuidToMethodElementMap().get(elementGUID);
                            if (o == null || o.eIsProxy()) continue;
                            marker.delete();
                            iterator.remove();
                            this.removeFromElementGUIDToMarkersMap(proxyURIStr, marker);
                            continue;
                        }
                        iterator.remove();
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                    }
                }
                if (!markers.isEmpty()) continue;
                iter.remove();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void notifyException(Exception e) {
        ResolveException re;
        if (!this.enabled) {
            return;
        }
        if (e instanceof ResolveException && this.addException(re = (ResolveException)e) && this.autoScheduled) {
            this.schedule(0L);
        }
    }

    public void setAutoScheduled(boolean b) {
        this.autoScheduled = b;
    }

    public boolean isAutoScheduled() {
        return this.autoScheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        if (!this.enabled) {
            return false;
        }
        List<ResolveException> list = this.exceptions;
        synchronized (list) {
            block5: {
                if (this.exceptions.isEmpty()) break block5;
                this.schedule(0L);
                return true;
            }
            return false;
        }
    }

    public void proxyResolved(Object proxy, Object resolved) {
        if (!this.enabled) {
            return;
        }
        if (proxy instanceof InternalEObject) {
            URI uri = ((InternalEObject)proxy).eProxyURI();
            this.removeExceptions(uri);
            if (this.invalidateMarkers(uri)) {
                this.schedule(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invalidateMarkers(URI uri) {
        Map<String, Collection<ValidObject>> map = this.elementGUIToMarkersMap;
        synchronized (map) {
            Collection<ValidObject> markers;
            String elementGUID;
            ValidObject vo;
            boolean ret = false;
            String resourceGUID = uri.authority();
            if (resourceGUID != null && (vo = this.resourceGUIDToMarkersMap.get(resourceGUID)) != null) {
                vo.valid = false;
                ret = true;
            }
            if ((elementGUID = uri.fragment()) != null && (markers = this.elementGUIToMarkersMap.get(elementGUID)) != null && !markers.isEmpty()) {
                ret = true;
                for (ValidObject vo2 : markers) {
                    vo2.valid = false;
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExceptions(URI uri) {
        List<ResolveException> list = this.exceptions;
        synchronized (list) {
            Set<ResolveException> exceptions = this.uriToExceptionsMap.get(uri);
            if (exceptions == null || exceptions.isEmpty()) {
                return;
            }
            this.exceptions.removeAll(exceptions);
            this.uriToExceptionsMap.remove(uri);
        }
    }

    public void clearMarkers(Resource resource) {
        try {
            IResource file = FileManager.getResourceForLocation(resource.getURI().toFileString());
            if (file instanceof IFile) {
                IMarker[] markers = file.findMarkers(MARKER_ID, false, 0);
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    this.removeMarker(marker);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarker(IMarker marker) {
        String proxyURI = null;
        try {
            if (marker.exists()) {
                proxyURI = (String)marker.getAttribute(PROXY_URI);
                marker.delete();
            }
        }
        catch (Exception e) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
        }
        if (proxyURI != null) {
            Map<String, Collection<ValidObject>> map = this.elementGUIToMarkersMap;
            synchronized (map) {
                this.removeFromElementGUIDToMarkersMap(proxyURI, marker);
                this.removeFromResourceGUIDToMarkersMap(proxyURI, marker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMarkers(Resource resource) {
        boolean newlyAdded = false;
        List<Resource> list = this.resourcesToValidateMarkers;
        synchronized (list) {
            newlyAdded = this.resourcesToValidateMarkers.add(resource);
        }
        if (newlyAdded) {
            this.schedule(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAllMarkers() {
        boolean newlyAdded = false;
        boolean invalid = false;
        if (!this.elementGUIToMarkersMap.isEmpty()) {
            ArrayList<ArrayList<ValidObject>> validObjectCollections = null;
            Object object = this.elementGUIToMarkersMap;
            synchronized (object) {
                if (!this.elementGUIToMarkersMap.isEmpty()) {
                    validObjectCollections = new ArrayList<ArrayList<ValidObject>>();
                    for (Collection<ValidObject> collection : this.elementGUIToMarkersMap.values()) {
                        if (collection.isEmpty()) continue;
                        validObjectCollections.add(new ArrayList<ValidObject>(collection));
                    }
                }
            }
            if (validObjectCollections != null) {
                object = this.resourcesToValidateMarkers;
                synchronized (object) {
                    for (Collection<ValidObject> collection : validObjectCollections) {
                        for (ValidObject vo : collection) {
                            IMarker marker = (IMarker)vo.object;
                            try {
                                if (marker.exists()) {
                                    String location = (String)marker.getAttribute("location");
                                    URI uri = URI.createFileURI((String)location);
                                    Resource resource = this.resourceSet.getResource(uri, true);
                                    newlyAdded = this.resourcesToValidateMarkers.add(resource) | newlyAdded;
                                    continue;
                                }
                                vo.valid = false;
                                invalid = true;
                            }
                            catch (CoreException e) {
                                PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        if (newlyAdded) {
            this.schedule(0L);
        } else if (invalid) {
            this.removeMarkers((IProgressMonitor)new NullProgressMonitor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doValidateMarkers(Resource resource) {
        block13: {
            try {
                IResource file = FileManager.getResourceForLocation(resource.getURI().toFileString());
                if (!(file instanceof IFile) || !file.exists()) break block13;
                IMarker[] markers = file.findMarkers(MARKER_ID, false, 0);
                HashSet<IMarker> markersToUpdate = new HashSet<IMarker>();
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    String proxyURI = (String)marker.getAttribute(PROXY_URI);
                    if (proxyURI != null) {
                        URI uri = URI.createURI((String)proxyURI);
                        String elementGUID = uri.fragment();
                        EObject o = ((MultiFileResourceSetImpl)this.resourceSet).getGuidToMethodElementMap().get(elementGUID);
                        if (o == null || o.eIsProxy()) {
                            markersToUpdate.add(marker);
                        } else {
                            if (marker.exists()) {
                                try {
                                    marker.delete();
                                }
                                catch (Exception e) {
                                    PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                                }
                            }
                            Map<String, Collection<ValidObject>> map = this.elementGUIToMarkersMap;
                            synchronized (map) {
                                this.removeFromElementGUIDToMarkersMap(proxyURI, marker);
                                this.removeFromResourceGUIDToMarkersMap(proxyURI, marker);
                            }
                        }
                    }
                    ++i;
                }
                if (!markersToUpdate.isEmpty()) {
                    IMarker[] markerArray = new IMarker[markersToUpdate.size()];
                    markersToUpdate.toArray(markerArray);
                    this.updateMarker(markerArray, resource, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    private static class DocumentCharSequence
    implements CharSequence {
        private IDocument fDocument;

        public DocumentCharSequence(IDocument document) {
            this.fDocument = document;
        }

        public int length() {
            return this.fDocument.getLength();
        }

        public char charAt(int index) {
            try {
                return this.fDocument.getChar(index);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }

        public CharSequence subSequence(int start, int end) {
            try {
                return this.fDocument.get(start, end - start);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }
    }

    private static class MarkerInfo {
        String proxyURI;
        String ownerGUID;
        String message;

        private MarkerInfo() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof MarkerInfo) {
                MarkerInfo info = (MarkerInfo)obj;
                if (this.proxyURI != null && this.ownerGUID != null && this.proxyURI.equals(info.proxyURI) && this.ownerGUID.equals(info.ownerGUID)) {
                    return true;
                }
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int result = this.proxyURI.hashCode();
            result ^= this.ownerGUID.hashCode();
            return result ^= this.message.hashCode();
        }
    }

    private static class MarkersAndLocations {
        Collection<IMarker> markers;
        Collection<int[]> locations;

        private MarkersAndLocations() {
        }
    }

    private static class ValidObject {
        boolean valid;
        Object object;

        public ValidObject(Object object) {
            this.object = object;
            this.valid = true;
        }
    }
}

