/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.WarUtil;
import org.eclipse.epf.search.ISearchService;
import org.eclipse.epf.search.IndexBuilder;
import org.eclipse.epf.search.SearchServiceException;
import org.eclipse.epf.search.configuration.ConfigurationHitEntry;
import org.eclipse.epf.search.configuration.ConfigurationSearchQuery;
import org.eclipse.epf.search.configuration.internal.ConfigurationSearchService;

public class SearchService
implements ISearchService {
    private static SearchService instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchService getInstance() {
        if (instance != null) return instance;
        Class<SearchService> clazz = SearchService.class;
        synchronized (SearchService.class) {
            if (instance != null) return instance;
            instance = new SearchService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SearchService() {
    }

    public ConfigurationHitEntry[] searchConfiguration(String path, ConfigurationSearchQuery searchQuery) throws SearchServiceException {
        ConfigurationSearchService service = new ConfigurationSearchService(path);
        service.index();
        return service.search(searchQuery);
    }

    public boolean createIndex(String publishDir) throws SearchServiceException {
        IndexBuilder service = new IndexBuilder(publishDir);
        return service.createIndex(true);
    }

    public boolean createIndex(String publishDir, boolean jarIt) throws SearchServiceException {
        IndexBuilder service = new IndexBuilder(publishDir);
        return service.createIndex(jarIt);
    }

    public void createWAR(String publishDir, String webAppName) {
        try {
            File warFile = null;
            warFile = webAppName.endsWith(".war") ? new File(publishDir, webAppName) : new File(publishDir, String.valueOf(webAppName) + ".war");
            WarUtil.buildWarFile((String)warFile.getAbsolutePath(), (String)publishDir, null);
            File logsDir = new File(publishDir, "logs");
            File cssDir = new File(publishDir, "css");
            File scriptsDir = new File(publishDir, "scripts");
            File imagesDir = new File(publishDir, "images");
            ArrayList<File> filesNotToDelete = new ArrayList<File>();
            filesNotToDelete.add(logsDir);
            filesNotToDelete.add(cssDir);
            filesNotToDelete.add(scriptsDir);
            filesNotToDelete.add(imagesDir);
            filesNotToDelete.add(warFile);
            FileUtil.deleteAllFiles((String)publishDir, filesNotToDelete);
            filesNotToDelete.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

