/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.cmdline;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.epf.authoring.ui.AuthoringUIService;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.common.ui.PreferenceStoreWrapper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class CmdlinePlugin
extends Plugin {
    private static CmdlinePlugin plugin;
    private ScopedPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        CommonPlugin.getDefault();
        PreferenceStoreWrapper storeWrapper = new PreferenceStoreWrapper(this.getPreferenceStore());
        CommonPlugin.getDefault().setCommonPreferenceStore((IPreferenceStoreWrapper)storeWrapper);
        AuthoringUIService.getInstance().start();
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CmdlinePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        if (plugin == null) {
            t.printStackTrace();
        } else {
            ILog log = plugin.getLog();
            String message = t.getMessage();
            if (message == null) {
                message = t.getClass().toString();
            }
            log.log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 1, message, t));
        }
    }

    public static void log(String message) {
        if (plugin == null) {
            System.out.println(message);
        } else {
            ILog log = plugin.getLog();
            log.log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 1, message, null));
        }
    }
}

