/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.views.ProcessTreeContentProvider;
import org.eclipse.epf.library.ui.views.ProcessTreeLabelProvider;
import org.eclipse.epf.library.ui.views.ProcessTreeUIFolder;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectContentPage
extends BaseWizardPage
implements Listener {
    public static final String PAGE_NAME = SelectContentPage.class.getName();
    protected Button publishConfigRadioButton;
    protected Button publishProcessesRadioButton;
    protected CheckboxTreeViewer processViewer;
    protected Button includeBaseProcessesCheckbox;
    protected MethodConfiguration config;

    public SelectContentPage() {
        super(PAGE_NAME);
        this.setTitle(PublishingUIResources.selectContentWizardPage_title);
        this.setDescription(PublishingUIResources.selectContentWizardPage_text);
        this.setImageDescriptor(PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = SelectContentPage.createGridLayoutComposite((Composite)parent, (int)1);
        this.publishConfigRadioButton = SelectContentPage.createRadioButton((Composite)composite, (String)PublishingUIResources.publishConfigRadioButton_text, (int)1, (boolean)true);
        this.publishProcessesRadioButton = SelectContentPage.createRadioButton((Composite)composite, (String)PublishingUIResources.publishProcessesRadioButton_text, (int)1, (boolean)false);
        Composite processComposite = SelectContentPage.createChildGridLayoutComposite((Composite)composite, (int)1);
        this.processViewer = new CheckboxTreeViewer(processComposite);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.processViewer.getTree().setLayoutData((Object)gridData);
        this.includeBaseProcessesCheckbox = SelectContentPage.createCheckbox((Composite)processComposite, (String)PublishingUIResources.includeBaseProcessesCheckboxLabel_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite);
    }

    protected void initControls() {
        this.processViewer.setContentProvider((IContentProvider)new ProcessViewerContentProvider());
        this.processViewer.setLabelProvider((IBaseLabelProvider)new ProcessTreeLabelProvider());
        String configId = this.config != null ? this.config.getGuid() : "";
        boolean publishConfig = PublishingUIPreferences.getPublishEntireConfig(configId);
        this.publishConfigRadioButton.setSelection(publishConfig);
        this.publishProcessesRadioButton.setSelection(!publishConfig);
        this.processViewer.getControl().setEnabled(!publishConfig);
    }

    protected void addListeners() {
        this.publishConfigRadioButton.addListener(13, (Listener)this);
        this.publishProcessesRadioButton.addListener(13, (Listener)this);
        this.includeBaseProcessesCheckbox.addListener(13, (Listener)this);
        this.processViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object checkedElement = event.getElement();
                boolean checked = event.getChecked();
                SelectContentPage.this.processViewer.setChecked(checkedElement, checked);
                SelectContentPage.this.processViewer.setSubtreeChecked(checkedElement, checked);
                if (SelectContentPage.this.includeBaseProcessesCheckbox.getSelection()) {
                    SelectContentPage.this.selectBaseProcesses();
                }
                SelectContentPage.this.updateCheckedStates();
                SelectContentPage.this.setPageComplete(SelectContentPage.this.isPageComplete());
            }
        });
    }

    private void updateCheckedStates() {
        ITreeContentProvider cp = (ITreeContentProvider)this.processViewer.getContentProvider();
        if (this.config != null) {
            Object[] plugins = cp.getChildren((Object)this.config);
            int i = 0;
            while (i < plugins.length) {
                Object[] uiFolders = cp.getChildren(plugins[i]);
                int totalUIFolders = uiFolders.length;
                int checkedUIFolders = 0;
                int j = 0;
                while (j < uiFolders.length) {
                    Object[] processes = cp.getChildren(uiFolders[j]);
                    int totalProcesses = processes.length;
                    int checkedProcesses = 0;
                    int k = 0;
                    while (k < processes.length) {
                        if (this.processViewer.getChecked(processes[k])) {
                            ++checkedProcesses;
                        }
                        ++k;
                    }
                    if (checkedProcesses == 0) {
                        this.processViewer.setGrayChecked(uiFolders[j], false);
                    } else if (checkedProcesses == totalProcesses) {
                        this.processViewer.setGrayed(uiFolders[j], false);
                        this.processViewer.setChecked(uiFolders[j], true);
                    } else {
                        this.processViewer.setGrayChecked(uiFolders[j], true);
                    }
                    if (this.processViewer.getChecked(uiFolders[j])) {
                        ++checkedUIFolders;
                    }
                    ++j;
                }
                if (checkedUIFolders == totalUIFolders) {
                    this.processViewer.setGrayed(plugins[i], false);
                    this.processViewer.setChecked(plugins[i], true);
                } else if (checkedUIFolders == 0) {
                    this.processViewer.setGrayChecked(plugins[i], false);
                } else {
                    this.processViewer.setGrayChecked(plugins[i], true);
                }
                ++i;
            }
        }
    }

    private void selectBaseProcesses() {
        List<Process> processes = this.getSelectedProcesses();
        ArrayList baseProcesses = new ArrayList();
        Iterator<Object> it = processes.iterator();
        while (it.hasNext()) {
            ConfigurationHelper.getBaseProcesses((Activity)((Activity)it.next()), (MethodConfiguration)this.config, baseProcesses);
        }
        for (Object element : baseProcesses) {
            this.processViewer.setChecked(element, true);
        }
    }

    public void handleEvent(Event event) {
        this.processViewer.getControl().setEnabled(this.publishProcessesRadioButton.getSelection());
        if (event.widget == this.includeBaseProcessesCheckbox) {
            this.selectBaseProcesses();
            this.updateCheckedStates();
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void onEnterPage(Object obj) {
        if (obj != null && obj instanceof String) {
            String configName = (String)obj;
            this.config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)configName);
            if (this.config != null) {
                this.processViewer.setInput((Object)this.config);
                this.processViewer.expandAll();
            }
        }
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.publishConfigRadioButton.getSelection()) {
            return true;
        }
        return this.getSelectedProcesses().size() > 0;
    }

    public Object getNextPageData() {
        return this.config;
    }

    public boolean getPublishConfigSelection() {
        return this.publishConfigRadioButton.getSelection();
    }

    public List<Process> getSelectedProcesses() {
        ArrayList<Process> processes = new ArrayList<Process>();
        Object[] selected = this.processViewer.getCheckedElements();
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (selected[i] instanceof Process) {
                    processes.add((Process)selected[i]);
                }
                ++i;
            }
        }
        return processes;
    }

    protected class ProcessViewerContentProvider
    extends ProcessTreeContentProvider {
        private List<MethodPackage> packages = new ArrayList<MethodPackage>();

        protected ProcessViewerContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof MethodConfiguration) {
                MethodConfiguration config = (MethodConfiguration)parentElement;
                ArrayList<MethodPlugin> children = new ArrayList<MethodPlugin>();
                this.packages = config.getMethodPackageSelection();
                List plugins = config.getMethodPluginSelection();
                for (MethodPlugin plugin : plugins) {
                    List processes = TngUtil.getAllProcesses((MethodPlugin)plugin);
                    if (processes.size() <= 0) continue;
                    children.add(plugin);
                }
                return children.toArray();
            }
            if (parentElement instanceof ProcessTreeUIFolder) {
                ProcessTreeUIFolder uiFolder = (ProcessTreeUIFolder)parentElement;
                MethodPlugin plugin = (MethodPlugin)uiFolder.getParent();
                if (uiFolder.getName() == CAPABILITY_PATTERNS) {
                    ArrayList<CapabilityPattern> selectedCapabilityPatterns = new ArrayList<CapabilityPattern>();
                    List capabilityPatterns = LibraryServiceUtil.getCapabilityPatterns((MethodPlugin)plugin);
                    for (CapabilityPattern cp : capabilityPatterns) {
                        ProcessPackage pkg = UmaUtil.getProcessPackage((EObject)cp);
                        if (!this.packages.contains(pkg)) continue;
                        selectedCapabilityPatterns.add(cp);
                    }
                    return selectedCapabilityPatterns.toArray();
                }
                ArrayList<DeliveryProcess> selectedDeliveryProcesses = new ArrayList<DeliveryProcess>();
                List deliveryProcesses = LibraryServiceUtil.getDeliveryProcesses((MethodPlugin)plugin);
                for (DeliveryProcess dp : deliveryProcesses) {
                    ProcessPackage pkg = UmaUtil.getProcessPackage((EObject)dp);
                    if (!this.packages.contains(pkg)) continue;
                    selectedDeliveryProcesses.add(dp);
                }
                return selectedDeliveryProcesses.toArray();
            }
            return super.getChildren(parentElement);
        }
    }
}

