/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.html;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Pattern;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.w3c.tidy.Tidy;

public class HTMLFormatter {
    private static final String HTML_BODY_START_TAG = "<body";
    private static final String HTML_BODY_END_TAG = "</body>";
    private static final int HTML_BODY_START_TAG_LENGTH = "<body".length();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.epf.common.HTMLFormatter";
    private int lineWidth;
    private boolean indent;
    private int indentSize;
    private String lastErrorStr;
    private static final Pattern p_whitespace = Pattern.compile("^\\s+", 8);
    public static final Pattern jTidyErrorParser = Pattern.compile("(line\\s+(\\d+)\\s+column\\s+(\\d+))\\s+-\\s+(.+)", 2);
    public static final String PRE_TAG_START = "<pre>";
    public static final String PRE_TAG_END = "</pre>";
    public static final int PRE_TAG_END_LENGTH = "</pre>".length();

    public HTMLFormatter() {
        this(132, true, 4);
    }

    public HTMLFormatter(int lineWidth, boolean indent, int indentSize) {
        this.lineWidth = lineWidth;
        this.indent = indent;
        this.indentSize = indentSize;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public String formatHTML(String html) throws UnsupportedEncodingException {
        return this.formatHTML(html, false, false, false, false);
    }

    public String formatHTML(String html, boolean returnBodyOnly, boolean forceOutput, boolean makeBare, boolean word2000) throws UnsupportedEncodingException {
        this.lastErrorStr = null;
        if (html == null || html.length() == 0) {
            return html;
        }
        html = HTMLFormatter.removeLeadingWhitespace(html);
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setDropEmptyParas(false);
        tidy.setDropFontTags(false);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setSmartIndent(false);
        tidy.setTidyMark(false);
        tidy.setWraplen(this.lineWidth);
        tidy.setIndentAttributes(false);
        tidy.setIndentContent(this.indent);
        tidy.setSpaces(this.indentSize);
        tidy.setInputEncoding("UTF-16");
        tidy.setOutputEncoding("UTF-16");
        tidy.setFixBackslash(false);
        if (forceOutput) {
            tidy.setForceOutput(true);
        }
        if (makeBare) {
            tidy.setMakeBare(true);
        }
        if (word2000) {
            tidy.setWord2000(true);
        }
        StringReader input = new StringReader(html);
        StringWriter output = new StringWriter();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tidy.setErrout(pw);
        tidy.parse((Reader)input, (Writer)output);
        String error = sw.getBuffer().toString();
        if (error != null && error.length() > 0 && error.startsWith("line") && error.indexOf("column") > 0) {
            this.lastErrorStr = error;
            if (!forceOutput) {
                return html;
            }
        }
        String formattedHTML = ((Object)output).toString();
        formattedHTML = StrUtil.getEscapedHTML(formattedHTML);
        String htmlStartUpper = html.substring(0, Math.min(10, html.length())).toUpperCase();
        if (returnBodyOnly || !htmlStartUpper.startsWith("<!DOCTYPE") && !htmlStartUpper.startsWith("<HTML")) {
            int startBodyTag = formattedHTML.indexOf(HTML_BODY_START_TAG);
            int start = -1;
            if (startBodyTag != -1) {
                start = formattedHTML.indexOf(">", startBodyTag);
            }
            int end = formattedHTML.indexOf(HTML_BODY_END_TAG);
            if (start == -1 || end == -1) {
                return "";
            }
            if (++start >= end) {
                return "";
            }
            start += FileUtil.LINE_SEP_LENGTH;
            end -= FileUtil.LINE_SEP_LENGTH;
            if (this.indent && this.indentSize > 0) {
                end -= this.indentSize;
            }
            if (start >= end) {
                return "";
            }
            String result = formattedHTML.substring(start, end);
            if (this.indent && this.indentSize > 0) {
                String indentStr = HTMLFormatter.getIndentStr(this.indentSize * 2);
                result = HTMLFormatter.fixIndentation(result, indentStr);
                return result;
            }
        }
        return formattedHTML;
    }

    private static String getIndentStr(int indentLength) {
        if (indentLength == 0) {
            return "";
        }
        StringBuffer indentStr = new StringBuffer();
        int i = 0;
        while (i < indentLength) {
            indentStr.append(' ');
            ++i;
        }
        return indentStr.toString();
    }

    private static String fixIndentation(String html, String indentStr) {
        if (html.startsWith(indentStr)) {
            html = html.substring(indentStr.length());
        }
        StringBuffer strBuf = new StringBuffer();
        int pre_index = -1;
        int last_pre_end_index = -1;
        while ((pre_index = html.indexOf(PRE_TAG_START, last_pre_end_index)) != -1) {
            strBuf.append(html.substring(last_pre_end_index < 0 ? 0 : last_pre_end_index + PRE_TAG_END_LENGTH, pre_index).replaceAll("\r\n" + indentStr, "\r\n"));
            last_pre_end_index = html.indexOf(PRE_TAG_END, pre_index);
            if (last_pre_end_index != -1) {
                strBuf.append(html.substring(pre_index, last_pre_end_index + PRE_TAG_END_LENGTH));
                continue;
            }
            strBuf.append(html.substring(pre_index));
            return strBuf.toString();
        }
        strBuf.append(html.substring(last_pre_end_index < 0 ? 0 : last_pre_end_index + PRE_TAG_END_LENGTH).replaceAll("\r\n" + indentStr, "\r\n"));
        return strBuf.toString();
    }

    public String getLastErrorStr() {
        return this.lastErrorStr;
    }

    public static String removeLeadingWhitespace(String input) {
        return p_whitespace.matcher(input).replaceAll("");
    }
}

