/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.serviceability;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class Logger {
    private Plugin plugin;
    private String pluginId;

    public Logger(Plugin plugin) {
        this.plugin = plugin;
        this.pluginId = plugin.getBundle().getSymbolicName();
    }

    public void logError(String msg) {
        this.logMsg(4, msg, null);
    }

    public void logError(Throwable ex) {
        this.logMsg(4, null, ex);
    }

    public void logError(String msg, Throwable ex) {
        this.logMsg(4, msg, ex);
    }

    public void logWarning(String msg) {
        this.logMsg(2, msg, null);
    }

    public void logWarning(String msg, Throwable ex) {
        this.logMsg(2, msg, ex);
    }

    public void logInfo(String msg) {
        this.logMsg(1, msg, null);
    }

    public synchronized void logMsg(int severity, String msg, Throwable ex) {
        if (msg == null && ex != null) {
            msg = ex.getMessage();
        }
        if (msg == null) {
            msg = "";
        }
        Status status = new Status(severity, this.pluginId, 0, msg, ex);
        this.plugin.getLog().log((IStatus)status);
    }
}

