/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.configuration.PracticeSubgroupItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.ActivityLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.elements.ProcessLayoutData;
import org.eclipse.epf.library.layout.elements.SummaryPageLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.DefaultNodeIconResources;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.util.PublishingUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationViewBuilder
extends AbstractViewBuilder {
    private static final String PREFIX_Reference_Workflows = "Reference_Workflows";
    private static final String PREFIX_Tasks = "Tasks";
    private static final String PREFIX_ResponsibleFor_Tasks = "Primarily_Performs";
    private static final String PREFIX_ParticipatesIn_Tasks = "Additionally_Performs";
    private static final String PREFIX_Performing_Roles = "Performing_Roles";
    private static final String PREFIX_Input_Work_Products = "Input_Work_Products";
    private static final String PREFIX_Output_Work_Products = "Output_Work_Products";
    private static final String PREFIX_Work_Products_Created = "Responsible_For";
    private static final String PREFIX_Work_Products_Modified = "Modifies";
    private static final String PREFIX_Responsible_Role = "Responsible_Role";
    private static final String PREFIX_Containing_Work_Product = "Containing_Work_Product";
    private static final String PREFIX_Contained_Work_Products = "Contained_Work_Products";
    private static final String PREFIX_Guidances = "Guidance";
    private static final String PREFIX_InputTo_Task = "Input_to";
    private static final String PREFIX_OutputOf_Task = "Output_from";
    private static final String ICON_FOLDER = DefaultNodeIconResources.getIconName("folder");
    private static final String NODE_Reference_Workflows = PublishingResources.referenceWorkflowsNode_text;
    private static final String NODE_Tasks = PublishingResources.taskNode_text;
    private static final String NODE_ResponsibleFor_Tasks = PublishingResources.primarilyPerformsNode_text;
    private static final String NODE_ParticipatesIn_Tasks = PublishingResources.additionallyPerformsNode_text;
    private static final String NODE_Performing_Roles = PublishingResources.performingRolesNode_text;
    private static final String NODE_Input_Work_Products = PublishingResources.inputWorkProductsNode_text;
    private static final String NODE_Output_Work_Products = PublishingResources.outputWorkProductsNode_text;
    private static final String NODE_Work_Products_Created = PublishingResources.responsibleForNode_text;
    private static final String NODE_Work_Products_Modified = PublishingResources.modifiesNode_text;
    private static final String NODE_Responsible_Role = PublishingResources.responsibleRoleNode_text;
    private static final String NODE_Containing_Work_Product = PublishingResources.containingWorkProductNode_text;
    private static final String NODE_Contained_Work_Products = PublishingResources.containedWorkProductsNode_text;
    private static final String NODE_Guidances = PublishingResources.guidanceNode_text;
    private static final String NODE_InputTo_Task = PublishingResources.inputToNode_text;
    private static final String NODE_OutputOf_Task = PublishingResources.outputFromNode_text;
    private static final String PROCESS_LAYOUT_DATA_FILE = "/scripts/processElementData.js";
    private static final Class ITreeItemContentProviderClass = ITreeItemContentProvider.class;
    protected static boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected List<Bookmark> bookmarks = new ArrayList<Bookmark>();
    protected AdapterFactory adapterFactory;
    protected IProgressMonitor monitor = null;
    protected EObjectComparator nameComparator = new EObjectComparator();
    Set<String> summaryPagesGenerated = new HashSet<String>();
    protected Set elementUrls = new HashSet();

    public ConfigurationViewBuilder(ISiteGenerator siteGenerator) {
        super(siteGenerator);
    }

    @Override
    public List<Bookmark> buildViews(IProgressMonitor monitor) {
        this.monitor = monitor;
        long startTime = 0L;
        if (this.config != null) {
            ConfigurationFilter configFilter = new ConfigurationFilter(this.config, false);
            this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configFilter);
            if (this.options != null && this.options.isPublishProcess()) {
                this.makeProcessClosure();
            }
            if (profiling) {
                startTime = System.currentTimeMillis();
            }
            List views = LibraryUtil.getValidViews((MethodConfiguration)this.config);
            Iterator it = views.iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    return null;
                }
                ContentCategory v = (ContentCategory)it.next();
                if (!ConfigurationHelper.canShow((MethodElement)v, (MethodConfiguration)this.config)) continue;
                Object element = LibraryUtil.unwrap((Object)v);
                Bookmark b = this.createBookmark(this.monitor, element);
                if (v == this.config.getDefaultView()) {
                    this.defaultView = b;
                }
                this.iterate(v, b);
                if (b.getChildCount() <= 0) continue;
                this.bookmarks.add(b);
            }
            if (profiling) {
                System.out.println("Time taken to publish bookmarks: " + (System.currentTimeMillis() - startTime) + " ms");
            }
            if (monitor.isCanceled()) {
                return null;
            }
        }
        if (profiling) {
            startTime = System.currentTimeMillis();
        }
        this.publishReferenceElements();
        if (profiling) {
            DebugTrace.print((Object)this, (String)"publishReferenceElements", (String)(String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (profiling) {
            startTime = System.currentTimeMillis();
        }
        this.saveElementUrls();
        if (profiling) {
            DebugTrace.print((Object)this, (String)"saveElementUrls", (String)(String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
        }
        return this.bookmarks;
    }

    private void makeProcessClosure() {
        this.monitor.subTask(PublishingResources.buildingProcessClosureTask_name);
        List<Process> processes = this.options.getProcesses();
        if (processes != null && processes.size() > 0) {
            Iterator<Process> it = processes.iterator();
            while (it.hasNext()) {
                this.makeProcessClosure(it.next());
                if (!this.monitor.isCanceled()) continue;
                return;
            }
        }
        this.getValidator().addClosureElements(this.getValidator().getPublishedElements());
        this.getValidator().addClosureElements(this.getValidator().getReferencedElements());
        ArrayList<MethodElement> refs = new ArrayList<MethodElement>(this.getValidator().getReferencedElements());
        for (MethodElement e : refs) {
            if (e instanceof ContentCategory) continue;
            super.publish(this.monitor, e);
            if (!LibraryUtil.isProcess((EObject)e)) continue;
            this.publishProcessLayout((Process)e);
        }
        refs.clear();
        for (MethodElement e : this.getValidator().getReferencedElements()) {
            if (!(e instanceof Guidance)) continue;
            refs.add(e);
        }
        if (refs.size() > 0) {
            this.getValidator().addClosureElements(refs);
        }
        this.getValidator().makeElementClosure(this.config);
    }

    private void makeProcessClosure(Process proc) {
        Process baseProc;
        if (proc == null) {
            return;
        }
        if (ConfigurationHelper.canShow((MethodElement)proc, (MethodConfiguration)this.config)) {
            ActivityLayout l = new ActivityLayout();
            l.init(this.getLayoutMgr(), (MethodElement)proc, proc, null);
            l.findAllLinkedElements();
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (ConfigurationHelper.isExtender((VariabilityElement)proc) && ConfigurationHelper.inConfig((MethodElement)(baseProc = (Process)proc.getVariabilityBasedOnElement()), (MethodConfiguration)this.config)) {
            this.makeProcessClosure(baseProc);
        }
    }

    private void publishReferenceElements() {
        while (this.getValidator().getReferencedElements().size() > 0) {
            MethodElement e = (MethodElement)this.getValidator().getReferencedElements().remove(0);
            try {
                long endTime;
                long timeTaken;
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (e instanceof MethodPlugin || e instanceof MethodPackage) continue;
                long startTime = System.currentTimeMillis();
                super.publish(this.monitor, e);
                if (LibraryUtil.isProcess((EObject)e)) {
                    this.publishProcessLayout((Process)e);
                }
                if ((timeTaken = (endTime = System.currentTimeMillis()) - startTime) < 5000L) continue;
                System.out.println("Published " + e.getName() + ": " + timeTaken + " ms");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getValidator().logError(e, "Error publishing element", ex);
            }
        }
    }

    private void publishProcessLayout(final Process e) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ActivityLayout layout = new ActivityLayout();
                    layout.init(ConfigurationViewBuilder.this.getLayoutMgr(), (MethodElement)e, null, null);
                    ProcessLayoutData pd = new ProcessLayoutData(e.getGuid());
                    layout.loadLayoutData(pd, true, true, true);
                    ConfigurationViewBuilder.this.printLayoutScript(pd);
                    pd.clear();
                }
                catch (Exception e1) {
                    ConfigurationViewBuilder.this.getValidator().logError((MethodElement)e, "Error publishing process specific layout data", e1);
                }
            }
        };
        Timer timer = new Timer();
        try {
            try {
                Thread t = new Thread(runnable);
                t.start();
                t.join(600000L);
                if (t.isAlive()) {
                    timer.stop();
                    this.getValidator().logInfo((MethodElement)e, "publishing process specific layout data takes " + timer.getTime() + " mini seconds already and is still not done yet ...");
                    timer.start();
                    t.join();
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                timer.stop();
                this.getValidator().logInfo((MethodElement)e, String.valueOf(timer.getTotalTime()) + " mini seconds publishing process specific layout data");
            }
        }
        finally {
            timer.stop();
            this.getValidator().logInfo((MethodElement)e, String.valueOf(timer.getTotalTime()) + " mini seconds publishing process specific layout data");
        }
    }

    private void printLayoutScript(ProcessLayoutData data) {
        File outputFile = new File(this.getLayoutMgr().getPublishDir(), PROCESS_LAYOUT_DATA_FILE);
        PrintWriter pw = null;
        try {
            try {
                FileOutputStream os = new FileOutputStream(outputFile, true);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "utf-8");
                pw = new PrintWriter((Writer)writer, true);
                data.print(pw);
            }
            catch (Exception e) {
                this.getValidator().logError("unable to save process layout data", e);
                if (pw != null) {
                    pw.flush();
                    pw.close();
                }
            }
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    private void iterate(Object obj, Bookmark parent) {
        try {
            if (this.monitor.isCanceled()) {
                return;
            }
            ITreeItemContentProvider treeItemContentProvider = null;
            treeItemContentProvider = obj instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)obj : (ITreeItemContentProvider)this.adapterFactory.adapt(obj, ITreeItemContentProvider.class);
            if (treeItemContentProvider != null) {
                Collection items = treeItemContentProvider.getChildren(obj);
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    if (this.monitor.isCanceled()) {
                        return;
                    }
                    Object itorObj = it.next();
                    Object element = LibraryUtil.unwrap(itorObj);
                    if (element instanceof MethodElement) {
                        MethodElement me = (MethodElement)element;
                        try {
                            if (!ConfigurationHelper.canShow((MethodElement)me, (MethodConfiguration)this.config) || (me = ConfigurationHelper.getCalculatedElement((MethodElement)me, (ElementRealizer)this.getLayoutMgr().getElementRealizer())) == null) continue;
                            if (me instanceof Tool) {
                                this.buildToolSubTree((Tool)me, parent);
                                continue;
                            }
                            if (me instanceof Discipline) {
                                this.buildDisciplineSubTree((Discipline)me, parent);
                                continue;
                            }
                            if (me instanceof ContentCategory) {
                                ContentCategory cc = (ContentCategory)me;
                                Bookmark b = this.createBookmark(this.monitor, cc);
                                this.iterate(itorObj, b);
                                if (this.options.isPublishEmptyCategories() || b.getChildCount() > 0) {
                                    parent.addChild(b);
                                    this.discardEmptyCategory(cc, false);
                                    continue;
                                }
                                this.discardEmptyCategory(cc, true);
                                continue;
                            }
                            if (itorObj instanceof PracticeSubgroupItemProvider) {
                                this.buildPracticeSubgroupTree(obj, parent, (PracticeSubgroupItemProvider)itorObj);
                                continue;
                            }
                            Bookmark b = this.createBookmark(me, parent);
                            if (this.buildSubTree(itorObj, me, b)) continue;
                            this.iterate(itorObj, b);
                        }
                        catch (Exception e) {
                            String message = "Error building navigation tree for " + LibraryUtil.getTypeName((MethodElement)me);
                            this.getHtmlBuilder().getValidator().logError(message, (Throwable)e);
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (itorObj instanceof PracticeSubgroupItemProvider) {
                        this.buildPracticeSubgroupTree(obj, parent, (PracticeSubgroupItemProvider)itorObj);
                        continue;
                    }
                    this.iterate(itorObj, parent);
                }
            }
        }
        catch (Exception e) {
            String message = "Error building navigation tree";
            this.getHtmlBuilder().getValidator().logError(message, (Throwable)e);
            e.printStackTrace();
        }
    }

    protected Bookmark createBookmark(Object element, Bookmark parent) {
        Bookmark b = this.createBookmark(this.monitor, element);
        if (parent == null) {
            this.bookmarks.add(b);
        } else {
            parent.addChild(b);
        }
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean buildSubTree(Object obj, MethodElement element, Bookmark bm) {
        boolean isShowRelatedLinks = this.options.isShowRelatedLinks();
        if (element instanceof Task) {
            if (!isShowRelatedLinks) return true;
            this.buildTaskSubTree((Task)element, bm);
            return true;
        } else if (element instanceof Role) {
            if (!isShowRelatedLinks) return true;
            this.buildRoleSubTree((Role)element, bm);
            return true;
        } else if (element instanceof WorkProduct) {
            if (!isShowRelatedLinks) return true;
            this.buildWorkProductSubTree((WorkProduct)element, bm);
            return true;
        } else {
            if (!LibraryUtil.isProcess((EObject)element)) return false;
            this.buildProcessSubTree(obj, (Process)element, bm);
        }
        return true;
    }

    private void buildItems(List elements, Bookmark bm) {
        this.buildItems(elements, bm, false);
    }

    private void buildItems(List elements, Bookmark bm, boolean buildSubTree) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            if (this.monitor.isCanceled()) {
                return;
            }
            MethodElement element = (MethodElement)it.next();
            if (ConfigurationHelper.isContainmentElement((Object)element) && ConfigurationHelper.isContainerInList((MethodElement)element, (List)elements, (MethodConfiguration)this.config)) continue;
            this.buildItem(element, bm, buildSubTree);
        }
    }

    private Bookmark buildItem(MethodElement element, Bookmark parent, boolean buildSubTree) {
        if (this.monitor.isCanceled()) {
            return null;
        }
        Bookmark b = null;
        MethodElement e = ConfigurationHelper.getCalculatedElement((MethodElement)element, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
        if (this.isVisible(e)) {
            b = this.createBookmark(this.monitor, e);
            if (b == null) {
                return b;
            }
            parent.addChild(b);
            if (buildSubTree && e instanceof Artifact) {
                this.buildContainedArtifactsSubTree((Artifact)e, b, true);
            }
        }
        return b;
    }

    private Bookmark createFolderBookmark(MethodElement element, Bookmark bm, String prefixName, String nodeName, List items, boolean createChildren) {
        Bookmark b = null;
        if (items.size() > 0) {
            SummaryPageLayout l = new SummaryPageLayout(this.getHtmlBuilder().getLayoutManager(), element, prefixName, nodeName, items);
            String url = l.getUrl();
            if (!this.summaryPagesGenerated.contains(url)) {
                this.getHtmlBuilder().generateHtml((IElementLayout)l);
                this.summaryPagesGenerated.add(url);
            }
            b = this.createBookmark(nodeName, EcoreUtil.generateUUID(), url, ICON_FOLDER, ICON_FOLDER, null);
            bm.addChild(b);
            if (createChildren) {
                this.buildItems(items, b);
            }
        }
        return b;
    }

    private void buildPracticeSubgroupTree(Object providerParent, Bookmark parent, PracticeSubgroupItemProvider provider) {
        List items;
        Collection children = provider.getChildren(null);
        List list = items = children instanceof List ? (List)children : new ArrayList(children);
        if (items != null && items.size() > 0) {
            Practice practice = provider.getPractice();
            if (practice == null) {
                return;
            }
            SummaryPageLayout l = new SummaryPageLayout(this.getHtmlBuilder().getLayoutManager(), (MethodElement)practice, provider.getText(null), provider.getText(null), items, provider.getText(null));
            String url = l.getUrl();
            String imageString = this.getNodeIconName(provider);
            Bookmark b = this.createBookmark(provider.getText(null), EcoreUtil.generateUUID(), url, imageString, imageString, null);
            parent.addChild(b);
            this.iterate(provider, b);
            if (!this.summaryPagesGenerated.contains(url)) {
                this.getHtmlBuilder().generateHtml((IElementLayout)l);
                this.summaryPagesGenerated.add(url);
            }
        }
    }

    private Bookmark buildDisciplineSubTree(Discipline element, Bookmark parent) {
        List items_workflow = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getDiscipline_ReferenceWorkflows());
        ArrayList<MethodElement> items_task = new ArrayList<MethodElement>();
        ArrayList<MethodElement> item_subDisciplies = new ArrayList<MethodElement>();
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
        if (treeItemContentProvider != null) {
            Collection items = treeItemContentProvider.getChildren((Object)element);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement d;
                if (this.monitor.isCanceled()) {
                    return null;
                }
                Object itorObj = it.next();
                Object object = LibraryUtil.unwrap(itorObj);
                if (object instanceof Task) {
                    MethodElement t = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)object), (ElementRealizer)this.getLayoutMgr().getElementRealizer());
                    if (t == null) continue;
                    items_task.add(t);
                    continue;
                }
                if (!(object instanceof Discipline) || (d = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)object), (ElementRealizer)this.getLayoutMgr().getElementRealizer())) == null) continue;
                item_subDisciplies.add(d);
            }
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        ArrayList items_guidance = new ArrayList();
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        if (!this.options.isPublishEmptyCategories() && items_workflow.size() + items_task.size() + items_guidance.size() + item_subDisciplies.size() == 0) {
            this.discardEmptyCategory((ContentCategory)element, true);
            return null;
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        Bookmark bm = this.createBookmark(this.monitor, element);
        if (item_subDisciplies.size() > 0) {
            for (Discipline discipline : item_subDisciplies) {
                this.buildDisciplineSubTree(discipline, bm);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            Collections.sort(items_workflow, this.nameComparator);
            Collections.sort(items_guidance, this.nameComparator);
            this.buildItems(items_workflow, bm);
            this.buildItems(items_task, bm);
            this.buildItems(items_guidance, bm);
        } else {
            if (items_workflow.size() > 0) {
                Bookmark wfFolder = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Reference_Workflows, NODE_Reference_Workflows, items_workflow, false);
                Iterator iterator = items_workflow.iterator();
                while (iterator.hasNext()) {
                    if (this.monitor.isCanceled()) {
                        return null;
                    }
                    Activity act = (Activity)iterator.next();
                    Bookmark bmWorkflow = this.buildItem((MethodElement)act, wfFolder, false);
                    this.buildActivitySubTree(act, act, bmWorkflow);
                }
            }
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (items_task.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Tasks, NODE_Tasks, items_task, true);
            }
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (items_guidance.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items_guidance, true);
            }
        }
        if (this.options.isPublishEmptyCategories() || bm.getChildCount() > 0) {
            parent.addChild(bm);
            this.discardEmptyCategory((ContentCategory)element, false);
        } else {
            this.discardEmptyCategory((ContentCategory)element, true);
        }
        return bm;
    }

    private void buildActivitySubTree(Object obj, Activity element, Bookmark bm) {
        if (this.monitor.isCanceled()) {
            return;
        }
        new ArrayList();
        Process proc = TngUtil.getOwningProcess((BreakdownElement)element);
        ProcessElementItem procItem = new ProcessElementItem(obj, (MethodElement)element, element.getGuid());
        ConfigurableComposedAdapterFactory adapterFactory = super.getLayoutMgr().getWBSAdapterFactory();
        Suppression sup = new Suppression(proc);
        this.iterateActivity(procItem, bm, (ComposedAdapterFactory)adapterFactory, sup);
    }

    private void buildToolSubTree(Tool element, Bookmark parent) {
        if (this.monitor.isCanceled()) {
            return;
        }
        List items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTool_ToolMentors());
        if (this.options.isPublishEmptyCategories() || items.size() > 0) {
            Bookmark b = this.createBookmark(element, parent);
            this.buildItems(items, b);
            this.discardEmptyCategory((ContentCategory)element, false);
        } else {
            this.discardEmptyCategory((ContentCategory)element, true);
        }
    }

    private void buildTaskSubTree(Task element, Bookmark bm) {
        ArrayList allItems = new ArrayList();
        List items = new ArrayList();
        List rList = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy());
        if (rList != null) {
            items.addAll(rList);
        }
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy()));
        if (items.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Performing_Roles, NODE_Performing_Roles, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree()) {
            items = new ArrayList();
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_MandatoryInput()));
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_OptionalInput()));
            if (items.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Input_Work_Products, NODE_Input_Work_Products, items, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        if ((items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output())).size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Output_Work_Products, NODE_Output_Work_Products, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        items.clear();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_ToolMentors()));
        if (items.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items, true);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            this.buildItems(allItems, bm);
        }
    }

    private void buildRoleSubTree(Role element, Bookmark bm) {
        Bookmark b;
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList allItems = new ArrayList();
        List items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.Role_Primary_Tasks);
        if (items.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_ResponsibleFor_Tasks, NODE_ResponsibleFor_Tasks, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree() && (items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.Role_Secondary_Tasks)).size() > 0) {
            this.createFolderBookmark((MethodElement)element, bm, PREFIX_ParticipatesIn_Tasks, NODE_ParticipatesIn_Tasks, items, true);
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getRole_ResponsibleFor());
        if (items.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                b = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Work_Products_Created, NODE_Work_Products_Created, items, false);
                this.buildItems(items, b, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree()) {
            items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getRole_Modifies());
            if (items.size() > 0) {
                b = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Work_Products_Modified, NODE_Work_Products_Modified, items, false);
                this.buildItems(items, b, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        items.clear();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        if (items.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items, true);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            this.buildItems(allItems, bm);
        }
    }

    private void buildWorkProductSubTree(WorkProduct element, Bookmark bm) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList allItems = new ArrayList();
        List items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_ResponsibleRoles);
        if (items.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Responsible_Role, NODE_Responsible_Role, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (element instanceof Artifact) {
            if (!this.options.isPublishLightWeightTree()) {
                Artifact wp = ((Artifact)element).getContainerArtifact();
                if (wp != null) {
                    items = new ArrayList();
                    items.add(wp);
                    this.createFolderBookmark((MethodElement)element, bm, PREFIX_Containing_Work_Product, NODE_Containing_Work_Product, items, true);
                }
                if (this.monitor.isCanceled()) {
                    return;
                }
            }
            items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
            items.remove(element);
            if (items.size() > 0) {
                if (this.options.isPublishLightWeightTree()) {
                    Collections.sort(items, this.nameComparator);
                    allItems.addAll(items);
                } else {
                    Bookmark b = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Contained_Work_Products, NODE_Contained_Work_Products, items, false);
                    this.buildItems(items, b, true);
                }
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree()) {
            items = new ArrayList<Artifact>();
            items.addAll(this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_MandatoryInputTo_Tasks));
            items.addAll(this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_OptionalInputTo_Tasks));
            if (items.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_InputTo_Task, NODE_InputTo_Task, items, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
            items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_OutputFrom_Tasks);
            if (items.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_OutputOf_Task, NODE_OutputOf_Task, items, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        items = new ArrayList();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Reports()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Templates()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_ToolMentors()));
        if (items.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items, true);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            this.buildItems(allItems, bm);
        }
    }

    private void buildContainedArtifactsSubTree(Artifact element, Bookmark bm, boolean showGuidances) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
        items.remove(element);
        if (this.monitor.isCanceled()) {
            return;
        }
        if (items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                Artifact e = (Artifact)it.next();
                this.buildItem((MethodElement)e, bm, true);
            }
        }
        if (!showGuidances) {
            return;
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        items = new ArrayList();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Reports()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Templates()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_ToolMentors()));
        if (items.size() > 0) {
            this.buildItems(items, bm);
        }
    }

    private void iterateActivity(ProcessElementItem parentItem, Bookmark parentBm, ComposedAdapterFactory adapterFactory, Suppression sup) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ITreeItemContentProvider provider = null;
        Object parentObj = parentItem.rawItem;
        provider = parentObj instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)parentObj : (ITreeItemContentProvider)adapterFactory.adapt(parentObj, ITreeItemContentProvider.class);
        if (provider != null) {
            Collection children = provider.getChildren(parentObj);
            Iterator it = children.iterator();
            while (it.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                Object rawitem = it.next();
                if (sup.isSuppressed(rawitem)) continue;
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                if (!this.options.showDescriptorsInNavigationTree && item instanceof Descriptor) continue;
                ProcessElementItem elementItem = new ProcessElementItem(rawitem, item, parentItem);
                Bookmark child = this.buildItem(elementItem.element, parentBm, false);
                if (child == null) continue;
                child.setQueryString(elementItem.getQueryString());
                IBSItemProvider adapter = null;
                adapter = rawitem instanceof IBSItemProvider ? (IBSItemProvider)rawitem : (IBSItemProvider)adapterFactory.adapt((Notifier)item, ITreeItemContentProvider.class);
                String displayName = ProcessUtil.getAttribute((Object)item, (String)"presentation_name", (Object)adapter);
                child.setPresentationName(displayName);
                if (!(item instanceof Activity)) continue;
                this.iterateActivity(elementItem, child, adapterFactory, sup);
            }
        }
    }

    private void buildProcessSubTree(Object obj, Process element, Bookmark bm) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList<SupportingMaterial> items = new ArrayList<SupportingMaterial>();
        ProcessElementItem procItem = new ProcessElementItem(obj, (MethodElement)element, element.getGuid());
        ConfigurableComposedAdapterFactory adapterFactory = super.getLayoutMgr().getWBSAdapterFactory();
        Suppression sup = new Suppression(element);
        this.iterateActivity(procItem, bm, (ComposedAdapterFactory)adapterFactory, sup);
        if (this.monitor.isCanceled()) {
            return;
        }
        items = new ArrayList();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Concepts()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_ReusableAssets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Roadmaps()));
        DiagramInfo userDiagramInfo = new DiagramInfo((Activity)element);
        List v = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_SupportingMaterials());
        for (SupportingMaterial s : v) {
            if (userDiagramInfo.isDiagram(s)) continue;
            items.add(s);
        }
        if (element instanceof DeliveryProcess) {
            DeliveryProcess cfr_ignored_0 = (DeliveryProcess)element;
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_CommunicationsMaterials()));
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_EducationMaterials()));
        }
        if (items.size() > 0) {
            this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items, true);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.adapterFactory = null;
        this.nameComparator = null;
        this.bookmarks.clear();
        this.elementUrls.clear();
        this.summaryPagesGenerated.clear();
    }

    @Override
    protected void elementPublished(IElementLayout layout, String htmlfile) {
        if (layout.getElement() instanceof ProcessElement) {
            ElementUrl url = new ElementUrl(layout.getElement().getGuid(), layout.getUrl(), layout.getDisplayName());
            this.elementUrls.add(url);
        }
    }

    private void saveElementUrls() {
        XmlElement xml = new XmlElement("ElementUrls");
        for (ElementUrl url : this.elementUrls) {
            xml.newChild("elementUrl", url.guid).setAttribute("text", StrUtil.escape((String)url.text)).setAttribute("url", StrUtil.escape((String)url.url));
        }
        String html = PublishingUtil.getHtml(xml, "xsl/elementUrls.xsl");
        File f = new File(this.getLayoutMgr().getPublishDir(), PROCESS_LAYOUT_DATA_FILE);
        FileUtil.writeUTF8File((String)f.getAbsolutePath(), (String)html, (boolean)true);
    }

    class EObjectComparator
    implements Comparator {
        private EStructuralFeature pName = UmaPackage.eINSTANCE.getMethodElement_PresentationName();
        private EStructuralFeature name = UmaPackage.eINSTANCE.getNamedElement_Name();

        public int compare(Object e1, Object e2) {
            if (e1 instanceof EObject && e2 instanceof EObject) {
                Object v1 = this.getValue(e1);
                Object v2 = this.getValue(e2);
                if (v1 == null && v2 == null) {
                    return e1.toString().compareTo(e2.toString());
                }
                if (v1 == null) {
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                return v1.toString().compareTo(v2.toString());
            }
            return e1.toString().compareTo(e2.toString());
        }

        private Object getValue(Object e) {
            Object v = null;
            try {
                v = ((EObject)e).eGet(this.pName);
            }
            catch (Exception exception) {}
            if (v == null || v.toString().length() == 0) {
                try {
                    v = ((EObject)e).eGet(this.name);
                }
                catch (Exception exception) {}
            }
            return v;
        }
    }

    public class ElementUrl {
        String guid;
        String url;
        String text;

        public ElementUrl(String guid, String url, String text) {
            this.guid = guid;
            this.url = url;
            this.text = text;
        }
    }
}

