/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteDiagramCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Collection elementsToRemove;
    private Process targetProcess;
    private DiagramManager dMgr = null;

    public DeleteDiagramCommand(Collection elementsToRemove, Process targetProcess) {
        this.elementsToRemove = elementsToRemove;
        this.targetProcess = targetProcess;
    }

    public void execute() {
        DiagramService diagramSvc = new DiagramService();
        try {
            try {
                for (MethodElement element : this.elementsToRemove) {
                    if (!(element instanceof Activity)) continue;
                    Collection<Diagram> diagrams = diagramSvc.getDiagrams((Activity)element);
                    for (Diagram diagram : diagrams) {
                        if (diagram == null) continue;
                        this.closeDiagramEditor(diagram);
                        DiagramHelper.deleteDiagram(diagram, true);
                    }
                }
            }
            catch (Exception e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                diagramSvc.dispose();
            }
        }
        finally {
            diagramSvc.dispose();
        }
    }

    public void redo() {
        this.execute();
    }

    private DiagramManager getDiagramManager() {
        if (this.dMgr == null) {
            this.dMgr = DiagramManager.getInstance(this.targetProcess, (Object)this);
        }
        return this.dMgr;
    }

    public Collection getModifiedResources() {
        DiagramManager dMgr = this.getDiagramManager();
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        boolean fileExist = true;
        try {
            if (dMgr != null && dMgr.getResource() != null && !dMgr.getResource().getContents().isEmpty()) {
                File file = new File(FileManager.toFileString((URI)dMgr.getResource().getURI()));
                if (!file.exists()) {
                    fileExist = false;
                }
                if (fileExist) {
                    modifiedResources.add(dMgr.getResource());
                }
            }
        }
        catch (Exception e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return modifiedResources;
    }

    public boolean canExecute() {
        return this.targetProcess != null;
    }

    public void dispose() {
        if (this.dMgr != null) {
            this.dMgr.removeConsumer((Object)this);
        }
        super.dispose();
    }

    private void closeDiagramEditor(Diagram diagram) {
        List editors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : editors) {
            DiagramEditor diagramEditor;
            if (!(obj instanceof DiagramEditor) || !(diagramEditor = (DiagramEditor)obj).getDiagram().equals(diagram)) continue;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)diagramEditor);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)diagramEditor, false);
        }
    }
}

