/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.part;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.resources.IDiagramStorage;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.services.IDisposable;

public class DiagramEditorInputProxy
extends DiagramFileEditorInputProxy
implements IDisposable {
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();
    private Diagram diagram;
    private PreferencesHint preferenceHint;
    private boolean isNewDiagram;

    public DiagramEditorInputProxy(DiagramEditorInput input, PreferencesHint hint) {
        super(input);
        this.preferenceHint = hint;
    }

    public void dispose() {
        this.diagram = null;
    }

    private Resource getResource() {
        block9: {
            Activity act;
            Process process;
            if ((this.diagram == null || this.diagram.eResource() == null) && (process = TngUtil.getOwningProcess((BreakdownElement)(act = (Activity)this.getDiagramEditorInput().getMethodElement()))) != null) {
                DiagramManager mgr = DiagramManager.getInstance(process, this);
                try {
                    try {
                        int diagramType = this.getDiagramEditorInput().getDiagramType();
                        List<Diagram> list = mgr.getDiagrams(act, diagramType);
                        if (list.isEmpty()) {
                            this.diagram = mgr.createDiagram(act, diagramType, this.preferenceHint);
                            this.isNewDiagram = this.diagram != null;
                        } else {
                            this.diagram = list.get(0);
                        }
                    }
                    catch (Exception e) {
                        CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                        mgr.removeConsumer(this);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    mgr.removeConsumer(this);
                    throw throwable;
                }
                mgr.removeConsumer(this);
            }
        }
        return this.diagram != null ? this.diagram.eResource() : null;
    }

    public IFile getFile() {
        Resource resource = this.getResource();
        if (resource != null) {
            return WorkspaceSynchronizer.getFile((Resource)resource);
        }
        return null;
    }

    public IStorage getStorage() throws CoreException {
        final Resource resource = this.getResource();
        if (resource != null) {
            return new IDiagramStorage(){
                private IFile file;

                private IFile getFile() {
                    if (this.file == null) {
                        this.file = DiagramEditorInputProxy.this.getFile();
                    }
                    return this.file;
                }

                public InputStream getContents() throws CoreException {
                    return null;
                }

                public IPath getFullPath() {
                    return this.getFile().getFullPath();
                }

                public String getName() {
                    return resource.getURI().toString();
                }

                public boolean isReadOnly() {
                    return this.getFile().isReadOnly();
                }

                public Object getAdapter(Class adapter) {
                    return this.getFile().getAdapter(adapter);
                }

                public Diagram getDiagram() {
                    return DiagramEditorInputProxy.this.diagram;
                }
            };
        }
        return null;
    }

    public String getName() {
        try {
            return this.getDiagramEditorInput().getMethodElement().getName();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public IPath getPath() {
        return this.getFile().getLocation();
    }

    public Object getAdapter(Class adapter) {
        IFile file = this.getFile();
        if (file != null) {
            if (adapter == IFile.class) {
                return file;
            }
            return file.getAdapter(adapter);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DiagramEditorInputProxy) {
            return this.getDiagramEditorInput().equals(((DiagramEditorInputProxy)obj).getDiagramEditorInput());
        }
        return false;
    }

    public int hashCode() {
        return this.getDiagramEditorInput().hashCode();
    }

    public PreferencesHint getPreferenceHint() {
        return this.preferenceHint;
    }

    public boolean isNewDiagram() {
        return this.isNewDiagram;
    }
}

