/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.configuration.MethodConfigurationElementList;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;

public class GuidanceItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IConfigurable,
ILibraryItemProvider {
    List children;
    private String label;
    private Object parent;
    private IFilter filter;
    private Object image;
    private IFilter guidanceFilter;
    private MethodConfiguration methodConfig;

    public GuidanceItemProvider(AdapterFactory adapterFactory, MethodConfiguration methodConfig, String name, Object image) {
        super(adapterFactory);
        this.label = name;
        this.methodConfig = methodConfig;
        this.image = image;
    }

    public Collection getChildren(Object object) {
        ArrayList<IFilter> filterList = new ArrayList<IFilter>();
        if (this.guidanceFilter != null) {
            filterList.add(this.guidanceFilter);
        }
        if (this.filter != null) {
            filterList.add(this.filter);
        }
        MethodConfigurationElementList elementList = new MethodConfigurationElementList(this.methodConfig, filterList);
        List elements = elementList.getList();
        Collections.sort(elements, new CompareByName());
        return elements;
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return super.getNewChildDescriptors((Object)this.methodConfig, editingDomain, sibling);
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        if (object instanceof EObject) {
            return super.getParent(object);
        }
        return null;
    }

    public Object getImage(Object object) {
        return this.image;
    }

    public String getText(Object object) {
        if (this.label != null) {
            return this.label;
        }
        return super.getText(object);
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public void setGuidanceFilter(IFilter filter) {
        this.guidanceFilter = filter;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Collection getChildrenFeatures(Object object) {
        return super.getChildrenFeatures(object);
    }

    public class CompareByName
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            String name1 = ((MethodElement)obj1).getName();
            String name2 = ((MethodElement)obj2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

