/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.util.ConfigurationSetter;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.DepthLevelAdapterFactoryTreeIterator;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IDiagramManager;
import org.eclipse.epf.library.edit.util.ITextReferenceReplacer;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.edit.command.MethodElementInitializeCopyCommand;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDeepCopyCommand
extends CopyCommand {
    private static final AdapterFactory[] adapterFactories = new AdapterFactory[]{TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory()};
    private static final int[] diagramTypes;
    protected ProcessPackage pkgCopy;
    protected MethodConfiguration config;
    protected IDiagramManager diagramMgr;
    protected Process targetProcess;
    protected IProgressMonitor monitor;
    protected Activity activity;
    private LinkedList<String> guidList;
    private BreakdownElementWrapperItemProvider wrapper;
    private IConfigurator activityDeepCopyConfigurator;
    private boolean copyExternalVariations = true;
    private boolean copyContributors = true;

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[2] = 1;
        diagramTypes = nArray;
    }

    public static AdapterFactory[] getAdapterFactories() {
        return adapterFactories;
    }

    protected void addCreateCopyCommands(CompoundCommand compoundCommand, EObject object) {
        if (this.copyExternalVariations && object instanceof ProcessPackage && object != this.activity.eContainer()) {
            ProcessPackage pkg = (ProcessPackage)object;
            boolean isReplaced = false;
            Activity replacer = null;
            Activity orignalActivity = null;
            for (Object procesElement : pkg.getProcessElements()) {
                Activity childAct;
                if (!(procesElement instanceof Activity) || (childAct = (Activity)procesElement).getSuperActivities() != this.activity) continue;
                replacer = this.getReplacer((Activity)procesElement);
                if (replacer == null) break;
                isReplaced = true;
                orignalActivity = (Activity)procesElement;
                break;
            }
            if (isReplaced) {
                this.copyHelper.decrementDeferredInitializationCount();
                ActivityDeepCopyCommand cmd = new ActivityDeepCopyCommand(replacer, (CopyHelper)this.copyHelper, this.config, this.targetProcess, this.monitor, false, this.activityDeepCopyConfigurator);
                cmd.guidList = new LinkedList<String>(this.guidList);
                cmd.guidList.addAll(ProcessUtil.getGuidList(this.activity, orignalActivity));
                try {
                    cmd.execute();
                    ProcessPackage pkgCopy = cmd.pkgCopy;
                    ((CopyHelper)this.copyHelper).basicPut(object, (EObject)pkgCopy);
                    ((CopyHelper)this.copyHelper).basicPut((EObject)orignalActivity, (EObject)this.copyHelper.get((Object)replacer));
                }
                finally {
                    cmd.dispose();
                }
                this.copyHelper.incrementDeferredInitializationCount();
                return;
            }
        }
        super.addCreateCopyCommands(compoundCommand, object);
    }

    protected Activity getReplacer(Activity activity) {
        ConfigurationSetter configSetter = new ConfigurationSetter(this.getAdapterFactory());
        try {
            if (this.activityDeepCopyConfigurator != null) {
                MethodConfiguration currentConfig = configSetter.getOldConfiguration();
                MethodConfiguration copyConfig = this.config == null ? (currentConfig != null ? currentConfig : this.targetProcess.getDefaultContext()) : this.config;
                this.activityDeepCopyConfigurator.setMethodConfiguration(copyConfig);
                VariabilityInfo variabilityInfo = this.activityDeepCopyConfigurator.getVariabilityInfo((VariabilityElement)activity);
                if (variabilityInfo != null && !variabilityInfo.getInheritanceList().isEmpty()) {
                    Activity replacer = (Activity)variabilityInfo.getInheritanceList().get(0);
                    Activity activity2 = replacer == activity ? null : replacer;
                    return activity2;
                }
            }
            return null;
        }
        finally {
            if (configSetter != null) {
                configSetter.restore();
            }
        }
    }

    protected List getContributors(Activity activity) {
        ConfigurationSetter configSetter = new ConfigurationSetter(this.getAdapterFactory());
        try {
            if (this.activityDeepCopyConfigurator != null) {
                MethodConfiguration currentConfig = configSetter.getOldConfiguration();
                MethodConfiguration copyConfig = this.config == null ? (currentConfig != null ? currentConfig : this.targetProcess.getDefaultContext()) : this.config;
                this.activityDeepCopyConfigurator.setMethodConfiguration(copyConfig);
                VariabilityInfo variabilityInfo = this.activityDeepCopyConfigurator.getVariabilityInfo((VariabilityElement)activity);
                if (variabilityInfo != null) {
                    List list = variabilityInfo.getContributors();
                    return list;
                }
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (configSetter != null) {
                configSetter.restore();
            }
        }
    }

    private ActivityDeepCopyCommand(Activity activity, CopyHelper copyHelper, MethodConfiguration config, Process targetProcess, IProgressMonitor monitor, boolean initGuidList, IConfigurator activityDeepCopyConfigurator) {
        super(null, activity.eContainer(), (CopyCommand.Helper)copyHelper);
        Assert.isTrue((boolean)(activity.eContainer() instanceof ProcessPackage), (String)"Activity's container must be a ProcessPackage");
        this.activity = activity;
        this.domain = new EditingDomain();
        this.config = config;
        this.targetProcess = targetProcess;
        this.diagramMgr = ExtensionManager.getDiagramManager();
        Assert.isNotNull((Object)this.diagramMgr, (String)"Could not load diagram manager");
        this.monitor = monitor;
        if (initGuidList) {
            this.guidList = ProcessUtil.getGuidList(null, this.activity);
        }
        this.activityDeepCopyConfigurator = activityDeepCopyConfigurator;
    }

    public ActivityDeepCopyCommand(Activity activity, CopyHelper copyHelper, MethodConfiguration config, Process targetProcess, IProgressMonitor monitor, IConfigurator activityDeepCopyConfigurator) {
        this(activity, copyHelper, config, targetProcess, monitor, true, activityDeepCopyConfigurator);
    }

    public ActivityDeepCopyCommand(Object activityOrWrapper, CopyHelper copyHelper, MethodConfiguration config, Process targetProcess, IProgressMonitor monitor, IConfigurator activityDeepCopyConfigurator) {
        this((Activity)TngUtil.unwrap(activityOrWrapper), copyHelper, config, targetProcess, monitor, activityOrWrapper instanceof Activity, activityDeepCopyConfigurator);
        if (activityOrWrapper instanceof BreakdownElementWrapperItemProvider) {
            this.wrapper = (BreakdownElementWrapperItemProvider)activityOrWrapper;
            this.guidList = ProcessUtil.getGuidList(this.wrapper);
        }
    }

    public void setCopyExternalVariations(boolean copyExternalVariations) {
        this.copyExternalVariations = copyExternalVariations;
    }

    public AdapterFactory getAdapterFactory() {
        return ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory();
    }

    public void execute() {
        this.monitor.subTask(NLS.bind((String)LibraryEditResources.copyingActivities_msg, (Object)ProcessUtil.getPresentationName((BreakdownElement)this.activity)));
        super.execute();
        Collection result = super.getResult();
        if (!result.isEmpty()) {
            this.pkgCopy = (ProcessPackage)result.iterator().next();
            this.fixProcessComponent();
            this.replaceTextReferences();
        }
    }

    protected void fixProcessComponent() {
        if (this.pkgCopy instanceof ProcessComponent) {
            ProcessPackage pkg = UmaFactory.eINSTANCE.createProcessPackage();
            ArrayList features = new ArrayList(this.pkgCopy.eClass().getEAllStructuralFeatures());
            features.retainAll((Collection<?>)pkg.eClass().getEAllStructuralFeatures());
            for (EStructuralFeature feature : features) {
                Object value = this.pkgCopy.eGet(feature);
                pkg.eSet(feature, value);
            }
            Process proc = ((ProcessComponent)this.pkgCopy).getProcess();
            if (proc != null) {
                pkg.getProcessElements().add(0, proc);
            }
            this.pkgCopy = pkg;
        }
    }

    protected void replaceTextReferences() {
        ITextReferenceReplacer txtRefReplacer = ExtensionManager.getTextReferenceReplacer();
        if (txtRefReplacer == null) {
            return;
        }
        Map oldToNewObjectMap = ((CopyHelper)this.copyHelper).getObjectToCopyMap();
        TreeIterator iter = this.pkgCopy.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            for (EAttribute attribute : element.eClass().getEAllAttributes()) {
                String text;
                if (!attribute.isChangeable() || attribute.isDerived() || !attribute.isMany() && !element.eIsSet((EStructuralFeature)attribute) || attribute.getEAttributeType().getInstanceClass() != XMLTypePackage.Literals.STRING.getInstanceClass() || (text = (String)element.eGet((EStructuralFeature)attribute)) == null) continue;
                text = txtRefReplacer.replace(text, (EObject)this.targetProcess, oldToNewObjectMap);
                element.eSet((EStructuralFeature)attribute, (Object)text);
            }
        }
    }

    public Collection<?> getResult() {
        Activity act;
        if (this.pkgCopy != null && (act = ProcessUtil.findActivity(this.pkgCopy)) != null) {
            return Collections.singletonList(act);
        }
        return Collections.EMPTY_LIST;
    }

    private static void moveContent(ProcessPackage src, Activity act) {
        ProcessPackage target = (ProcessPackage)act.eContainer();
        for (EObject e : new ArrayList(src.eContents())) {
            EStructuralFeature f = e.eContainingFeature();
            if (!f.isMany()) continue;
            ((List)target.eGet(f)).add(e);
        }
        if (src instanceof ProcessComponent) {
            Process baseCopy = ((ProcessComponent)src).getProcess();
            target.getProcessElements().add(baseCopy);
        }
    }

    private static BreakdownElement getTopElement(BreakdownElement e) {
        if (e == null) {
            return null;
        }
        BreakdownElement top = e;
        Activity o = e.getSuperActivities();
        while (o != null) {
            top = o;
            o = o.getSuperActivities();
        }
        return top;
    }

    public void copySuppressionStates() {
        Collection<?> result = this.getResult();
        if (result.isEmpty()) {
            return;
        }
        String wrapperPath = this.wrapper != null ? ProcessUtil.toGuidPath(this.guidList) : null;
        int i = 0;
        while (i < adapterFactories.length) {
            AdapterFactory adapterFactory = adapterFactories[i];
            boolean isWBS = adapterFactory == TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            IFilter filter = ProcessUtil.getFilter(adapterFactory);
            IConfigurator configurator = null;
            MethodConfiguration currentConfig = null;
            if (filter instanceof IConfigurator) {
                configurator = (IConfigurator)filter;
                currentConfig = configurator.getMethodConfiguration();
                configurator.setMethodConfiguration(this.config);
            }
            try {
                Activity act = ProcessUtil.findActivity((ProcessPackage)this.owner);
                ProcessUtil.initializeItemProviderPath(act, adapterFactory);
                Process proc = TngUtil.getOwningProcess((BreakdownElement)act);
                Suppression suppression = Suppression.getSuppression(proc);
                DepthLevelAdapterFactoryTreeIterator<Process> iter = new DepthLevelAdapterFactoryTreeIterator<Process>(adapterFactory, proc);
                int depthLevel = -1;
                while (iter.hasNext()) {
                    String path;
                    Process child = iter.next();
                    if (this.wrapper == null) {
                        if (child != this.activity) continue;
                        depthLevel = iter.getDepthLevel();
                        break;
                    }
                    if (!(child instanceof BreakdownElementWrapperItemProvider) || !wrapperPath.equals(path = Suppression.getPathWithoutViewType((BreakdownElementWrapperItemProvider)child).toString())) continue;
                    depthLevel = iter.getDepthLevel();
                    break;
                }
                CopyHelper helper = (CopyHelper)this.copyHelper;
                Map originalToCopyMap = helper.getObjectToCopyMap();
                HashMap<BreakdownElementWrapperItemProvider, Object> elementOrWrapperToCopyMap = null;
                if (isWBS) {
                    elementOrWrapperToCopyMap = new HashMap<BreakdownElementWrapperItemProvider, Object>();
                    Activity deepCopy = (Activity)result.iterator().next();
                    elementOrWrapperToCopyMap.put(this.wrapper != null ? this.wrapper : this.activity, deepCopy);
                }
                while (iter.hasNext()) {
                    BreakdownElementWrapperItemProvider childWrapper;
                    Process child = iter.next();
                    if (iter.getDepthLevel() <= depthLevel) break;
                    Object e = TngUtil.unwrap(child);
                    if (!(e instanceof BreakdownElement) || !isWBS && e instanceof Activity) continue;
                    BreakdownElement copy = null;
                    boolean isSuppressed = suppression.isSuppressed(child);
                    if (!isSuppressed && !isWBS) continue;
                    if (child == e) {
                        copy = (BreakdownElement)originalToCopyMap.get(e);
                    } else if (child instanceof BreakdownElementWrapperItemProvider && (childWrapper = (BreakdownElementWrapperItemProvider)child).isInherited()) {
                        String guidPath = Suppression.getPathWithoutViewType(childWrapper).toString();
                        copy = helper.getWrapperCopy(guidPath);
                    }
                    if (copy == null) continue;
                    if (isSuppressed) {
                        copy.setSuppressed(Boolean.TRUE);
                    }
                    if (!isWBS) continue;
                    elementOrWrapperToCopyMap.put((BreakdownElementWrapperItemProvider)child, copy);
                }
                if (isWBS) {
                    for (Map.Entry entry : elementOrWrapperToCopyMap.entrySet()) {
                        Object o = entry.getKey();
                        Object copy = entry.getValue();
                        if (!(copy instanceof Activity)) continue;
                        ITreeItemContentProvider ip = (ITreeItemContentProvider)adapterFactory.adapt(o, ITreeItemContentProvider.class);
                        Collection children = ip.getChildren(o);
                        EList list = (EList)((Activity)copy).getBreakdownElements();
                        List childrenList = children instanceof List ? (List)children : new ArrayList(children);
                        int size = childrenList.size();
                        int j = 0;
                        while (j < size) {
                            Object child = childrenList.get(j);
                            Object childCopy = elementOrWrapperToCopyMap.get(child);
                            if (childCopy != null) {
                                if (j < size - 1) {
                                    Object nextChild = childrenList.get(j + 1);
                                    Object nextChildCopy = elementOrWrapperToCopyMap.get(nextChild);
                                    if (nextChildCopy != null) {
                                        int id;
                                        int succId = list.indexOf(nextChildCopy);
                                        if (succId != -1 && (id = list.indexOf(childCopy)) != succId - 1) {
                                            if (id < succId) {
                                                list.move(succId - 1, id);
                                            } else {
                                                list.move(id, succId);
                                            }
                                        }
                                    } else if (TngUtil.DEBUG) {
                                        System.err.println("Element does not have copy: " + nextChild);
                                    }
                                }
                            } else if (TngUtil.DEBUG) {
                                System.err.println("Element does not have copy: " + child);
                            }
                            ++j;
                        }
                    }
                }
            }
            finally {
                if (configurator != null) {
                    configurator.setMethodConfiguration(currentConfig);
                }
            }
            ++i;
        }
    }

    public CopyHelper getCopyHelper() {
        return (CopyHelper)this.copyHelper;
    }

    /* synthetic */ ActivityDeepCopyCommand(Activity activity, CopyHelper copyHelper, MethodConfiguration methodConfiguration, Process process, IProgressMonitor iProgressMonitor, boolean bl, IConfigurator iConfigurator, ActivityDeepCopyCommand activityDeepCopyCommand) {
        this(activity, copyHelper, methodConfiguration, process, iProgressMonitor, bl, iConfigurator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateDeepCopyCommand
    extends CreateCopyCommand {
        public CreateDeepCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper copyHelper) {
            super((org.eclipse.emf.edit.domain.EditingDomain)domain, owner, copyHelper);
        }

        public Collection<?> doGetChildrenToCopy() {
            ConfigurationSetter configSetter = new ConfigurationSetter(ActivityDeepCopyCommand.this.getAdapterFactory());
            try {
                configSetter.set(ActivityDeepCopyCommand.this.config);
                IConfigurator configurator = configSetter.getConfigurator();
                ArrayList result = new ArrayList();
                for (Object o : this.owner.eContents()) {
                    if (o instanceof Activity) {
                        if (configurator != null && !configurator.accept(o)) continue;
                        result.add(0, o);
                        continue;
                    }
                    result.add(o);
                }
                ArrayList arrayList = result;
                return arrayList;
            }
            finally {
                configSetter.restore();
            }
        }
    }

    private class EditingDomain
    extends AdapterFactoryEditingDomain {
        public EditingDomain() {
            super((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
        }

        public Command createCommand(Class commandClass, CommandParameter commandParameter) {
            if (commandClass == CreateCopyCommand.class) {
                return new CreateDeepCopyCommand(this, commandParameter.getEOwner(), (CopyCommand.Helper)commandParameter.getValue());
            }
            if (commandClass == InitializeCopyCommand.class) {
                return new InitializeDeepCopyCommand(this, commandParameter.getEOwner(), (CopyCommand.Helper)commandParameter.getValue());
            }
            return super.createCommand(commandClass, commandParameter);
        }
    }

    private class InitializeDeepCopyCommand
    extends MethodElementInitializeCopyCommand {
        private List<String> guidList;

        public InitializeDeepCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper copyHelper) {
            super((org.eclipse.emf.edit.domain.EditingDomain)domain, owner, copyHelper);
            this.copy = (EObject)copyHelper.get((Object)owner);
        }

        protected void copyReferences() {
            Constraint rule;
            Activity activityCopy;
            Activity base = null;
            Activity baseCopy = null;
            HashSet<EObject> childBaseCopies = new HashSet<EObject>();
            ConfigurationSetter configSetter = null;
            IConfigurator configurator = null;
            boolean baseAccepted = false;
            try {
                List contributors;
                Activity activity;
                if (this.owner instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)(activity = (Activity)this.owner))) {
                    configSetter = new ConfigurationSetter(ActivityDeepCopyCommand.this.getAdapterFactory());
                    configSetter.set(ActivityDeepCopyCommand.this.config);
                    configurator = configSetter.getConfigurator();
                    base = (Activity)activity.getVariabilityBasedOnElement();
                    boolean bl = baseAccepted = configurator == null || configurator.accept(base);
                    if (baseAccepted) {
                        CopyHelper helper = (CopyHelper)this.copyHelper;
                        Activity oldBaseCopy = (Activity)helper.get(base);
                        helper.putVariabilityElement((VariabilityElement)base, (VariabilityElement)activity);
                        ArrayList<VariabilityElement> childBases = new ArrayList<VariabilityElement>();
                        for (Object e : activity.getBreakdownElements()) {
                            VariabilityElement ve;
                            VariabilityElement baseElement;
                            if (!(e instanceof VariabilityElement) || (baseElement = (ve = (VariabilityElement)e).getVariabilityBasedOnElement()) == null || ve.getVariabilityType() != VariabilityType.LOCAL_CONTRIBUTION && ve.getVariabilityType() != VariabilityType.LOCAL_REPLACEMENT) continue;
                            helper.putVariabilityElement(baseElement, ve);
                            childBases.add(baseElement);
                        }
                        ActivityDeepCopyCommand cmd = new ActivityDeepCopyCommand(base, helper, ActivityDeepCopyCommand.this.config, ActivityDeepCopyCommand.this.targetProcess, ActivityDeepCopyCommand.this.monitor, false, ActivityDeepCopyCommand.this.activityDeepCopyConfigurator, null);
                        cmd.copyExternalVariations = ActivityDeepCopyCommand.this.copyExternalVariations;
                        cmd.guidList = new LinkedList(ActivityDeepCopyCommand.this.guidList);
                        cmd.guidList.addAll(ProcessUtil.getGuidList(ActivityDeepCopyCommand.this.activity, activity));
                        try {
                            cmd.execute();
                            baseCopy = (Activity)helper.get(base);
                            if (activity.getVariabilityType() == VariabilityType.EXTENDS) {
                                helper.removeVariabilityElement((VariabilityElement)base);
                                helper.putBackupCopy((VariabilityElement)base, (VariabilityElement)activity);
                                if (oldBaseCopy != null) {
                                    helper.basicPut((EObject)base, (EObject)oldBaseCopy);
                                }
                            }
                            helper.remove(base);
                            Iterator iter = childBases.iterator();
                            while (iter.hasNext()) {
                                EObject childBaseCopy = helper.remove(iter.next());
                                if (childBaseCopy == null) continue;
                                childBaseCopies.add(childBaseCopy);
                                EcoreUtil.remove((EObject)childBaseCopy.eContainer());
                            }
                            Activity activityCopy2 = (Activity)this.copy;
                            int i = 0;
                            while (i < diagramTypes.length) {
                                Diagram diagram;
                                int type = diagramTypes[i];
                                if (ActivityDeepCopyCommand.this.diagramMgr.getDiagram(activity, type) != null && (diagram = ActivityDeepCopyCommand.this.diagramMgr.getDiagram(activityCopy2, type)) != null) {
                                    EcoreUtil.remove((EObject)diagram);
                                }
                                ++i;
                            }
                            ActivityDeepCopyCommand.moveContent(cmd.pkgCopy, activityCopy2);
                            for (BreakdownElement e : baseCopy.getBreakdownElements()) {
                                if (childBaseCopies.contains(e)) continue;
                                BreakdownElement original = (BreakdownElement)helper.getOriginal(e);
                                ArrayList<String> list = new ArrayList<String>(cmd.guidList);
                                list.add(original.getGuid());
                                helper.putWrapperCopy(ProcessUtil.toGuidPath(list), e);
                            }
                        }
                        finally {
                            cmd.dispose();
                        }
                    }
                }
                super.copyReferences();
                if (base != null) {
                    activity = (Activity)this.owner;
                    Activity activityCopy3 = (Activity)this.copy;
                    if (baseAccepted) {
                        MethodConfiguration currentConfig = configSetter.getOldConfiguration();
                        ArrayList<BreakdownElement> breakdownElements = new ArrayList<BreakdownElement>();
                        for (Object e : baseCopy.getBreakdownElements()) {
                            if (childBaseCopies.contains(e) || configurator != null && !configurator.accept(e)) continue;
                            breakdownElements.add((BreakdownElement)e);
                        }
                        activityCopy3.getBreakdownElements().addAll(0, breakdownElements);
                        baseCopy.setSuperActivities(null);
                        EcoreUtil.remove(baseCopy);
                        MethodConfiguration copyConfig = ActivityDeepCopyCommand.this.config == null ? (currentConfig != null ? currentConfig : ActivityDeepCopyCommand.this.targetProcess.getDefaultContext()) : ActivityDeepCopyCommand.this.config;
                        for (EAttribute attribute : this.getAttributesToCopy()) {
                            if (!attribute.isChangeable() || attribute.isDerived()) continue;
                            Object value = Providers.getConfigurationApplicator().getAttribute((VariabilityElement)activity, attribute, copyConfig);
                            activityCopy3.eSet((EStructuralFeature)attribute, value);
                        }
                        ContentDescription content = activity.getPresentation();
                        for (EAttribute attribute : content.eClass().getEAllAttributes()) {
                            if (!attribute.isChangeable() || attribute.isDerived() || attribute.getEAttributeType().getInstanceClass() != XMLTypePackage.Literals.STRING.getInstanceClass()) continue;
                            Object value = Providers.getConfigurationApplicator().getAttribute(content, (DescribableElement)activity, attribute, copyConfig);
                            activityCopy3.getPresentation().eSet((EStructuralFeature)attribute, value);
                        }
                    }
                    activityCopy3.setPresentationName(ProcessUtil.getPresentationName((BreakdownElement)activity));
                }
                if (ActivityDeepCopyCommand.this.copyExternalVariations && this.owner instanceof Activity && (ActivityDeepCopyCommand.this.copyContributors || this.owner != ActivityDeepCopyCommand.this.activity) && !(contributors = ActivityDeepCopyCommand.this.getContributors(activity = (Activity)this.owner)).isEmpty()) {
                    this.doCopyContributors(contributors, activity);
                }
                if (this.copy instanceof Activity) {
                    activityCopy = (Activity)this.copy;
                    activityCopy.setVariabilityBasedOnElement(null);
                    activityCopy.setVariabilityType(null);
                }
            }
            finally {
                if (configSetter != null) {
                    configSetter.restore();
                }
            }
            if (this.copy instanceof Activity && (rule = ConstraintManager.getConstraint((MethodElement)(activityCopy = (Activity)this.copy), "", false)) != null) {
                EcoreUtil.remove((EObject)rule);
            }
        }

        protected void doCopyContributors(List contributors, Activity owner) {
            ConfigurationSetter configSetter = new ConfigurationSetter(ActivityDeepCopyCommand.this.getAdapterFactory());
            try {
                MethodConfiguration currentConfig = configSetter.getOldConfiguration();
                MethodConfiguration copyConfig = ActivityDeepCopyCommand.this.config == null ? (currentConfig != null ? currentConfig : ActivityDeepCopyCommand.this.targetProcess.getDefaultContext()) : ActivityDeepCopyCommand.this.config;
                configSetter.set(copyConfig);
                IConfigurator configurator = configSetter.getConfigurator();
                for (Activity contributedActivity : contributors) {
                    CopyHelper helper = (CopyHelper)this.copyHelper;
                    Activity contributorCopy = (Activity)helper.get(contributedActivity);
                    ActivityDeepCopyCommand cmd = new ActivityDeepCopyCommand(contributedActivity, helper, ActivityDeepCopyCommand.this.config, ActivityDeepCopyCommand.this.targetProcess, ActivityDeepCopyCommand.this.monitor, false, ActivityDeepCopyCommand.this.activityDeepCopyConfigurator, null);
                    cmd.copyContributors = false;
                    cmd.guidList = new LinkedList(ActivityDeepCopyCommand.this.guidList);
                    cmd.guidList.addAll(ProcessUtil.getGuidList(ActivityDeepCopyCommand.this.activity, owner));
                    try {
                        cmd.execute();
                        contributorCopy = (Activity)helper.get(contributedActivity);
                        Activity activityCopy = (Activity)this.copy;
                        int i = 0;
                        while (i < diagramTypes.length) {
                            Diagram diagram;
                            int type = diagramTypes[i];
                            if (ActivityDeepCopyCommand.this.diagramMgr.getDiagram(ActivityDeepCopyCommand.this.activity, type) != null && (diagram = ActivityDeepCopyCommand.this.diagramMgr.getDiagram(activityCopy, type)) != null) {
                                EcoreUtil.remove((EObject)diagram);
                            }
                            ++i;
                        }
                        ActivityDeepCopyCommand.moveContent(cmd.pkgCopy, activityCopy);
                        ArrayList<BreakdownElement> breakdownElements = new ArrayList<BreakdownElement>();
                        for (BreakdownElement e : contributorCopy.getBreakdownElements()) {
                            if (configurator != null && !configurator.accept(e)) continue;
                            breakdownElements.add(e);
                        }
                        activityCopy.getBreakdownElements().addAll(breakdownElements);
                        contributorCopy.setSuperActivities(null);
                        EcoreUtil.remove((EObject)contributorCopy);
                    }
                    finally {
                        cmd.dispose();
                    }
                }
            }
            finally {
                if (configSetter != null) {
                    configSetter.restore();
                }
            }
        }
    }
}

