/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.command.ResourceAwareCompoundCommand;
import org.eclipse.epf.library.edit.command.ResourceAwareDragAndDropCommand;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;

public abstract class BSDragAndDropCommand
extends ResourceAwareDragAndDropCommand {
    public BSDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        super(domain, owner, location, operations, operation, collection);
    }

    protected boolean prepareDropCopyOn() {
        return this.prepareDropLinkOn();
    }

    protected boolean prepareDropLinkOn() {
        boolean result;
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList actList = new ArrayList();
        for (Object obj : this.collection) {
            Object e = TngUtil.unwrap(obj);
            if (TngUtil.isLocked((EObject)this.owner)) {
                return false;
            }
            if (this.accept(e)) {
                list.add(e);
                continue;
            }
            if (!(e instanceof Activity) || !(this.owner instanceof Activity)) continue;
            Activity target = (Activity)this.owner;
            if (DependencyChecker.newCheckAct ? !DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)target, Collections.singletonList(e), true) : !DependencyChecker.checkCircularDependency((Activity)e, target).isOK()) {
                return false;
            }
            actList.add(obj);
        }
        if (list.isEmpty() && actList.isEmpty()) {
            result = false;
        } else {
            ResourceAwareCompoundCommand cmd = new ResourceAwareCompoundCommand();
            if (!list.isEmpty()) {
                cmd.append(this.createDropCommand(this.owner, list));
            }
            if (!actList.isEmpty() && this.owner instanceof Activity) {
                cmd.append(new ActivityDropCommand((Activity)this.owner, actList, this.getTargetViewer(), ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory()));
            }
            this.dropCommand = cmd;
            result = this.dropCommand.canExecute();
        }
        return result;
    }

    protected Object getTargetViewer() {
        if (this.domain instanceof AdapterFactoryEditingDomain) {
            Process proc = TngUtil.getOwningProcess((BreakdownElement)this.owner);
            AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory();
            return UserInteractionHelper.getUIHelper().getViewer(adapterFactory, proc);
        }
        return null;
    }

    public Collection getAffectedObjects() {
        return this.dropCommand.getAffectedObjects();
    }

    protected abstract boolean accept(Object var1);

    protected abstract Command createDropCommand(Object var1, List var2);
}

