/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;

public class MoveDownCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Activity activity;
    private Collection modifiedResources;
    private int elementLocation = 0;
    private int transferLocation = 0;
    private Object elementObj;
    private Collection eClasses;
    private boolean adjacent = false;

    public MoveDownCommand(Activity activity, Object elementObj, Collection eClasses) {
        this.activity = activity;
        this.elementObj = elementObj;
        this.eClasses = eClasses;
        this.modifiedResources = new HashSet();
        if (activity.eResource() != null) {
            this.modifiedResources.add(activity.eResource());
        }
    }

    public void execute() {
        Object obj;
        List allElements = this.activity.getBreakdownElements();
        int i = 0;
        while (i < allElements.size()) {
            obj = allElements.get(i);
            if (obj.equals(this.elementObj)) {
                this.elementLocation = i;
                break;
            }
            ++i;
        }
        i = this.elementLocation + 1;
        while (i <= allElements.size()) {
            obj = allElements.get(i);
            if (TngUtil.isEClassInstanceOf(this.eClasses, obj)) {
                this.transferLocation = i;
                break;
            }
            ++i;
        }
        BreakdownElement next = (BreakdownElement)allElements.get(this.transferLocation);
        BreakdownElement e = (BreakdownElement)this.elementObj;
        if (e.getPresentedAfter() == next) {
            this.adjacent = true;
        }
        this.redo();
    }

    public void redo() {
        if (this.adjacent) {
            BreakdownElement next = (BreakdownElement)this.activity.getBreakdownElements().get(this.transferLocation);
            BreakdownElement e = (BreakdownElement)this.elementObj;
            e.setPresentedAfter(next.getPresentedAfter());
            next.setPresentedAfter(e);
        }
        ((EList)this.activity.getBreakdownElements()).move(this.transferLocation, this.elementLocation);
    }

    public void undo() {
        ((EList)this.activity.getBreakdownElements()).move(this.elementLocation, this.transferLocation);
        if (this.adjacent) {
            BreakdownElement next = (BreakdownElement)this.activity.getBreakdownElements().get(this.transferLocation);
            BreakdownElement e = (BreakdownElement)this.elementObj;
            next.setPresentedAfter(e.getPresentedAfter());
            e.setPresentedAfter(next);
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

