/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.process.command.AddRoleToTeamCommand;
import org.eclipse.epf.library.edit.process.command.BSDragAndDropCommand;
import org.eclipse.epf.library.edit.process.command.GenericDropCommand;
import org.eclipse.epf.library.edit.process.command.OBSDropCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;

public class OBSDragAndDropCommand
extends BSDragAndDropCommand {
    public OBSDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        super(domain, owner, location, operations, operation, collection);
    }

    protected boolean accept(Object obj) {
        if (obj instanceof Role) {
            if (this.owner instanceof Activity) {
                return true;
            }
            if (this.owner instanceof TeamProfile) {
                return !ProcessUtil.getAssociatedElementList(((TeamProfile)this.owner).getTeamRoles()).contains(obj);
            }
        }
        return false;
    }

    protected Command createDropCommand(Object owner, List dropSrc) {
        if (owner instanceof Activity) {
            return new OBSDropCommand((Activity)owner, dropSrc);
        }
        if (owner instanceof TeamProfile) {
            return new AddRoleToTeamCommand((TeamProfile)owner, dropSrc);
        }
        if (owner instanceof CompositeRole) {
            return new GenericDropCommand((EObject)((CompositeRole)owner), (EStructuralFeature)UmaPackage.eINSTANCE.getCompositeRole_AggregatedRoles(), dropSrc, this.getDropAdapter(owner));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private GenericDropCommand.ElementAdapter getDropAdapter(Object owner) {
        AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory();
        BreakdownElementItemProvider adapter = (BreakdownElementItemProvider)adapterFactory.adapt(owner, IEditingDomainItemProvider.class);
        return adapter.createDropAdapter();
    }
}

