/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessCommandUtil {
    public static final EStructuralFeature[] DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), UmaPackage.eINSTANCE.getBreakdownElement_Checklists(), UmaPackage.eINSTANCE.getBreakdownElement_Concepts(), UmaPackage.eINSTANCE.getBreakdownElement_Examples(), UmaPackage.eINSTANCE.getBreakdownElement_Guidelines(), UmaPackage.eINSTANCE.getBreakdownElement_ReusableAssets(), UmaPackage.eINSTANCE.getBreakdownElement_SupportingMaterials()};
    public static final EStructuralFeature[] TASK_DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy(), UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), UmaPackage.eINSTANCE.getTaskDescriptor_Output(), UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps()};
    public static final EStructuralFeature[] ROLE_DESCRIPTOR_REFRESHABLE_FEATURES = new EStructuralFeature[]{UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor()};

    public static Map createRefreshableFeatureMap(Descriptor descriptor, Set excludeFeatures) {
        HashMap<EReference, List> featureMap = new HashMap<EReference, List>();
        ProcessCommandUtil.addToFeatureMap((EObject)descriptor, DESCRIPTOR_REFRESHABLE_FEATURES, featureMap, excludeFeatures);
        if (descriptor instanceof TaskDescriptor) {
            ProcessCommandUtil.addToFeatureMap((EObject)descriptor, TASK_DESCRIPTOR_REFRESHABLE_FEATURES, featureMap, excludeFeatures);
        } else if (descriptor instanceof RoleDescriptor) {
            ProcessCommandUtil.addToFeatureMap((EObject)descriptor, ROLE_DESCRIPTOR_REFRESHABLE_FEATURES, featureMap, excludeFeatures);
        } else if (descriptor instanceof WorkProductDescriptor) {
            WorkProductDescriptor wpd = (WorkProductDescriptor)descriptor;
            EReference feature = UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts();
            if (wpd.getWorkProduct() instanceof Deliverable && !excludeFeatures.contains(feature)) {
                featureMap.put(feature, wpd.getDeliverableParts());
            }
        }
        return featureMap;
    }

    private static void addToFeatureMap(EObject eObject, EStructuralFeature[] features, Map featureMap, Set excludeFeatures) {
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (!excludeFeatures.contains(feature)) {
                ArrayList value = eObject.eGet(feature);
                if (feature.isMany()) {
                    value = new ArrayList(value);
                }
                featureMap.put(feature, value);
            }
            ++i;
        }
    }

    public static Map clearRefreshableFeatures(Descriptor descriptor, Set excludeFeatures) {
        Map featureMap = ProcessCommandUtil.createRefreshableFeatureMap(descriptor, excludeFeatures);
        for (EStructuralFeature feature : featureMap.keySet()) {
            if (feature instanceof EAttribute) {
                descriptor.eSet(feature, feature.getDefaultValue());
                continue;
            }
            if (feature.isMany()) {
                List list = (List)descriptor.eGet(feature);
                switch (list.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        list.remove(0);
                        break;
                    }
                    default: {
                        list.clear();
                        break;
                    }
                }
                continue;
            }
            descriptor.eSet(feature, feature.getDefaultValue());
        }
        return featureMap;
    }

    public static boolean clearDescriptor(Descriptor descriptor, Map descriptorToOldRefreshableFeaturesMap, Set excludeFeatures) {
        if (descriptorToOldRefreshableFeaturesMap != null && !descriptorToOldRefreshableFeaturesMap.containsKey(descriptor)) {
            descriptorToOldRefreshableFeaturesMap.put(descriptor, ProcessCommandUtil.clearRefreshableFeatures(descriptor, excludeFeatures));
            return true;
        }
        return false;
    }

    private static boolean isValidDescriptorOf(Object element, MethodConfiguration config, Object descriptor, boolean excludeSuppressed) {
        if (descriptor instanceof Descriptor) {
            Descriptor desc = (Descriptor)descriptor;
            if (excludeSuppressed && desc.getSuppressed().booleanValue()) {
                return false;
            }
            Object elementObj = ProcessUtil.getAssociatedElement(desc);
            elementObj = Providers.getConfigurationApplicator().resolve(elementObj, config);
            return element == elementObj;
        }
        return false;
    }

    private static boolean isValidDescriptorOrDescriptorWrapperOf(Object element, MethodConfiguration config, Suppression suppression, Object object) {
        if (object instanceof BreakdownElementWrapperItemProvider) {
            if (suppression.isInSuppressedList((BreakdownElementWrapperItemProvider)object)) {
                return false;
            }
            return ProcessCommandUtil.isValidDescriptorOf(element, config, TngUtil.unwrap(object), false);
        }
        return ProcessCommandUtil.isValidDescriptorOf(element, config, object, true);
    }

    public static Object getDescriptor(Object obj, List descriptorList, MethodConfiguration config) {
        return ProcessCommandUtil.getDescriptor(obj, descriptorList, config, true);
    }

    static Object getDescriptor(Object obj, List descriptorList, MethodConfiguration config, boolean excludeSuppressed) {
        int size = descriptorList.size();
        int j = 0;
        while (j < size) {
            Object object = descriptorList.get(j);
            if (ProcessCommandUtil.isValidDescriptorOf(obj, config, object, excludeSuppressed)) {
                return object;
            }
            ++j;
        }
        return null;
    }

    static Object getBestDescriptor(Object obj, Activity activity, MethodConfiguration config) {
        List descriptorList = activity.getBreakdownElements();
        int size = descriptorList.size();
        Descriptor descriptor = null;
        int j = 0;
        while (j < size) {
            Object object = descriptorList.get(j);
            if (ProcessCommandUtil.isValidDescriptorOf(obj, config, object, false)) {
                Descriptor desc = (Descriptor)object;
                if (!desc.getSuppressed().booleanValue()) {
                    return desc;
                }
                if (descriptor == null) {
                    descriptor = desc;
                }
            }
            ++j;
        }
        return descriptor;
    }

    public static Descriptor getValidDescriptor(Object obj, Activity activity, AdapterFactory adapterFactory) {
        Process proc = TngUtil.getOwningProcess((BreakdownElement)activity);
        MethodConfiguration config = proc.getDefaultContext();
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)activity, ITreeItemContentProvider.class);
        for (Object child : adapter.getChildren((Object)activity)) {
            if (!ProcessCommandUtil.isValidDescriptorOrDescriptorWrapperOf(obj, config, Suppression.getSuppression(proc), child)) continue;
            return (Descriptor)TngUtil.unwrap(child);
        }
        return null;
    }

    public static Object getDescriptor(Object obj, Activity activity, MethodConfiguration config) {
        return ProcessCommandUtil.getDescriptor(obj, activity.getBreakdownElements(), config);
    }

    public static void addResponsibleRoleDescriptors(WorkProductDescriptor wpDesc, Activity activity, List<RoleDescriptor> roleDescriptors, Set descriptorsToRefresh, MethodConfiguration config) {
        WorkProduct wp;
        if (wpDesc != null && (wp = wpDesc.getWorkProduct()) != null) {
            if (TngUtil.isContributor((VariabilityElement)wp)) {
                wp = (WorkProduct)TngUtil.getBase((VariabilityElement)wp);
            }
            List roles = AssociationHelper.getResponsibleRoles((WorkProduct)wp);
            for (Role role : roles) {
                if (TngUtil.isContributor((VariabilityElement)role)) {
                    role = (Role)TngUtil.getBase((VariabilityElement)role);
                }
                boolean isNewDescriptor = false;
                RoleDescriptor roleDesc = (RoleDescriptor)ProcessCommandUtil.getBestDescriptor(role, activity, config);
                if (roleDesc == null && (roleDesc = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(role, activity, config)) == null && (roleDesc = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, roleDescriptors, config)) == null) {
                    roleDesc = ProcessUtil.createRoleDescriptor(role);
                    roleDescriptors.add(roleDesc);
                    isNewDescriptor = true;
                }
                if (isNewDescriptor || descriptorsToRefresh == null || !roleDesc.getIsSynchronizedWithSource().booleanValue()) continue;
                descriptorsToRefresh.add(roleDesc);
            }
        }
    }

    private static void collectWorkProductDescrtiptors(Task task, TaskDescriptor taskDescriptor, EReference taskFeature, EStructuralFeature taskDescriptorFeature, MethodConfiguration config, Activity activity, List wpDescriptors, Map wpdToDeliverablePartsMap, Map wpdToDeliverableDescriptorMap, Set descriptorsToRefresh, Map descriptorToNewFeatureValuesMap) {
        List workProducts = (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)task, taskFeature, config);
        ArrayList list = new ArrayList();
        ProcessCommandUtil.createWorkProductDescriptors(workProducts, list, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh, config);
        if (!list.isEmpty()) {
            BatchCommand.addFeatureValues(descriptorToNewFeatureValuesMap, (EObject)taskDescriptor, taskDescriptorFeature, list);
        }
    }

    static void createWorkProductDescriptors(List workProducts, List featureValue, Activity activity, List wpDescriptors, Map wpdToDeliverablePartsMap, Map wpdToDeliverableDescriptorMap, Set descriptorsToRefresh, MethodConfiguration config) {
        if (workProducts != null) {
            boolean wasEmpty = featureValue.isEmpty();
            int j = 0;
            while (j < workProducts.size()) {
                WorkProduct wpObj = (WorkProduct)workProducts.get(j);
                if (wpObj != null) {
                    WorkProductDescriptor wpDesc;
                    if (TngUtil.isContributor((VariabilityElement)wpObj)) {
                        wpObj = (WorkProduct)TngUtil.getBase((VariabilityElement)wpObj);
                    }
                    if ((wpDesc = (WorkProductDescriptor)ProcessCommandUtil.getBestDescriptor(wpObj, activity, config)) == null && (wpDesc = (WorkProductDescriptor)ProcessCommandUtil.getInheritedDescriptor(wpObj, activity, config)) == null) {
                        wpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)wpObj, wpDescriptors, config);
                        if (wpDesc == null) {
                            wpDesc = ProcessCommandUtil.createWorkProductDescriptor(wpObj, config, wpdToDeliverablePartsMap);
                            wpDescriptors.add(wpDesc);
                            WorkProductDescriptor descriptor = UserInteractionHelper.getDeliverable(activity, wpObj);
                            if (descriptor != null) {
                                wpdToDeliverableDescriptorMap.put(wpDesc, descriptor);
                            }
                        } else {
                            if (descriptorsToRefresh != null) {
                                descriptorsToRefresh.add(wpDesc);
                            }
                            if (wpObj instanceof Deliverable && wpdToDeliverablePartsMap != null) {
                                ProcessCommandUtil.createDeliverableParts(wpDesc, (Deliverable)wpObj, config, wpdToDeliverablePartsMap, descriptorsToRefresh);
                            }
                        }
                    }
                    if (wasEmpty || !featureValue.contains(wpDesc)) {
                        featureValue.add(wpDesc);
                    }
                }
                ++j;
            }
        }
    }

    public static TaskDescriptor createTaskDescriptor(Task task, Activity activity, List roleDescriptors, List wpDescriptors, Map wpdToDeliverablePartsMap, Map wpdToDeliverableDescriptorMap, Set descriptorsToRefresh, Map descriptorToNewFeatureValuesMap, MethodConfiguration config, boolean useExistingDescriptor, Set synchFeatures) {
        if (TngUtil.isContributor((VariabilityElement)task)) {
            task = (Task)TngUtil.getBase((VariabilityElement)task);
        }
        TaskDescriptor taskDesc = null;
        if (useExistingDescriptor) {
            taskDesc = (TaskDescriptor)ProcessCommandUtil.getBestDescriptor(task, activity, config);
        }
        boolean isNewTaskDescriptor = false;
        if (taskDesc == null) {
            taskDesc = ProcessCommandUtil.createTaskDescriptor(task);
            isNewTaskDescriptor = true;
        } else if (descriptorsToRefresh != null && taskDesc.getIsSynchronizedWithSource().booleanValue()) {
            descriptorsToRefresh.add(taskDesc);
        }
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        if (isNewTaskDescriptor) {
            List steps = (List)configApplicator.getReference(task.getPresentation(), (DescribableElement)task, UmaPackage.eINSTANCE.getContentDescription_Sections(), config);
            taskDesc.getSelectedSteps().addAll(steps);
        }
        if (roleDescriptors != null) {
            List additionalPerformers;
            List primaryPerformers;
            EReference ref = UmaPackage.eINSTANCE.getTask_PerformedBy();
            List list = primaryPerformers = synchFeatures.contains(ref) ? (List)configApplicator.getReference((VariabilityElement)task, ref, config) : null;
            if (primaryPerformers != null) {
                int j = 0;
                while (j < primaryPerformers.size()) {
                    Role role = (Role)primaryPerformers.get(j);
                    if (role != null) {
                        RoleDescriptor primaryRoleDesc = (RoleDescriptor)ProcessCommandUtil.getBestDescriptor(role, activity, config);
                        boolean isNewRoleDescriptor = false;
                        if (primaryRoleDesc == null && (primaryRoleDesc = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(role, activity, config)) == null && (primaryRoleDesc = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, roleDescriptors, config)) == null) {
                            primaryRoleDesc = ProcessUtil.createRoleDescriptor(role);
                            isNewRoleDescriptor = true;
                            roleDescriptors.add(primaryRoleDesc);
                        }
                        if (descriptorsToRefresh != null && !isNewRoleDescriptor && primaryRoleDesc.getIsSynchronizedWithSource().booleanValue()) {
                            descriptorsToRefresh.add(primaryRoleDesc);
                        }
                        if (isNewTaskDescriptor && isNewRoleDescriptor) {
                            taskDesc.getPerformedPrimarilyBy().add(primaryRoleDesc);
                        } else {
                            BatchCommand.addFeatureValue(descriptorToNewFeatureValuesMap, (EObject)taskDesc, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), primaryRoleDesc);
                        }
                    }
                    ++j;
                }
            }
            List list2 = additionalPerformers = synchFeatures.contains(ref = UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy()) ? (List)configApplicator.getReference((VariabilityElement)task, ref, config) : null;
            if (additionalPerformers != null) {
                int j = 0;
                while (j < additionalPerformers.size()) {
                    Role roleObj = (Role)additionalPerformers.get(j);
                    RoleDescriptor roleDesc = (RoleDescriptor)ProcessCommandUtil.getBestDescriptor(roleObj, activity, config);
                    boolean isNewRoleDescriptor = false;
                    if (roleDesc == null && (roleDesc = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(roleObj, activity, config)) == null && (roleDesc = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)roleObj, roleDescriptors, config)) == null) {
                        roleDesc = ProcessUtil.createRoleDescriptor(roleObj);
                        isNewRoleDescriptor = true;
                        roleDescriptors.add(roleDesc);
                    }
                    if (descriptorsToRefresh != null && !isNewRoleDescriptor && roleDesc.getIsSynchronizedWithSource().booleanValue()) {
                        descriptorsToRefresh.add(roleDesc);
                    }
                    if (isNewTaskDescriptor && isNewRoleDescriptor) {
                        taskDesc.getAdditionallyPerformedBy().add(roleDesc);
                    } else {
                        BatchCommand.addFeatureValue(descriptorToNewFeatureValuesMap, (EObject)taskDesc, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy(), roleDesc);
                    }
                    ++j;
                }
            }
        }
        if (wpDescriptors != null) {
            if (!isNewTaskDescriptor && !synchFeatures.contains(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())) {
                wpdToDeliverablePartsMap = null;
            }
            if (isNewTaskDescriptor || synchFeatures.contains(UmaPackage.eINSTANCE.getTask_MandatoryInput())) {
                ProcessCommandUtil.collectWorkProductDescrtiptors(task, taskDesc, UmaPackage.eINSTANCE.getTask_MandatoryInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), config, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh, descriptorToNewFeatureValuesMap);
            }
            if (isNewTaskDescriptor || synchFeatures.contains(UmaPackage.eINSTANCE.getTask_OptionalInput())) {
                ProcessCommandUtil.collectWorkProductDescrtiptors(task, taskDesc, UmaPackage.eINSTANCE.getTask_OptionalInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), config, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh, descriptorToNewFeatureValuesMap);
            }
            if (isNewTaskDescriptor || synchFeatures.contains(UmaPackage.eINSTANCE.getTask_Output())) {
                ProcessCommandUtil.collectWorkProductDescrtiptors(task, taskDesc, UmaPackage.eINSTANCE.getTask_Output(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Output(), config, activity, wpDescriptors, wpdToDeliverablePartsMap, wpdToDeliverableDescriptorMap, descriptorsToRefresh, descriptorToNewFeatureValuesMap);
            }
        }
        if (isNewTaskDescriptor) {
            return taskDesc;
        }
        return null;
    }

    private static TaskDescriptor createTaskDescriptor(Task task) {
        TaskDescriptor taskDesc = UmaFactory.eINSTANCE.createTaskDescriptor();
        taskDesc.setTask(task);
        taskDesc.setName(task.getName());
        taskDesc.setPresentationName(StrUtil.isBlank((String)task.getPresentationName()) ? task.getName() : task.getPresentationName());
        return taskDesc;
    }

    public static void createDeliverableParts(WorkProductDescriptor wpd, Deliverable deliverable, MethodConfiguration config, Map wpDescToDeliverableParts, Set descriptorsToRefresh) {
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        List deliveredWPs = (List)configApplicator.getReference((VariabilityElement)deliverable, UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), config);
        ArrayList<WorkProductDescriptor> parts = new ArrayList<WorkProductDescriptor>();
        if (wpd.getDeliverableParts().isEmpty()) {
            Iterator iter = deliveredWPs.iterator();
            while (iter.hasNext()) {
                parts.add(ProcessCommandUtil.createWorkProductDescriptor((WorkProduct)iter.next(), config, wpDescToDeliverableParts));
            }
        } else {
            for (WorkProduct workProduct : deliveredWPs) {
                WorkProductDescriptor desc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)workProduct, wpd.getDeliverableParts(), config);
                if (desc == null) {
                    desc = ProcessCommandUtil.createWorkProductDescriptor(workProduct, config, wpDescToDeliverableParts);
                } else {
                    if (descriptorsToRefresh != null) {
                        descriptorsToRefresh.add(desc);
                    }
                    if (workProduct instanceof Deliverable) {
                        ProcessCommandUtil.createDeliverableParts(desc, (Deliverable)workProduct, config, wpDescToDeliverableParts, descriptorsToRefresh);
                    }
                }
                parts.add(desc);
            }
        }
        if (!parts.isEmpty()) {
            wpDescToDeliverableParts.put(wpd, parts);
        }
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct wp, MethodConfiguration config, Map wpDescToDeliverableParts) {
        WorkProductDescriptor wpd = ProcessUtil.createWorkProductDescriptor(wp);
        if (wp instanceof Deliverable && wpDescToDeliverableParts != null) {
            ProcessCommandUtil.createDeliverableParts(wpd, (Deliverable)wp, config, wpDescToDeliverableParts, null);
        }
        return wpd;
    }

    public static Object getInheritedDescriptor(Object obj, Activity activity, MethodConfiguration config) {
        VariabilityType variabilityType = activity.getVariabilityType();
        while (variabilityType == VariabilityType.EXTENDS || variabilityType == VariabilityType.LOCAL_CONTRIBUTION) {
            VariabilityElement element = activity.getVariabilityBasedOnElement();
            if (!(element instanceof Activity)) break;
            Activity baseActivity = (Activity)element;
            Object desc = ProcessCommandUtil.getBestDescriptor(obj, baseActivity, config);
            if (desc != null) {
                return desc;
            }
            activity = baseActivity;
            variabilityType = activity.getVariabilityType();
        }
        return null;
    }

    public static Map getFeaturesMap(List tasks, WorkProduct wp, MethodConfiguration config) {
        HashMap<Task, ArrayList<EReference>> featuresMap = new HashMap<Task, ArrayList<EReference>>();
        EReference[] taskFeatures = new EReference[]{UmaPackage.eINSTANCE.getTask_MandatoryInput(), UmaPackage.eINSTANCE.getTask_OptionalInput(), UmaPackage.eINSTANCE.getTask_Output()};
        int i = tasks.size() - 1;
        while (i > -1) {
            Task task = (Task)tasks.get(i);
            int j = 0;
            while (j < taskFeatures.length) {
                EReference feature = taskFeatures[j];
                Object value = Providers.getConfigurationApplicator().getReference((VariabilityElement)task, feature, config);
                if (feature.isMany() && ((List)value).contains(wp) || value == wp) {
                    ArrayList<EReference> features = (ArrayList<EReference>)featuresMap.get(task);
                    if (features == null) {
                        features = new ArrayList<EReference>();
                        featuresMap.put(task, features);
                    }
                    features.add(feature);
                }
                ++j;
            }
            --i;
        }
        return featuresMap;
    }
}

