/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.consolidated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IBreakdownElementWrapperItemProviderFactory;
import org.eclipse.epf.library.edit.process.consolidated.ActivityItemProvider;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;

public class TaskDescriptorItemProvider
extends org.eclipse.epf.library.edit.process.TaskDescriptorItemProvider {
    protected Collection cachedChildren;

    public TaskDescriptorItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter delegateItemProvider) {
        super(adapterFactory, delegateItemProvider);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(new CommandParameter((Object)this.target, (Object)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), (Object)UmaFactory.eINSTANCE.createRoleDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy(), UmaFactory.eINSTANCE.createRoleDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getTaskDescriptor_AssistedBy(), UmaFactory.eINSTANCE.createRoleDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), UmaFactory.eINSTANCE.createWorkProductDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), UmaFactory.eINSTANCE.createWorkProductDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getTaskDescriptor_ExternalInput(), UmaFactory.eINSTANCE.createWorkProductDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getTaskDescriptor_Output(), UmaFactory.eINSTANCE.createWorkProductDescriptor()));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy());
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy());
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTaskDescriptor_AssistedBy());
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput());
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput());
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTaskDescriptor_ExternalInput());
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTaskDescriptor_Output());
        }
        return this.childrenFeatures;
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection selection) {
        return this.getFeatureText(feature);
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection) {
        Object img = TngUtil.getImage(child);
        return img != null ? img : super.getCreateChildImage(owner, feature, child, selection);
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)IBreakdownElementWrapperItemProviderFactory.INSTANCE.createWrapper(value, object, feature, index, this.adapterFactory);
        wrapper.setReadOnly(false);
        return wrapper;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TaskDescriptor.class)) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.refreshChildren(notification);
            }
        }
        super.notifyChanged(notification);
    }

    static void refreshChildren(ItemProviderAdapter ipa, Notification notification) {
        if (ProcessUtil.isRefreshRequired(notification, null)) {
            ipa.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
            AdapterFactory adapterFactory = ipa.getAdapterFactory();
            if (notification.getNotifier() instanceof BreakdownElement) {
                Activity parent = ((BreakdownElement)notification.getNotifier()).getSuperActivities();
                Object adapter = adapterFactory.adapt((Notifier)parent, ITreeItemContentProvider.class);
                if (adapter instanceof ItemProviderAdapter) {
                    ((ItemProviderAdapter)adapter).fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)parent, true, false));
                }
                if (parent instanceof VariabilityElement) {
                    Iterator iter = TngUtil.getGeneralizers((VariabilityElement)parent);
                    while (iter.hasNext()) {
                        VariabilityElement ve = (VariabilityElement)iter.next();
                        if (ve.getVariabilityType() != VariabilityType.EXTENDS && ve.getVariabilityType() != VariabilityType.LOCAL_CONTRIBUTION || !((adapter = TngUtil.getAdapterByType((Notifier)ve, adapterFactory)) instanceof ItemProviderAdapter)) continue;
                        ((ItemProviderAdapter)adapter).fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)ve, true, false));
                    }
                }
            }
        }
    }

    private void refreshChildren(Notification notification) {
        TaskDescriptorItemProvider.refreshChildren((ItemProviderAdapter)this, notification);
    }

    private void updateCachedChildren(Collection children) {
    }

    public Collection getChildren(Object obj) {
        Collection children = super.getChildren(obj);
        List newChildren = new ArrayList();
        ArrayList primaryPerformers = new ArrayList();
        ArrayList additionalPerformers = new ArrayList();
        ArrayList assitedBy = new ArrayList();
        ArrayList mandatoryInput = new ArrayList();
        ArrayList externalInput = new ArrayList();
        ArrayList optionalInput = new ArrayList();
        ArrayList output = new ArrayList();
        IFilter filter = this.getFilter(obj);
        for (Object o : children) {
            if (!(o instanceof WrapperItemProvider)) continue;
            Object child = ((WrapperItemProvider)o).getValue();
            if (filter == null || !filter.accept(child)) continue;
            if (((WrapperItemProvider)o).getFeature().equals(UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy())) {
                primaryPerformers.add(o);
                continue;
            }
            if (((WrapperItemProvider)o).getFeature().equals(UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy())) {
                additionalPerformers.add(o);
                continue;
            }
            if (((WrapperItemProvider)o).getFeature().equals(UmaPackage.eINSTANCE.getTaskDescriptor_AssistedBy())) {
                assitedBy.add(o);
                continue;
            }
            if (((WrapperItemProvider)o).getFeature().equals(UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput())) {
                mandatoryInput.add(o);
                continue;
            }
            if (((WrapperItemProvider)o).getFeature().equals(UmaPackage.eINSTANCE.getTaskDescriptor_ExternalInput())) {
                externalInput.add(o);
                continue;
            }
            if (((WrapperItemProvider)o).getFeature().equals(UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput())) {
                optionalInput.add(o);
                continue;
            }
            if (!((WrapperItemProvider)o).getFeature().equals(UmaPackage.eINSTANCE.getTaskDescriptor_Output())) continue;
            output.add(o);
        }
        Collections.sort(primaryPerformers, Comparators.PRESENTATION_NAME_COMPARATOR);
        Collections.sort(additionalPerformers, Comparators.PRESENTATION_NAME_COMPARATOR);
        Collections.sort(assitedBy, Comparators.PRESENTATION_NAME_COMPARATOR);
        Collections.sort(externalInput, Comparators.PRESENTATION_NAME_COMPARATOR);
        Collections.sort(mandatoryInput, Comparators.PRESENTATION_NAME_COMPARATOR);
        Collections.sort(optionalInput, Comparators.PRESENTATION_NAME_COMPARATOR);
        Collections.sort(output, Comparators.PRESENTATION_NAME_COMPARATOR);
        newChildren.addAll(primaryPerformers);
        newChildren.addAll(additionalPerformers);
        newChildren.addAll(assitedBy);
        newChildren.addAll(externalInput);
        newChildren.addAll(mandatoryInput);
        newChildren.addAll(optionalInput);
        newChildren.addAll(output);
        newChildren = this.removeSubartifactsFromChildren(newChildren, true);
        this.updateCachedChildren(newChildren);
        return newChildren;
    }

    protected List removeSubartifactsFromChildren(Collection children, boolean unwrap) {
        return ProcessUtil.removeSubartifactsFromChildren(children, unwrap);
    }

    private IFilter getFilter(Object obj) {
        IFilter filter = null;
        Object parent = this.getParent(obj);
        IBSItemProvider adapter = (IBSItemProvider)this.getRootAdapterFactory().adapt(parent, ITreeItemContentProvider.class);
        if (adapter instanceof ActivityItemProvider) {
            filter = ((ActivityItemProvider)adapter).getFilter();
        }
        return filter;
    }

    public Collection getChildrenFromCache() {
        if (this.cachedChildren == null) {
            this.getChildren(this.target);
        }
        return this.cachedChildren;
    }

    public Collection getRollupChildrenFromCache() {
        return Collections.EMPTY_LIST;
    }

    public void dispose() {
        if (this.cachedChildren != null) {
            this.cachedChildren.clear();
            this.cachedChildren = null;
        }
        super.dispose();
    }
}

