/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.DepthLevelAdapterFactoryTreeIterator;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredecessorList
extends ArrayList<Object> {
    private static final long serialVersionUID = 3617853092570412082L;
    private static final String FINISH_TO_START = LibraryEditResources.WorkOrderTypeAbbreviation_FINISH_TO_START;
    private static final String FINISH_TO_FINISH = LibraryEditResources.WorkOrderTypeAbbreviation_FINISH_TO_FINISH;
    private static final String START_TO_START = LibraryEditResources.WorkOrderTypeAbbreviation_START_TO_START;
    private static final String START_TO_FINISH = LibraryEditResources.WorkOrderTypeAbbreviation_START_TO_FINISH;
    private Map map4LinkType = new HashMap();
    public static final PredecessorList EMPTY_LIST = new PredecessorList(){
        private static final long serialVersionUID = 3904676098217097016L;

        public void refresh() {
        }

        public void add(int index, Object element) {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }
    };
    private AdapterFactory adapterFactory;
    private Object object;
    private Adapter listener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(BreakdownElement.class)) {
                case 34: {
                    PredecessorList.this.refresh();
                    return;
                }
            }
        }
    };
    private Object top;

    private PredecessorList() {
    }

    public PredecessorList(AdapterFactory adapterFactory, Object object) {
        this.adapterFactory = adapterFactory;
        this.object = object;
        BreakdownElement e = (BreakdownElement)TngUtil.unwrap(object);
        e.eAdapters().add(0, (Object)this.listener);
        if (!this.map4LinkType.isEmpty()) {
            this.map4LinkType.clear();
        }
        this.initialize();
    }

    public void dispose() {
        Object e = TngUtil.unwrap(this.object);
        if (e instanceof EObject) {
            ((EObject)e).eAdapters().remove((Object)this.listener);
        }
        this.clear();
    }

    protected Object getTopItem() {
        if (this.object instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider itemProvider = (BreakdownElementWrapperItemProvider)this.object;
            if (itemProvider.isReadOnly()) {
                BreakdownElement e = (BreakdownElement)TngUtil.unwrap(this.object);
                Process proc = TngUtil.getOwningProcess(e);
                Object top = itemProvider;
                Object parent = itemProvider.getParent(this.object);
                while (parent != null) {
                    top = parent;
                    BreakdownElement parentElement = (BreakdownElement)TngUtil.unwrap(parent);
                    Process parentProc = TngUtil.getOwningProcess(parentElement);
                    if (parentProc != proc) break;
                    if (parent instanceof ITreeItemContentProvider) {
                        parent = ((ITreeItemContentProvider)parent).getParent(parent);
                        continue;
                    }
                    ITreeItemContentProvider adapter = (ITreeItemContentProvider)this.adapterFactory.adapt(parent, ITreeItemContentProvider.class);
                    parent = adapter.getParent(parent);
                }
                return top;
            }
            return itemProvider.getTopItem();
        }
        IBSItemProvider adapter = (IBSItemProvider)this.adapterFactory.adapt(this.object, ITreeItemContentProvider.class);
        return adapter.getTopItem();
    }

    static List<DepthLevelItemProvider> createItemProviderList(Object top, AdapterFactory adapterFactory) {
        ArrayList<DepthLevelItemProvider> list = new ArrayList<DepthLevelItemProvider>();
        DepthLevelAdapterFactoryTreeIterator<Object> iter = new DepthLevelAdapterFactoryTreeIterator<Object>(adapterFactory, top){
            private static final long serialVersionUID = 1L;

            protected Iterator<Object> getChildren(Object o) {
                Object e = TngUtil.unwrap(o);
                if (e instanceof Descriptor || e instanceof Milestone) {
                    return Collections.emptyList().iterator();
                }
                return super.getChildren(o);
            }
        };
        while (iter.hasNext()) {
            Object object = iter.next();
            Object element = TngUtil.unwrap(object);
            if (!(element instanceof WorkBreakdownElement)) continue;
            int depthLevel = iter.getDepthLevel();
            Object itemProvider = adapterFactory.adapt(object, ITreeItemContentProvider.class);
            list.add(new DepthLevelItemProvider(object, depthLevel, itemProvider, element));
        }
        return list;
    }

    private static void updateElementToItemProvidersMap(Map<Object, Collection<Object>> map, Object element, Object itemProvider) {
        VariabilityElement ve;
        Collection<Object> itemProviders = map.get(element);
        if (itemProviders == null) {
            itemProviders = new ArrayList<Object>();
            map.put(element, itemProviders);
        }
        itemProviders.add(itemProvider);
        if (element instanceof VariabilityElement && (ve = (VariabilityElement)element).getVariabilityBasedOnElement() != null) {
            itemProviders = map.get(ve.getVariabilityBasedOnElement());
            if (itemProviders == null) {
                itemProviders = new ArrayList<Object>();
                map.put(ve.getVariabilityBasedOnElement(), itemProviders);
            }
            itemProviders.add(itemProvider);
        }
    }

    Map<?, Collection<Object>> createBreakdownElementToItemProviderMap(List<DepthLevelItemProvider> list) {
        Object top = this.getTopItem();
        DepthLevelItemProvider topIp = null;
        int startIndex = 0;
        for (DepthLevelItemProvider itemProvider : list) {
            if (itemProvider.object == top) {
                topIp = itemProvider;
                break;
            }
            ++startIndex;
        }
        assert (topIp != null) : "Could not find item provider of top object in the given item provider list.";
        int size = list.size();
        int lastIndex = startIndex + 1;
        while (lastIndex < size && list.get(lastIndex).depthLevel > topIp.depthLevel) {
            ++lastIndex;
        }
        HashMap<Object, Collection<Object>> map = new HashMap<Object, Collection<Object>>();
        for (DepthLevelItemProvider itemProvider : list.subList(startIndex, lastIndex)) {
            PredecessorList.updateElementToItemProvidersMap(map, itemProvider.element, itemProvider.itemProvider);
        }
        return map;
    }

    static Map<Object, Collection<Object>> createBreakdownElementToItemProviderMap(Object top, AdapterFactory adapterFactory) {
        AdapterFactoryTreeIterator<Object> iter = new AdapterFactoryTreeIterator<Object>(adapterFactory, top){
            private static final long serialVersionUID = 1L;

            protected Iterator<Object> getChildren(Object o) {
                Object e = TngUtil.unwrap(o);
                if (e instanceof Descriptor || e instanceof Milestone) {
                    return Collections.emptyList().iterator();
                }
                return super.getChildren(o);
            }
        };
        HashMap<Object, Collection<Object>> map = new HashMap<Object, Collection<Object>>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            Object be = TngUtil.unwrap(obj);
            if (!(be instanceof WorkBreakdownElement)) continue;
            IBSItemProvider ip = (IBSItemProvider)(obj instanceof IBSItemProvider ? obj : adapterFactory.adapt(obj, ITreeItemContentProvider.class));
            PredecessorList.updateElementToItemProvidersMap(map, be, ip);
        }
        return map;
    }

    private void initialize() {
        Object unwrapped = TngUtil.unwrap(this.object);
        if (unwrapped instanceof WorkBreakdownElement) {
            WorkBreakdownElement e = (WorkBreakdownElement)unwrapped;
            List workOrders = e.getLinkToPredecessor();
            if (workOrders.isEmpty()) {
                return;
            }
            this.top = this.getTopItem();
            this.initialize(PredecessorList.createBreakdownElementToItemProviderMap(this.top, this.adapterFactory));
        }
    }

    private void initialize(Map<?, Collection<Object>> map) {
        if (TngUtil.unwrap(this.object) instanceof WorkBreakdownElement) {
            WorkBreakdownElement e = (WorkBreakdownElement)TngUtil.unwrap(this.object);
            List workOrders = e.getLinkToPredecessor();
            if (workOrders.isEmpty()) {
                return;
            }
            WorkBreakdownElement topElement = (WorkBreakdownElement)TngUtil.unwrap(this.top);
            String topGUID = topElement.getGuid();
            int n = workOrders.size();
            int i = 0;
            while (i < n) {
                WorkOrder workOrder = (WorkOrder)workOrders.get(i);
                WorkBreakdownElement pred = workOrder.getPred();
                Collection<Object> itemProviders = map.get(pred);
                if (itemProviders != null && !itemProviders.isEmpty()) {
                    IBSItemProvider bsItemProvider = null;
                    MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)workOrder, "pred_process_path");
                    if (prop == null) {
                        bsItemProvider = (IBSItemProvider)itemProviders.iterator().next();
                    } else {
                        String procPath = prop.getValue();
                        String guid = topGUID;
                        VariabilityElement base = topElement instanceof VariabilityElement ? ((VariabilityElement)topElement).getVariabilityBasedOnElement() : null;
                        int index = procPath.indexOf(guid);
                        while (index == -1 && base != null) {
                            if (base != null) {
                                guid = base.getGuid();
                                base = base.getVariabilityBasedOnElement();
                            }
                            index = procPath.indexOf(guid);
                        }
                        if (index != -1) {
                            StringBuffer strBuff = new StringBuffer(procPath.substring(index + guid.length()));
                            Object topObject = this.top;
                            WorkBreakdownElement wbe = topElement;
                            while (wbe != null) {
                                strBuff.insert(0, wbe.getGuid());
                                strBuff.insert(0, '/');
                                if (topObject instanceof WorkBreakdownElement) {
                                    wbe = ((WorkBreakdownElement)topObject).getSuperActivities();
                                    topObject = wbe;
                                    continue;
                                }
                                topObject = this.adapterFactory.adapt(topObject, ITreeItemContentProvider.class);
                                wbe = (WorkBreakdownElement)TngUtil.unwrap(topObject);
                            }
                            strBuff.insert(0, ":/").insert(0, "wbs");
                            String path = strBuff.toString();
                            for (Object itemProvider : itemProviders) {
                                String p;
                                if (!(itemProvider instanceof BreakdownElementWrapperItemProvider) || !path.equals(p = Suppression.getPath((BreakdownElementWrapperItemProvider)itemProvider))) continue;
                                bsItemProvider = (IBSItemProvider)itemProvider;
                                break;
                            }
                        }
                    }
                    if (bsItemProvider != null) {
                        this.add(bsItemProvider);
                        this.map4LinkType.put(bsItemProvider.getId(), workOrder.getLinkType().getValue());
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (!this.map4LinkType.isEmpty()) {
            this.map4LinkType.clear();
        }
    }

    protected void refresh() {
        this.clear();
        this.initialize();
    }

    void refresh(List<DepthLevelItemProvider> list) {
        this.clear();
        this.initialize(this.createBreakdownElementToItemProviderMap(list));
    }

    @Override
    public String toString() {
        return this.toUnSuppressedString(null);
    }

    public String toUnSuppressedString(Suppression sup) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            BreakdownElement be;
            Activity superAct;
            Object e = TngUtil.unwrap(iter.next());
            if (e instanceof ItemProviderAdapter && (e = ((ItemProviderAdapter)e).getTarget()) == null) {
                iter.remove();
            }
            if (!(e instanceof BreakdownElement) || (superAct = (be = (BreakdownElement)e).getSuperActivities()) != null || TngUtil.getOwningProcess(be) == be) continue;
            iter.remove();
        }
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        int n = this.size() - 1;
        int i = 0;
        while (i < n) {
            IBSItemProvider bsItemProvider = (IBSItemProvider)this.get(i);
            if (sup == null || !sup.isSuppressed(bsItemProvider)) {
                strBuf.append(bsItemProvider.getId()).append(',');
            }
            ++i;
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)this.get(n);
        if (sup == null || !sup.isSuppressed(bsItemProvider)) {
            strBuf.append(bsItemProvider.getId());
        }
        return strBuf.toString();
    }

    public String toUnSuppressedString(Suppression sup, boolean isLinkTypeRequired) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            BreakdownElement be;
            Activity superAct;
            Object e = TngUtil.unwrap(iter.next());
            if (e instanceof ItemProviderAdapter && (e = ((ItemProviderAdapter)e).getTarget()) == null) {
                iter.remove();
            }
            if (!(e instanceof BreakdownElement) || (superAct = (be = (BreakdownElement)e).getSuperActivities()) != null || TngUtil.getOwningProcess(be) == be) continue;
            iter.remove();
        }
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        int n = this.size() - 1;
        int i = 0;
        while (i < n) {
            IBSItemProvider bsItemProvider = (IBSItemProvider)this.get(i);
            if (sup == null || !sup.isSuppressed(bsItemProvider)) {
                int v;
                String abbrev;
                strBuf.append(bsItemProvider.getId());
                Object value = this.map4LinkType.get(bsItemProvider.getId());
                if (value != null && isLinkTypeRequired && (abbrev = PredecessorList.toWorkOrderTypeAbbreviation(v = Integer.parseInt(value.toString()))) != null) {
                    strBuf.append(abbrev);
                }
                strBuf.append(',');
            }
            ++i;
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)this.get(n);
        if (sup == null || !sup.isSuppressed(bsItemProvider)) {
            int v;
            String abbrev;
            strBuf.append(bsItemProvider.getId());
            Object value = this.map4LinkType.get(bsItemProvider.getId());
            if (value != null && isLinkTypeRequired && (abbrev = PredecessorList.toWorkOrderTypeAbbreviation(v = Integer.parseInt(value.toString()))) != null) {
                strBuf.append(abbrev);
            }
        }
        return strBuf.toString();
    }

    public static boolean prepareUpdatePredecessors(AdapterFactory adapterFactory, WorkBreakdownElement wbe, List<Object> predecessors, List<WorkOrder> addList, List<WorkOrder> predToBeDeleted) {
        WorkOrder wo2 = null;
        int size = wbe.getLinkToPredecessor().size();
        IFilter filter = ProcessUtil.getFilter(adapterFactory);
        boolean nullFilter = filter == null;
        for (WorkOrder wo2 : wbe.getLinkToPredecessor()) {
            if (!nullFilter && !filter.accept(wo2.getPred())) continue;
            boolean found = false;
            for (Object pred : predecessors) {
                if (pred instanceof WorkBreakdownElement) {
                    if (wo2.getPred() != pred) continue;
                    found = true;
                    break;
                }
                if (!(pred instanceof BreakdownElementWrapperItemProvider) || !PredecessorList.isPredecessor((BreakdownElementWrapperItemProvider)pred, wo2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            predToBeDeleted.add(wo2);
        }
        size = predecessors.size();
        int i = 0;
        while (i < size) {
            Object obj = predecessors.get(i);
            WorkBreakdownElement element = (WorkBreakdownElement)TngUtil.unwrap(obj);
            boolean found = false;
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)(obj instanceof BreakdownElementWrapperItemProvider ? obj : null);
            String procPath = null;
            for (WorkOrder wo2 : wbe.getLinkToPredecessor()) {
                if (wo2.getPred() != element) continue;
                if (wrapper != null) {
                    if (!PredecessorList.isPredecessor(wrapper, wo2)) continue;
                    found = true;
                    break;
                }
                found = true;
                break;
            }
            if (!found) {
                wo2 = UmaFactory.eINSTANCE.createWorkOrder();
                wo2.setPred(element);
                if (wrapper != null) {
                    if (procPath == null) {
                        procPath = Suppression.getPath(wrapper);
                    }
                    MethodElementPropertyHelper.setProperty((MethodElement)wo2, "pred_process_path", procPath);
                }
                addList.add(wo2);
            }
            ++i;
        }
        return true;
    }

    public static boolean prepareUpdatePredecessors(AdapterFactory adapterFactory, WorkBreakdownElement wbe, String indexList, List<WorkOrder> addList, List<WorkOrder> predToBeDeleted) {
        ArrayList<Object> predecessors;
        Process process = TngUtil.getOwningProcess((BreakdownElement)wbe);
        if (ProcessUtil.checkPredecessorList(wbe, indexList, adapterFactory, (Object)process, predecessors = new ArrayList<Object>()) == null) {
            return PredecessorList.prepareUpdatePredecessors(adapterFactory, wbe, predecessors, addList, predToBeDeleted);
        }
        return false;
    }

    public static String toWorkOrderTypeAbbreviation(int workOrderType) {
        switch (workOrderType) {
            case 1: {
                return FINISH_TO_FINISH;
            }
            case 3: {
                return START_TO_FINISH;
            }
            case 2: {
                return START_TO_START;
            }
        }
        return null;
    }

    public static boolean isPredecessor(BreakdownElementWrapperItemProvider wrapper, WorkOrder workOrder) {
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)workOrder, "pred_process_path");
        if (prop == null) {
            return false;
        }
        String procPath = prop.getValue();
        String p = Suppression.getPath(wrapper);
        return procPath.equals(p);
    }

    /* synthetic */ PredecessorList(PredecessorList predecessorList) {
        this();
    }

    public static class DepthLevelItemProvider {
        private int depthLevel;
        private Object itemProvider;
        private Object object;
        private Object element;

        private DepthLevelItemProvider(Object object, int depthLevel, Object itemProvider, Object element) {
            this.object = object;
            this.depthLevel = depthLevel;
            this.itemProvider = itemProvider;
            this.element = element;
        }

        public Object getItemProvider() {
            return this.itemProvider;
        }
    }
}

