/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.net.URI;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.util.IResourceScanner;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFileCopyHandler {
    private IResourceScanner scanner;
    private static boolean localDebug = false;

    public ResourceFileCopyHandler(IResourceScanner scanner) {
        this.scanner = scanner;
    }

    public void execute(Map<MethodElement, MethodElement> originalToCopyMap) {
        int sz;
        int n = sz = originalToCopyMap == null ? 0 : originalToCopyMap.size();
        if (localDebug) {
            System.out.println("LD> copyToOriginalMap: " + sz);
        }
        if (sz == 0) {
            return;
        }
        for (Map.Entry<MethodElement, MethodElement> entry : originalToCopyMap.entrySet()) {
            this.scanElement(entry.getKey(), entry.getValue());
        }
        this.scanner.copyFiles();
    }

    public IResourceScanner getScanner() {
        return this.scanner;
    }

    private void scanElement(MethodElement source, MethodElement copy) {
        if (localDebug) {
            System.out.println("LD> source: " + source);
            System.out.println("LD> copy: " + copy);
            System.out.println("");
        }
        EList features = source.eClass().getEAllStructuralFeatures();
        int i = 0;
        while (i < features.size()) {
            EStructuralFeature feature = (EStructuralFeature)features.get(i);
            if (feature instanceof EAttribute) {
                this.scanAttribute(source, copy, (EAttribute)feature);
            }
            ++i;
        }
    }

    private void scanAttribute(MethodElement source, MethodElement copy, EAttribute feature) {
        Object sourceValue = source.eGet((EStructuralFeature)feature);
        if (sourceValue == null) {
            return;
        }
        Object copiedValue = sourceValue;
        if (sourceValue instanceof URI) {
            URI uri = (URI)sourceValue;
            String urlStr = this.scanner.registerFileCopy(uri.toString());
            try {
                copiedValue = new URI(urlStr);
            }
            catch (Exception exception) {
                copiedValue = sourceValue;
            }
        } else if (sourceValue instanceof String) {
            copiedValue = this.scanner.scan(source, copy, (String)sourceValue, (EStructuralFeature)feature);
        } else {
            return;
        }
        if (!sourceValue.equals(copiedValue)) {
            copy.eSet((EStructuralFeature)feature, copiedValue);
        }
    }
}

