/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.PluginDependencyInfoMgr;
import org.eclipse.epf.uma.MethodPlugin;

public class PluginDepInfo {
    private PluginDependencyInfoMgr mgr;
    private MethodPlugin plugin;
    private HashMap parentMap;
    private boolean complete = false;
    private boolean debug = false;

    protected PluginDepInfo(PluginDependencyInfoMgr mgr, MethodPlugin plugin) {
        this.mgr = mgr;
        this.plugin = plugin;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void build(boolean checkCircular) {
        if (this.debug) {
            System.out.println("LD> build: " + this);
        }
        this.buildInner(checkCircular);
    }

    private void buildInner(boolean checkCircular) {
        PluginDepInfo info = this.mgr.getProcessedInfo(this.getPlugin());
        if (info != null) {
            if (info == this && this.complete) {
                return;
            }
            throw new RuntimeException("Internal error in buildInner: " + info);
        }
        this.mgr.addToProcessed(this);
        if (this.debug) {
            System.out.println("LD> buildInner: " + this);
            System.out.println("");
        }
        this.buildInner_(checkCircular);
    }

    private void buildInner_(boolean checkCircular) {
        int sz;
        List parents = this.getPlugin().getBases();
        int n = sz = parents == null ? 0 : parents.size();
        if (sz == 0) {
            this.complete = true;
            return;
        }
        this.parentMap = new HashMap();
        ArrayList<PluginDepInfo> processedParents = null;
        int i = 0;
        while (i < sz) {
            MethodPlugin parentElem = (MethodPlugin)parents.get(i);
            PluginDepInfo pinfo = this.mgr.getProcessedInfo(parentElem);
            if (pinfo == null) {
                pinfo = new PluginDepInfo(this.mgr, parentElem);
                this.parentMap.put(parentElem.getGuid(), pinfo);
                pinfo.buildInner(checkCircular);
            } else {
                this.parentMap.put(parentElem.getGuid(), pinfo);
                if (checkCircular) {
                    if (processedParents == null) {
                        processedParents = new ArrayList<PluginDepInfo>();
                    }
                    processedParents.add(pinfo);
                }
            }
            ++i;
        }
        this.complete = true;
        if (checkCircular && processedParents != null) {
            i = 0;
            while (i < processedParents.size()) {
                this.reachableBy((PluginDepInfo)processedParents.get(i));
                ++i;
            }
        }
    }

    public boolean reachableBy(PluginDepInfo info) {
        if (!(info instanceof PluginDepInfo)) {
            throw new UnsupportedOperationException();
        }
        if (this.debug) {
            System.out.println("LD> Entry reachableBy: this -> " + this);
            System.out.println("LD> Entry reachableBy: info -> " + info);
            System.out.println("");
        }
        return this.reachableBy(info, new Stack(), new HashMap());
    }

    private boolean reachableBy(PluginDepInfo info, Stack stack, Map seen) {
        stack.push(info);
        if (this.debug) {
            System.out.println("LD> reachableBy: this -> " + this);
            System.out.println("LD> reachableBy: info -> " + info);
            System.out.println("");
        }
        boolean ret = this.reachableBy_(info, stack, seen);
        stack.pop();
        return ret;
    }

    private boolean reachableBy_(PluginDepInfo info, Stack stack, Map seen) {
        HashMap testMap = info.parentMap;
        if (testMap == null || testMap.isEmpty()) {
            return false;
        }
        if (testMap.containsKey(this.getPlugin().getGuid())) {
            if (this.debug) {
                System.out.println("LD> Contained in parentMap of: " + info);
            }
            stack.push(this);
            this.mgr.logCircularDependency((Stack)stack.clone());
            stack.pop();
            return true;
        }
        if (seen.containsKey(info.getPlugin().getGuid())) {
            return false;
        }
        seen.put(info.getPlugin().getGuid(), info);
        for (PluginDepInfo parentInfo : testMap.values()) {
            if (parentInfo.containedIn(stack)) {
                if (this.debug) {
                    System.out.println("LD> containedIn stack: " + info);
                }
                stack.push(parentInfo);
                this.mgr.logCircularDependency((Stack)stack.clone());
                stack.pop();
                return true;
            }
            if (!this.reachableBy(parentInfo, stack, seen)) continue;
            return true;
        }
        return false;
    }

    public MethodPlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return TngUtil.getLabelWithPath(this.plugin);
    }

    private boolean containedIn(List infoList) {
        int sz;
        int n = sz = infoList == null ? 0 : infoList.size();
        if (sz == 0) {
            return false;
        }
        String guid = this.getPlugin().getGuid();
        if (sz == 1) {
            return guid.equals(((PluginDepInfo)infoList.get(0)).getPlugin().getGuid());
        }
        HashMap<String, PluginDepInfo> listMap = new HashMap<String, PluginDepInfo>();
        int i = 0;
        while (i < sz) {
            PluginDepInfo info = (PluginDepInfo)infoList.get(i);
            listMap.put(info.getPlugin().getGuid(), info);
            ++i;
        }
        return listMap.containsKey(guid);
    }
}

