/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyInfoMgr;
import org.eclipse.epf.library.edit.validation.IDependencyInfo;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;

public class UpwardReachableInfo
implements IDependencyInfo {
    private DependencyInfoMgr mgr;
    private MethodElement element;
    private HashMap parentMap;
    private boolean complete = false;
    private boolean debug = false;

    protected UpwardReachableInfo(DependencyInfoMgr mgr, MethodElement element) {
        this.mgr = mgr;
        this.element = element;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void build(boolean checkCircular) {
        if (this.debug) {
            System.out.println("LD> build: " + this);
        }
        this.buildInner(checkCircular);
    }

    private void buildInner(boolean checkCircular) {
        IDependencyInfo info = this.mgr.getProcessedInfo(this.element);
        if (info != null) {
            if (info == this && this.complete) {
                return;
            }
            throw new RuntimeException("Internal error in buildInner: " + info);
        }
        this.mgr.addToProcessed(this);
        if (this.debug) {
            System.out.println("LD> buildInner: " + this);
            System.out.println("");
        }
        this.buildInner_(checkCircular);
    }

    private void buildInner_(boolean checkCircular) {
        int sz;
        List parents = this.getMixedParentList();
        int n = sz = parents == null ? 0 : parents.size();
        if (sz == 0) {
            this.complete = true;
            return;
        }
        this.parentMap = new HashMap();
        ArrayList<UpwardReachableInfo> processedParents = null;
        int i = 0;
        while (i < sz) {
            MethodElement parentElem = (MethodElement)parents.get(i);
            UpwardReachableInfo pinfo = (UpwardReachableInfo)this.mgr.getProcessedInfo(parentElem);
            if (pinfo == null) {
                pinfo = new UpwardReachableInfo(this.mgr, parentElem);
                this.parentMap.put(parentElem.getGuid(), pinfo);
                pinfo.buildInner(checkCircular);
            } else {
                this.parentMap.put(parentElem.getGuid(), pinfo);
                if (checkCircular) {
                    if (processedParents == null) {
                        processedParents = new ArrayList<UpwardReachableInfo>();
                    }
                    processedParents.add(pinfo);
                }
            }
            ++i;
        }
        this.complete = true;
        if (checkCircular && processedParents != null) {
            i = 0;
            while (i < processedParents.size()) {
                this.reachableBy((IDependencyInfo)processedParents.get(i));
                ++i;
            }
        }
    }

    public boolean reachableBy(IDependencyInfo info) {
        if (!(info instanceof UpwardReachableInfo)) {
            throw new UnsupportedOperationException();
        }
        if (this.debug) {
            System.out.println("LD> Entry reachableBy: this -> " + this);
            System.out.println("LD> Entry reachableBy: info -> " + info);
            System.out.println("");
        }
        return this.reachableBy((UpwardReachableInfo)info, new Stack(), new HashMap());
    }

    private boolean reachableBy(UpwardReachableInfo info, Stack stack, Map seen) {
        stack.push(info);
        if (this.debug) {
            System.out.println("LD> reachableBy: this -> " + this);
            System.out.println("LD> reachableBy: info -> " + info);
            System.out.println("");
        }
        boolean ret = this.reachableBy_(info, stack, seen);
        stack.pop();
        return ret;
    }

    private boolean reachableBy_(UpwardReachableInfo info, Stack stack, Map seen) {
        HashMap testMap = info.parentMap;
        if (testMap == null || testMap.isEmpty()) {
            return false;
        }
        if (testMap.containsKey(this.element.getGuid())) {
            if (this.debug) {
                System.out.println("LD> Contained in parentMap of: " + info);
            }
            stack.push(this);
            this.mgr.logCircularDependency((Stack)stack.clone());
            stack.pop();
            return true;
        }
        if (seen.containsKey(info.getElement().getGuid())) {
            return false;
        }
        seen.put(info.getElement().getGuid(), info);
        for (UpwardReachableInfo parentInfo : testMap.values()) {
            if (parentInfo.containedIn(stack)) {
                if (this.debug) {
                    System.out.println("LD> containedIn stack: " + info);
                }
                stack.push(parentInfo);
                this.mgr.logCircularDependency((Stack)stack.clone());
                stack.pop();
                return true;
            }
            if (!this.reachableBy(parentInfo, stack, seen)) continue;
            return true;
        }
        return false;
    }

    public MethodElement getElement() {
        return this.element;
    }

    private List getMixedParentList() {
        ArrayList list = new ArrayList();
        this.collectParentList(this.element, list);
        VariabilityElement ve = (VariabilityElement)this.element;
        this.collectParentListByVariantPaths(ve, list);
        if (ve.getVariabilityType() == VariabilityType.REPLACES) {
            this.mgr.addToReplacerMap(this);
        }
        return list;
    }

    private void collectParentList(MethodElement elem, List list) {
        int sz;
        List parentList = UpwardReachableInfo.getParentList(elem);
        int n = sz = parentList == null ? 0 : parentList.size();
        if (this.mgr.isMoveElement(elem)) {
            if (sz > 1 && !(elem instanceof CustomCategory)) {
                throw new UnsupportedOperationException();
            }
        } else if (sz > 0) {
            list.addAll(parentList);
        }
    }

    public static List getParentList(MethodElement elem) {
        List<Object> parentList = null;
        if (elem instanceof CustomCategory) {
            parentList = AssociationHelper.getCustomCategories((DescribableElement)((CustomCategory)elem));
            parentList = UpwardReachableInfo.combine(parentList, AssociationHelper.getPractices((ContentElement)((CustomCategory)elem)));
        } else if (elem instanceof Deliverable) {
            parentList = AssociationHelper.getDeliverables((WorkProduct)((Deliverable)elem));
        } else {
            MethodElement parent = UpwardReachableInfo.getSameTypeParent(elem);
            if (parent != null) {
                parentList = new ArrayList<MethodElement>();
                parentList.add(parent);
            }
            if (elem instanceof Practice) {
                parentList = UpwardReachableInfo.combine(parentList, AssociationHelper.getCustomCategories((DescribableElement)((Practice)elem)));
                parentList = UpwardReachableInfo.combine(parentList, AssociationHelper.getPractices((ContentElement)((Practice)elem)));
            }
        }
        return parentList;
    }

    private static List combine(List list1, List list2) {
        ArrayList ret = new ArrayList();
        if (list1 != null) {
            ret.addAll(list1);
        }
        if (list2 != null) {
            ret.addAll(list2);
        }
        return ret;
    }

    private void collectParentListByVariantPaths(VariabilityElement ve, List list) {
        if (!this.mgr.isFilterElement((MethodElement)ve)) {
            VariabilityType type;
            VariabilityElement parentVe = ve.getVariabilityBasedOnElement();
            VariabilityType variabilityType = type = parentVe == null ? null : ve.getVariabilityType();
            if (type == VariabilityType.CONTRIBUTES || type == VariabilityType.REPLACES) {
                list.add(parentVe);
            }
        }
        if (this.mgr.isDndElement((MethodElement)ve)) {
            return;
        }
        Iterator it = TngUtil.getImmediateVarieties(ve, VariabilityType.EXTENDS);
        while (it.hasNext()) {
            VariabilityElement extender = (VariabilityElement)it.next();
            if (this.mgr.isFilterElement((MethodElement)extender)) continue;
            list.add(extender);
        }
    }

    private static MethodElement getSameTypeParent(MethodElement elem) {
        if (elem instanceof Activity) {
            return ((Activity)elem).getSuperActivities();
        }
        MethodElement parent = (MethodElement)elem.eContainer();
        return parent.getType() == elem.getType() ? parent : null;
    }

    public String toString() {
        return TngUtil.getLabelWithPath(this.element);
    }

    public boolean inheritAncestor(VariabilityType type) {
        VariabilityElement parentVe = ((VariabilityElement)this.element).getVariabilityBasedOnElement();
        if (parentVe == null) {
            return false;
        }
        if (((VariabilityElement)this.element).getVariabilityType() != type) {
            return false;
        }
        ArrayList mixParentList = new ArrayList();
        this.collectParentList(this.element, mixParentList);
        if (mixParentList != null && mixParentList.contains(parentVe)) {
            return true;
        }
        UpwardReachableInfo parentVeInfo = (UpwardReachableInfo)this.parentMap.get(parentVe.getGuid());
        for (UpwardReachableInfo parentInfo : this.parentMap.values()) {
            if (parentVeInfo == parentInfo || !parentVeInfo.reachableBy(parentInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean containedIn(List infoList) {
        int sz;
        int n = sz = infoList == null ? 0 : infoList.size();
        if (sz == 0) {
            return false;
        }
        String guid = this.getElement().getGuid();
        if (sz == 1) {
            return guid.equals(((IDependencyInfo)infoList.get(0)).getElement().getGuid());
        }
        HashMap<String, IDependencyInfo> listMap = new HashMap<String, IDependencyInfo>();
        int i = 0;
        while (i < sz) {
            IDependencyInfo info = (IDependencyInfo)infoList.get(i);
            listMap.put(info.getElement().getGuid(), info);
            ++i;
        }
        return listMap.containsKey(guid);
    }
}

