/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class WPFigure
extends Figure {
    public Label label = new Label();

    public WPFigure(Label l) {
        this.add((IFigure)l);
    }

    protected void paintFigure(Graphics g) {
        Rectangle clientArea = this.getClientArea();
        Rectangle bar = clientArea.getCopy();
        bar.crop(new Insets(0, 5, 5, 5));
        g.setBackgroundColor(ColorConstants.gray);
        g.fillRectangle(bar.getTranslated(6, 6));
        g.setBackgroundColor(ColorConstants.yellow);
        g.fillRectangle(bar);
        g.setLineStyle(2);
        g.setLineWidth(1);
        super.paintFigure(g);
    }

    public Label getFigure() {
        return this.label;
    }

    public void setLabelName(String name) {
        this.label.setText(name);
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    class Box
    extends Figure {
        public Box(Insets insets) {
            this.setBorder((Border)new BoxBorder(insets));
            ToolbarLayout toolbarLayout = new ToolbarLayout();
            toolbarLayout.setStretchMinorAxis(false);
            this.setLayoutManager((LayoutManager)toolbarLayout);
            this.setBackgroundColor(ColorConstants.red);
        }

        private class BoxBorder
        extends AbstractBorder {
            public Insets insets = new Insets(1, 0, 0, 0);

            public BoxBorder(Insets insets) {
                this.insets = insets;
            }

            public Insets getInsets(IFigure figure) {
                return this.insets;
            }

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                Rectangle rect = BoxBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
                graphics.drawLine(rect.getTopLeft(), rect.getTopRight());
            }
        }
    }
}

