/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.library.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class LibraryViewDeleteAction
extends MethodElementDeleteAction {
    public LibraryViewDeleteAction() {
        this(true);
    }

    public LibraryViewDeleteAction(boolean confirm) {
        this.confirm = confirm;
    }

    protected void didDelete(Collection deletedElements) {
        super.didDelete(deletedElements);
        Iterator iter = deletedElements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || ((MethodElement)element).eContainer() != null) continue;
            IEditorKeeper.REFERENCE.getEditorKeeper().closeEditorsOnDeletion((MethodElement)element);
        }
    }

    protected static CustomCategory getRootCustomCategory(Object object) {
        while (object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getOwner();
        }
        return (object = TngUtil.unwrap((Object)object)) instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)object)) ? (CustomCategory)object : null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ArrayList<Object> filteredSelection = new ArrayList<Object>();
        for (Object e : selection) {
            if (e instanceof CustomCategory) {
                filteredSelection.add(e);
                continue;
            }
            Object element = TngUtil.unwrap(e);
            if (element instanceof ItemProviderAdapter || element instanceof MethodElement && TngUtil.isPredefined((MethodElement)((MethodElement)element))) continue;
            if (element instanceof CustomCategory) {
                CustomCategory rootCustomCategory = LibraryViewDeleteAction.getRootCustomCategory(e);
                CustomCategory cc = (CustomCategory)element;
                if (rootCustomCategory == null || UmaUtil.getMethodPlugin((EObject)rootCustomCategory) != UmaUtil.getMethodPlugin((EObject)cc)) continue;
                filteredSelection.add(element);
                continue;
            }
            if (e instanceof IWrapperItemProvider) {
                IWrapperItemProvider wrapper = (IWrapperItemProvider)e;
                if (TngUtil.isUnderCustomCategoryTree((IWrapperItemProvider)wrapper)) continue;
                if (wrapper.getFeature() == UmaPackage.Literals.DISCIPLINE_GROUPING__DISCIPLINES || wrapper.getFeature() == UmaPackage.Literals.ROLE_SET_GROUPING__ROLE_SETS) {
                    Object owner = wrapper.getOwner();
                    if (!(owner instanceof EObject) || !(element instanceof EObject) || UmaUtil.getMethodPlugin((EObject)((EObject)owner)) != UmaUtil.getMethodPlugin((EObject)((EObject)element))) continue;
                    filteredSelection.add(element);
                    continue;
                }
            }
            filteredSelection.add(e);
        }
        if (filteredSelection.isEmpty()) {
            return false;
        }
        return super.updateSelection((IStructuredSelection)new StructuredSelection(filteredSelection));
    }

    protected void performDelete() {
        IStatus status;
        HashSet<Object> configsToDelete = new HashSet<Object>();
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        ILibraryPersister persister = LibraryServiceUtil.getCurrentPersister();
        if (this.selection != null && this.selection.size() > 0) {
            Iterator iter = this.selection.iterator();
            while (iter.hasNext()) {
                EObject eObject;
                Object object = TngUtil.unwrap(iter.next());
                if (object instanceof MethodConfiguration) {
                    configsToDelete.add(object);
                }
                if (!(object instanceof EObject) || persister.hasOwnResourceWithoutReferrer(object) || (eObject = ((EObject)object).eContainer()) == null || eObject.eResource() == null) continue;
                modifiedResources.add(eObject.eResource());
            }
        }
        if (!configsToDelete.isEmpty()) {
            HashSet<String> configGUIDsToDelete = new HashSet<String>();
            for (MethodConfiguration methodConfiguration : configsToDelete) {
                configGUIDsToDelete.add(methodConfiguration.getGuid());
            }
            ILibraryResourceSet resourceSet = (ILibraryResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet();
            resourceSet.loadOppositeFeatures(Collections.singletonList(AssociationHelper.MethodConfiguration_DependentProcesses), configGUIDsToDelete);
            for (MethodConfiguration methodConfiguration : configsToDelete) {
                List references = AssociationHelper.getDependentProcesses((MethodConfiguration)methodConfiguration);
                if (references == null || references.size() <= 0) continue;
                String processName = ((Process)references.get(0)).getName();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.deleteDialog_title, AuthoringUIResources.deleteConfigError_msg, AuthoringUIResources.bind((String)AuthoringUIResources.deleteConfigError_reason, (Object)processName));
                return;
            }
        }
        if (!(status = UserInteractionHelper.checkModify(modifiedResources, (Object)LibraryEditPlugin.getDefault().getContext())).isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.deleteDialog_title, status);
            return;
        }
        if (this.confirmDelete()) {
            Collection collection;
            ArrayList refreshList = new ArrayList();
            Iterator iterator = this.selection.iterator();
            while (iterator.hasNext()) {
                Object object = TngUtil.unwrap(iterator.next());
                if (!(object instanceof MethodElement) || !(object instanceof VariabilityElement)) continue;
                Iterator iterator2 = TngUtil.getGeneralizers((VariabilityElement)((VariabilityElement)object));
                while (iterator2.hasNext()) {
                    Object aReference = iterator2.next();
                    refreshList.add(aReference);
                }
            }
            DeleteMethodElementCommand deleteMethodElementCommand = (DeleteMethodElementCommand)(this.command instanceof DeleteMethodElementCommand ? this.command : null);
            this.command.execute();
            if (deleteMethodElementCommand != null && (collection = deleteMethodElementCommand.getDescriptorsToDelete()) != null && !collection.isEmpty()) {
                ProcessDeleteAction.delete((Collection)collection);
            }
            if (refreshList.size() > 0) {
                TreeViewer treeViewer = (TreeViewer)LibraryView.getView().getViewer();
                Iterator iter2 = refreshList.iterator();
                while (iter2.hasNext()) {
                    treeViewer.refresh(iter2.next());
                }
            }
        }
    }

    public void notifyPropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void filterCustomCategorySelection(Object e, List filteredSelection) {
        if (e instanceof FeatureValueWrapperItemProvider) {
            filteredSelection.add(e);
        } else {
            Object owner = ((DelegatingWrapperItemProvider)e).getOwner();
            while (owner instanceof DelegatingWrapperItemProvider) {
                if (owner instanceof FeatureValueWrapperItemProvider) {
                    if (filteredSelection.contains(owner)) break;
                    filteredSelection.add(e);
                    break;
                }
                if (filteredSelection.contains(owner)) break;
                if ((owner = ((DelegatingWrapperItemProvider)owner).getOwner()) instanceof FeatureValueWrapperItemProvider || filteredSelection.contains(owner)) continue;
                filteredSelection.add(e);
                break;
            }
        }
    }
}

