/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.filters;

import org.eclipse.epf.authoring.ui.filters.ActivityVariabilityFilter;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.library.edit.configuration.CategorizedProcessesItemProvider;
import org.eclipse.epf.library.edit.configuration.ProcessesItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ProcessActivityFilter
extends DescriptorConfigurationFilter {
    private Activity activity = null;
    private int command = 0;
    private ActivityVariabilityFilter delegateFilter;

    public ProcessActivityFilter(MethodConfiguration config, TableViewer viewer, String tabName, Activity activity, int command) {
        super(config, (Viewer)viewer, tabName);
        this.activity = activity;
        this.command = command;
        this.delegateFilter = new ActivityVariabilityFilter(config, viewer, tabName, activity);
    }

    public void setHelper(FilterHelper helper) {
        super.setHelper(helper);
        this.delegateFilter.setHelper(helper);
    }

    public boolean accept(Object obj) {
        if (this.command == 3 && (obj instanceof Activity || obj instanceof ProcessComponent)) {
            return true;
        }
        return super.accept(obj);
    }

    public boolean childAccept(Object obj) {
        if (obj instanceof ProcessesItemProvider) {
            return true;
        }
        if (obj instanceof CategorizedProcessesItemProvider) {
            return true;
        }
        if (obj instanceof Activity || obj instanceof ProcessPackage) {
            switch (this.command) {
                case 2: {
                    return this.delegateFilter.accept(obj);
                }
                case 1: {
                    Process srcProc = null;
                    if (obj instanceof ProcessComponent) {
                        srcProc = ((ProcessComponent)obj).getProcess();
                    } else if (obj instanceof BreakdownElement) {
                        BreakdownElement be = (BreakdownElement)obj;
                        srcProc = TngUtil.getOwningProcess((BreakdownElement)be);
                    }
                    if (srcProc == null) break;
                    Process targetProc = TngUtil.getOwningProcess((BreakdownElement)this.activity);
                    return !(srcProc instanceof DeliveryProcess) || !(targetProc instanceof CapabilityPattern);
                }
            }
            return true;
        }
        return false;
    }
}

