/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PracticeReferencesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "practiceReferencesPage";
    private Practice practice;
    private IActionManager actionMgr;
    private ContentElementOrderList contentElementOrderList;
    private ContentElementOrderList activityOrderList;
    private Button manualSortCheckButton;
    private Button typeSortButton;

    public PracticeReferencesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.REFERENCES_PAGE_TITLE);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.practice = (Practice)this.contentElement;
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.setIsUpAndDownButtonsRequired1(true);
        this.setUseCategory2(false);
        this.setUseCategory3(false);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.manualSortCheckButton = this.toolkit.createButton(this.category1pane2, AuthoringUIResources.practiceReferencesPage_sortOrderButton_text, 32);
        this.manualSortCheckButton.moveAbove((Control)this.ctrl_up1);
        this.manualSortCheckButton.setLayoutData((Object)new GridData(768));
        boolean isManual = CategorySortHelper.isManualCategorySort((MethodElement)this.contentElement);
        this.manualSortCheckButton.setSelection(isManual);
        this.manualSortCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isManual = PracticeReferencesPage.this.manualSortCheckButton.getSelection();
                String value = "Manual";
                if (!isManual) {
                    value = "MethodType";
                }
                PracticeReferencesPage.this.actionMgr.execute((IResourceAwareCommand)new MethodElementSetPropertyCommand((MethodElement)PracticeReferencesPage.this.practice, "CategoryElementsSortType", value));
                PracticeReferencesPage.this.enableUpDownButtons1();
            }
        });
        this.typeSortButton = this.toolkit.createButton(this.category1pane2, AuthoringUIResources.practiceReferencesPage_sortTypeButton_text, 8);
        this.typeSortButton.setLayoutData((Object)new GridData(768));
        this.typeSortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(PracticeReferencesPage.this.practice.getContentReferences());
                Comparator comparator = PresentationContext.INSTANCE.getMethodElementTypeComparator();
                Collections.sort(list, comparator);
                PracticeReferencesPage.this.actionMgr.doAction(6, (EObject)PracticeReferencesPage.this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), (Object)PracticeReferencesPage.this.practice.getContentReferences(), -1);
                PracticeReferencesPage.this.actionMgr.doAction(5, (EObject)PracticeReferencesPage.this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), list, -1);
                PracticeReferencesPage.this.refreshViewers();
            }
        });
    }

    @Override
    protected void enableUpDownButtons1() {
        super.enableUpDownButtons1();
        if (this.typeSortButton != null) {
            if (this.isShouldEnableAlphaSort()) {
                this.typeSortButton.setEnabled(true);
            } else {
                this.typeSortButton.setEnabled(false);
            }
        }
    }

    protected boolean isShouldEnableAlphaSort() {
        return this.contentElement != null && !TngUtil.isLocked((EObject)this.contentElement) && CategorySortHelper.isManualCategorySort((MethodElement)this.contentElement);
    }

    @Override
    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (PracticeReferencesPage.this.contentElementOrderList == null) {
                    PracticeReferencesPage.this.contentElementOrderList = new ContentElementOrderList((VariabilityElement)PracticeReferencesPage.this.contentElement, 1, PracticeReferencesPage.this.getContentElementOrderFeature());
                }
                if (PracticeReferencesPage.this.activityOrderList == null) {
                    PracticeReferencesPage.this.activityOrderList = new ContentElementOrderList((VariabilityElement)PracticeReferencesPage.this.contentElement, 1, PracticeReferencesPage.this.getActivityOrderFeature());
                }
                ArrayList list = new ArrayList();
                list.addAll(PracticeReferencesPage.this.contentElementOrderList);
                list.addAll(PracticeReferencesPage.this.activityOrderList);
                return list.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    @Override
    protected void addItemsToModel1(ArrayList addItems) {
        boolean ok = DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.practice, (Collection)addItems);
        if (!ok) {
            String title = AuthoringUIResources.circular_dependency_error_title;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, LibraryEditResources.circular_dependency_error_msg);
            return;
        }
        if (!addItems.isEmpty()) {
            for (Object item : addItems) {
                if (item instanceof ContentElement) {
                    this.actionMgr.doAction(3, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), item, -1);
                    continue;
                }
                if (!(item instanceof Activity)) continue;
                this.actionMgr.doAction(3, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ActivityReferences(), item, -1);
            }
        }
    }

    @Override
    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (Object item : rmItems) {
                if (item instanceof ContentElement) {
                    this.actionMgr.doAction(4, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), item, -1);
                    continue;
                }
                if (!(item instanceof Activity)) continue;
                this.actionMgr.doAction(4, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ActivityReferences(), item, -1);
            }
        }
    }

    @Override
    protected EStructuralFeature getOrderFeature() {
        List<ContentElement> ceList = this.getSelectedContentElements();
        List<Activity> aList = this.getSelectedActivities();
        if (ceList.size() > 0 && aList.size() == 0) {
            return this.getContentElementOrderFeature();
        }
        if (aList.size() > 0 && ceList.size() == 0) {
            return this.getActivityOrderFeature();
        }
        return null;
    }

    private EStructuralFeature getContentElementOrderFeature() {
        return UmaPackage.eINSTANCE.getPractice_ContentReferences();
    }

    private EStructuralFeature getActivityOrderFeature() {
        return UmaPackage.eINSTANCE.getPractice_ActivityReferences();
    }

    @Override
    protected ContentElementOrderList getContentElementOrderList() {
        List<ContentElement> ceList = this.getSelectedContentElements();
        List<Activity> aList = this.getSelectedActivities();
        if (ceList.size() > 0 && aList.size() == 0) {
            return this.contentElementOrderList;
        }
        if (aList.size() > 0 && ceList.size() == 0) {
            return this.activityOrderList;
        }
        return null;
    }

    private List<ContentElement> getSelectedContentElements() {
        ArrayList<ContentElement> result = new ArrayList<ContentElement>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer_selected.getSelection();
        for (Object o : selection) {
            if (!(o instanceof ContentElement)) continue;
            result.add((ContentElement)o);
        }
        return result;
    }

    private List<Activity> getSelectedActivities() {
        ArrayList<Activity> result = new ArrayList<Activity>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer_selected.getSelection();
        for (Object o : selection) {
            if (!(o instanceof Activity)) continue;
            result.add((Activity)o);
        }
        return result;
    }

    @Override
    protected Object getContentElement() {
        return this.practice;
    }

    @Override
    protected String getTabString() {
        return FilterConstants.ALL_ELEMENTS;
    }

    @Override
    protected IFilter getFilter() {
        this.filter = new AllFilter(){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Milestone) {
                    return false;
                }
                return obj instanceof ContentElement || obj instanceof BreakdownElement || obj instanceof ProcessPackage;
            }
        };
        return this.filter;
    }

    @Override
    protected String getMultipleSelectDescription(int count) {
        return super.getMultipleSelectDescription(count, AuthoringUIResources.practiceReferencesPage_multipleSelectDescription);
    }

    @Override
    protected String getSectionDescription() {
        return AuthoringUIResources.practiceReferencesPage_sectionDescription;
    }

    @Override
    protected String getSectionName() {
        return AuthoringUIResources.practiceReferencesPage_sectionName;
    }

    @Override
    protected String getSelectedLabel() {
        return AuthoringUIResources.practiceReferencesPage_selectedLabel;
    }

    @Override
    protected String getSelectedLabel2() {
        return AuthoringUIResources.practiceReferencesPage_selectedLabel;
    }

    @Override
    protected String getSelectedLabel3() {
        return AuthoringUIResources.practiceReferencesPage_selectedLabel;
    }
}

