/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.internal.IProblemChangedListener;
import org.eclipse.epf.authoring.ui.providers.MethodElementUILabelProvider;
import org.eclipse.epf.authoring.ui.providers.ProblemsLabelDecorator;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class MethodElementEditorErrorTickUpdater
implements IProblemChangedListener {
    private MethodElementEditor fMethodElementEditor;
    private MethodElementUILabelProvider fLabelProvider;

    public MethodElementEditorErrorTickUpdater(MethodElementEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.fMethodElementEditor = editor;
        this.fLabelProvider = new MethodElementUILabelProvider();
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        AuthoringUIPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.fMethodElementEditor.getEditorInput();
        if (input instanceof MethodElementEditorInput) {
            MethodElement melement = ((MethodElementEditorInput)input).getMethodElement();
            if (melement instanceof ProcessComponent) {
                melement = ((ProcessComponent)melement).getProcess();
            }
            if (melement != null) {
                IResource resource = PersistenceUtil.getWorkspaceResource((Object)melement);
                int i = 0;
                while (i < changedResources.length) {
                    if (changedResources[i].equals((Object)resource)) {
                        this.updateEditorImage(melement);
                    }
                    ++i;
                }
            }
        }
    }

    public void updateEditorImage(MethodElement melement) {
        Image titleImage = this.fMethodElementEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = this.fLabelProvider.getImage(melement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fMethodElementEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MethodElementEditorErrorTickUpdater.this.fMethodElementEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        AuthoringUIPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

