/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessRoleFilter;
import org.eclipse.epf.authoring.ui.properties.DescriptorGeneralSection;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.command.LinkMethodElementCommand;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RoleDescriptorGeneralSection
extends DescriptorGeneralSection {
    protected RoleDescriptor element;
    private Label ctrl_method_element_label;
    private Text ctrl_method_element;
    private Button linkButton;
    private Button clearButton;

    protected void init() {
        super.init();
        this.element = (RoleDescriptor)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        this.ctrl_method_element_label = FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Process_Type_Role);
        this.ctrl_method_element = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
        this.ctrl_method_element.setText(this.getMethodElementName(this.element));
        this.ctrl_method_element.setEnabled(false);
        Composite buttonComposite = FormUI.createComposite(this.toolkit, this.generalComposite, 0, 2, true);
        this.linkButton = FormUI.createButton(this.toolkit, buttonComposite, 8, 1);
        this.linkButton.setText(PropertiesResources.Process_Button_LinkMethodElement);
        this.clearButton = FormUI.createButton(this.toolkit, buttonComposite, 8, 1);
        this.clearButton.setText(PropertiesResources.Process_Button_ClearMethodElement);
        this.toggleMethodRole();
    }

    private void toggleMethodRole() {
        if (this.element instanceof CompositeRole) {
            this.ctrl_method_element_label.setVisible(false);
            this.ctrl_method_element.setVisible(false);
            this.linkButton.setVisible(false);
            this.clearButton.setVisible(false);
        } else {
            this.ctrl_method_element_label.setVisible(true);
            this.ctrl_method_element.setVisible(true);
            this.linkButton.setVisible(true);
            this.clearButton.setVisible(true);
        }
    }

    protected void addListeners() {
        super.addListeners();
        this.linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessRoleFilter filter = new ProcessRoleFilter(RoleDescriptorGeneralSection.this.getConfiguration(), null, FilterConstants.ROLES);
                ArrayList<Role> existingElements = new ArrayList<Role>();
                if (RoleDescriptorGeneralSection.this.element.getRole() != null) {
                    existingElements.add(RoleDescriptorGeneralSection.this.element.getRole());
                }
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, RoleDescriptorGeneralSection.this.element, FilterConstants.ROLES, existingElements);
                fd.setBlockOnOpen(true);
                fd.setViewerSelectionSingle(true);
                fd.setTitle(FilterConstants.ROLES);
                fd.open();
                RoleDescriptorGeneralSection.this.setMethodElement(fd.getSelectedItems());
                RoleDescriptorGeneralSection.this.ctrl_method_element.setText(RoleDescriptorGeneralSection.this.getMethodElementName(RoleDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent e1) {
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RoleDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)RoleDescriptorGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Role(), null, -1);
                RoleDescriptorGeneralSection.this.ctrl_method_element.setText(RoleDescriptorGeneralSection.this.getMethodElementName(RoleDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent e1) {
            }
        });
    }

    private void setMethodElement(List items) {
        if (items != null && items.size() >= 1 && items.get(0) instanceof Role) {
            Role role = (Role)items.get(0);
            boolean canAssign = true;
            if (canAssign) {
                LinkMethodElementCommand cmd = new LinkMethodElementCommand((Descriptor)this.element, (Object)role, 32);
                this.actionMgr.execute((IResourceAwareCommand)cmd);
                this.getEditor().setSelection(this.getSelection());
            } else {
                MessageFormat mf = new MessageFormat(PropertiesResources.Process_InvalidLinkMethodElement);
                Object[] args = new Object[]{role.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_LinkMethodElementTitle, mf.format(args));
            }
        }
    }

    private String getMethodElementName(RoleDescriptor element) {
        String str = PropertiesResources.Process_None;
        if (element.getRole() != null) {
            str = element.getRole().getName();
        }
        return str;
    }

    protected void updateControls() {
        super.updateControls();
        this.linkButton.setEnabled(this.editable);
        this.clearButton.setEnabled(this.editable);
        BreakdownElement obj = this.getElement();
        if (obj instanceof RoleDescriptor) {
            RoleDescriptor roleDesc = (RoleDescriptor)obj;
            if (roleDesc.getSuperActivities() == null || roleDesc.getSuperActivities() == null) {
                this.nameText.setEditable(true);
                this.presentationNameText.setEditable(true);
            } else {
                this.nameText.setEditable(this.editable);
                this.presentationNameText.setEditable(this.editable);
            }
        }
    }

    public void refresh() {
        try {
            super.refresh();
            if (this.getElement() instanceof RoleDescriptor) {
                this.element = (RoleDescriptor)this.getElement();
                this.ctrl_method_element.setText(this.getMethodElementName(this.element));
                this.toggleMethodRole();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing RoleDescriptor general section: ", (Throwable)ex);
        }
    }

    public String getNamePrefix() {
        if (this.getElement() instanceof CompositeRole) {
            return String.valueOf(LibraryUIText.TEXT_COMPOSITE_ROLE) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_ROLE_DESCRIPTOR) + ": ";
    }
}

