/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.category.DisciplineCategoriesItemProvider;
import org.eclipse.epf.library.edit.category.DomainsItemProvider;
import org.eclipse.epf.library.edit.category.RoleSetsItemProvider;
import org.eclipse.epf.library.edit.category.ToolsItemProvider;
import org.eclipse.epf.library.edit.category.WorkProductTypesItemProvider;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryContentProvider
extends AdapterFactoryContentProvider {
    private Map<Object, Object> childUIParentMap = new HashMap<Object, Object>();
    private MethodConfiguration config;

    public CategoryContentProvider(AdapterFactory adapterFactory, MethodConfiguration config) {
        super(adapterFactory);
        this.config = config;
    }

    public Object[] getChildren(Object parentElement) {
        Collection<Object> children = new ArrayList<Object>();
        if (parentElement instanceof MethodPlugin) {
            CustomCategory rootCC;
            ToolsItemProvider tools;
            RoleSetsItemProvider roleSets;
            WorkProductTypesItemProvider wpTypes;
            DomainsItemProvider domains;
            DisciplineCategoriesItemProvider disciplines = (DisciplineCategoriesItemProvider)TngUtil.getDisciplineCategoriesItemProvider((MethodPlugin)((MethodPlugin)parentElement));
            if (disciplines != null && !disciplines.getChildren((Object)disciplines).isEmpty()) {
                children.add(disciplines);
            }
            if ((domains = (DomainsItemProvider)TngUtil.getDomainsItemProvider((MethodPlugin)((MethodPlugin)parentElement))) != null && !domains.getChildren((Object)domains).isEmpty()) {
                children.add(domains);
            }
            if ((wpTypes = (WorkProductTypesItemProvider)TngUtil.getWorkProductTypesItemProvider((MethodPlugin)((MethodPlugin)parentElement))) != null && !wpTypes.getChildren((Object)wpTypes).isEmpty()) {
                children.add(wpTypes);
            }
            if ((roleSets = (RoleSetsItemProvider)TngUtil.getRoleSetsItemProvider((MethodPlugin)((MethodPlugin)parentElement))) != null && !roleSets.getChildren((Object)roleSets).isEmpty()) {
                children.add(roleSets);
            }
            if ((tools = (ToolsItemProvider)TngUtil.getToolsItemProvider((MethodPlugin)((MethodPlugin)parentElement))) != null && !tools.getChildren((Object)tools).isEmpty()) {
                children.add(tools);
            }
            if ((rootCC = TngUtil.getRootCustomCategory((MethodPlugin)((MethodPlugin)parentElement))) != null && !rootCC.getCategorizedElements().isEmpty()) {
                children.add(rootCC);
            }
        } else if (parentElement instanceof PluginUIPackagesItemProvider) {
            children.addAll((Collection)Arrays.asList(super.getChildren(parentElement)));
            children = this.filterPlugin(children);
        } else if (parentElement instanceof ContentCategory) {
            children.addAll((Collection)Arrays.asList(super.getChildren(parentElement)));
            children = this.filterCategoryElements(parentElement, children);
        } else if (parentElement instanceof FeatureValueWrapperItemProvider) {
            children.addAll((Collection<Object>)Arrays.asList(super.getChildren(parentElement)));
            children = this.filterCategoryElements(parentElement, children);
        } else if (parentElement instanceof MethodLibrary) {
            children.addAll((Collection<Object>)Arrays.asList(super.getElements(parentElement)));
            children = this.filterPlugin(children);
        } else if (parentElement instanceof TransientGroupItemProvider) {
            children.addAll((Collection<Object>)Arrays.asList(super.getChildren(parentElement)));
        }
        this.createChildParentMap(parentElement, children);
        return children.toArray();
    }

    private void createChildParentMap(Object parent, Collection children) {
        if (children == null || children.size() == 0) {
            return;
        }
        for (Object child : children) {
            this.childUIParentMap.put(child, parent);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    private Collection<Object> filterPlugin(Collection<Object> elements) {
        Iterator<Object> iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof MethodPlugin) {
                if (this.hasChildren((MethodPlugin)element) && this.config.getMethodPluginSelection().contains(element)) continue;
                iter.remove();
                continue;
            }
            if (element instanceof PluginUIPackagesItemProvider) {
                if (this.hasChildren((PluginUIPackagesItemProvider)element)) continue;
                iter.remove();
                continue;
            }
            if (!(element instanceof ConfigurationsItemProvider)) continue;
            iter.remove();
        }
        return elements;
    }

    private Collection<Object> filterCategoryElements(Object parent, Collection<Object> elements) {
        Iterator<Object> iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if ((element = TngUtil.unwrap((Object)element)) instanceof ContentCategory) continue;
            iter.remove();
        }
        return elements;
    }

    public Object getParent(Object element) {
        if (this.childUIParentMap.containsKey(element)) {
            return this.childUIParentMap.get(element);
        }
        return null;
    }

    public Collection<Object> getTreeItems(Object item) {
        ArrayList<Object> result = new ArrayList<Object>();
        List notifyChangedListeners = TngUtil.getNotifyChangedListeners((AdapterFactory)this.adapterFactory, (Object)item);
        if (!notifyChangedListeners.isEmpty()) {
            for (Object listener : notifyChangedListeners) {
                if (!(listener instanceof ITreeItemContentProvider) || TngUtil.unwrap(listener) != item) continue;
                result.add(listener);
            }
        } else {
            result.add(item);
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.childUIParentMap.clear();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification instanceof IViewerNotification) {
            IViewerNotification vnt = (IViewerNotification)notification;
            Object element = vnt.getElement();
            final CheckboxTreeViewer ctrl = (CheckboxTreeViewer)this.viewer;
            if (element != null && (vnt.getEventType() == 3 || vnt.getEventType() == 1)) {
                SafeUpdateController.syncExec((Runnable)new Runnable(){

                    public void run() {
                        ctrl.refresh();
                    }
                });
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.childUIParentMap.clear();
    }
}

