/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.edit.navigator.ConfigPageCategoriesItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigPackageContentProvider
extends AdapterFactoryContentProvider {
    Map<Object, Object> childUIParentMap = new HashMap<Object, Object>();
    List<Object> uiFolders = new ArrayList<Object>();

    public List<Object> getUIElements() {
        return this.uiFolders;
    }

    public ConfigPackageContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] items = this.getValidItems(parentElement, super.getChildren(parentElement));
        return items;
    }

    public Object[] getElements(Object inputElement) {
        Object[] items = this.getValidItems(inputElement, super.getElements(inputElement));
        return items;
    }

    private boolean isUIFolder(Object e) {
        return e instanceof ContentItemProvider || e instanceof ProcessesItemProvider || e instanceof MethodPackagesItemProvider || e instanceof PluginUIPackagesItemProvider || e instanceof ConfigPageCategoriesItemProvider;
    }

    public Object getUITargetElement(Object e) {
        Notifier target;
        if (e instanceof CustomCategory) {
            return ((CustomCategory)e).eContainer();
        }
        if (e instanceof MethodElement) {
            return e;
        }
        if (e instanceof ContentItemProvider) {
            return ((ContentItemProvider)e).getParent(null);
        }
        if (e instanceof ProcessesItemProvider) {
            return ((ProcessesItemProvider)e).getParent(null);
        }
        if (e instanceof ItemProviderAdapter && (target = ((ItemProviderAdapter)e).getTarget()) != null && target instanceof MethodElement) {
            return target;
        }
        return null;
    }

    private Object[] getValidItems(Object parent, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return elements;
        }
        ArrayList<Object> pkgs = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            Object e = LibraryUtil.unwrap((Object)elements[i]);
            boolean uiFolder = this.isUIFolder(e);
            if (uiFolder || e instanceof MethodPackage || e instanceof MethodPlugin) {
                pkgs.add(e);
                if (uiFolder) {
                    this.uiFolders.add(e);
                }
                this.childUIParentMap.put(e, parent);
            }
            ++i;
        }
        return pkgs.toArray();
    }

    public Object getParent(Object element) {
        if (this.childUIParentMap.containsKey(element)) {
            return this.childUIParentMap.get(element);
        }
        return super.getParent(element);
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.childUIParentMap.clear();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification instanceof IViewerNotification) {
            IViewerNotification vnt = (IViewerNotification)notification;
            final Object element = vnt.getElement();
            final ContainerCheckedTreeViewer ctrl = (ContainerCheckedTreeViewer)this.viewer;
            if (element != null && vnt.getEventType() == 3) {
                SafeUpdateController.syncExec((Runnable)new Runnable(){

                    public void run() {
                        ctrl.setChecked(element, true);
                    }
                });
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.uiFolders.clear();
        this.childUIParentMap.clear();
    }
}

