/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.AssignAction;
import org.eclipse.epf.authoring.ui.actions.CreateMethodElementCommand;
import org.eclipse.epf.authoring.ui.actions.CustomCategoryDeepCopyAction;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LayoutActionGroup;
import org.eclipse.epf.authoring.ui.actions.LibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCopyAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCutAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewDeleteAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewPasteAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewSimpleAction;
import org.eclipse.epf.authoring.ui.actions.NewPluginAction;
import org.eclipse.epf.authoring.ui.actions.ReassignAction;
import org.eclipse.epf.authoring.ui.actions.RenameAction;
import org.eclipse.epf.authoring.ui.actions.UnassignAction;
import org.eclipse.epf.authoring.ui.dialogs.MoveDialog;
import org.eclipse.epf.authoring.ui.dialogs.SwitchConfigDialog;
import org.eclipse.epf.authoring.ui.dialogs.VariabilitySelection;
import org.eclipse.epf.authoring.ui.dnd.LibraryViewerDragAdapter;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.preferences.ApplicationPreferenceConstants;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.providers.MethodElementLabelDecorator;
import org.eclipse.epf.authoring.ui.util.RefreshHandler;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.INamedFilter;
import org.eclipse.epf.library.edit.PluginUIPackageContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.navigator.MethodLibraryItemProvider;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.PersistenceService;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.project.MethodLibraryProjectNature;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.util.ImportExportUtil;
import org.eclipse.epf.library.xmi.XMILibraryManager;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.provider.MethodPluginItemProvider;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.markers.internal.MarkerAdapter;
import org.eclipse.ui.views.navigator.ResourceNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryView
extends AbstractBaseView
implements IRefreshHandler,
IShowInTarget {
    public static final String VIEW_ID = LibraryView.class.getName();
    private static LibraryView INSTANCE = null;
    private static boolean DEBUG = AuthoringUIPlugin.getDefault().isDebugging();
    protected TreeViewer treeViewer;
    protected IDoubleClickListener doubleClickListener = null;
    private ISelection selection;
    private LayoutActionGroup fLayoutActionSet;
    private String PERFORM_ID = "org.eclipse.epf.authoring.view.LibraryView.performValidatorAction";
    private IAction performLibraryValidationAction = new Action(AuthoringUIResources.Validate_method_library, AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/validate_method_lib.gif")){

        public void run() {
            try {
                ViewHelper.checkLibraryHealth();
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    };
    private IPartListener editorPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                SwitchConfigDialog.run(Display.getCurrent().getActiveShell(), (IEditorPart)part);
            }
        }
    };
    private long lastRefreshTimeStamp;
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 2 || event.getType() == 4) {
                IProject project = (IProject)event.getResource();
                try {
                    if (project.exists() && project.isOpen() && project.hasNature(MethodLibraryProjectNature.NATURE_ID)) {
                        EditorChooser.getInstance().closeAllMethodEditors();
                        IProject currProject = MethodLibraryProject.findProject((String)LibraryService.getInstance().getCurrentMethodLibraryLocation());
                        if (project == currProject) {
                            LibraryService.getInstance().closeCurrentMethodLibrary();
                        }
                    }
                }
                catch (CoreException cex) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)cex);
                }
                catch (LibraryServiceException lex) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)lex);
                }
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    ResourceDeltaVisitor() {
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((delta.getFlags() & 0x20000) == 131072) {
                            switch (delta.getKind()) {
                                case 1: 
                                case 4: {
                                    UIHelper.showProblemsView();
                                    return false;
                                }
                            }
                        } else if (delta.getResource().getType() == 4 && delta.getKind() == 4) {
                            IProject project;
                            if ((delta.getFlags() & 0x40000) == 0 && (delta.getFlags() & 0x80000) != 0) {
                                XMILibraryManager xmiLibMgr;
                                IProject project2 = (IProject)delta.getResource();
                                ILibraryManager libMgr = LibraryService.getInstance().getCurrentLibraryManager();
                                if (libMgr instanceof XMILibraryManager && project2.equals((Object)(xmiLibMgr = (XMILibraryManager)libMgr).getMethodLibraryProject())) {
                                    xmiLibMgr.handleLibraryMoved();
                                    return false;
                                }
                            } else if ((delta.getFlags() & 0x4000) != 0 && (project = (IProject)delta.getResource()).isOpen() && project.hasNature(MethodLibraryProjectNature.NATURE_ID) && LibraryService.getInstance().getCurrentMethodLibrary() == null) {
                                java.net.URI projectLocation = project.getLocationURI();
                                try {
                                    LibraryService.getInstance().openMethodLibrary("xmi", projectLocation);
                                }
                                catch (Exception e) {
                                    LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                                }
                                return false;
                            }
                        }
                        return true;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    };
    private IRefreshListener refreshListener = new IRefreshListener(){

        public void notifyRefreshed(IRefreshEvent event) {
            if (event.getRefreshedObjects() != null && !event.getRefreshedObjects().isEmpty()) {
                Control ctrl = LibraryView.this.getViewer().getControl();
                if (ctrl == null || ctrl.isDisposed()) {
                    return;
                }
                if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
                    LibraryView.this.doRefresh(LibraryView.this.getSite().getShell());
                } else {
                    ctrl.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            LibraryView.this.doRefresh(null);
                        }
                    });
                }
            }
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                LibraryView.this.firePropertyChange(257);
            }
        }
    };

    public LibraryView() {
        if ("flat".equals(ApplicationPreferenceConstants.getLayout())) {
            PluginUIPackageContext.INSTANCE.setLayoutFlat();
        } else if ("hierarchical".equals(ApplicationPreferenceConstants.getLayout())) {
            PluginUIPackageContext.INSTANCE.setLayoutHierarchical();
        }
        INSTANCE = this;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.makeActions();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, AuthoringUIHelpContexts.LIBRARY_NAVIGATOR_VIEW_CONTEXT);
        RefreshJob.getInstance().setRefreshHandler((IRefreshHandler)this);
    }

    private void makeActions() {
        this.fLayoutActionSet = new LayoutActionGroup(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fLayoutActionSet.fillActionBars(actionBars);
    }

    @Override
    public void setFocus() {
        this.actionBarContributor.setActiveView((IViewPart)this);
        IStructuredSelection selected = (IStructuredSelection)this.getSelection();
        if (selected.isEmpty()) {
            this.actionBarContributor.disableGlobalEditMenu();
        } else {
            this.actionBarContributor.enableGlobalEditMenu();
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    @Override
    public Viewer getViewer() {
        return this.treeViewer;
    }

    @Override
    public void createViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent){

            protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
                if (event.getElement() instanceof IResource && event.getSource() instanceof ILabelDecorator) {
                    this.refresh();
                    return;
                }
                super.handleLabelProviderChanged(event);
            }
        };
        this.adapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        LibraryView.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            Viewer viewer;
                            LibraryView.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                            if (mostRecentCommand instanceof CreateMethodElementCommand && (viewer = LibraryView.this.getViewer()) instanceof StructuredViewer) {
                                Object[] elements = mostRecentCommand.getAffectedObjects().toArray();
                                ((StructuredViewer)viewer).update(elements, null);
                            }
                        }
                        if ((this).LibraryView.this.propertySheetPage != null && (this).LibraryView.this.propertySheetPage.getControl() != null && !(this).LibraryView.this.propertySheetPage.getControl().isDisposed() && (this).LibraryView.this.propertySheetPage.getControl().isVisible()) {
                            (this).LibraryView.this.propertySheetPage.refresh();
                        }
                    }
                };
                if (Display.getCurrent() != null) {
                    Display.getCurrent().asyncExec(runnable);
                } else {
                    runnable.run();
                }
            }
        });
        ILibraryResourceSet resourceSet = PersistenceService.INSTANCE.createResourceSet(Services.getDefaultLibraryPersistenceType());
        this.editingDomain = new TraceableAdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory), (ILabelDecorator)new MethodElementLabelDecorator()));
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UIActionDispatcher.getInstance().handleDoubleClickEvent(event);
            }
        };
        this.treeViewer.addDoubleClickListener(this.doubleClickListener);
        this.getSite().getPage().addPartListener(this.editorPartListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
    }

    @Override
    public void setInputForViewer(Object model) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl.isDisposed()) {
            return;
        }
        if (model == null || model instanceof MethodLibrary) {
            String name;
            IFilter filter;
            StructuredSelection emptySelection = new StructuredSelection();
            this.actionDispatcher.setSelection((ISelection)emptySelection);
            UIActionDispatcher.getInstance().setSelection((ISelection)emptySelection);
            this.getViewer().setInput(model);
            if (this.adapterFactory instanceof ConfigurableComposedAdapterFactory && (filter = ((ConfigurableComposedAdapterFactory)this.adapterFactory).getFilter()) instanceof INamedFilter && (name = ((INamedFilter)filter).getName()) != null) {
                this.setContentDescription(name);
            }
            this.updateLastRefreshTimestamp();
        } else {
            AuthoringUIPlugin.getDefault().getLogger().logError("Library viewer input is not a MethodLibrary object: " + model);
        }
    }

    private void updateLastRefreshTimestamp() {
        this.lastRefreshTimeStamp = System.currentTimeMillis();
    }

    public static LibraryView getView() {
        boolean show = ViewHelper.isViewInCurrentPerspective(VIEW_ID);
        return (LibraryView)ViewHelper.findView(VIEW_ID, show);
    }

    public static LibraryView getViewInstance() {
        return INSTANCE;
    }

    @Override
    public void setSelection(ISelection selection) {
        ((LibraryViewActionBarContributor)this.actionBarContributor).updateSelection(selection);
        super.setSelection(selection);
        this.selection = selection;
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            URI uri;
            Resource resource;
            Object o;
            IStructuredSelection structuredSelection;
            String path = "";
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (o = TngUtil.unwrap((Object)structuredSelection.getFirstElement())) instanceof EObject && (resource = ((EObject)o).eResource()) != null && (uri = resource.getURI()) != null && uri.isFile()) {
                URI contentURI;
                ContentDescription content;
                path = uri.toFileString();
                if (o instanceof ContentElement && (content = ((ContentElement)o).getPresentation()) != null && (resource = content.eResource()) != null && (contentURI = resource.getURI()) != null) {
                    path = String.valueOf(path) + ",." + File.separatorChar + contentURI.deresolve(uri).toFileString();
                }
            }
            statusLineManager.setMessage(path);
        }
    }

    public void registerChangeListeners() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.registerEditingDomain(this.editingDomain);
            manager.addPropertyListener(this.propertyListener);
        }
    }

    @Override
    public void libraryReopened(MethodLibrary library) {
        this.refreshViews();
    }

    @Override
    public void librarySet(MethodLibrary library) {
        super.librarySet(library);
        this.registerChangeListeners();
    }

    @Override
    public void libraryClosed(MethodLibrary library) {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.unregisterEditingDomain(this.editingDomain);
            manager.removePropertyListener(this.propertyListener);
        }
        super.libraryClosed(library);
    }

    @Override
    public ILibraryActionBarContributor createActionBarContributor() {
        LibraryViewActionBarContributor actionBar = new LibraryViewActionBarContributor((EditingDomain)this.editingDomain);
        return actionBar;
    }

    @Override
    public void createContextMenuFor(StructuredViewer viewer) {
        super.createContextMenuFor(viewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{HTMLTransfer.getInstance(), TextTransfer.getInstance(), LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, this.createDragSourceListener((Viewer)viewer));
    }

    protected DragSourceListener createDragSourceListener(Viewer viewer) {
        return new LibraryViewerDragAdapter(viewer);
    }

    @Override
    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        AuthoringUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("enabledLibraryValidation")) {
                    Boolean enabled = (Boolean)event.getNewValue();
                    IToolBarManager toolBarManager = LibraryView.this.getViewSite().getActionBars().getToolBarManager();
                    if (enabled != null && enabled.booleanValue()) {
                        LibraryView.this.performLibraryValidationAction.setId(LibraryView.this.PERFORM_ID);
                        toolBarManager.insertAfter("additions", LibraryView.this.performLibraryValidationAction);
                    } else {
                        IContributionItem[] items = toolBarManager.getItems();
                        int i = 0;
                        while (i < items.length) {
                            IContributionItem item = items[i];
                            if (item.getId().equals(LibraryView.this.PERFORM_ID)) {
                                toolBarManager.remove(item);
                            }
                            ++i;
                        }
                    }
                    toolBarManager.update(true);
                }
            }
        });
    }

    @Override
    public void dispose() {
        RefreshJob.getInstance().setRefreshHandler(null);
        if (this.fLayoutActionSet != null) {
            this.fLayoutActionSet.dispose();
        }
        super.dispose();
        if (this.doubleClickListener != null) {
            this.treeViewer.removeDoubleClickListener(this.doubleClickListener);
        }
    }

    public ProcessComponent getProcessComponent(Object obj) {
        Object parent = obj;
        while (parent != null && !(parent instanceof ProcessComponent)) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt(parent, ITreeItemContentProvider.class);
            parent = adapter.getParent(parent);
        }
        return (ProcessComponent)parent;
    }

    public void openLibrary(final String path) {
        StatusWorkspaceModifyOperation operation = new StatusWorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(AuthoringUIResources.openingLibraryTask_name, 2);
                try {
                    try {
                        monitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        MethodLibrary library = XMILibraryUtil.openMethodLibrary((String)path);
                        LibraryService.getInstance().setCurrentMethodLibrary(library);
                        LibraryUIPreferences.setSavedLibraryPath((String)path);
                    }
                    catch (Exception ex) {
                        if (ex instanceof IOException) {
                            String message = ex.getMessage();
                            if (message.startsWith("###")) {
                                String projectFileName = message.substring(3);
                                String prompt = AuthoringUIResources.bind((String)AuthoringUIResources.ElementsView_35, (Object[])new Object[]{projectFileName});
                                if (MsgBox.prompt((String)prompt, (int)1280) == 1024) {
                                    LibraryView.this.openLibrary(path);
                                }
                            }
                        } else {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.openLibraryError_msg, (Throwable)ex);
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (org.eclipse.jface.operation.IRunnableWithProgress)operation);
            if (operation.getErrorMessage() == null) {
                this.getSite().getPage().closeAllEditors(false);
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    @Override
    protected void handleActivate(IWorkbenchPart part) {
        super.handleActivate(part);
        XMILibraryUtil.openMethodLibraryProject((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)this.getViewSite().getActionBars().getStatusLineManager().getProgressMonitor());
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void doSaveAs() {
    }

    public void setSelectionToViewer(Object object) {
        Object o = TngUtil.unwrap((Object)object);
        if (!(o instanceof MethodElement)) {
            return;
        }
        if (o instanceof MethodConfiguration) {
            super.setSelectionToViewer(Arrays.asList(o));
            return;
        }
        try {
            Process proc;
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)o));
            MethodPluginItemProvider pluginAdapter = (MethodPluginItemProvider)TngUtil.getAdapter((EObject)plugin, MethodPluginItemProvider.class);
            MethodLibraryItemProvider libraryAdapter = (MethodLibraryItemProvider)TngUtil.getAdapter((EObject)LibraryService.getInstance().getCurrentMethodLibrary(), MethodLibraryItemProvider.class);
            ItemProviderAdapter pluginTreeAdapter = libraryAdapter.getPluginItemProvider(plugin);
            while (pluginTreeAdapter instanceof PluginUIPackagesItemProvider) {
                this.treeViewer.setExpandedState((Object)pluginTreeAdapter, true);
                pluginTreeAdapter = ((PluginUIPackagesItemProvider)pluginTreeAdapter).getPluginItemProvider(plugin);
            }
            this.treeViewer.setExpandedState((Object)plugin, true);
            if (o instanceof BreakdownElement && (proc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)o))) != null) {
                o = proc.eContainer();
            }
            if (o instanceof ProcessComponent || o instanceof ProcessPackage) {
                this.treeViewer.setExpandedState(pluginAdapter.getChildren((Object)plugin).toArray()[1], true);
                this.expandTreeViewerPackages(((MethodElement)o).eContainer());
            } else {
                ITreeItemContentProvider methodContentPkg = (ITreeItemContentProvider)pluginAdapter.getChildren((Object)plugin).toArray()[0];
                this.treeViewer.setExpandedState((Object)methodContentPkg, true);
                if (o instanceof CustomCategory) {
                    CustomCategory rootCC = TngUtil.getRootCustomCategory((MethodPlugin)plugin);
                    ArrayList<CustomCategory> treePath = new ArrayList<CustomCategory>();
                    CustomCategory cc = (CustomCategory)o;
                    while (cc != rootCC) {
                        treePath.add(0, cc);
                        cc = (CustomCategory)AssociationHelper.getCustomCategories((DescribableElement)cc).get(0);
                    }
                    o = this.expandTree(rootCC, treePath);
                } else if (o instanceof ContentCategory) {
                    Object stdCats = methodContentPkg.getChildren(o).toArray()[1];
                    ArrayList<Object> treePath = new ArrayList<Object>();
                    if (o instanceof Discipline) {
                        Object dis = o;
                        while (true) {
                            treePath.add(0, dis);
                            List parentDisc = AssociationHelper.getDiscipline((Discipline)((Discipline)dis));
                            if (parentDisc.isEmpty()) break;
                            dis = parentDisc.get(0);
                        }
                        if (!AssociationHelper.getDisciplineGroups((Discipline)((Discipline)dis)).isEmpty()) {
                            DisciplineGrouping dg = (DisciplineGrouping)AssociationHelper.getDisciplineGroups((Discipline)((Discipline)dis)).get(0);
                            treePath.add(0, dg);
                        }
                        treePath.add(0, TngUtil.getDisciplineCategoriesItemProvider((MethodPlugin)plugin));
                        o = this.expandTree(stdCats, treePath);
                    } else if (o instanceof RoleSet) {
                        treePath.add(0, o);
                        RoleSetGrouping rsg = (RoleSetGrouping)AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)o)).get(0);
                        treePath.add(0, rsg);
                        treePath.add(0, TngUtil.getRoleSetsItemProvider((MethodPlugin)plugin));
                        o = this.expandTree(stdCats, treePath);
                    } else {
                        this.treeViewer.setExpandedState(stdCats, true);
                    }
                } else {
                    Object coreContent = methodContentPkg.getChildren(o).toArray()[0];
                    this.treeViewer.setExpandedState(coreContent, true);
                    this.expandTreeViewerPackages(((MethodElement)o).eContainer());
                }
            }
        }
        catch (Exception ex) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
        }
        super.setSelectionToViewer(Arrays.asList(o));
        if (o instanceof ProcessComponent && object instanceof BreakdownElement) {
            IEditorKeeper.REFERENCE.getEditorKeeper().openEditor(o);
            IEditorPart editor = this.getSite().getPage().findEditor((IEditorInput)new MethodElementEditorInput((MethodElement)o));
            if (editor instanceof ProcessEditor) {
                ProcessEditor procEditor = (ProcessEditor)editor;
                String pageId = object instanceof RoleDescriptor || object instanceof TeamProfile ? "tbs" : (object instanceof WorkProductDescriptor ? "wpbs" : "wbs");
                procEditor.setActivePage(pageId);
                procEditor.setSelectionToViewer(Collections.singletonList(object));
            }
        }
    }

    private Object expandTree(Object root, List treePath) {
        Object parent = root;
        int size = treePath.size();
        int i = 0;
        while (i < size) {
            Object e = treePath.get(i);
            this.treeViewer.setExpandedState(parent, true);
            List notifyChangedListeners = TngUtil.getNotifyChangedListeners((AdapterFactory)this.adapterFactory, e);
            if (!notifyChangedListeners.isEmpty()) {
                for (Object listener : notifyChangedListeners) {
                    if (!(listener instanceof FeatureValueWrapperItemProvider) || TngUtil.unwrap(listener) != e) continue;
                    FeatureValueWrapperItemProvider wrapper = (FeatureValueWrapperItemProvider)listener;
                    while (wrapper != null && wrapper.getOwner() != parent) {
                        wrapper = TngUtil.getWrapper((Collection)wrapper.getNotifyChangedListeners(), e);
                    }
                    if (wrapper == null) continue;
                    parent = wrapper;
                    break;
                }
            } else {
                parent = e;
            }
            ++i;
        }
        return parent;
    }

    private void expandTreeViewerPackages(EObject e) {
        if (e == null) {
            return;
        }
        if (e instanceof ContentPackage || e instanceof ProcessPackage) {
            this.expandTreeViewerPackages(e.eContainer());
            this.treeViewer.setExpandedState((Object)e, true);
        }
    }

    public void refresh(IProgressMonitor monitor) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.doRefresh(this.getSite().getShell());
        } else {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    LibraryView.this.doRefresh(null);
                }
            });
        }
    }

    private void blockingRefresh(final ArrayList removedResources, final ArrayList changedResources, final Collection addedWorkspaceResources, final boolean refreshViews, Shell shell) {
        org.eclipse.jface.operation.IRunnableWithProgress runnable = new org.eclipse.jface.operation.IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", -1);
                monitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                monitor.worked(1);
                try {
                    LibraryView.this.doRefresh(removedResources, changedResources, addedWorkspaceResources, refreshViews);
                }
                finally {
                    monitor.done();
                }
            }
        };
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        try {
            this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()));
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            String title = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.toString(), (Throwable)e);
        }
    }

    private synchronized void doRefresh(Collection removedResources, Collection changedResources, Collection addedWorkspaceResources, boolean refreshViews) {
        ResourceSet resourceSet;
        ILibraryManager mgr;
        HashSet editorsToRefresh = new HashSet();
        if (!removedResources.isEmpty()) {
            this.handleRemovedResources(removedResources, editorsToRefresh);
            refreshViews = true;
        }
        if (!changedResources.isEmpty()) {
            this.handleChangedResources(changedResources, editorsToRefresh, refreshViews);
        } else {
            if (refreshViews) {
                this.refreshViews();
            }
            if (!editorsToRefresh.isEmpty()) {
                for (Object editor : editorsToRefresh) {
                    if (!(editor instanceof MethodElementEditor)) continue;
                    ((MethodElementEditor)((Object)editor)).refresh();
                }
            }
        }
        if (addedWorkspaceResources != null && !addedWorkspaceResources.isEmpty() && (mgr = LibraryService.getInstance().getCurrentLibraryManager()) != null && (resourceSet = mgr.getEditingDomain().getResourceSet()) instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)resourceSet).loadNewResources(addedWorkspaceResources);
            ((MultiFileResourceSetImpl)resourceSet).getUnresolvedProxyMarkerManager().validateAllMarkers();
        }
    }

    private boolean isViewObject(Object o) {
        return o instanceof MethodElement && !(o instanceof ContentDescription) && !(o instanceof ProcessElement) && (!(o instanceof ProcessPackage) || UmaUtil.getProcessComponent((MethodElement)((MethodElement)o)) != null);
    }

    private void doRefresh(IRefreshEvent event, Shell shell) {
        if (DEBUG) {
            System.out.println("Refreshed objects: " + event.getRefreshedObjects());
        }
        boolean refresh = false;
        for (Object e : event.getRefreshedObjects()) {
            if (!this.isViewObject(e)) continue;
            refresh = true;
            break;
        }
        if (refresh) {
            this.refreshViews();
        }
    }

    private void doRefresh(Shell shell) {
        boolean refreshViews = !RefreshJob.getInstance().getReloadedBeforeRefreshResources().isEmpty() || !RefreshJob.getInstance().getAddedResources().isEmpty();
        ArrayList removedResources = new ArrayList(RefreshJob.getInstance().getRemovedResources());
        ArrayList changedResources = new ArrayList(RefreshJob.getInstance().getChangedResources());
        ArrayList addedWsResources = new ArrayList(RefreshJob.getInstance().getAddedWorkspaceResources());
        if (!removedResources.isEmpty() || !changedResources.isEmpty() || !addedWsResources.isEmpty() || refreshViews) {
            this.blockingRefresh(removedResources, changedResources, addedWsResources, refreshViews, shell);
        }
        if (!removedResources.isEmpty()) {
            RefreshJob.getInstance().getRemovedResources().removeAll(removedResources);
        }
        if (!changedResources.isEmpty()) {
            RefreshJob.getInstance().getChangedResources().removeAll(changedResources);
        }
        if (!addedWsResources.isEmpty()) {
            RefreshJob.getInstance().getAddedWorkspaceResources().removeAll(addedWsResources);
        }
        if (refreshViews) {
            RefreshJob.getInstance().getReloadedBeforeRefreshResources().clear();
            RefreshJob.getInstance().getAddedResources().clear();
        }
    }

    private Collection handleRemovedResources(Collection removedResources, Collection editorsToRefresh) {
        IEditorPart editor;
        IEditorReference reference;
        IWorkbenchPage workbenchPage = this.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList removedResourceList = new ArrayList(removedResources);
        if (editorsToRefresh == null) {
            editorsToRefresh = new ArrayList<Object>();
        }
        int i = 0;
        while (i < editorReferences.length) {
            reference = editorReferences[i];
            editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && editor.isDirty()) {
                Resource resource;
                MethodElementEditorInput input = (MethodElementEditorInput)editor.getEditorInput();
                Resource resource2 = resource = input.getMethodElement() != null ? input.getMethodElement().eResource() : null;
                if (!removedResources.contains(resource)) {
                    Collection<Resource> usedResources = ((MethodElementEditor)editor).getUsedResources();
                    int j = 0;
                    while (j < removedResourceList.size()) {
                        resource = (Resource)removedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            dirtyEditorsWithConflict.add(editor);
                            break;
                        }
                        ++j;
                    }
                } else {
                    editorsToRefresh.add(editor);
                }
            }
            ++i;
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] selected = this.selectDirtyEditors(dirtyEditorsWithConflict);
            int i2 = 0;
            while (i2 < selected.length) {
                editorsToRefresh.add(selected[i2]);
                ++i2;
            }
        }
        PersistenceUtil.unload((Collection)removedResources);
        i = 0;
        while (i < editorReferences.length) {
            reference = editorReferences[i];
            editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && !editor.isDirty()) {
                Collection<Resource> usedResources = ((MethodElementEditor)editor).getUsedResources();
                int j = 0;
                while (j < removedResourceList.size()) {
                    Resource resource = (Resource)removedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        editorsToRefresh.add(editor);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return removedResources;
    }

    private Collection handleChangedResources(Collection changedResources, Collection editorsToRefresh, boolean forceRefreshViews) {
        if (!forceRefreshViews) {
            for (Resource resource : changedResources) {
                if (!(resource instanceof ILibraryResource) || ((ILibraryResource)resource).getLoadStamp() <= this.lastRefreshTimeStamp) continue;
                forceRefreshViews = true;
                break;
            }
        }
        return this.handleChangedResources(changedResources, null, forceRefreshViews, editorsToRefresh);
    }

    public Collection handleChangedResources(Collection changedResources, Collection editorsNotToRefresh, boolean forceRefreshViews, Collection editorsToRefresh) {
        Object editor;
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return Collections.EMPTY_LIST;
        }
        IWorkbenchPage workbenchPage = this.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList changedResourceList = new ArrayList(changedResources);
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor2 = reference.getEditor(true);
            if (editor2 instanceof MethodElementEditor && editor2.isDirty()) {
                Collection<Resource> usedResources = ((MethodElementEditor)editor2).getUsedResources();
                int j = 0;
                while (j < changedResourceList.size()) {
                    Resource resource = (Resource)changedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        dirtyEditorsWithConflict.add(editor2);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        ArrayList<Object> editorListToRefresh = new ArrayList<Object>();
        if (editorsToRefresh != null) {
            editorListToRefresh.addAll(editorsToRefresh);
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] result = this.selectDirtyEditors(dirtyEditorsWithConflict);
            if (result != null) {
                int i2 = 0;
                while (i2 < result.length) {
                    editor = result[i2];
                    if (!(editorsNotToRefresh != null && editorsNotToRefresh.contains(editor) || editorsToRefresh != null && editorsToRefresh.contains(editor))) {
                        editorListToRefresh.add(editor);
                        dirtyEditorsWithConflict.remove(editor);
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < dirtyEditorsWithConflict.size()) {
                editor = (MethodElementEditor)((Object)dirtyEditorsWithConflict.get(i3));
                Collection<Resource> usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                usedResources.retainAll(changedResourceList);
                ((MethodElementEditor)((Object)editor)).updateResourceInfos(usedResources);
                ((MethodElementEditor)((Object)editor)).ovewriteResources(usedResources);
                changedResourceList.removeAll(usedResources);
                ++i3;
            }
        }
        boolean refreshViews = false;
        if (!changedResourceList.isEmpty()) {
            int i4 = 0;
            while (i4 < editorReferences.length) {
                IEditorReference reference = editorReferences[i4];
                IEditorPart editor3 = reference.getEditor(true);
                if (editor3 instanceof MethodElementEditor && !editor3.isDirty()) {
                    Collection<Resource> usedResources = ((MethodElementEditor)editor3).getUsedResources();
                    int j = 0;
                    while (j < changedResourceList.size()) {
                        Resource resource = (Resource)changedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            editorListToRefresh.add(editor3);
                            break;
                        }
                        ++j;
                    }
                }
                ++i4;
            }
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                Collection reloadedResources = manager.reloadResources(changedResourceList);
                boolean bl = refreshViews = !reloadedResources.isEmpty();
            }
        }
        if (forceRefreshViews || refreshViews) {
            this.refreshViews();
        }
        if (!editorListToRefresh.isEmpty()) {
            int i5 = 0;
            while (i5 < editorListToRefresh.size()) {
                editor = (MethodElementEditor)((Object)editorListToRefresh.get(i5));
                try {
                    ((MethodElementEditor)((Object)editor)).refresh();
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                ++i5;
            }
        }
        return changedResourceList;
    }

    public synchronized void refreshViews() {
        Control ctrl;
        ConfigurationView configView;
        EObject input = (EObject)this.getViewer().getInput();
        if (input != null) {
            if (input.eIsProxy()) {
                this.setInputForViewer(RefreshJob.getInstance().resolve(input));
            } else {
                ISelection selection = this.getViewer().getSelection();
                this.getViewer().refresh();
                this.updateLastRefreshTimestamp();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object o = null;
                    if (structuredSelection.size() == 1 && (o = structuredSelection.getFirstElement()) instanceof EObject && ((EObject)o).eIsProxy()) {
                        o = RefreshJob.getInstance().resolve((EObject)o);
                        try {
                            this.setSelectionToViewer(o);
                        }
                        catch (Exception e) {
                            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                    } else {
                        ViewHelper.restoreSelection(this.getViewer(), selection);
                    }
                }
            }
        }
        if ((configView = ConfigurationView.getView()) != null && (ctrl = configView.getViewer().getControl()) != null && !ctrl.isDisposed() && (input = (EObject)configView.getViewer().getInput()) != null) {
            if (input.eIsProxy()) {
                configView.setInputForViewer(RefreshJob.getInstance().resolve(input));
            } else {
                ISelection selection = configView.getViewer().getSelection();
                configView.getViewer().refresh();
                ViewHelper.restoreSelection(configView.getViewer(), selection);
            }
        }
    }

    private Object[] selectDirtyEditors(List<?> dirtyEditors) {
        return RefreshHandler.selectDirtyEditors(dirtyEditors, this.getSite().getShell());
    }

    public static void runRename(final NamedElement e, final String newName) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                RenameAction.doRename(e, newName);
            }
        });
    }

    public boolean show(ShowInContext context) {
        Object firstObj;
        TreeSelection sel;
        IViewPart view;
        ISelectionProvider selectionProvider;
        StructuredSelection selection;
        Object o;
        if (context.getInput() instanceof MarkerAdapter && (o = (selection = (StructuredSelection)(selectionProvider = (view = this.getViewSite().getPage().findView("org.eclipse.ui.views.ProblemView")).getViewSite().getSelectionProvider()).getSelection()).getFirstElement()) instanceof IMarker) {
            IMarker marker = (IMarker)o;
            try {
                String guid = (String)marker.getAttribute("guid");
                if (guid != null) {
                    IResource wsRes = marker.getResource();
                    ILibraryManager libMgr = LibraryService.getInstance().getCurrentLibraryManager();
                    Resource resource = libMgr.getEditingDomain().getResourceSet().getResource(URI.createFileURI((String)wsRes.getLocation().toString()), false);
                    Object element = resource != null ? resource.getEObject(guid) : libMgr.getMethodElement(guid);
                    if (element != null) {
                        this.setSelectionToViewer(element);
                        return true;
                    }
                }
            }
            catch (CoreException e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        ISelection contextSelection = context.getSelection();
        if (context.getSelection() instanceof TreeSelection) {
            sel = (TreeSelection)context.getSelection();
            this.setSelectionToViewer(sel.getFirstElement());
        } else if (contextSelection instanceof StructuredSelection && (firstObj = (sel = (StructuredSelection)contextSelection).getFirstElement()) instanceof IResource) {
            IResource wsRes = (IResource)firstObj;
            ILibraryManager libMgr = LibraryService.getInstance().getCurrentLibraryManager();
            Resource resource = libMgr.getEditingDomain().getResourceSet().getResource(URI.createFileURI((String)wsRes.getLocation().toString()), false);
            MethodElement element = PersistenceUtil.getMethodElement((Resource)resource);
            if (element != null) {
                this.setSelectionToViewer(element);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getViewId() {
        return VIEW_ID;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setContentDescription(String description) {
        super.setContentDescription(description);
    }

    protected class LibraryViewActionBarContributor
    extends LibraryActionBarContributor {
        protected IAction newPluginAction;
        private IAction moveAction;
        private LibraryViewSimpleAction assignAction;
        private LibraryViewSimpleAction unassignAction;
        private LibraryViewSimpleAction reassignAction;
        private LibraryViewSimpleAction customCategoryDeepCopyAction;
        private RenameAction renameAction;
        private IAction replaceAction;
        private IAction openVariabilityDialogAction;
        private boolean locked;
        private boolean canMove;
        private boolean canAssign;
        private IAction showInResourceNavigatorAction;
        private boolean canRename;

        public LibraryViewActionBarContributor(EditingDomain editingDomain) {
            super(editingDomain);
            this.newPluginAction = new NewPluginAction(AuthoringUIResources.new_plugin);
            this.moveAction = new Action(AuthoringUIResources.move){

                private void doMove() {
                    ArrayList elementsToMove = new ArrayList();
                    IStructuredSelection selection = (IStructuredSelection)LibraryView.this.selection;
                    for (Object element : selection) {
                        if (!(element instanceof MethodElement) && !((element = TngUtil.unwrap(element)) instanceof CustomCategory)) continue;
                        EObject container = ((EObject)element).eContainer();
                        IStatus status = UserInteractionHelper.checkModify((EObject)container, (Object)LibraryView.this.getSite().getShell());
                        if (container != null && !status.isOK()) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.errorDialog_moveError, status);
                            return;
                        }
                        elementsToMove.add(element);
                    }
                    Iterator iterator = elementsToMove.iterator();
                    while (iterator.hasNext()) {
                        Object element;
                        element = (EObject)iterator.next();
                        boolean isContained = false;
                        for (Object e : elementsToMove) {
                            if (!UmaUtil.isContainedBy(element, e)) continue;
                            isContained = true;
                            break;
                        }
                        if (!isContained) continue;
                        iterator.remove();
                    }
                    MoveDialog dlg = new MoveDialog(LibraryView.this.getSite().getShell(), elementsToMove, (EditingDomain)((LibraryViewActionBarContributor)LibraryViewActionBarContributor.this).LibraryView.this.editingDomain);
                    dlg.open();
                }

                public void run() {
                    LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
                    runner.setProgressMonitor(LibraryViewActionBarContributor.this.getActionBars().getStatusLineManager().getProgressMonitor());
                    runner.run(new org.eclipse.jface.operation.IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            this.doMove();
                        }
                    });
                }
            };
            this.assignAction = new AssignAction(LibraryView.this);
            this.unassignAction = new UnassignAction(LibraryView.this);
            this.reassignAction = new ReassignAction(LibraryView.this);
            this.customCategoryDeepCopyAction = new CustomCategoryDeepCopyAction(LibraryView.this);
            this.renameAction = new RenameAction();
            this.replaceAction = new Action(AuthoringUIResources.ElementsView_replaceAction_text){

                public void run() {
                    if (!LibraryViewActionBarContributor.this.getPage().closeAllEditors(true)) {
                        return;
                    }
                    final ProcessComponent procComp = (ProcessComponent)((IStructuredSelection)LibraryView.this.selection).getFirstElement();
                    Process proc = procComp.getProcess();
                    String typeStr = proc instanceof CapabilityPattern ? AuthoringUIResources.ElementsView_20 : (proc instanceof DeliveryProcess ? AuthoringUIResources.ElementsView_21 : AuthoringUIResources.ElementsView_22);
                    DirectoryDialog dirDlg = new DirectoryDialog(LibraryView.this.getSite().getShell());
                    dirDlg.setText(AuthoringUIResources.ElementsView_replace_text);
                    dirDlg.setMessage(MessageFormat.format(AuthoringUIResources.ElementsView_migration_dir_dlg_description_text, typeStr));
                    final String dir = dirDlg.open();
                    if (dir == null) {
                        return;
                    }
                    boolean ret = UserInteractionHelper.runWithProgress((IRunnableWithProgress)new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ImportExportUtil.replace((ProcessComponent)procComp, (String)dir);
                            }
                            catch (Exception e) {
                                throw new WrappedException(e);
                            }
                        }
                    }, (String)MessageFormat.format(AuthoringUIResources.ElementsView_replaceingwithformat_text, typeStr));
                    if (ret) {
                        LibraryUIManager.getInstance().openLibrary(LibraryService.getInstance().getCurrentMethodLibraryLocation());
                    }
                }
            };
            this.openVariabilityDialogAction = new Action(AuthoringUIResources.ElementsView_openVariabilityDialogAction_text){

                public void run() {
                    VariabilityElement element;
                    VariabilitySelection variabilitySelection;
                    Object selectedObject;
                    Object obj = TngUtil.unwrap((Object)((IStructuredSelection)LibraryView.this.selection).getFirstElement());
                    if (obj instanceof VariabilityElement && (selectedObject = (variabilitySelection = new VariabilitySelection()).getSelectedVariability(element = (VariabilityElement)obj)) != null) {
                        EditorChooser.getInstance().openEditor(selectedObject);
                    }
                }
            };
            this.showInResourceNavigatorAction = new Action(AuthoringUIResources.showInResourceNavigatorAction_label){

                public void run() {
                    try {
                        ResourceNavigator navigator = (ResourceNavigator)LibraryViewActionBarContributor.this.getPage().showView("org.eclipse.ui.views.ResourceNavigator");
                        Object obj = TngUtil.unwrap((Object)((IStructuredSelection)LibraryView.this.selection).getFirstElement());
                        IResource wsRes = PersistenceUtil.getWorkspaceResource((Object)obj);
                        if (wsRes != null) {
                            navigator.getViewer().setSelection((ISelection)new StructuredSelection((Object)wsRes), true);
                        }
                    }
                    catch (PartInitException e) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
            };
        }

        protected DeleteAction createDeleteAction() {
            LibraryViewDeleteAction action = new LibraryViewDeleteAction(){

                public boolean updateSelection(IStructuredSelection selection) {
                    if (LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(selection);
                }

                public void run() {
                    String title = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorTitle;
                    try {
                        super.run();
                    }
                    catch (MessageException e) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.getMessage());
                    }
                    catch (Exception e) {
                        String details = TngUtil.toStackTraceString((Throwable)e);
                        String message = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorMessage;
                        String reason = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorReason;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, reason, details, (Throwable)e);
                    }
                }

                protected void deleteFailed() {
                    ViewHelper.reloadCurrentLibrary(LibraryView.this.getSite().getShell(), AuthoringUIResources.msg_reloadLibrary);
                    if (LibraryViewActionBarContributor.this.activeViewPart instanceof IViewerProvider) {
                        ArrayList<MethodElement> elements = new ArrayList<MethodElement>();
                        for (Object e : this.selection) {
                            MethodElement element;
                            if (!(e instanceof MethodElement)) continue;
                            String guid = ((MethodElement)e).getGuid();
                            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                            if (manager == null || (element = manager.getMethodElement(guid)) == null) continue;
                            elements.add(element);
                        }
                        if (!elements.isEmpty()) {
                            Viewer viewer = ((IViewerProvider)LibraryViewActionBarContributor.this.activeViewPart).getViewer();
                            viewer.setSelection((ISelection)new StructuredSelection(elements), true);
                        }
                    }
                }
            };
            action.setProgressMonitor(this.getActionBars().getStatusLineManager().getProgressMonitor());
            return action;
        }

        protected CutAction createCutAction() {
            return new LibraryViewCutAction(){

                public boolean updateSelection(IStructuredSelection selection) {
                    if (LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(selection);
                }
            };
        }

        protected CopyAction createCopyAction() {
            return new LibraryViewCopyAction(){

                public boolean updateSelection(IStructuredSelection selection) {
                    if (ViewHelper.hasCustomizedLocker(selection) && LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(selection);
                }
            };
        }

        protected PasteAction createPasteAction() {
            LibraryViewPasteAction action = new LibraryViewPasteAction(){

                public boolean updateSelection(IStructuredSelection selection) {
                    if (LibraryViewActionBarContributor.this.locked) {
                        return false;
                    }
                    return super.updateSelection(selection);
                }
            };
            action.setProgressMonitor(this.getActionBars().getStatusLineManager().getProgressMonitor());
            return action;
        }

        private void checkLocked() {
            if (LibraryView.this.selection instanceof IStructuredSelection) {
                boolean wasLocked = this.locked;
                this.locked = ViewHelper.hasCustomizedLocker((IStructuredSelection)LibraryView.this.selection) ? ViewHelper.isLockedWithCustomizedLocker((IStructuredSelection)LibraryView.this.selection) : ViewHelper.isLocked((IStructuredSelection)LibraryView.this.selection);
                if (wasLocked != this.locked) {
                    this.deleteAction.setEnabled(this.deleteAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    this.cutAction.setEnabled(this.cutAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    this.pasteAction.setEnabled(this.pasteAction.updateSelection((IStructuredSelection)LibraryView.this.selection));
                    boolean enabled = !this.locked;
                    this.renameAction.setEnabled(enabled);
                    this.moveAction.setEnabled(enabled);
                    this.unassignAction.setEnabled(enabled);
                    this.reassignAction.setEnabled(enabled);
                }
            }
        }

        void updateSelection(ISelection selection) {
            boolean enabled;
            IStructuredSelection sel = (IStructuredSelection)selection;
            this.renameAction.setActiveWorkbenchPart((IWorkbenchPart)LibraryView.this);
            this.canRename = this.renameAction.updateSelection(sel);
            this.locked = ViewHelper.hasCustomizedLocker(sel) ? ViewHelper.isLockedWithCustomizedLocker(sel) : ViewHelper.isLocked(sel);
            boolean bl = enabled = !this.locked;
            if (this.canRename && !enabled) {
                this.renameAction.setEnabled(enabled);
            }
            this.moveAction.setEnabled(enabled);
            this.unassignAction.setEnabled(enabled);
            this.reassignAction.setEnabled(enabled);
            this.canMove = this.canMove(sel);
            this.canAssign = this.assignAction.updateSelection(sel);
            if (!this.locked && sel.size() == 1 && sel.getFirstElement() instanceof ProcessComponent) {
                this.replaceAction.setEnabled(true);
            } else {
                this.replaceAction.setEnabled(false);
            }
            if (sel.size() == 1) {
                Object obj = TngUtil.unwrap((Object)((IStructuredSelection)selection).getFirstElement());
                this.openVariabilityDialogAction.setEnabled(obj instanceof VariabilityElement && !TngUtil.isPredefined((MethodElement)((MethodElement)obj)));
                this.showInResourceNavigatorAction.setEnabled(obj instanceof MethodElement);
            }
        }

        public void enableGlobalEditMenu() {
        }

        protected void addGlobalActions(IMenuManager menuManager) {
            super.addGlobalActions(menuManager);
            menuManager.insertAfter("fixed-additions", this.newPluginAction);
        }

        private boolean canMove(IStructuredSelection selection) {
            for (Object element : selection) {
                if (!(element instanceof MethodElement) || element instanceof ContentCategory || element instanceof MethodPlugin || element instanceof MethodConfiguration || TngUtil.isPredefined((MethodElement)((MethodElement)element))) continue;
                return true;
            }
            return false;
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            LibraryView.this.performLibraryValidationAction.setId(LibraryView.this.PERFORM_ID);
            if (AuthoringUIPreferences.getEnableLibraryValidation()) {
                toolBarManager.add(LibraryView.this.performLibraryValidationAction);
            }
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            this.updatePasteAction();
            this.checkLocked();
            menuManager.add((IContributionItem)new Separator("fixed-additions"));
            menuManager.add((IContributionItem)new Separator("fixed-additions-end"));
            menuManager.add((IContributionItem)new Separator("edit"));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.libraryViewEditAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
            if (this.canRename) {
                menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.renameAction));
            }
            if (this.canMove) {
                menuManager.add((IContributionItem)new ActionContributionItem(this.moveAction));
            }
            if (this.canAssign) {
                menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.assignAction));
                menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.unassignAction));
                menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.reassignAction));
                menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.customCategoryDeepCopyAction));
            }
            menuManager.add((IContributionItem)new Separator("view"));
            if (this.openVariabilityDialogAction.isEnabled()) {
                menuManager.add((IContributionItem)new ActionContributionItem(this.openVariabilityDialogAction));
            }
            if (this.showInResourceNavigatorAction.isEnabled()) {
                menuManager.add((IContributionItem)new ActionContributionItem(this.showInResourceNavigatorAction));
            }
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator("additions-end"));
            this.addGlobalActions(menuManager);
            if (!this.locked) {
                MenuManager submenuManager = null;
                submenuManager = new MenuManager(AuthoringUIResources._UI_CreateChild_menu_item);
                this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
                menuManager.insertBefore("fixed-additions", (IContributionItem)submenuManager);
            }
        }

        protected void refreshViewer(final Viewer viewer) {
            if (viewer == LibraryView.this.getViewer()) {
                org.eclipse.jface.operation.IRunnableWithProgress runnable = new org.eclipse.jface.operation.IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("", 3);
                        monitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                        monitor.worked(1);
                        try {
                            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                            if (manager != null) {
                                ILibraryResourceSet libResourceSet;
                                ResourceSet resourceSet = manager.getEditingDomain().getResourceSet();
                                if (resourceSet instanceof ILibraryResourceSet && (libResourceSet = (ILibraryResourceSet)resourceSet).getPersistenceType().equals("xmi")) {
                                    libResourceSet.loadNewResources();
                                    ArrayList<Resource> removedResources = new ArrayList<Resource>();
                                    ArrayList<Resource> changedResources = new ArrayList<Resource>();
                                    for (Resource resource : new ArrayList(resourceSet.getResources())) {
                                        String loc = resource.getURI().toFileString();
                                        IResource wsRes = FileManager.getResourceForLocation((String)loc);
                                        if (wsRes == null) {
                                            removedResources.add(resource);
                                            continue;
                                        }
                                        if (wsRes.isSynchronized(0)) continue;
                                        changedResources.add(resource);
                                    }
                                    monitor.worked(2);
                                    if (removedResources.isEmpty() && changedResources.isEmpty()) {
                                        viewer.refresh();
                                    } else {
                                        LibraryView.this.doRefresh(removedResources, changedResources, null, false);
                                    }
                                } else {
                                    viewer.refresh();
                                }
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                ProgressMonitorDialog context = new ProgressMonitorDialog(LibraryView.this.getSite().getShell());
                try {
                    LibraryView.this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, null);
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    String title = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.toString(), (Throwable)e);
                }
                return;
            }
            super.refreshViewer(viewer);
        }
    }

    private static abstract class StatusWorkspaceModifyOperation
    extends WorkspaceModifyOperation {
        protected String errMsg;

        private StatusWorkspaceModifyOperation() {
        }

        public String getErrorMessage() {
            return this.errMsg;
        }
    }
}

