/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.views.AbstractLocker;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.osgi.framework.Bundle;

public class LockerFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.authoring.ui";
    public static final String EXTENSION_POINT_NAME = "CustomizedLocker";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String ID_ATTRIB_NAME = "id";
    private static LockerFactory instance = null;
    private Map<String, LockerElement> lockerElements = new HashMap<String, LockerElement>();
    private Map<String, AbstractLocker> lockerMap = new HashMap<String, AbstractLocker>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LockerFactory getInstance() {
        if (instance != null) return instance;
        Class<LockerFactory> clazz = LockerFactory.class;
        synchronized (LockerFactory.class) {
            if (instance != null) return instance;
            instance = new LockerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LockerFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        LockerElement provider;
                        String className = configElement.getAttribute(CLASS_ATTRIB_NAME);
                        String id = configElement.getAttribute(ID_ATTRIB_NAME);
                        if (className != null && className.trim().length() > 0 && id != null && id.trim().length() > 0 && (provider = this.lockerElements.get(id)) == null) {
                            provider = new LockerElement(bundle, className, id);
                            this.lockerElements.put(id, provider);
                        }
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public AbstractLocker getLocker(Object obj) {
        List props;
        MethodElement e;
        if (obj instanceof MethodElement && (e = (MethodElement)obj) != null && (props = e.getMethodElementProperty()) != null && props.size() > 0) {
            for (MethodElementProperty prop : props) {
                String id = prop.getName();
                AbstractLocker locker = this.getLocker(id);
                if (locker == null) continue;
                return locker;
            }
        }
        return null;
    }

    private AbstractLocker getLocker(String id) {
        if (!this.lockerElements.containsKey(id)) {
            return null;
        }
        if (this.lockerMap.containsKey(id)) {
            return this.lockerMap.get(id);
        }
        LockerElement provider = this.lockerElements.get(id);
        try {
            Class clazz = provider.bundle.loadClass(provider.className);
            AbstractLocker lockerInstance = (AbstractLocker)clazz.newInstance();
            this.lockerMap.put(id, lockerInstance);
            return lockerInstance;
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    private class LockerElement {
        Bundle bundle;
        String className;
        String id;

        private LockerElement(Bundle bundle, String className, String id) {
            this.bundle = bundle;
            this.className = className;
            this.id = id;
        }
    }
}

