/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.wpdd.part.DiagramVisualIDRegistry;
import org.eclipse.epf.diagram.wpdd.providers.DiagramElementTypes;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class WorkProductDependencyDiagramCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    private Collection myLinkDescriptors = new LinkedList();
    private Map myEObject2ViewMap = new HashMap();

    public EObject getSemanticHost() {
        return this.host().getModel() != null ? super.getSemanticHost() : null;
    }

    protected void refreshOnActivate() {
        super.refreshOnActivate();
        EditPart ep = this.getHost();
        if (ep instanceof DiagramEditPart) {
            DiagramEditorUtil.initializeOnActivate((DiagramEditPart)((DiagramEditPart)ep));
        }
    }

    protected List getSemanticChildrenList() {
        LinkedList<EObject> result = new LinkedList<EObject>();
        EObject modelObject = ((View)this.getHost().getModel()).getElement();
        View viewObject = (View)this.getHost().getModel();
        for (EObject nextValue : ((NodeContainer)modelObject).getNodes()) {
            int nodeVID = DiagramVisualIDRegistry.getNodeVisualID(viewObject, nextValue);
            if (1001 != nodeVID) continue;
            result.add(nextValue);
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return view.isSetElement() && view.getElement() != null && (view.getElement().eIsProxy() || view.getElement() instanceof Node);
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected List getSemanticConnectionsList() {
        ArrayList connections = new ArrayList();
        WorkProductDependencyDiagram diagram = (WorkProductDependencyDiagram)((View)this.getHost().getModel()).getElement();
        for (Node node : diagram.getNodes()) {
            connections.addAll(node.getOutgoingConnections());
        }
        return connections;
    }

    protected EObject getSourceElement(EObject relationship) {
        if (relationship instanceof Link) {
            return ((Link)relationship).getSource();
        }
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        if (relationship instanceof Link) {
            return ((Link)relationship).getTarget();
        }
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return super.shouldIncludeConnection(connector, children);
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Collection refreshConnections() {
        try {
            this.collectAllLinks((View)this.getDiagram());
            LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
            Iterator diagramLinks = existingLinks.iterator();
            while (diagramLinks.hasNext()) {
                Edge nextDiagramLink = (Edge)diagramLinks.next();
                EObject diagramLinkObject = nextDiagramLink.getElement();
                EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
                EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
                int diagramLinkVisualID = DiagramVisualIDRegistry.getVisualID((View)nextDiagramLink);
                Iterator modelLinkDescriptors = this.myLinkDescriptors.iterator();
                while (modelLinkDescriptors.hasNext()) {
                    LinkDescriptor nextLinkDescriptor = (LinkDescriptor)modelLinkDescriptors.next();
                    if (diagramLinkObject != nextLinkDescriptor.getLinkElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                    diagramLinks.remove();
                    modelLinkDescriptors.remove();
                }
            }
            this.deleteViews(existingLinks.iterator());
            Collection collection = this.createConnections(this.myLinkDescriptors);
            return collection;
        }
        finally {
            this.myLinkDescriptors.clear();
            this.myEObject2ViewMap.clear();
        }
    }

    private void collectAllLinks(View view) {
        EObject modelElement = view.getElement();
        int diagramElementVisualID = DiagramVisualIDRegistry.getVisualID(view);
        switch (diagramElementVisualID) {
            case 79: 
            case 1001: {
                this.myEObject2ViewMap.put(modelElement, view);
                this.storeLinks(modelElement, this.getDiagram());
            }
        }
        for (View childView : view.getChildren()) {
            this.collectAllLinks(childView);
        }
    }

    private Collection createConnections(Collection linkDescriptors) {
        if (linkDescriptors.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (LinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPartFor(nextLinkDescriptor.getSource());
            EditPart targetEditPart = this.getEditPartFor(nextLinkDescriptor.getDestination());
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPartFor(EObject modelElement) {
        View view = (View)this.myEObject2ViewMap.get(modelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private void storeLinks(EObject container, Diagram diagram) {
        EClass containerMetaclass = container.eClass();
        this.storeFeatureModelFacetLinks(container, containerMetaclass, diagram);
        this.storeTypeModelFacetLinks(container, containerMetaclass);
    }

    private void storeTypeModelFacetLinks(EObject container, EClass containerMetaclass) {
        this.storeTypeModelFacetLinks_Link_3001(container, containerMetaclass);
    }

    private void storeTypeModelFacetLinks_Link_3001(EObject container, EClass containerMetaclass) {
        if (ModelPackage.eINSTANCE.getNode().isSuperTypeOf(containerMetaclass)) {
            for (EObject nextValue : ((Node)container).getOutgoingConnections()) {
                Node structuralFeatureResult;
                int linkVID = DiagramVisualIDRegistry.getLinkWithClassVisualID(nextValue);
                if (3001 != linkVID || !((structuralFeatureResult = ((Link)nextValue).getTarget()) instanceof EObject)) continue;
                EObject dst = (EObject)structuralFeatureResult;
                structuralFeatureResult = ((Link)nextValue).getSource();
                if (!(structuralFeatureResult instanceof EObject)) continue;
                EObject src = (EObject)structuralFeatureResult;
                this.myLinkDescriptors.add(new LinkDescriptor(src, dst, nextValue, DiagramElementTypes.Link_3001, linkVID));
            }
        }
    }

    private void storeFeatureModelFacetLinks(EObject container, EClass containerMetaclass, Diagram diagram) {
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private class LinkDescriptor {
        private EObject mySource;
        private EObject myDestination;
        private EObject myLinkElement;
        private int myVisualID;
        private IAdaptable mySemanticAdapter;

        protected LinkDescriptor(EObject source, EObject destination, EObject linkElement, IElementType elementType, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = linkElement;
            final IElementType elementTypeCopy = elementType;
            this.mySemanticAdapter = new EObjectAdapter(linkElement){

                public Object getAdapter(Class adapter) {
                    if (IElementType.class.equals((Object)adapter)) {
                        return elementTypeCopy;
                    }
                    return super.getAdapter(adapter);
                }
            };
        }

        protected LinkDescriptor(EObject source, EObject destination, IElementType elementType, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = null;
            final IElementType elementTypeCopy = elementType;
            this.mySemanticAdapter = new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (IElementType.class.equals((Object)adapter)) {
                        return elementTypeCopy;
                    }
                    return null;
                }
            };
        }

        private LinkDescriptor(EObject source, EObject destination, int linkVID) {
            this.mySource = source;
            this.myDestination = destination;
            this.myVisualID = linkVID;
        }

        protected EObject getSource() {
            return this.mySource;
        }

        protected EObject getDestination() {
            return this.myDestination;
        }

        protected EObject getLinkElement() {
            return this.myLinkElement;
        }

        protected int getVisualID() {
            return this.myVisualID;
        }

        protected IAdaptable getSemanticAdapter() {
            return this.mySemanticAdapter;
        }
    }
}

