/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.commands.Command;

public class ChangeBoundsCommand
extends Command {
    private Node node;
    private Point newLocation;
    private Point oldLocation;
    private int newWidth;
    private int oldWidth;
    private static final String LABEL = AuthoringUIResources.gef_changeBoundsCommand_label;

    public ChangeBoundsCommand(Node node, Point newLocation, int newWidth) {
        super(LABEL);
        this.setNode(node);
        this.setNewLocation(newLocation.getCopy());
        this.newWidth = newWidth;
    }

    public boolean canExecute() {
        return this.node != null && this.newLocation != null && (this.newWidth != this.oldWidth || !this.node.getLocation().equals((Object)this.newLocation));
    }

    public void execute() {
        this.oldLocation = this.node.getLocation();
        this.oldWidth = this.node.getWidth();
        this.redo();
    }

    public void redo() {
        this.node.setLocation(this.newLocation);
        this.node.setWidth(this.newWidth);
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setNewLocation(Point loc) {
        this.newLocation = loc;
    }

    public void undo() {
        this.node.setWidth(this.oldWidth);
        this.node.setLocation(this.oldLocation);
    }
}

