/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui;

import java.util.List;
import org.eclipse.epf.authoring.gef.util.DiagramEditorUtil;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.providers.DescriptionPageColumnProvider;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.common.ui.PreferenceStoreWrapper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationApplicator;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IConfiguratorFactory;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.util.CopyAttachmentsToNewLocation;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;

public class AuthoringUIService {
    private static AuthoringUIService instance = new AuthoringUIService();
    private boolean started = false;

    private AuthoringUIService() {
        LibraryService.getInstance().addListener(new ILibraryServiceListener(){

            public void libraryCreated(MethodLibrary library) {
            }

            public void libraryOpened(MethodLibrary library) {
            }

            public void libraryReopened(MethodLibrary library) {
            }

            public void libraryClosed(MethodLibrary library) {
            }

            public void librarySet(MethodLibrary library) {
                if (library != null) {
                    AuthoringUIService.this.start();
                }
                LibraryUIUtil.updateShellTitle();
            }

            public void configurationSet(MethodConfiguration config) {
            }
        });
    }

    public static AuthoringUIService getInstance() {
        return instance;
    }

    public synchronized void start() {
        if (!this.started) {
            ConfigurableComposedAdapterFactory adapterFactory;
            LibraryUIPreferences.applyDefaultValuesForBreakdownElementAttributes();
            ProcessAuthoringConfigurator.INSTANCE.getClass();
            if (TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory() instanceof ConfigurableComposedAdapterFactory && (adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()).getFilter() == null) {
                adapterFactory.setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            MethodElementAddCommand.setResourceManager((MethodElementAddCommand.ResourceManager)new CopyAttachmentsToNewLocation());
            EditorChooser.getInstance();
            DescriptionPageColumnProvider.getInstance().loadProviders();
            Providers.setConfiguratorFactory((IConfiguratorFactory)new IConfiguratorFactory(){

                public IConfigurator createConfigurator(MethodConfiguration config) {
                    return new ProcessConfigurator(config, true);
                }
            });
            Providers.setConfigurationApplicator((IConfigurationApplicator)new ConfigurationApplicator());
            Providers.setPreferenceStore((IPreferenceStoreWrapper)LibraryPlugin.getDefault().getPreferenceStore());
            PreferenceStoreWrapper store = new PreferenceStoreWrapper(AuthoringUIPlugin.getDefault().getPreferenceStore());
            Providers.setAuthoringPluginPreferenceStore((IPreferenceStoreWrapper)store);
            List cmdListeners = GraphicalDataManager.getInstance().getCommandListeners();
            cmdListeners.addAll(DiagramEditorUtil.getInstance().getVaryCommandListeners());
            for (ICommandListener listener : cmdListeners) {
                Providers.registerCommandListener((ICommandListener)listener);
            }
            RefreshJob.getInstance().start();
            this.started = true;
        }
    }

    public synchronized void stop() {
        if (this.started) {
            RefreshJob.getInstance().stop();
            this.started = false;
        }
    }
}

