/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IModifyingAction;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class OutdentAction
extends CommandActionHandler
implements IWorkbenchPartAction,
IModifyingAction {
    private static final String LABEL = AuthoringUIResources.ProcessEditor_Action_Outdent;
    private ProcessEditor editor;

    public OutdentAction(String text) {
        super(null, text);
    }

    public OutdentAction() {
        this(LABEL);
        this.setImageDescriptor(RichTextImages.IMG_DESC_OUTDENT);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_OUTDENT);
        this.setToolTipText(LABEL);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object e;
        boolean ret = false;
        if (selection.size() == 1 && (e = selection.getFirstElement()) instanceof Activity) {
            ret = super.updateSelection(selection);
        }
        this.setEnabled(ret);
        return ret;
    }

    public Command createCommand(Collection selection) {
        if (this.domain instanceof AdapterFactoryEditingDomain) {
            return new OutdentCommand(selection, ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory());
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
        if (workbenchPart instanceof ProcessEditor) {
            this.editor = (ProcessEditor)workbenchPart;
        } else if (workbenchPart == null) {
            this.editor = null;
        }
    }

    private void superRun() {
        super.run();
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.editor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                OutdentAction.this.superRun();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OutdentCommand
    extends AbstractCommand
    implements IResourceAwareCommand {
        private static final AdapterFactory[] ADAPTER_FACTORIES = new AdapterFactory[]{TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()};
        private Collection<BreakdownElement> elements;
        private Set modifiedResources;
        private BreakdownElement element;
        private Activity oldParent;
        private Activity newParent;
        private int oldIndex;
        private int newIndex;
        private List<Object> newChildren;
        private AdapterFactory adapterFactory;

        public OutdentCommand(Collection<BreakdownElement> collection, AdapterFactory adapterFactory) {
            this.elements = collection;
            this.adapterFactory = adapterFactory;
            this.setLabel(LABEL);
        }

        public void dispose() {
            if (this.newChildren != null) {
                this.newChildren.clear();
                this.newChildren = null;
            }
            super.dispose();
        }

        public Collection getModifiedResources() {
            if (this.modifiedResources == null) {
                Resource resource;
                Process proc = null;
                Iterator<BreakdownElement> iter = this.elements.iterator();
                while (proc == null && iter.hasNext()) {
                    BreakdownElement e = iter.next();
                    proc = TngUtil.getOwningProcess((BreakdownElement)e);
                }
                if (proc != null && (resource = proc.eResource()) != null) {
                    this.modifiedResources = Collections.singleton(proc.eResource());
                }
                if (this.modifiedResources == null) {
                    this.modifiedResources = Collections.EMPTY_SET;
                }
            }
            return this.modifiedResources;
        }

        protected boolean prepare() {
            this.element = this.elements.iterator().next();
            this.oldParent = this.element.getSuperActivities();
            if (this.oldParent == null) {
                return false;
            }
            this.oldIndex = this.oldParent.getBreakdownElements().indexOf(this.element);
            HashMap childrenToStartIndexMap = new HashMap();
            AdapterFactory[] adapterFactories = this.element instanceof Activity ? ADAPTER_FACTORIES : new AdapterFactory[]{this.adapterFactory};
            int i = 0;
            while (i < adapterFactories.length) {
                int size;
                AdapterFactory adapterFactory = adapterFactories[i];
                ITreeItemContentProvider ip = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)this.oldParent, ITreeItemContentProvider.class);
                ArrayList children = new ArrayList(ip.getChildren((Object)this.oldParent));
                int index = children.indexOf(this.element);
                int newChildrenFromIndex = index + 1;
                if (newChildrenFromIndex < (size = children.size())) {
                    int j = newChildrenFromIndex;
                    while (j < size) {
                        Object child = children.get(j);
                        if (ProcessUtil.isInherited(child)) {
                            return false;
                        }
                        ++j;
                    }
                    childrenToStartIndexMap.put(children, newChildrenFromIndex);
                }
                ++i;
            }
            if (!(this.element instanceof Activity) && !childrenToStartIndexMap.isEmpty()) {
                return false;
            }
            this.newParent = this.oldParent.getSuperActivities();
            if (this.newParent != null) {
                this.newIndex = this.newParent.getBreakdownElements().indexOf(this.oldParent) + 1;
                if (!childrenToStartIndexMap.isEmpty()) {
                    this.newChildren = new UniqueEList();
                    for (Map.Entry entry : childrenToStartIndexMap.entrySet()) {
                        List children = (List)entry.getKey();
                        this.newChildren.addAll(children.subList((Integer)entry.getValue(), children.size()));
                    }
                    if (!DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)((VariabilityElement)this.element), this.newChildren, (boolean)true)) {
                        return false;
                    }
                }
                return DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.newParent, (Collection)Collections.singleton(this.element), (boolean)true);
            }
            return false;
        }

        public void execute() {
            this.newParent.getBreakdownElements().add(this.newIndex, this.element);
            if (this.element instanceof Activity) {
                ProcessPackage parentPkg = (ProcessPackage)this.newParent.eContainer();
                parentPkg.getChildPackages().add((MethodPackage)this.element.eContainer());
                if (this.newChildren != null) {
                    for (Object child : this.newChildren) {
                        if (child instanceof BreakdownElement) {
                            ((Activity)this.element).getBreakdownElements().add((BreakdownElement)child);
                        }
                        if (!(child instanceof Activity)) continue;
                        parentPkg.getChildPackages().add((MethodPackage)((Activity)child).eContainer());
                    }
                }
            }
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
            this.oldParent.getBreakdownElements().add(this.oldIndex, this.element);
            if (this.element instanceof Activity) {
                ProcessPackage parentPkg = (ProcessPackage)this.oldParent.eContainer();
                parentPkg.getChildPackages().add((MethodPackage)this.element.eContainer());
                if (this.newChildren != null) {
                    ((Activity)this.element).getBreakdownElements().removeAll(this.newChildren);
                    for (Object child : this.newChildren) {
                        if (!(child instanceof Activity)) continue;
                        parentPkg.getChildPackages().add((MethodPackage)((Activity)child).eContainer());
                    }
                }
            }
        }

        public Collection getAffectedObjects() {
            return this.elements;
        }
    }
}

