/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.ConfigurationPage;
import org.eclipse.epf.authoring.ui.providers.ConfigurationEditorDefaultPageProvider;
import org.eclipse.epf.authoring.ui.providers.IMethodElementEditorPageProviderExtension;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class ConfigurationEditor
extends MethodElementEditor
implements IGotoMarker {
    public static final String EDITOR_ID = ConfigurationEditor.class.getName();
    protected static IMethodElementEditorPageProviderExtension defaultConfigPageProvider;
    ConfigurationPage configPage = null;
    private List<Listener> setFocusListeners = new ArrayList<Listener>();

    public MethodConfiguration getConfiguration() {
        return ((ConfigurationEditorInput)super.getEditorInput()).getConfiguration();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Resource resource;
        MethodElement element;
        if (input instanceof FileEditorInput && (element = PersistenceUtil.getMethodElement((Resource)(resource = RefreshJob.getInstance().getResource((IResource)((FileEditorInput)input).getFile())))) instanceof MethodConfiguration) {
            input = new ConfigurationEditorInput((MethodConfiguration)element);
        }
        super.init(site, input);
    }

    protected IMethodElementEditorPageProviderExtension getDefaultPageProvider() {
        if (defaultConfigPageProvider == null) {
            defaultConfigPageProvider = new ConfigurationEditorDefaultPageProvider();
        }
        return defaultConfigPageProvider;
    }

    protected void addPages() {
        Map<Object, String> pageMap = this.getDefaultPageProvider().getPages(new LinkedHashMap<Object, String>(), this, this.elementObj);
        List<IMethodElementEditorPageProviderExtension> pageProviders = ConfigurationEditor.getAllPageProviders();
        if (pageProviders != null && pageProviders.size() > 0) {
            for (IMethodElementEditorPageProviderExtension iMethodElementEditorPageProviderExtension : pageProviders) {
                pageMap = iMethodElementEditorPageProviderExtension.getPages(pageMap, this, this.elementObj);
            }
        }
        try {
            for (Map.Entry entry : pageMap.entrySet()) {
                Object page = entry.getKey();
                String name = (String)entry.getValue();
                int index = -1;
                if (page instanceof Control) {
                    index = this.addPage((Control)page);
                } else if (page instanceof IFormPage) {
                    index = this.addPage((IFormPage)page);
                } else if (page instanceof IEditorPart) {
                    index = this.addPage((IEditorPart)page, this.getEditorInput());
                }
                if (name != null) {
                    this.setPageText(index, name);
                }
                if (!(page instanceof ConfigurationPage)) continue;
                this.configPage = (ConfigurationPage)((Object)page);
            }
        }
        catch (PartInitException partInitException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)partInitException);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected IEditorInput createInput(MethodElement e) {
        if (e instanceof MethodConfiguration) {
            return new ConfigurationEditorInput((MethodConfiguration)e);
        }
        return null;
    }

    public void addToSetFocusLiseners(Listener lis) {
        this.setFocusListeners.add(lis);
    }

    public void setFocus() {
        Event e = new Event();
        e.data = this.getActivePageInstance();
        int i = 0;
        while (i < this.setFocusListeners.size()) {
            Listener lis = this.setFocusListeners.get(i);
            lis.handleEvent(e);
            ++i;
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(1);
        if (this.configPage != null) {
            this.configPage.gotoMarker(marker);
        }
    }

    public void doQuickFix(IMarker marker) {
        this.configPage.doQuickFix(marker);
    }
}

