/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.editors.EditorOpener;
import org.eclipse.epf.authoring.ui.editors.EditorOpenerFactory;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.ui.editors.IMethodEditor;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorChooser
implements IEditorKeeper {
    private static EditorChooser singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditorChooser getInstance() {
        if (singleton != null) return singleton;
        Class<EditorChooser> clazz = EditorChooser.class;
        synchronized (EditorChooser.class) {
            if (singleton != null) return singleton;
            singleton = new EditorChooser();
            IEditorKeeper.REFERENCE.setEditorKeeper(singleton);
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public void openEditor(Object obj) {
        try {
            Process process;
            EObject container;
            EditorOpener opener;
            obj = ViewHelper.handleDangling(obj);
            if (obj == null) {
                return;
            }
            obj = LibraryUtil.unwrap((Object)obj);
            ArrayList errors = new ArrayList();
            if (obj instanceof EObject) {
                Resource presRes;
                Resource res = ((EObject)obj).eResource();
                if (res != null && !res.getErrors().isEmpty()) {
                    errors.addAll(res.getErrors());
                }
                if (obj instanceof DescribableElement && (presRes = ((DescribableElement)obj).getPresentation().eResource()) != null && !presRes.getErrors().isEmpty()) {
                    errors.addAll(presRes.getErrors());
                }
                if (!errors.isEmpty()) {
                    MultiStatus multiStatus = new MultiStatus(AuthoringUIPlugin.getDefault().getId(), 0, AuthoringUIResources.EditorChooser_ResourcesError, null);
                    for (Resource.Diagnostic e : errors) {
                        Status status = new Status(2, LibraryPlugin.getDefault().getId(), 0, e.getMessage(), null);
                        multiStatus.add((IStatus)status);
                    }
                    try {
                        if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(AuthoringUIResources.EditorChooser_loaddErrorDlgTitle, AuthoringUIResources.EditorChooser_ResourcesError, (IStatus)multiStatus) == 1) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
            }
            if ((opener = EditorOpenerFactory.getInstance().getOpener(obj)) != null && opener.canOpen(obj)) {
                opener.openEditor(obj);
            } else if (obj instanceof MethodPlugin || obj instanceof ContentPackage || obj instanceof Role || obj instanceof Task || obj instanceof WorkProduct || obj instanceof Guidance || obj instanceof Discipline || obj instanceof DisciplineGrouping || obj instanceof Domain || obj instanceof WorkProductType || obj instanceof RoleSet || obj instanceof Tool || obj instanceof RoleSetGrouping || obj instanceof MethodLibrary) {
                this.openEditor((MethodElement)obj, MethodElementEditor.EDITOR_ID);
            } else if (obj instanceof CustomCategory) {
                CustomCategory custCat = (CustomCategory)obj;
                if (TngUtil.isRootCustomCategory((CustomCategory)custCat)) {
                    return;
                }
                this.openEditor((MethodElement)obj, MethodElementEditor.EDITOR_ID);
            } else if (obj instanceof ProcessComponent) {
                this.openEditor((MethodElement)obj, ProcessEditor.EDITOR_ID);
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet", null, 2);
                }
                catch (PartInitException exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            } else if (obj instanceof Process) {
                EObject container2 = ((Process)obj).eContainer();
                if (container2 instanceof ProcessComponent) {
                    this.openEditor((MethodElement)container2, ProcessEditor.EDITOR_ID);
                }
            } else if (obj instanceof MethodConfiguration) {
                this.openEditor((MethodConfiguration)obj, ConfigurationEditor.EDITOR_ID);
            } else if (obj instanceof BreakdownElement && (container = (process = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)obj))).eContainer()) instanceof ProcessComponent) {
                this.openEditor((MethodElement)container, ProcessEditor.EDITOR_ID);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            String title = AuthoringUIResources.editors_EditorChooser_systemErrorDialog_title;
            String message = AuthoringUIResources.editors_EditorChooser_systemErrorDialog_message;
            String reason = AuthoringUIResources.editors_EditorChooser_systemErrorDialog_reason;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, message, reason, t);
        }
    }

    private void openEditor(MethodConfiguration config, String editorId) throws PartInitException {
        ConfigurationEditorInput editorInput = new ConfigurationEditorInput(config);
        AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, editorId);
    }

    private void openEditor(MethodElement element, String editorId) throws PartInitException {
        MethodElementEditorInput editorInput = new MethodElementEditorInput(element);
        AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, editorId);
    }

    public void selectEditor(Object obj) {
        IWorkbenchPage page;
        IEditorPart editorPart;
        try {
            obj = ViewHelper.handleDangling(obj);
            if (obj == null) {
                return;
            }
            obj = LibraryUtil.unwrap((Object)obj);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        MethodElementEditorInput editorInput = null;
        if (obj instanceof MethodConfiguration) {
            editorInput = new ConfigurationEditorInput((MethodConfiguration)obj);
        } else if (obj instanceof MethodElement) {
            editorInput = new MethodElementEditorInput((MethodElement)obj);
        }
        if (editorInput != null && (editorPart = (page = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()).findEditor((IEditorInput)editorInput)) != null) {
            page.bringToTop((IWorkbenchPart)editorPart);
        }
    }

    public Object getActiveMethodEditorInput() {
        IEditorPart editorPart = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return this.getMethodEditorInput(editorPart);
    }

    public Object getMethodEditorInput(IEditorPart editorPart) {
        if (editorPart != null) {
            IEditorInput editorInput = editorPart.getEditorInput();
            if (editorInput instanceof ConfigurationEditorInput) {
                return ((ConfigurationEditorInput)editorInput).getConfiguration();
            }
            if (editorInput instanceof MethodElementEditorInput) {
                return ((MethodElementEditorInput)editorInput).getMethodElement();
            }
        }
        return null;
    }

    public void closeEditor(Object obj) {
        try {
            IEditorPart editor = this.findEditor(obj);
            if (editor != null) {
                AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
            }
        }
        catch (NullPointerException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public IEditorPart findEditor(Object obj) {
        try {
            MethodElementEditorInput editorInput = new MethodElementEditorInput((MethodElement)obj);
            IEditorPart editor = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)editorInput);
            return editor;
        }
        catch (NullPointerException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    public Collection getElementsWithDirtyEditor(Collection elements) {
        ArrayList<MethodElement> result = new ArrayList<MethodElement>();
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null && editor.isDirty()) {
                IEditorInput input = editor.getEditorInput();
                MethodElement element = null;
                if (input instanceof MethodElementEditorInput) {
                    element = ((MethodElementEditorInput)input).getMethodElement();
                } else if (input instanceof ConfigurationEditorInput) {
                    element = ((ConfigurationEditorInput)input).getConfiguration();
                }
                if (element != null) {
                    Iterator iter = elements.iterator();
                    while (iter.hasNext()) {
                        Object e = iter.next();
                        if (e != element && !UmaUtil.isContainedBy((EObject)element, e)) continue;
                        result.add(element);
                        iter.remove();
                    }
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public void closeEditorsOnDeletion(Object e) {
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorReference> closeEditorRefs = new ArrayList<IEditorReference>();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                IEditorInput input = editor.getEditorInput();
                MethodElement element = null;
                if (input instanceof MethodElementEditorInput) {
                    element = ((MethodElementEditorInput)input).getMethodElement();
                } else if (input instanceof ConfigurationEditorInput) {
                    element = ((ConfigurationEditorInput)input).getConfiguration();
                }
                if (element != null && (element.eContainer() == null || UmaUtil.isContainedBy((EObject)element, (Object)e))) {
                    closeEditorRefs.add(reference);
                }
            }
            ++i;
        }
        int size = closeEditorRefs.size();
        IEditorReference[] references = new IEditorReference[size];
        int i2 = 0;
        while (i2 < size) {
            references[i2] = (IEditorReference)closeEditorRefs.get(i2);
            ++i2;
        }
        workbenchPage.closeEditors(references, false);
    }

    public void closeAllMethodEditors() {
        this.closeAllMethodEditors(false);
    }

    public void closeAllMethodEditors(boolean saveFlag) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final boolean save = saveFlag;
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage workbenchPage = window.getActivePage();
                    List<IEditorReference> closeEditorRefs = EditorChooser.this.getOpenMethodEditors();
                    workbenchPage.closeEditors(closeEditorRefs.toArray(new IEditorReference[closeEditorRefs.size()]), save);
                }
            }
        });
    }

    public void closeAllMethodEditorsWithSaving() {
        this.closeAllMethodEditors(true);
    }

    public List<IEditorReference> getOpenMethodEditors() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final ArrayList<IEditorReference> methodEditorRefs = new ArrayList<IEditorReference>();
        workbench.getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage workbenchPage = window.getActivePage();
                    IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
                    int i = 0;
                    while (i < editorReferences.length) {
                        IEditorReference reference = editorReferences[i];
                        IEditorPart editorPart = reference.getEditor(false);
                        String editorId = reference.getId();
                        if (editorId.startsWith("org.eclipse.epf") || editorPart instanceof IMethodEditor) {
                            methodEditorRefs.add(reference);
                        }
                        ++i;
                    }
                }
            }
        });
        return methodEditorRefs;
    }

    public void closeMethodEditorsForPluginElements(MethodPlugin methodplugin) {
        if (AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null && AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            List<IEditorReference> list = this.getOpenMethodEditors();
            ArrayList<IEditorReference> editorRefsToClose = new ArrayList<IEditorReference>();
            for (IEditorReference editorReference : list) {
                DiagramEditorInput eInput;
                IEditorPart editor = editorReference.getEditor(true);
                if (editor == null) continue;
                IEditorInput input = editor.getEditorInput();
                MethodElement element = null;
                if (input instanceof MethodElementEditorInput) {
                    element = ((MethodElementEditorInput)input).getMethodElement();
                } else if (input instanceof ConfigurationEditorInput) {
                    element = ((ConfigurationEditorInput)input).getConfiguration();
                } else if (input instanceof DiagramEditorInputProxy && (element = (eInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput()).getMethodElement()) == null && eInput.getWrapper() != null) {
                    element = (MethodElement)TngUtil.unwrap((Object)eInput.getWrapper());
                }
                if (element == null || element.eContainer() != null && !UmaUtil.isContainedBy((EObject)element, (Object)methodplugin) || element.equals(methodplugin)) continue;
                editorRefsToClose.add(editorReference);
            }
            workbenchPage.closeEditors(editorRefsToClose.toArray(new IEditorReference[editorRefsToClose.size()]), true);
        }
    }

    @Override
    public void closeEditors(Object e, boolean promptSave) {
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorReference> closeEditorRefs = new ArrayList<IEditorReference>();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                IEditorInput input = editor.getEditorInput();
                MethodElement element = null;
                if (input instanceof MethodElementEditorInput) {
                    element = ((MethodElementEditorInput)input).getMethodElement();
                } else if (input instanceof ConfigurationEditorInput) {
                    element = ((ConfigurationEditorInput)input).getConfiguration();
                }
                if (element != null && (element == e || UmaUtil.isContainedBy((EObject)element, (Object)e))) {
                    closeEditorRefs.add(reference);
                }
            }
            ++i;
        }
        int size = closeEditorRefs.size();
        IEditorReference[] references = new IEditorReference[size];
        int i2 = 0;
        while (i2 < size) {
            references[i2] = (IEditorReference)closeEditorRefs.get(i2);
            ++i2;
        }
        workbenchPage.closeEditors(references, promptSave);
    }
}

